/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.antlr.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.sql.legacy.antlr.parser.OpenSearchLegacySqlParser;
import org.opensearch.sql.legacy.antlr.parser.OpenSearchLegacySqlParserBaseVisitor;
import org.opensearch.sql.legacy.antlr.visitor.EarlyExitAnalysisException;
import org.opensearch.sql.legacy.antlr.visitor.GenericSqlParseTreeVisitor;
import org.opensearch.sql.legacy.antlr.visitor.Reducible;
import org.opensearch.sql.legacy.antlr.visitor.UnsupportedSemanticVerifier;
import shaded.com.google.common.base.Strings;

public class AntlrSqlParseTreeVisitor<T extends Reducible>
extends OpenSearchLegacySqlParserBaseVisitor<T> {
    private final GenericSqlParseTreeVisitor<T> visitor;

    public AntlrSqlParseTreeVisitor(GenericSqlParseTreeVisitor<T> visitor2) {
        this.visitor = visitor2;
    }

    @Override
    public T visitRoot(OpenSearchLegacySqlParser.RootContext ctx) {
        this.visitor.visitRoot();
        return (T)((Reducible)super.visitRoot(ctx));
    }

    @Override
    public T visitUnionSelect(OpenSearchLegacySqlParser.UnionSelectContext ctx) {
        Reducible union = (Reducible)this.visitor.visitOperator("UNION");
        return (T)this.reduce(union, this.asList(ctx.querySpecification(), ctx.unionStatement()));
    }

    @Override
    public T visitMinusSelect(OpenSearchLegacySqlParser.MinusSelectContext ctx) {
        Reducible minus2 = (Reducible)this.visitor.visitOperator("MINUS");
        return (T)this.reduce(minus2, this.asList(ctx.querySpecification(), ctx.minusStatement()));
    }

    @Override
    public T visitInPredicate(OpenSearchLegacySqlParser.InPredicateContext ctx) {
        Reducible in = (Reducible)this.visitor.visitOperator("IN");
        OpenSearchLegacySqlParser.PredicateContext field = ctx.predicate();
        ParserRuleContext subquery = ctx.selectStatement() != null ? ctx.selectStatement() : ctx.expressions();
        return (T)this.reduce(in, Arrays.asList(field, subquery));
    }

    @Override
    public T visitTableSources(OpenSearchLegacySqlParser.TableSourcesContext ctx) {
        if (ctx.tableSource().size() < 2) {
            return (T)((Reducible)super.visitTableSources(ctx));
        }
        Reducible commaJoin = (Reducible)this.visitor.visitOperator("JOIN");
        return (T)this.reduce(commaJoin, ctx.tableSource());
    }

    @Override
    public T visitTableSourceBase(OpenSearchLegacySqlParser.TableSourceBaseContext ctx) {
        if (ctx.joinPart().isEmpty()) {
            return (T)((Reducible)super.visitTableSourceBase(ctx));
        }
        Reducible join = (Reducible)this.visitor.visitOperator("JOIN");
        return (T)this.reduce(join, this.asList(ctx.tableSourceItem(), ctx.joinPart()));
    }

    @Override
    public T visitInnerJoin(OpenSearchLegacySqlParser.InnerJoinContext ctx) {
        return this.visitJoin(ctx.children, ctx.tableSourceItem());
    }

    @Override
    public T visitOuterJoin(OpenSearchLegacySqlParser.OuterJoinContext ctx) {
        return this.visitJoin(ctx.children, ctx.tableSourceItem());
    }

    @Override
    public T visitQuerySpecification(OpenSearchLegacySqlParser.QuerySpecificationContext ctx) {
        this.visitor.visitQuery();
        OpenSearchLegacySqlParser.FromClauseContext fromClause = ctx.fromClause();
        this.visit(fromClause.tableSources());
        if (fromClause.whereExpr != null) {
            this.visit(fromClause.whereExpr);
        }
        Object result2 = this.visitSelectElements(ctx.selectElements());
        fromClause.groupByItem().forEach(this::visit);
        if (fromClause.havingExpr != null) {
            this.visit(fromClause.havingExpr);
        }
        if (ctx.orderByClause() != null) {
            this.visitOrderByClause(ctx.orderByClause());
        }
        if (ctx.limitClause() != null) {
            this.visitLimitClause(ctx.limitClause());
        }
        this.visitor.endVisitQuery();
        return (T)result2;
    }

    @Override
    public T visitSubqueryTableItem(OpenSearchLegacySqlParser.SubqueryTableItemContext ctx) {
        throw new EarlyExitAnalysisException("Exit when meeting subquery in from");
    }

    @Override
    public T visitAtomTableItem(OpenSearchLegacySqlParser.AtomTableItemContext ctx) {
        String alias = ctx.alias == null ? "" : ctx.alias.getText();
        Reducible result2 = (Reducible)this.visit(ctx.tableName());
        this.visitor.visitAs(alias, result2);
        return (T)result2;
    }

    @Override
    public T visitSimpleTableName(OpenSearchLegacySqlParser.SimpleTableNameContext ctx) {
        return (T)((Reducible)this.visitor.visitIndexName(ctx.getText()));
    }

    @Override
    public T visitTableNamePattern(OpenSearchLegacySqlParser.TableNamePatternContext ctx) {
        return (T)((Reducible)this.visitor.visitIndexName(ctx.getText()));
    }

    @Override
    public T visitTableAndTypeName(OpenSearchLegacySqlParser.TableAndTypeNameContext ctx) {
        return (T)((Reducible)this.visitor.visitIndexName(ctx.uid(0).getText()));
    }

    @Override
    public T visitFullColumnName(OpenSearchLegacySqlParser.FullColumnNameContext ctx) {
        return (T)((Reducible)this.visitor.visitFieldName(ctx.getText()));
    }

    @Override
    public T visitUdfFunctionCall(OpenSearchLegacySqlParser.UdfFunctionCallContext ctx) {
        String funcName = ctx.fullId().getText();
        Reducible func = (Reducible)this.visitor.visitFunctionName(funcName);
        return (T)this.reduce(func, ctx.functionArgs());
    }

    @Override
    public T visitScalarFunctionCall(OpenSearchLegacySqlParser.ScalarFunctionCallContext ctx) {
        UnsupportedSemanticVerifier.verify(ctx);
        Reducible func = (Reducible)this.visit(ctx.scalarFunctionName());
        return (T)this.reduce(func, ctx.functionArgs());
    }

    @Override
    public T visitMathOperator(OpenSearchLegacySqlParser.MathOperatorContext ctx) {
        UnsupportedSemanticVerifier.verify(ctx);
        return (T)((Reducible)super.visitMathOperator(ctx));
    }

    @Override
    public T visitRegexpPredicate(OpenSearchLegacySqlParser.RegexpPredicateContext ctx) {
        UnsupportedSemanticVerifier.verify(ctx);
        return (T)((Reducible)super.visitRegexpPredicate(ctx));
    }

    @Override
    public T visitSelectElements(OpenSearchLegacySqlParser.SelectElementsContext ctx) {
        return (T)((Reducible)this.visitor.visitSelect(ctx.selectElement().stream().map(this::visit).collect(Collectors.toList())));
    }

    @Override
    public T visitSelectStarElement(OpenSearchLegacySqlParser.SelectStarElementContext ctx) {
        return (T)((Reducible)this.visitor.visitSelectAllColumn());
    }

    @Override
    public T visitSelectColumnElement(OpenSearchLegacySqlParser.SelectColumnElementContext ctx) {
        return this.visitSelectItem(ctx.fullColumnName(), ctx.uid());
    }

    @Override
    public T visitSelectFunctionElement(OpenSearchLegacySqlParser.SelectFunctionElementContext ctx) {
        return this.visitSelectItem(ctx.functionCall(), ctx.uid());
    }

    @Override
    public T visitSelectExpressionElement(OpenSearchLegacySqlParser.SelectExpressionElementContext ctx) {
        return this.visitSelectItem(ctx.expression(), ctx.uid());
    }

    @Override
    public T visitAggregateWindowedFunction(OpenSearchLegacySqlParser.AggregateWindowedFunctionContext ctx) {
        String funcName = ctx.getChild(0).getText();
        Reducible func = (Reducible)this.visitor.visitFunctionName(funcName);
        return (T)this.reduce(func, ctx.functionArg());
    }

    @Override
    public T visitFunctionNameBase(OpenSearchLegacySqlParser.FunctionNameBaseContext ctx) {
        return (T)((Reducible)this.visitor.visitFunctionName(ctx.getText()));
    }

    @Override
    public T visitBinaryComparisonPredicate(OpenSearchLegacySqlParser.BinaryComparisonPredicateContext ctx) {
        if (this.isNamedArgument(ctx)) {
            return (T)this.defaultResult();
        }
        Reducible op = (Reducible)this.visit(ctx.comparisonOperator());
        return (T)this.reduce(op, Arrays.asList(ctx.left, ctx.right));
    }

    @Override
    public T visitIsExpression(OpenSearchLegacySqlParser.IsExpressionContext ctx) {
        Reducible op = (Reducible)this.visitor.visitOperator("IS");
        return (T)op.reduce(Arrays.asList((Reducible)this.visit(ctx.predicate()), (Reducible)this.visitor.visitBoolean(ctx.testValue.getText())));
    }

    @Override
    public T visitConvertedDataType(OpenSearchLegacySqlParser.ConvertedDataTypeContext ctx) {
        if (ctx.getChild(0) != null && !Strings.isNullOrEmpty(ctx.getChild(0).getText())) {
            return (T)((Reducible)this.visitor.visitConvertedType(ctx.getChild(0).getText()));
        }
        return (T)((Reducible)super.visitConvertedDataType(ctx));
    }

    @Override
    public T visitComparisonOperator(OpenSearchLegacySqlParser.ComparisonOperatorContext ctx) {
        return (T)((Reducible)this.visitor.visitOperator(ctx.getText()));
    }

    @Override
    public T visitConstant(OpenSearchLegacySqlParser.ConstantContext ctx) {
        if (ctx.REAL_LITERAL() != null) {
            return (T)((Reducible)this.visitor.visitFloat(ctx.getText()));
        }
        if (ctx.dateType != null) {
            return (T)((Reducible)this.visitor.visitDate(ctx.getText()));
        }
        if (ctx.nullLiteral != null) {
            return (T)((Reducible)this.visitor.visitNull());
        }
        return (T)((Reducible)super.visitConstant(ctx));
    }

    @Override
    public T visitStringLiteral(OpenSearchLegacySqlParser.StringLiteralContext ctx) {
        return (T)((Reducible)this.visitor.visitString(ctx.getText()));
    }

    @Override
    public T visitDecimalLiteral(OpenSearchLegacySqlParser.DecimalLiteralContext ctx) {
        return (T)((Reducible)this.visitor.visitInteger(ctx.getText()));
    }

    @Override
    public T visitBooleanLiteral(OpenSearchLegacySqlParser.BooleanLiteralContext ctx) {
        return (T)((Reducible)this.visitor.visitBoolean(ctx.getText()));
    }

    @Override
    protected T defaultResult() {
        return (T)((Reducible)this.visitor.defaultValue());
    }

    @Override
    protected T aggregateResult(T aggregate, T nextResult) {
        if (nextResult != this.defaultResult()) {
            return nextResult;
        }
        return aggregate;
    }

    private boolean isNamedArgument(OpenSearchLegacySqlParser.BinaryComparisonPredicateContext ctx) {
        if (ctx.getParent() != null && ctx.getParent().getParent() != null && ctx.getParent().getParent().getParent() != null && ctx.getParent().getParent().getParent() instanceof OpenSearchLegacySqlParser.ScalarFunctionCallContext) {
            OpenSearchLegacySqlParser.ScalarFunctionCallContext parent = (OpenSearchLegacySqlParser.ScalarFunctionCallContext)ctx.getParent().getParent().getParent();
            return parent.scalarFunctionName().functionNameBase().openSearchFunctionNameBase() != null;
        }
        return false;
    }

    private T visitJoin(List<ParseTree> children, OpenSearchLegacySqlParser.TableSourceItemContext tableCtx) {
        Object result2 = this.defaultResult();
        for (ParseTree child : children) {
            if (child == tableCtx) {
                result2 = (Reducible)this.visit(tableCtx);
                continue;
            }
            this.visit(child);
        }
        return (T)result2;
    }

    private T visitSelectItem(ParserRuleContext item, OpenSearchLegacySqlParser.UidContext uid) {
        Reducible result2 = (Reducible)this.visit(item);
        if (uid != null) {
            this.visitor.visitAs(uid.getText(), result2);
        }
        return (T)result2;
    }

    private T reduce(T reducer, ParserRuleContext ctx) {
        return this.reduce(reducer, ctx == null ? Collections.emptyList() : ctx.children);
    }

    private <Node extends ParseTree> T reduce(T reducer, List<Node> nodes) {
        List args2 = nodes == null ? Collections.emptyList() : nodes.stream().map(this::visit).filter(type2 -> type2 != this.defaultResult()).collect(Collectors.toList());
        return reducer.reduce(args2);
    }

    private <Node1 extends ParseTree, Node2 extends ParseTree> List<ParseTree> asList(Node1 first, List<Node2> rest) {
        ArrayList<ParseTree> result2 = new ArrayList<ParseTree>(Collections.singleton(first));
        result2.addAll(rest);
        return result2;
    }
}

