/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.common.patterns;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PatternUtils {
    public static final String PATTERN = "pattern";
    public static final String PATTERN_COUNT = "pattern_count";
    public static final String SAMPLE_LOGS = "sample_logs";
    public static final String TOKENS = "tokens";
    public static final String WILDCARD_PREFIX = "<*";
    public static final Pattern WILDCARD_PATTERN = Pattern.compile("<\\*[^>]*>");
    public static final String TOKEN_PREFIX = "<token";
    public static final Pattern TOKEN_PATTERN = Pattern.compile("<token\\d+>");

    public static Map<String, Map<String, Object>> mergePatternGroups(Map<String, Map<String, Object>> left, Map<String, Map<String, Object>> right, int maxSampleCount) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        right.forEach((pattern, stat) -> {
            if (left.containsKey(pattern)) {
                Map leftStat = (Map)left.get(pattern);
                leftStat.put(PATTERN_COUNT, (Long)leftStat.get(PATTERN_COUNT) + (Long)stat.get(PATTERN_COUNT));
                List leftSampleLogs = (List)leftStat.get(SAMPLE_LOGS);
                List rightSampleLogs = (List)stat.get(SAMPLE_LOGS);
                if (leftSampleLogs.size() < maxSampleCount) {
                    leftSampleLogs.addAll(rightSampleLogs.subList(0, Math.min(rightSampleLogs.size(), maxSampleCount - leftSampleLogs.size())));
                }
            } else {
                left.put((String)pattern, (Map<String, Object>)stat);
            }
        });
        return left;
    }

    public static void extractVariables(ParseResult parseResult, String original, Map<String, List<String>> result2, String prefix) {
        List<String> parts = parseResult.parts;
        List<String> tokenOrder = parseResult.tokenOrder;
        if (parts.isEmpty()) {
            return;
        }
        int pos = 0;
        int i = 0;
        int tokenIndex = 0;
        while (i < parts.size()) {
            String currentPart = parts.get(i);
            if (currentPart.startsWith(prefix)) {
                String tokenKey = tokenOrder.get(tokenIndex++);
                if (i == parts.size() - 1) {
                    String value = original.substring(pos);
                    PatternUtils.addToResult(result2, tokenKey, value);
                    pos = original.length();
                    ++i;
                    continue;
                }
                String nextStatic = parts.get(i + 1);
                int index = original.indexOf(nextStatic, pos);
                if (index == -1) {
                    return;
                }
                String value = original.substring(pos, index);
                PatternUtils.addToResult(result2, tokenKey, value);
                pos = index;
                ++i;
                continue;
            }
            if (original.startsWith(currentPart, pos)) {
                pos += currentPart.length();
                ++i;
                continue;
            }
            return;
        }
    }

    public static ParseResult parsePattern(String pattern, Pattern compiledPattern) {
        ArrayList<String> parts = new ArrayList<String>();
        ArrayList<String> tokenOrder = new ArrayList<String>();
        Matcher matcher = compiledPattern.matcher(pattern);
        int lastEnd = 0;
        int tokenCount = 1;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            if (start > lastEnd) {
                parts.add(pattern.substring(lastEnd, start));
            }
            String wildcard = matcher.group();
            parts.add(wildcard);
            tokenOrder.add(TOKEN_PREFIX + tokenCount++ + ">");
            lastEnd = end;
        }
        if (lastEnd < pattern.length()) {
            parts.add(pattern.substring(lastEnd));
        }
        return new ParseResult(parts, tokenOrder);
    }

    private static void addToResult(Map<String, List<String>> result2, String key, String value) {
        result2.computeIfAbsent(key, k -> new ArrayList()).add(value);
    }

    public static class ParseResult {
        List<String> parts;
        List<String> tokenOrder;

        public ParseResult(List<String> parts, List<String> tokenOrder) {
            this.parts = parts;
            this.tokenOrder = tokenOrder;
        }

        public String toTokenOrderString(String prefix) {
            StringBuilder result2 = new StringBuilder();
            int tokenIndex = 0;
            for (String currentPart : this.parts) {
                if (currentPart.startsWith(prefix)) {
                    result2.append(this.tokenOrder.get(tokenIndex++));
                    continue;
                }
                result2.append(currentPart);
            }
            return result2.toString();
        }
    }
}

