/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.datetime;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.utils.DateTimeFormatters;
import shaded.com.google.common.collect.ImmutableList;

public interface DateTimeParser {
    public static LocalDateTime parse(String input) {
        if (input == null || input.trim().isEmpty()) {
            throw new SemanticCheckException("Cannot parse a null/empty date-time string.");
        }
        if (input.contains(":")) {
            try {
                return DateTimeParser.parseTimestamp(input);
            }
            catch (Exception exception) {
                try {
                    LocalTime t2 = DateTimeParser.parseTime(input);
                    return LocalDateTime.of(LocalDate.now(ZoneId.of("UTC")), t2);
                }
                catch (Exception t2) {
                }
            }
        } else {
            try {
                LocalDate d = DateTimeParser.parseDate(input);
                return d.atStartOfDay();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new SemanticCheckException(String.format("Unable to parse %s as datetime", input));
    }

    public static LocalDateTime parseTimeOrTimestamp(String input) {
        if (input == null || input.trim().isEmpty()) {
            throw new SemanticCheckException("Cannot parse a null/empty date-time string.");
        }
        try {
            return DateTimeParser.parseTime(input).atDate(LocalDate.now(ZoneId.of("UTC")));
        }
        catch (Exception exception) {
            try {
                return DateTimeParser.parseTimestamp(input);
            }
            catch (Exception exception2) {
                throw new SemanticCheckException(String.format("time:%s in unsupported format, please use 'HH:mm:ss[.SSSSSSSSS]'", input));
            }
        }
    }

    public static LocalDateTime parseDateOrTimestamp(String input) {
        if (input == null || input.trim().isEmpty()) {
            throw new SemanticCheckException("Cannot parse a null/empty date-time string.");
        }
        try {
            return DateTimeParser.parseDate(input).atStartOfDay();
        }
        catch (Exception exception) {
            try {
                return DateTimeParser.parseTimestamp(input);
            }
            catch (Exception exception2) {
                throw new SemanticCheckException(String.format("date:%s in unsupported format, please use 'yyyy-MM-dd'", input));
            }
        }
    }

    public static LocalDateTime parseTimestamp(String input) {
        ImmutableList<DateTimeFormatter> dateTimeFormatters = ImmutableList.of(DateTimeFormatters.DATE_TIME_FORMATTER_VARIABLE_NANOS_OPTIONAL);
        for (DateTimeFormatter fmt : dateTimeFormatters) {
            try {
                return LocalDateTime.parse(input, fmt);
            }
            catch (Exception exception) {
            }
        }
        throw new SemanticCheckException(String.format("timestamp:%s in unsupported format, please use 'yyyy-MM-dd HH:mm:ss[.SSSSSSSSS]'", input));
    }

    public static LocalTime parseTime(String input) {
        ImmutableList<DateTimeFormatter> timeFormatters = ImmutableList.of(DateTimeFormatter.ISO_TIME);
        for (DateTimeFormatter fmt : timeFormatters) {
            try {
                return LocalTime.parse(input, fmt);
            }
            catch (Exception exception) {
            }
        }
        throw new SemanticCheckException(String.format("time:%s in unsupported format, please use 'HH:mm:ss[.SSSSSSSSS]'", input));
    }

    public static LocalDate parseDate(String input) {
        ImmutableList<DateTimeFormatter> dateFormatters = ImmutableList.of(DateTimeFormatter.ISO_DATE);
        for (DateTimeFormatter fmt : dateFormatters) {
            try {
                return LocalDate.parse(input, fmt);
            }
            catch (Exception exception) {
            }
        }
        throw new SemanticCheckException(String.format("date:%s in unsupported format, please use 'yyyy-MM-dd'", input));
    }
}

