/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite;

import java.util.Arrays;
import java.util.List;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.opensearch.sql.ast.expression.SpanUnit;
import shaded.com.google.common.collect.ImmutableList;

public class ExtendedRexBuilder
extends RexBuilder {
    public ExtendedRexBuilder(RexBuilder rexBuilder) {
        super(rexBuilder.getTypeFactory());
    }

    public RexNode coalesce(RexNode ... nodes) {
        return this.makeCall((SqlOperator)SqlStdOperatorTable.COALESCE, nodes);
    }

    public RexNode equals(RexNode n1, RexNode n2) {
        return this.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, n1, n2);
    }

    public RexNode and(RexNode left, RexNode right) {
        RelDataType booleanType = this.getTypeFactory().createSqlType(SqlTypeName.BOOLEAN);
        return this.makeCall(booleanType, (SqlOperator)SqlStdOperatorTable.AND, List.of(left, right));
    }

    public RelDataType commonType(RexNode ... nodes) {
        return this.getTypeFactory().leastRestrictive(Arrays.stream(nodes).map(RexNode::getType).toList());
    }

    public SqlIntervalQualifier createIntervalUntil(SpanUnit unit) {
        TimeUnit timeUnit = switch (unit) {
            case SpanUnit.MILLISECOND, SpanUnit.MS -> TimeUnit.MILLISECOND;
            case SpanUnit.SECOND, SpanUnit.S -> TimeUnit.SECOND;
            case SpanUnit.MINUTE, SpanUnit.m -> TimeUnit.MINUTE;
            case SpanUnit.HOUR, SpanUnit.H -> TimeUnit.HOUR;
            case SpanUnit.DAY, SpanUnit.D -> TimeUnit.DAY;
            case SpanUnit.WEEK, SpanUnit.W -> TimeUnit.WEEK;
            case SpanUnit.MONTH, SpanUnit.M -> TimeUnit.MONTH;
            case SpanUnit.QUARTER, SpanUnit.Q -> TimeUnit.QUARTER;
            case SpanUnit.YEAR, SpanUnit.Y -> TimeUnit.YEAR;
            default -> TimeUnit.EPOCH;
        };
        return new SqlIntervalQualifier(timeUnit, timeUnit, SqlParserPos.ZERO);
    }

    @Override
    public RexNode makeCast(SqlParserPos pos, RelDataType type2, RexNode exp, boolean matchNullability, boolean safe, RexLiteral format) {
        SqlTypeName sqlType = type2.getSqlTypeName();
        if (exp instanceof RexLiteral && sqlType == SqlTypeName.BOOLEAN) {
            if (exp.equals(this.makeLiteral("1", this.typeFactory.createSqlType(SqlTypeName.CHAR, 1)))) {
                return this.makeLiteral(true, type2);
            }
            if (exp.equals(this.makeLiteral("0", this.typeFactory.createSqlType(SqlTypeName.CHAR, 1)))) {
                return this.makeLiteral(false, type2);
            }
            if (SqlTypeUtil.isExactNumeric(exp.getType())) {
                return this.makeCall(type2, (SqlOperator)SqlStdOperatorTable.NOT_EQUALS, ImmutableList.of(exp, this.makeZeroLiteral(exp.getType())));
            }
        }
        return super.makeCast(pos, type2, exp, matchNullability, safe, format);
    }
}

