/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.ReflectiveCallNotNullImplementor;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.schema.ImplementableFunction;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableFunction;
import org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.Static;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TableFunctionImpl
extends ReflectiveFunctionBase
implements TableFunction,
ImplementableFunction {
    private final CallImplementor implementor;

    private TableFunctionImpl(Method method, CallImplementor implementor) {
        super(method);
        this.implementor = implementor;
    }

    public static @Nullable TableFunction create(Class<?> clazz) {
        return TableFunctionImpl.create(clazz, "eval");
    }

    public static @Nullable TableFunction create(Class<?> clazz, String methodName) {
        Method method = TableFunctionImpl.findMethod(clazz, methodName);
        if (method == null) {
            return null;
        }
        return TableFunctionImpl.create(method);
    }

    public static @Nullable TableFunction create(Method method) {
        Class<?> clazz;
        if (!ReflectUtil.isStatic(method) && !TableFunctionImpl.classHasPublicZeroArgsConstructor(clazz = method.getDeclaringClass())) {
            throw Static.RESOURCE.requireDefaultConstructor(clazz.getName()).ex();
        }
        Class<?> returnType = method.getReturnType();
        if (!QueryableTable.class.isAssignableFrom(returnType) && !ScannableTable.class.isAssignableFrom(returnType)) {
            return null;
        }
        CallImplementor implementor = TableFunctionImpl.createImplementor(method);
        return new TableFunctionImpl(method, implementor);
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, List<? extends @Nullable Object> arguments2) {
        return this.apply(arguments2).getRowType(typeFactory);
    }

    @Override
    public Type getElementType(List<? extends @Nullable Object> arguments2) {
        Table table = this.apply(arguments2);
        if (table instanceof QueryableTable) {
            QueryableTable queryableTable = (QueryableTable)table;
            return queryableTable.getElementType();
        }
        if (table instanceof ScannableTable) {
            return Object[].class;
        }
        throw new AssertionError((Object)("Invalid table class: " + table + " " + table.getClass()));
    }

    @Override
    public CallImplementor getImplementor() {
        return this.implementor;
    }

    private static CallImplementor createImplementor(Method method) {
        return RexImpTable.createImplementor(new ReflectiveCallNotNullImplementor(method){

            @Override
            public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
                Expression expr = super.implement(translator, call, translatedOperands);
                Class<?> returnType = this.method.getReturnType();
                if (QueryableTable.class.isAssignableFrom(returnType)) {
                    MethodCallExpression queryable = Expressions.call((Expression)Expressions.convert_(expr, QueryableTable.class), BuiltInMethod.QUERYABLE_TABLE_AS_QUERYABLE.method, Expressions.call(translator.getRoot(), BuiltInMethod.DATA_CONTEXT_GET_QUERY_PROVIDER.method, new Expression[0]), Expressions.constant(null, SchemaPlus.class), Expressions.constant(call.getOperator().getName(), String.class));
                    expr = Expressions.call((Expression)queryable, BuiltInMethod.QUERYABLE_AS_ENUMERABLE.method, new Expression[0]);
                } else {
                    expr = Expressions.call(expr, BuiltInMethod.SCANNABLE_TABLE_SCAN.method, translator.getRoot());
                }
                return expr;
            }
        }, NullPolicy.NONE, false);
    }

    private Table apply(List<? extends @Nullable Object> arguments2) {
        try {
            Object o = null;
            if (!ReflectUtil.isStatic(this.method)) {
                Constructor<?> constructor = this.method.getDeclaringClass().getConstructor(new Class[0]);
                o = constructor.newInstance(new Object[0]);
            }
            Object table = this.method.invoke(o, arguments2.toArray());
            return (Table)Objects.requireNonNull(table, () -> "got null from " + this.method + " with arguments " + arguments2);
        }
        catch (IllegalArgumentException e) {
            throw (CalciteException)Static.RESOURCE.illegalArgumentForTableFunctionCall(this.method.toString(), Arrays.toString(this.method.getParameterTypes()), arguments2.toString()).ex(e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

