/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowExclusion;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;
import shaded.com.google.common.base.Preconditions;
import shaded.com.google.common.collect.ImmutableList;

public class RexWindow {
    public final ImmutableList<RexNode> partitionKeys;
    public final ImmutableList<RexFieldCollation> orderKeys;
    private final RexWindowBound lowerBound;
    private final RexWindowBound upperBound;
    private final RexWindowExclusion exclude;
    private final boolean isRows;
    private final String digest;
    public final int nodeCount;

    RexWindow(List<RexNode> partitionKeys, List<RexFieldCollation> orderKeys, RexWindowBound lowerBound, RexWindowBound upperBound, boolean isRows, RexWindowExclusion exclude) {
        this.partitionKeys = ImmutableList.copyOf(partitionKeys);
        this.orderKeys = ImmutableList.copyOf(orderKeys);
        this.lowerBound = Objects.requireNonNull(lowerBound, "lowerBound");
        this.upperBound = Objects.requireNonNull(upperBound, "upperBound");
        this.exclude = exclude;
        this.isRows = isRows;
        this.nodeCount = this.computeCodeCount();
        this.digest = this.computeDigest();
        Preconditions.checkArgument(!lowerBound.isUnboundedPreceding() || !upperBound.isUnboundedFollowing() || !isRows, "use RANGE for unbounded, not ROWS");
    }

    public String toString() {
        return this.digest;
    }

    public int hashCode() {
        return this.digest.hashCode();
    }

    public boolean equals(@Nullable Object that) {
        if (that instanceof RexWindow) {
            RexWindow window = (RexWindow)that;
            return this.digest.equals(window.digest);
        }
        return false;
    }

    private String computeDigest() {
        return this.appendDigest_(new StringBuilder(), true).toString();
    }

    StringBuilder appendDigest(StringBuilder sb, boolean allowFraming) {
        if (allowFraming) {
            return sb.append(this.digest);
        }
        return this.appendDigest_(sb, allowFraming);
    }

    private StringBuilder appendDigest_(StringBuilder sb, boolean allowFraming) {
        int i;
        int initialLength = sb.length();
        if (!this.partitionKeys.isEmpty()) {
            sb.append("PARTITION BY ");
            for (i = 0; i < this.partitionKeys.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.partitionKeys.get(i));
            }
        }
        if (!this.orderKeys.isEmpty()) {
            sb.append(sb.length() > initialLength ? " ORDER BY " : "ORDER BY ");
            for (i = 0; i < this.orderKeys.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.orderKeys.get(i));
            }
        }
        if (!(!allowFraming || !this.isRows && this.orderKeys.isEmpty() || this.orderKeys.isEmpty() && this.lowerBound.isUnboundedPreceding() && this.upperBound.isUnboundedFollowing())) {
            if (this.upperBound.isCurrentRow()) {
                if (this.isRows || !this.lowerBound.isUnboundedPreceding()) {
                    sb.append(sb.length() > initialLength ? " " : "").append(this.isRows ? "ROWS" : "RANGE").append(' ').append(this.lowerBound);
                }
            } else {
                sb.append(sb.length() > initialLength ? " " : "").append(this.isRows ? "ROWS" : "RANGE").append(" BETWEEN ").append(this.lowerBound).append(" AND ").append(this.upperBound);
            }
        }
        if (this.exclude != RexWindowExclusion.EXCLUDE_NO_OTHER) {
            sb.append(" ").append((Object)this.exclude).append(" ");
        }
        return sb;
    }

    public RexWindowBound getLowerBound() {
        return this.lowerBound;
    }

    public RexWindowBound getUpperBound() {
        return this.upperBound;
    }

    public RexWindowExclusion getExclude() {
        return this.exclude;
    }

    public boolean isRows() {
        return this.isRows;
    }

    private int computeCodeCount() {
        return RexUtil.nodeCount(this.partitionKeys) + RexUtil.nodeCount(Pair.left(this.orderKeys)) + (this.lowerBound == null ? 0 : this.lowerBound.nodeCount()) + (this.upperBound == null ? 0 : this.upperBound.nodeCount());
    }
}

