/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.externalize;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.externalize.RelEnumTypes;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexSlot;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.rex.RexWindowBounds;
import org.apache.calcite.rex.RexWindowExclusion;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperatorTableFactory;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.JsonBuilder;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.RangeSets;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableRangeSet;
import shaded.com.google.common.collect.Range;
import shaded.com.google.common.collect.RangeSet;

public class RelJson {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    private static final List<Class> VALUE_CLASSES = ImmutableList.of(NlsString.class, BigDecimal.class, ByteString.class, Boolean.class, TimestampString.class, DateString.class, TimeString.class);
    private final Map<String, Constructor> constructorMap = new HashMap<String, Constructor>();
    private final @Nullable JsonBuilder jsonBuilder;
    private final InputTranslator inputTranslator;
    private final SqlOperatorTable operatorTable;
    public static final List<String> PACKAGES = ImmutableList.of("org.apache.calcite.rel.", "org.apache.calcite.rel.core.", "org.apache.calcite.rel.logical.", "org.apache.calcite.adapter.jdbc.", "org.apache.calcite.adapter.jdbc.JdbcRules$");

    private RelJson(@Nullable JsonBuilder jsonBuilder, InputTranslator inputTranslator, SqlOperatorTable operatorTable) {
        this.jsonBuilder = jsonBuilder;
        this.inputTranslator = Objects.requireNonNull(inputTranslator, "inputTranslator");
        this.operatorTable = Objects.requireNonNull(operatorTable, "operatorTable");
    }

    public static RelJson create() {
        return new RelJson(null, RelJson::translateInput, SqlStdOperatorTable.instance());
    }

    @Deprecated
    public RelJson(@Nullable JsonBuilder jsonBuilder) {
        this(jsonBuilder, RelJson::translateInput, SqlStdOperatorTable.instance());
    }

    public RelJson withJsonBuilder(JsonBuilder jsonBuilder) {
        Objects.requireNonNull(jsonBuilder, "jsonBuilder");
        if (jsonBuilder == this.jsonBuilder) {
            return this;
        }
        return new RelJson(jsonBuilder, this.inputTranslator, this.operatorTable);
    }

    public RelJson withInputTranslator(InputTranslator inputTranslator) {
        if (inputTranslator == this.inputTranslator) {
            return this;
        }
        return new RelJson(this.jsonBuilder, inputTranslator, this.operatorTable);
    }

    public RelJson withOperatorTable(SqlOperatorTable operatorTable) {
        if (operatorTable == this.operatorTable) {
            return this;
        }
        return new RelJson(this.jsonBuilder, this.inputTranslator, operatorTable);
    }

    public RelJson withLibraryOperatorTable() {
        return this.withOperatorTable(SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(SqlLibrary.values()));
    }

    private JsonBuilder jsonBuilder() {
        return Objects.requireNonNull(this.jsonBuilder, "jsonBuilder");
    }

    private static <T> T get(Map<String, ? extends @Nullable Object> map, String key) {
        return (T)Objects.requireNonNull(map.get(key), () -> "entry for key " + key);
    }

    private static <T extends Enum<T>> T enumVal(Class<T> clazz, Map<String, Object> map, String key) {
        String textValue = (String)RelJson.get(map, key);
        return (T)((Enum)((Object)Objects.requireNonNull(Util.enumVal(clazz, textValue), () -> "unable to find enum value " + textValue + " in class " + clazz)));
    }

    public RelNode create(Map<String, Object> map) {
        String type2 = (String)RelJson.get(map, "type");
        Constructor constructor = this.getConstructor(type2);
        try {
            return (RelNode)constructor.newInstance(map);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("while invoking constructor for type '" + type2 + "'", e);
        }
    }

    public Constructor getConstructor(String type2) {
        Constructor constructor = this.constructorMap.get(type2);
        if (constructor == null) {
            Class clazz = this.typeNameToClass(type2);
            try {
                constructor = clazz.getConstructor(RelInput.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("class does not have required constructor, " + clazz + "(RelInput)");
            }
            this.constructorMap.put(type2, constructor);
        }
        return constructor;
    }

    public Class typeNameToClass(String type2) {
        if (!type2.contains(".")) {
            for (String package_ : PACKAGES) {
                try {
                    return Class.forName(package_ + type2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        try {
            return Class.forName(type2);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("unknown type " + type2);
        }
    }

    public String classToTypeName(Class<? extends RelNode> class_) {
        String canonicalName = class_.getName();
        for (String package_ : PACKAGES) {
            String remaining;
            if (!canonicalName.startsWith(package_) || (remaining = canonicalName.substring(package_.length())).indexOf(46) >= 0 || remaining.indexOf(36) >= 0) continue;
            return remaining;
        }
        return canonicalName;
    }

    private static RexNode translateInput(RelJson relJson, int input, Map<String, @Nullable Object> map, RelInput relInput) {
        RelOptCluster cluster = relInput.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (map.containsKey("type")) {
            RelDataTypeFactory typeFactory = cluster.getTypeFactory();
            RelDataType type2 = relJson.toType(typeFactory, RelJson.get(map, "type"));
            return rexBuilder.makeLocalRef(type2, input);
        }
        int i = input;
        List<RelNode> relNodes = relInput.getInputs();
        for (RelNode inputNode : relNodes) {
            RelDataType rowType = inputNode.getRowType();
            if (i < rowType.getFieldCount()) {
                RelDataTypeField field = rowType.getFieldList().get(i);
                return rexBuilder.makeInputRef(field.getType(), input);
            }
            i -= rowType.getFieldCount();
        }
        throw new RuntimeException("input field " + input + " is out of range");
    }

    public Object toJson(RelCollationImpl node) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (RelFieldCollation fieldCollation : node.getFieldCollations()) {
            Map<String, @Nullable Object> map = this.jsonBuilder().map();
            map.put("field", fieldCollation.getFieldIndex());
            map.put("direction", fieldCollation.getDirection().name());
            map.put("nulls", fieldCollation.nullDirection.name());
            list.add(map);
        }
        return list;
    }

    public RelCollation toCollation(List<Map<String, Object>> jsonFieldCollations) {
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        for (Map<String, Object> map : jsonFieldCollations) {
            fieldCollations.add(this.toFieldCollation(map));
        }
        return RelCollations.of(fieldCollations);
    }

    public RelFieldCollation toFieldCollation(Map<String, Object> map) {
        Integer field = (Integer)RelJson.get(map, "field");
        RelFieldCollation.Direction direction = RelJson.enumVal(RelFieldCollation.Direction.class, map, "direction");
        RelFieldCollation.NullDirection nullDirection = RelJson.enumVal(RelFieldCollation.NullDirection.class, map, "nulls");
        return new RelFieldCollation(field, direction, nullDirection);
    }

    public RelDistribution toDistribution(Map<String, Object> map) {
        RelDistribution.Type type2 = RelJson.enumVal(RelDistribution.Type.class, map, "type");
        ImmutableIntList list = RelDistributions.EMPTY;
        List keys2 = (List)map.get("keys");
        if (keys2 != null) {
            list = ImmutableIntList.copyOf(keys2);
        }
        return RelDistributions.of(type2, list);
    }

    private Object toJson(RelDistribution relDistribution) {
        Map<String, @Nullable Object> map = this.jsonBuilder().map();
        map.put("type", relDistribution.getType().name());
        if (!relDistribution.getKeys().isEmpty()) {
            map.put("keys", relDistribution.getKeys());
        }
        return map;
    }

    public RelDataType toType(RelDataTypeFactory typeFactory, Object o) {
        if (o instanceof List) {
            List jsonList = (List)o;
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            for (Map jsonMap : jsonList) {
                ((RelDataTypeFactory.Builder)builder).add((String)RelJson.get(jsonMap, "name"), this.toType(typeFactory, jsonMap));
            }
            return builder.build();
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            RelDataType type2 = this.getRelDataType(typeFactory, map);
            boolean nullable = (Boolean)RelJson.get(map, "nullable");
            return typeFactory.createTypeWithNullability(type2, nullable);
        }
        SqlTypeName sqlTypeName = (SqlTypeName)((Object)Objects.requireNonNull(Util.enumVal(SqlTypeName.class, (String)o), () -> "unable to find enum value " + o + " in class " + SqlTypeName.class));
        return typeFactory.createSqlType(sqlTypeName);
    }

    private RelDataType getRelDataType(RelDataTypeFactory typeFactory, Map<String, Object> map) {
        Object fields2 = map.get("fields");
        if (fields2 != null) {
            return this.toType(typeFactory, fields2);
        }
        SqlTypeName sqlTypeName = RelJson.enumVal(SqlTypeName.class, map, "type");
        switch (sqlTypeName) {
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                TimeUnit startUnit = sqlTypeName.getStartUnit();
                TimeUnit endUnit = sqlTypeName.getEndUnit();
                return typeFactory.createSqlIntervalType(new SqlIntervalQualifier(startUnit, endUnit, SqlParserPos.ZERO));
            }
            case ARRAY: {
                Object component = Objects.requireNonNull(map.get("component"), "component");
                RelDataType componentType = this.toType(typeFactory, component);
                return typeFactory.createArrayType(componentType, -1L);
            }
            case MAP: {
                Object key = RelJson.get(map, "key");
                Object value = RelJson.get(map, "value");
                RelDataType keyType = this.toType(typeFactory, key);
                RelDataType valueType = this.toType(typeFactory, value);
                return typeFactory.createMapType(keyType, valueType);
            }
            case MULTISET: {
                Object component = Objects.requireNonNull(map.get("component"), "component");
                RelDataType componentType = this.toType(typeFactory, component);
                return typeFactory.createMultisetType(componentType, -1L);
            }
        }
        Integer precision = (Integer)map.get("precision");
        Integer scale = (Integer)map.get("scale");
        if (precision == null) {
            return typeFactory.createSqlType(sqlTypeName);
        }
        if (scale == null) {
            return typeFactory.createSqlType(sqlTypeName, precision);
        }
        return typeFactory.createSqlType(sqlTypeName, precision, scale);
    }

    public Object toJson(AggregateCall node) {
        Map<String, @Nullable Object> map = this.jsonBuilder().map();
        Map<String, @Nullable Object> aggMap = this.toJson(node.getAggregation());
        if (node.getAggregation().getFunctionType().isUserDefined()) {
            aggMap.put("class", node.getAggregation().getClass().getName());
        }
        map.put("agg", aggMap);
        map.put("type", this.toJson(node.getType()));
        map.put("distinct", node.isDistinct());
        map.put("operands", node.getArgList());
        map.put("name", node.getName());
        return map;
    }

    public @Nullable Object toJson(@Nullable Object value) {
        if (value == null || value instanceof Number || value instanceof String || value instanceof Boolean) {
            return value;
        }
        if (value instanceof RexNode) {
            return this.toJson((RexNode)value);
        }
        if (value instanceof RexWindow) {
            return this.toJson((RexWindow)value);
        }
        if (value instanceof RexFieldCollation) {
            return this.toJson((RexFieldCollation)value);
        }
        if (value instanceof RexWindowBound) {
            return this.toJson((RexWindowBound)value);
        }
        if (value instanceof CorrelationId) {
            return RelJson.toJson((CorrelationId)value);
        }
        if (value instanceof List || value instanceof Set) {
            List<@Nullable Object> list = this.jsonBuilder().list();
            for (Object o : (Collection)value) {
                list.add(this.toJson(o));
            }
            return list;
        }
        if (value instanceof ImmutableBitSet) {
            List<@Nullable Object> list = this.jsonBuilder().list();
            for (Integer integer : (ImmutableBitSet)value) {
                list.add(this.toJson(integer));
            }
            return list;
        }
        if (value instanceof AggregateCall) {
            return this.toJson((AggregateCall)value);
        }
        if (value instanceof RelCollationImpl) {
            return this.toJson((RelCollationImpl)value);
        }
        if (value instanceof RelDataType) {
            return this.toJson((RelDataType)value);
        }
        if (value instanceof RelDataTypeField) {
            return this.toJson((RelDataTypeField)value);
        }
        if (value instanceof RelDistribution) {
            return this.toJson((RelDistribution)value);
        }
        if (value instanceof Sarg) {
            return this.toJson((Sarg)value);
        }
        if (value instanceof RangeSet) {
            return this.toJson((RangeSet)value);
        }
        if (value instanceof Range) {
            return this.toJson((Range)value);
        }
        throw new UnsupportedOperationException("type not serializable: " + value + " (type " + value.getClass().getCanonicalName() + ")");
    }

    public <C extends Comparable<C>> Object toJson(Sarg<C> node) {
        Map<String, @Nullable Object> map = this.jsonBuilder().map();
        map.put("rangeSet", this.toJson(node.rangeSet));
        map.put("nullAs", RelEnumTypes.fromEnum(node.nullAs));
        return map;
    }

    public <C extends Comparable<C>> List<List<String>> toJson(RangeSet<C> rangeSet) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        try {
            RangeSets.forEach(rangeSet, RangeToJsonConverter.instance().andThen(list::add));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to serialize RangeSet: ", e);
        }
        return list;
    }

    public <C extends Comparable<C>> List<String> toJson(Range<C> range) {
        return (List)RangeSets.map(range, RangeToJsonConverter.instance());
    }

    private Object toJson(RelDataType node) {
        Map<String, @Nullable Object> map = this.jsonBuilder().map();
        if (node.isStruct()) {
            List<@Nullable Object> list = this.jsonBuilder().list();
            for (RelDataTypeField field : node.getFieldList()) {
                list.add(this.toJson(field));
            }
            map.put("fields", list);
            map.put("nullable", node.isNullable());
        } else {
            RelDataType valueType;
            RelDataType keyType;
            map.put("type", node.getSqlTypeName().name());
            map.put("nullable", node.isNullable());
            if (node.getComponentType() != null) {
                map.put("component", this.toJson(node.getComponentType()));
            }
            if ((keyType = node.getKeyType()) != null) {
                map.put("key", this.toJson(keyType));
            }
            if ((valueType = node.getValueType()) != null) {
                map.put("value", this.toJson(valueType));
            }
            if (node.getSqlTypeName().allowsPrec()) {
                map.put("precision", node.getPrecision());
            }
            if (node.getSqlTypeName().allowsScale()) {
                map.put("scale", node.getScale());
            }
        }
        return map;
    }

    private Object toJson(RelDataTypeField node) {
        Map map;
        if (node.getType().isStruct()) {
            map = this.jsonBuilder().map();
            map.put("fields", this.toJson(node.getType()));
            map.put("nullable", node.getType().isNullable());
        } else {
            map = (Map)this.toJson(node.getType());
        }
        map.put("name", node.getName());
        return map;
    }

    private static Object toJson(CorrelationId node) {
        return node.getId();
    }

    public Object toJson(RexNode node) {
        switch (node.getKind()) {
            case DYNAMIC_PARAM: {
                Map<String, Object> map = this.jsonBuilder().map();
                RexDynamicParam rexDynamicParam = (RexDynamicParam)node;
                RelDataType rdpType = rexDynamicParam.getType();
                map.put("dynamicParam", rexDynamicParam.getIndex());
                map.put("type", this.toJson(rdpType));
                return map;
            }
            case FIELD_ACCESS: {
                Map<String, Object> map = this.jsonBuilder().map();
                RexFieldAccess fieldAccess = (RexFieldAccess)node;
                map.put("field", fieldAccess.getField().getName());
                map.put("expr", this.toJson(fieldAccess.getReferenceExpr()));
                return map;
            }
            case LITERAL: {
                RexLiteral literal = (RexLiteral)node;
                Object value = literal.getValue3();
                Map<String, Object> map = this.jsonBuilder().map();
                map.put("literal", value instanceof Enum ? RelEnumTypes.fromEnum((Enum)value) : this.toJson(value));
                map.put("type", this.toJson(node.getType()));
                return map;
            }
            case INPUT_REF: {
                Map<String, Object> map = this.jsonBuilder().map();
                map.put("input", ((RexSlot)node).getIndex());
                map.put("name", ((RexSlot)node).getName());
                return map;
            }
            case LOCAL_REF: {
                Map<String, Object> map = this.jsonBuilder().map();
                map.put("input", ((RexSlot)node).getIndex());
                map.put("name", ((RexSlot)node).getName());
                map.put("type", this.toJson(node.getType()));
                return map;
            }
            case CORREL_VARIABLE: {
                Map<String, Object> map = this.jsonBuilder().map();
                map.put("correl", ((RexCorrelVariable)node).getName());
                map.put("type", this.toJson(node.getType()));
                return map;
            }
        }
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            Map<String, Object> map = this.jsonBuilder().map();
            map.put("op", this.toJson(call.getOperator()));
            List<@Nullable Object> list = this.jsonBuilder().list();
            for (RexNode operand : call.getOperands()) {
                list.add(this.toJson(operand));
            }
            map.put("operands", list);
            switch (node.getKind()) {
                case MINUS: 
                case CAST: 
                case SAFE_CAST: {
                    map.put("type", this.toJson(node.getType()));
                    break;
                }
            }
            if (call.getOperator() instanceof SqlFunction && ((SqlFunction)call.getOperator()).getFunctionType().isUserDefined()) {
                SqlOperator op = call.getOperator();
                map.put("class", op.getClass().getName());
                map.put("type", this.toJson(node.getType()));
                map.put("deterministic", op.isDeterministic());
                map.put("dynamic", op.isDynamicFunction());
            }
            if (call instanceof RexOver) {
                RexOver over = (RexOver)call;
                map.put("distinct", over.isDistinct());
                map.put("type", this.toJson(node.getType()));
                map.put("window", this.toJson(over.getWindow()));
            }
            return map;
        }
        throw new UnsupportedOperationException("unknown rex " + node);
    }

    private Object toJson(RexWindow window) {
        Map<String, @Nullable Object> map = this.jsonBuilder().map();
        if (!window.partitionKeys.isEmpty()) {
            map.put("partition", this.toJson(window.partitionKeys));
        }
        if (!window.orderKeys.isEmpty()) {
            map.put("order", this.toJson(window.orderKeys));
        }
        if (window.getLowerBound() != null) {
            if (window.getUpperBound() == null) {
                if (window.isRows()) {
                    map.put("rows-lower", this.toJson(window.getLowerBound()));
                } else {
                    map.put("range-lower", this.toJson(window.getLowerBound()));
                }
            } else if (window.isRows()) {
                map.put("rows-lower", this.toJson(window.getLowerBound()));
                map.put("rows-upper", this.toJson(window.getUpperBound()));
            } else {
                map.put("range-lower", this.toJson(window.getLowerBound()));
                map.put("range-upper", this.toJson(window.getUpperBound()));
            }
        }
        return map;
    }

    private Object toJson(RexFieldCollation collation) {
        Map<String, @Nullable Object> map = this.jsonBuilder().map();
        map.put("expr", this.toJson((RexNode)collation.left));
        map.put("direction", collation.getDirection().name());
        map.put("null-direction", collation.getNullDirection().name());
        return map;
    }

    private Object toJson(RexWindowBound windowBound) {
        Map<String, @Nullable Object> map = this.jsonBuilder().map();
        if (windowBound.isCurrentRow()) {
            map.put("type", "CURRENT_ROW");
        } else if (windowBound.isUnbounded()) {
            map.put("type", windowBound.isPreceding() ? "UNBOUNDED_PRECEDING" : "UNBOUNDED_FOLLOWING");
        } else {
            map.put("type", windowBound.isPreceding() ? "PRECEDING" : "FOLLOWING");
            RexNode offset = Objects.requireNonNull(windowBound.getOffset(), () -> "getOffset for window bound " + windowBound);
            map.put("offset", this.toJson(offset));
        }
        return map;
    }

    public RexNode toRex(RelOptCluster cluster, Object o) {
        RelInputForCluster input = new RelInputForCluster(cluster);
        return this.toRex(input, o);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @PolyNull RexNode toRex(RelInput relInput, @PolyNull Object o) {
        RelOptCluster cluster = relInput.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (o == null) {
            return null;
        }
        if (Map.class.isAssignableFrom(o.getClass())) {
            @Nullable Map map = (Map)o;
            RelDataTypeFactory typeFactory = cluster.getTypeFactory();
            if (map.containsKey("op")) {
                @Nullable Map opMap = (Map)RelJson.get(map, "op");
                if (map.containsKey("class")) {
                    opMap.put("class", RelJson.get(map, "class"));
                }
                List operands = (List)RelJson.get(map, "operands");
                List<RexNode> rexOperands = this.toRexList(relInput, operands);
                Object jsonType = map.get("type");
                Map window = (Map)map.get("window");
                if (window != null) {
                    boolean physical;
                    RexWindowBound upperBound;
                    RexWindowBound lowerBound;
                    SqlAggFunction operator = Objects.requireNonNull(this.toAggregation(opMap), "operator");
                    RelDataType type2 = this.toType(typeFactory, Objects.requireNonNull(jsonType, "jsonType"));
                    ArrayList<RexNode> partitionKeys = new ArrayList();
                    Object partition = window.get("partition");
                    if (partition != null) {
                        partitionKeys = this.toRexList(relInput, (List)partition);
                    }
                    ArrayList<RexFieldCollation> orderKeys = new ArrayList<RexFieldCollation>();
                    if (window.containsKey("order")) {
                        this.addRexFieldCollationList(orderKeys, relInput, (List)window.get("order"));
                    }
                    if (window.get("rows-lower") != null) {
                        lowerBound = this.toRexWindowBound(relInput, (Map)window.get("rows-lower"));
                        upperBound = this.toRexWindowBound(relInput, (Map)window.get("rows-upper"));
                        physical = true;
                    } else if (window.get("range-lower") != null) {
                        lowerBound = this.toRexWindowBound(relInput, (Map)window.get("range-lower"));
                        upperBound = this.toRexWindowBound(relInput, (Map)window.get("range-upper"));
                        physical = false;
                    } else {
                        lowerBound = null;
                        upperBound = null;
                        physical = false;
                    }
                    RexWindowExclusion exclude = window.get("exclude") != null ? RelJson.toRexWindowExclusion((Map)window.get("exclude")) : RexWindowExclusion.EXCLUDE_NO_OTHER;
                    boolean distinct2 = (Boolean)RelJson.get(map, "distinct");
                    return rexBuilder.makeOver(type2, operator, rexOperands, partitionKeys, ImmutableList.copyOf(orderKeys), Objects.requireNonNull(lowerBound, "lowerBound"), Objects.requireNonNull(upperBound, "upperBound"), Objects.requireNonNull(exclude, "exclude"), physical, true, false, distinct2, false);
                }
                SqlOperator operator = Objects.requireNonNull(this.toOp(opMap), "operator");
                RelDataType type3 = jsonType != null ? this.toType(typeFactory, jsonType) : rexBuilder.deriveReturnType(operator, rexOperands);
                return rexBuilder.makeCall(type3, operator, rexOperands);
            }
            Integer input = (Integer)map.get("input");
            if (input != null) {
                return this.inputTranslator.translateInput(this, input, map, relInput);
            }
            String field = (String)map.get("field");
            if (field != null) {
                Object jsonExpr = RelJson.get(map, "expr");
                RexNode expr = this.toRex(relInput, jsonExpr);
                return rexBuilder.makeFieldAccess(expr, field, true);
            }
            String correl = (String)map.get("correl");
            if (correl != null) {
                Object jsonType = RelJson.get(map, "type");
                RelDataType type4 = this.toType(typeFactory, jsonType);
                return rexBuilder.makeCorrel(type4, new CorrelationId(correl));
            }
            if (map.containsKey("literal")) {
                Object literal = map.get("literal");
                if (literal == null) {
                    RelDataType type5 = this.toType(typeFactory, RelJson.get(map, "type"));
                    return rexBuilder.makeNullLiteral(type5);
                }
                if (!map.containsKey("type")) {
                    return this.toRex(relInput, literal);
                }
                RelDataType type6 = this.toType(typeFactory, RelJson.get(map, "type"));
                if (literal instanceof Map && ((Map)literal).containsKey("rangeSet")) {
                    Sarg sarg = RelJson.sargFromJson((Map)literal);
                    return rexBuilder.makeSearchArgumentLiteral(sarg, type6);
                }
                if (type6.getSqlTypeName() == SqlTypeName.SYMBOL) {
                    literal = RelEnumTypes.toEnum((String)literal);
                }
                return rexBuilder.makeLiteral(literal, type6);
            }
            if (map.containsKey("sargLiteral")) {
                Object sargObject = map.get("sargLiteral");
                if (sargObject == null) {
                    RelDataType type7 = this.toType(typeFactory, RelJson.get(map, "type"));
                    return rexBuilder.makeNullLiteral(type7);
                }
                RelDataType type8 = this.toType(typeFactory, RelJson.get(map, "type"));
                Sarg sarg = RelJson.sargFromJson((Map)sargObject);
                return rexBuilder.makeSearchArgumentLiteral(sarg, type8);
            }
            if (map.containsKey("dynamicParam")) {
                Object dynamicParamObject = Objects.requireNonNull(map.get("dynamicParam"));
                Integer index = (Integer)dynamicParamObject;
                RelDataType type9 = this.toType(typeFactory, RelJson.get(map, "type"));
                return rexBuilder.makeDynamicParam(type9, index);
            }
            throw new UnsupportedOperationException("cannot convert to rex " + o);
        }
        if (o instanceof Boolean) {
            return rexBuilder.makeLiteral((Boolean)o);
        }
        if (o instanceof String) {
            return rexBuilder.makeLiteral((String)o);
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            if (number instanceof Double || number instanceof Float) {
                return rexBuilder.makeApproxLiteral(BigDecimal.valueOf(number.doubleValue()));
            }
            return rexBuilder.makeExactLiteral(BigDecimal.valueOf(number.longValue()));
        }
        throw new UnsupportedOperationException("cannot convert to rex " + o);
    }

    public static <C extends Comparable<C>> Sarg<C> sargFromJson(Map<String, Object> map) {
        String nullAs = Objects.requireNonNull((String)map.get("nullAs"), "nullAs");
        List rangeSet = Objects.requireNonNull((List)map.get("rangeSet"), "rangeSet");
        return Sarg.of((RexUnknownAs)((Object)RelEnumTypes.toEnum(nullAs)), RelJson.rangeSetFromJson(rangeSet));
    }

    public static <C extends Comparable<C>> RangeSet<C> rangeSetFromJson(List<List<String>> rangeSetsJson) {
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        try {
            rangeSetsJson.forEach(list -> builder.add(RelJson.rangeFromJson(list)));
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating RangeSet from JSON: ", e);
        }
        return builder.build();
    }

    public static <C extends Comparable<C>> Range<C> rangeFromJson(List<String> list) {
        switch (list.get(0)) {
            case "all": {
                return Range.all();
            }
            case "atLeast": {
                return Range.atLeast(RelJson.rangeEndPointFromJson(list.get(1)));
            }
            case "atMost": {
                return Range.atMost(RelJson.rangeEndPointFromJson(list.get(1)));
            }
            case "greaterThan": {
                return Range.greaterThan(RelJson.rangeEndPointFromJson(list.get(1)));
            }
            case "lessThan": {
                return Range.lessThan(RelJson.rangeEndPointFromJson(list.get(1)));
            }
            case "singleton": {
                return Range.singleton(RelJson.rangeEndPointFromJson(list.get(1)));
            }
            case "closed": {
                return Range.closed(RelJson.rangeEndPointFromJson(list.get(1)), RelJson.rangeEndPointFromJson(list.get(2)));
            }
            case "closedOpen": {
                return Range.closedOpen(RelJson.rangeEndPointFromJson(list.get(1)), RelJson.rangeEndPointFromJson(list.get(2)));
            }
            case "openClosed": {
                return Range.openClosed(RelJson.rangeEndPointFromJson(list.get(1)), RelJson.rangeEndPointFromJson(list.get(2)));
            }
            case "open": {
                return Range.open(RelJson.rangeEndPointFromJson(list.get(1)), RelJson.rangeEndPointFromJson(list.get(2)));
            }
        }
        throw new AssertionError((Object)("unknown range type " + list.get(0)));
    }

    private static <C extends Comparable<C>> C rangeEndPointFromJson(Object o) {
        JsonProcessingException e = null;
        for (Class clsType : VALUE_CLASSES) {
            try {
                return (C)((Comparable)OBJECT_MAPPER.readValue((String)o, clsType));
            }
            catch (JsonProcessingException ex) {
                e = ex;
            }
        }
        throw new RuntimeException("Error deserializing range endpoint (did not find compatible type): ", e);
    }

    private void addRexFieldCollationList(List<RexFieldCollation> list, RelInput relInput, @Nullable List<Map<String, Object>> order) {
        if (order == null) {
            return;
        }
        for (Map<String, Object> o : order) {
            RexNode expr = Objects.requireNonNull(this.toRex(relInput, o.get("expr")), "expr");
            HashSet<SqlKind> directions = new HashSet<SqlKind>();
            if (RelFieldCollation.Direction.valueOf((String)RelJson.get(o, "direction")) == RelFieldCollation.Direction.DESCENDING) {
                directions.add(SqlKind.DESCENDING);
            }
            if (RelFieldCollation.NullDirection.valueOf((String)RelJson.get(o, "null-direction")) == RelFieldCollation.NullDirection.FIRST) {
                directions.add(SqlKind.NULLS_FIRST);
            } else {
                directions.add(SqlKind.NULLS_LAST);
            }
            list.add(new RexFieldCollation(expr, (Set<SqlKind>)directions));
        }
    }

    private static @Nullable RexWindowExclusion toRexWindowExclusion(@Nullable Map<String, Object> map) {
        String type2;
        if (map == null) {
            return null;
        }
        switch (type2 = (String)RelJson.get(map, "type")) {
            case "CURRENT_ROW": {
                return RexWindowExclusion.EXCLUDE_CURRENT_ROW;
            }
            case "GROUP": {
                return RexWindowExclusion.EXCLUDE_GROUP;
            }
            case "TIES": {
                return RexWindowExclusion.EXCLUDE_TIES;
            }
            case "NO OTHERS": {
                return RexWindowExclusion.EXCLUDE_NO_OTHER;
            }
        }
        throw new UnsupportedOperationException("cannot convert " + type2 + " to rex window exclusion");
    }

    private @Nullable RexWindowBound toRexWindowBound(RelInput input, @Nullable Map<String, Object> map) {
        String type2;
        if (map == null) {
            return null;
        }
        switch (type2 = (String)RelJson.get(map, "type")) {
            case "CURRENT_ROW": {
                return RexWindowBounds.CURRENT_ROW;
            }
            case "UNBOUNDED_PRECEDING": {
                return RexWindowBounds.UNBOUNDED_PRECEDING;
            }
            case "UNBOUNDED_FOLLOWING": {
                return RexWindowBounds.UNBOUNDED_FOLLOWING;
            }
            case "PRECEDING": {
                return RexWindowBounds.preceding(this.toRex(input, RelJson.get(map, "offset")));
            }
            case "FOLLOWING": {
                return RexWindowBounds.following(this.toRex(input, RelJson.get(map, "offset")));
            }
        }
        throw new UnsupportedOperationException("cannot convert " + type2 + " to rex window bound");
    }

    private List<RexNode> toRexList(RelInput relInput, List operands) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        for (Object operand : operands) {
            list.add(this.toRex(relInput, operand));
        }
        return list;
    }

    @Nullable SqlOperator toOp(Map<String, ? extends @Nullable Object> map) {
        String name = (String)RelJson.get(map, "name");
        String kind = (String)RelJson.get(map, "kind");
        String syntax = (String)RelJson.get(map, "syntax");
        SqlKind sqlKind = SqlKind.valueOf(kind);
        SqlSyntax sqlSyntax = SqlSyntax.valueOf(syntax);
        ArrayList<SqlOperator> operators = new ArrayList<SqlOperator>();
        this.operatorTable.lookupOperatorOverloads(new SqlIdentifier(name, SqlParserPos.ZERO), null, sqlSyntax, operators, SqlNameMatchers.liberal());
        for (SqlOperator operator : operators) {
            if (operator.kind != sqlKind) continue;
            return operator;
        }
        String class_ = (String)map.get("class");
        if (class_ != null) {
            return AvaticaUtils.instantiatePlugin(SqlOperator.class, class_);
        }
        throw Static.RESOURCE.noOperator(name, kind, syntax).ex();
    }

    @Nullable SqlAggFunction toAggregation(Map<String, ? extends @Nullable Object> map) {
        return (SqlAggFunction)this.toOp(map);
    }

    private Map<String, @Nullable Object> toJson(SqlOperator operator) {
        Map<String, @Nullable Object> map = this.jsonBuilder().map();
        map.put("name", operator.getName());
        map.put("kind", operator.kind.toString());
        map.put("syntax", operator.getSyntax().toString());
        return map;
    }

    @Deprecated
    public static RexNode readExpression(RelOptCluster cluster, InputTranslator translator, Map<String, Object> o) {
        RelInputForCluster relInput = new RelInputForCluster(cluster);
        return new RelJson(null, translator, SqlStdOperatorTable.instance()).toRex(relInput, o);
    }

    private static class RangeToJsonConverter<V>
    implements RangeSets.Handler<V, List<String>> {
        private static final RangeToJsonConverter INSTANCE = new RangeToJsonConverter();

        private RangeToJsonConverter() {
        }

        private static <C extends Comparable<C>> RangeToJsonConverter<C> instance() {
            return INSTANCE;
        }

        @Override
        public List<String> all() {
            return ImmutableList.of("all");
        }

        @Override
        public List<String> atLeast(@NonNull V lower) {
            return ImmutableList.of("atLeast", RangeToJsonConverter.toJson(lower));
        }

        @Override
        public List<String> atMost(@NonNull V upper) {
            return ImmutableList.of("atMost", RangeToJsonConverter.toJson(upper));
        }

        @Override
        public List<String> greaterThan(@NonNull V lower) {
            return ImmutableList.of("greaterThan", RangeToJsonConverter.toJson(lower));
        }

        @Override
        public List<String> lessThan(@NonNull V upper) {
            return ImmutableList.of("lessThan", RangeToJsonConverter.toJson(upper));
        }

        @Override
        public List<String> singleton(@NonNull V value) {
            return ImmutableList.of("singleton", RangeToJsonConverter.toJson(value));
        }

        @Override
        public List<String> closed(@NonNull V lower, @NonNull V upper) {
            return ImmutableList.of("closed", RangeToJsonConverter.toJson(lower), RangeToJsonConverter.toJson(upper));
        }

        @Override
        public List<String> closedOpen(@NonNull V lower, @NonNull V upper) {
            return ImmutableList.of("closedOpen", RangeToJsonConverter.toJson(lower), RangeToJsonConverter.toJson(upper));
        }

        @Override
        public List<String> openClosed(@NonNull V lower, @NonNull V upper) {
            return ImmutableList.of("openClosed", RangeToJsonConverter.toJson(lower), RangeToJsonConverter.toJson(upper));
        }

        @Override
        public List<String> open(@NonNull V lower, @NonNull V upper) {
            return ImmutableList.of("open", RangeToJsonConverter.toJson(lower), RangeToJsonConverter.toJson(upper));
        }

        private static String toJson(Object o) {
            try {
                return OBJECT_MAPPER.writeValueAsString(o);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Failed to serialize Range endpoint: ", e);
            }
        }
    }

    @FunctionalInterface
    public static interface InputTranslator {
        public RexNode translateInput(RelJson var1, int var2, Map<String, @Nullable Object> var3, RelInput var4);
    }

    private static class RelInputForCluster
    implements RelInput {
        private final RelOptCluster cluster;

        RelInputForCluster(RelOptCluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public RelOptCluster getCluster() {
            return this.cluster;
        }

        @Override
        public RelTraitSet getTraitSet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelOptTable getTable(String table) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelNode getInput() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<RelNode> getInputs() {
            return ImmutableList.of();
        }

        @Override
        public @Nullable RexNode getExpression(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableBitSet getBitSet(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable List<ImmutableBitSet> getBitSetList(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AggregateCall> getAggregateCalls(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object get(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable String getString(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float getFloat(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal getBigDecimal(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <E extends Enum<E>> @Nullable E getEnum(String tag, Class<E> enumClass) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable List<RexNode> getExpressionList(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable List<String> getStringList(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable List<Integer> getIntegerList(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable List<List<Integer>> getIntegerListList(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelDataType getRowType(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelDataType getRowType(String expressionsTag, String fieldsTag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelCollation getCollation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RelDistribution getDistribution() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ImmutableList<ImmutableList<RexLiteral>> getTuples(String tag) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getBoolean(String tag, boolean default_) {
            throw new UnsupportedOperationException();
        }
    }
}

