/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api.ssl;

import java.util.Locale;

public enum CertificateType {
    HTTP("http"),
    TRANSPORT("transport"),
    ALL("all");

    private final String value;

    private CertificateType(String value) {
        this.value = value;
    }

    public static boolean isHttp(CertificateType certificateType) {
        return certificateType == HTTP || certificateType == ALL;
    }

    public static boolean isTransport(CertificateType certificateType) {
        return certificateType == TRANSPORT || certificateType == ALL;
    }

    public String value() {
        return this.value.toLowerCase(Locale.ROOT);
    }

    public static CertificateType from(String certType) {
        if (certType == null) {
            return ALL;
        }
        for (CertificateType t : CertificateType.values()) {
            if (!t.value.equalsIgnoreCase(certType)) continue;
            return t;
        }
        throw new IllegalArgumentException("Invalid certificate type: " + certType);
    }
}

