/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedBiConsumer;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.identity.tokens.AuthToken;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.RequestHandler;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.api.SecurityConfiguration;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.EndpointValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.hasher.PasswordHasher;
import org.opensearch.security.securityconf.Hashed;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.support.SecurityJsonNode;
import org.opensearch.security.user.UserFilterType;
import org.opensearch.security.user.UserService;
import org.opensearch.security.user.UserServiceException;
import org.opensearch.threadpool.ThreadPool;

public class InternalUsersApiAction
extends AbstractApiAction {
    private final PasswordHasher passwordHasher;
    public static final List<String> RESTRICTED_FROM_USERNAME = ImmutableList.of((Object)":");
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/user/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/user"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/user/{name}/authtoken"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/user/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/user/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/internalusers/{name}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/internalusers"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/internalusers/{name}/authtoken"), (Object)new RestHandler.Route(RestRequest.Method.DELETE, "/internalusers/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PUT, "/internalusers/{name}"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/internalusers"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/internalusers/{name}"), (Object[])new RestHandler.Route[0]));
    UserService userService;

    @Override
    protected void consumeParameters(RestRequest request) {
        request.param("name");
        request.param("filterBy");
    }

    @Inject
    public InternalUsersApiAction(ClusterService clusterService, ThreadPool threadPool, UserService userService, SecurityApiDependencies securityApiDependencies, PasswordHasher passwordHasher) {
        super(Endpoint.INTERNALUSERS, clusterService, threadPool, securityApiDependencies);
        this.userService = userService;
        this.requestHandlersBuilder.configureRequestHandlers(this::internalUsersApiRequestHandlers);
        this.passwordHasher = passwordHasher;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected CType<?> getConfigType() {
        return CType.INTERNALUSERS;
    }

    private void internalUsersApiRequestHandlers(RequestHandler.RequestHandlersBuilder requestHandlersBuilder) {
        requestHandlersBuilder.onGetRequest((CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)request -> ValidationResult.success(request).map(this::processGetRequest).map(securityConfiguration -> {
            SecurityDynamicConfiguration<?> configuration = securityConfiguration.configuration();
            this.filterUsers(configuration, this.filterParam((RestRequest)request));
            return ValidationResult.success(securityConfiguration);
        }))).override(RestRequest.Method.POST, (channel, request, client) -> this.withAuthTokenPath(request).map(username -> this.loadConfiguration(this.getConfigType(), true, false).map(configuration -> ValidationResult.success(SecurityConfiguration.of(username, configuration)))).map(this.endpointValidator::entityExists).map(this.endpointValidator::isAllowedToLoadOrChangeHiddenEntity).valid(securityConfiguration -> this.generateAuthToken(channel, (SecurityConfiguration)securityConfiguration)).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent)))).onChangeRequest(RestRequest.Method.PATCH, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)this::processPatchRequest)).onChangeRequest(RestRequest.Method.PUT, (CheckedFunction<RestRequest, ValidationResult<SecurityConfiguration>, IOException>)((CheckedFunction)request -> this.endpointValidator.withRequiredEntityName(this.nameParam((RestRequest)request)).map(username -> this.loadConfigurationWithRequestContent((String)username, (RestRequest)request)).map(this.endpointValidator::isAllowedToChangeImmutableEntity).map(this::validateSecurityRoles).map(securityConfiguration -> this.createOrUpdateAccount((RestRequest)request, (SecurityConfiguration)securityConfiguration)).map(this::validateAndUpdatePassword).map(this::addEntityToConfig)));
    }

    protected final ValidationResult<SecurityConfiguration> filterUsers(SecurityDynamicConfiguration<?> users, UserFilterType userType) {
        this.userService.includeAccountsIfType(users, userType);
        return ValidationResult.success(SecurityConfiguration.of(users.getCType().toString(), users));
    }

    protected final UserFilterType filterParam(RestRequest request) {
        String filter = request.param("filterBy");
        if (Strings.isNullOrEmpty((String)filter)) {
            return UserFilterType.ANY;
        }
        return UserFilterType.fromString(filter);
    }

    ValidationResult<String> withAuthTokenPath(RestRequest request) throws IOException {
        return this.endpointValidator.withRequiredEntityName(this.nameParam(request)).map(username -> {
            if (request.uri().contains("/internalusers/" + username + "/authtoken") && request.uri().endsWith("/authtoken")) {
                return ValidationResult.success(username);
            }
            return ValidationResult.error(RestStatus.NOT_IMPLEMENTED, Responses.methodNotImplementedMessage(request.method()));
        });
    }

    void generateAuthToken(RestChannel channel, SecurityConfiguration securityConfiguration) throws IOException {
        try {
            String username = securityConfiguration.entityName();
            AuthToken authToken = this.userService.generateAuthToken(username);
            Responses.ok(channel, "'" + username + "' authtoken generated " + String.valueOf(authToken));
        }
        catch (UserServiceException e) {
            Responses.badRequest(channel, e.getMessage());
        }
    }

    ValidationResult<SecurityConfiguration> validateSecurityRoles(SecurityConfiguration securityConfiguration) throws IOException {
        return this.loadConfiguration(CType.ROLES, false, false).map(rolesConfiguration -> this.loadConfiguration(CType.ROLESMAPPING, false, false).map(roleMappingsConfiguration -> {
            ObjectNode contentAsNode = (ObjectNode)securityConfiguration.requestContent();
            SecurityJsonNode securityJsonNode = new SecurityJsonNode((JsonNode)contentAsNode);
            List<String> securityRoles = securityJsonNode.get("opendistro_security_roles").asList();
            securityRoles = securityRoles == null ? List.of() : securityRoles;
            ValidationResult<SecurityDynamicConfiguration<?>> rolesValid = this.endpointValidator.validateRoles(securityRoles, (SecurityDynamicConfiguration<?>)rolesConfiguration);
            if (!rolesValid.isValid()) {
                return ValidationResult.error(rolesValid.status(), rolesValid.errorMessage());
            }
            for (String role : securityRoles) {
                ValidationResult<SecurityConfiguration> roleMappingValid = this.endpointValidator.isAllowedToChangeImmutableEntity(SecurityConfiguration.of(role, roleMappingsConfiguration));
                if (roleMappingValid.isValid()) continue;
                return ValidationResult.error(roleMappingValid.status(), roleMappingValid.errorMessage());
            }
            return ValidationResult.success(securityConfiguration);
        }));
    }

    ValidationResult<SecurityConfiguration> createOrUpdateAccount(RestRequest request, SecurityConfiguration securityConfiguration) throws IOException {
        try {
            String username = securityConfiguration.entityName();
            ObjectNode content = (ObjectNode)securityConfiguration.requestContent();
            if (request.hasParam("attributes")) {
                content.put("attributes", request.param("attributes"));
            }
            if (request.hasParam("enabled")) {
                content.put("enabled", request.param("enabled"));
            }
            content.put("name", username);
            SecurityDynamicConfiguration<?> updateConfiguration = this.userService.createOrUpdateAccount(content);
            if (!securityConfiguration.entityExists()) {
                updateConfiguration.remove(securityConfiguration.entityName());
            }
            return ValidationResult.success(SecurityConfiguration.of((JsonNode)content, username, updateConfiguration));
        }
        catch (UserServiceException ex) {
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage(ex.getMessage()));
        }
    }

    ValidationResult<SecurityConfiguration> validateAndUpdatePassword(SecurityConfiguration securityConfiguration) {
        String username = securityConfiguration.entityName();
        ObjectNode contentAsNode = (ObjectNode)securityConfiguration.requestContent();
        SecurityJsonNode securityJsonNode = new SecurityJsonNode((JsonNode)contentAsNode);
        if (securityConfiguration.entityExists() && securityJsonNode.get("hash").asString() == null) {
            String hash = ((Hashed)securityConfiguration.configuration().getCEntry(username)).getHash();
            if (Strings.isNullOrEmpty((String)hash)) {
                return ValidationResult.error(RestStatus.INTERNAL_SERVER_ERROR, Responses.payload(RestStatus.INTERNAL_SERVER_ERROR, "Existing user " + username + " has no password, and no new password or hash was specified."));
            }
            contentAsNode.put("hash", hash);
        }
        return ValidationResult.success(securityConfiguration);
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return InternalUsersApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return InternalUsersApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public ValidationResult<SecurityConfiguration> onConfigChange(SecurityConfiguration securityConfiguration) throws IOException {
                return EndpointValidator.super.onConfigChange(securityConfiguration).map(this::validateUserName).map(this::generateHashForPassword).map(InternalUsersApiAction.this::validateAndUpdatePassword).map(InternalUsersApiAction.this::validateSecurityRoles);
            }

            private ValidationResult<SecurityConfiguration> validateUserName(SecurityConfiguration securityConfiguration) {
                return UserService.restrictedFromUsername(securityConfiguration.entityName()).map(m -> ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage(m))).orElseGet(() -> ValidationResult.success(securityConfiguration));
            }

            private ValidationResult<SecurityConfiguration> generateHashForPassword(SecurityConfiguration securityConfiguration) {
                ObjectNode content = (ObjectNode)securityConfiguration.requestContent();
                if (content.has("password")) {
                    String plainTextPassword = content.get("password").asText();
                    content.remove("password");
                    content.put("hash", InternalUsersApiAction.this.passwordHasher.hash(plainTextPassword.toCharArray()));
                }
                return ValidationResult.success(securityConfiguration);
            }

            @Override
            public RequestContentValidator createRequestContentValidator(final Object ... params) {
                return RequestContentValidator.of(new RequestContentValidator.ValidationContext(){

                    @Override
                    public Object[] params() {
                        return params;
                    }

                    @Override
                    public Settings settings() {
                        return InternalUsersApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        ImmutableMap.Builder allowedKeys = ImmutableMap.builder();
                        if (this.isCurrentUserAdmin()) {
                            allowedKeys.put((Object)"hidden", (Object)RequestContentValidator.DataType.BOOLEAN);
                            allowedKeys.put((Object)"reserved", (Object)RequestContentValidator.DataType.BOOLEAN);
                        }
                        return allowedKeys.put((Object)"backend_roles", (Object)RequestContentValidator.DataType.ARRAY).put((Object)"attributes", (Object)RequestContentValidator.DataType.OBJECT).put((Object)"description", (Object)RequestContentValidator.DataType.STRING).put((Object)"opendistro_security_roles", (Object)RequestContentValidator.DataType.ARRAY).put((Object)"hash", (Object)RequestContentValidator.DataType.STRING).put((Object)"password", (Object)RequestContentValidator.DataType.STRING).build();
                    }
                });
            }
        };
    }
}

