/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.configuration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsIndexRequest;
import org.opensearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.opensearch.action.admin.indices.refresh.RefreshRequest;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.replication.ReplicationRequest;
import org.opensearch.action.support.single.shard.SingleShardRequest;
import org.opensearch.action.termvectors.MultiTermVectorsRequest;
import org.opensearch.action.termvectors.TermVectorsRequest;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.security.privileges.PrivilegesInterceptor;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.securityconf.DynamicConfigModel;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public class PrivilegesInterceptorImpl
extends PrivilegesInterceptor {
    private static final String USER_TENANT = "__user__";
    private static final String EMPTY_STRING = "";
    private static final Map<String, Object> KIBANA_INDEX_SETTINGS = ImmutableMap.of((Object)"index.number_of_shards", (Object)1, (Object)"index.auto_expand_replicas", (Object)"0-1");
    private static final ImmutableSet<String> READ_ONLY_ALLOWED_ACTIONS = ImmutableSet.of((Object)"indices:admin/get", (Object)"indices:data/read/get", (Object)"indices:data/read/search", (Object)"indices:data/read/msearch", (Object)"indices:data/read/mget", (Object)"indices:data/read/mget[shard]", (Object[])new String[0]);
    protected final Logger log = LogManager.getLogger(this.getClass());

    public PrivilegesInterceptorImpl(IndexNameExpressionResolver resolver, ClusterService clusterService, Client client, ThreadPool threadPool) {
        super(resolver, clusterService, client, threadPool);
    }

    private boolean isTenantAllowed(ActionRequest request, String action, User user, Map<String, Boolean> tenants, String requestedTenant) {
        if (!tenants.keySet().contains(requestedTenant)) {
            this.log.warn("Tenant {} is not allowed for user {}", (Object)requestedTenant, (Object)user.getName());
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("request " + String.valueOf(request.getClass()));
        }
        if (tenants.get(requestedTenant) == Boolean.FALSE && !READ_ONLY_ALLOWED_ACTIONS.contains((Object)action)) {
            this.log.warn("Tenant {} is not allowed to write (user: {})", (Object)requestedTenant, (Object)user.getName());
            return false;
        }
        return true;
    }

    @Override
    public PrivilegesInterceptor.ReplaceResult replaceDashboardsIndex(ActionRequest request, String action, User user, DynamicConfigModel config, IndexResolverReplacer.Resolved requestedResolved, Map<String, Boolean> tenants) {
        boolean private_tenant_enabled;
        boolean enabled = config.isDashboardsMultitenancyEnabled();
        if (!enabled) {
            return CONTINUE_EVALUATION_REPLACE_RESULT;
        }
        String dashboardsServerUsername = config.getDashboardsServerUsername();
        String dashboardsIndexName = config.getDashboardsIndexname();
        String requestedTenant = user.getRequestedTenant();
        if (USER_TENANT.equals(requestedTenant) && !(private_tenant_enabled = config.isDashboardsPrivateTenantEnabled())) {
            return ACCESS_DENIED_REPLACE_RESULT;
        }
        boolean isDebugEnabled = this.log.isDebugEnabled();
        if (isDebugEnabled) {
            this.log.debug("raw requestedTenant: '" + requestedTenant + "'");
        }
        boolean dashboardsIndexOnly = !user.getName().equals(dashboardsServerUsername) && PrivilegesInterceptorImpl.resolveToDashboardsIndexOrAlias(requestedResolved, dashboardsIndexName);
        boolean isTraceEnabled = this.log.isTraceEnabled();
        if (requestedTenant == null || requestedTenant.length() == 0) {
            if (isTraceEnabled) {
                this.log.trace("No tenant, will resolve to " + dashboardsIndexName);
            }
            if (dashboardsIndexOnly && !this.isTenantAllowed(request, action, user, tenants, "global_tenant")) {
                return ACCESS_DENIED_REPLACE_RESULT;
            }
            return CONTINUE_EVALUATION_REPLACE_RESULT;
        }
        if (USER_TENANT.equals(requestedTenant)) {
            requestedTenant = user.getName();
        }
        if (isDebugEnabled && !user.getName().equals(dashboardsServerUsername)) {
            this.log.debug("requestedResolved: " + String.valueOf(requestedResolved));
        }
        if (!user.getName().equals(dashboardsServerUsername) && !requestedResolved.isLocalAll()) {
            Set<String> indices = requestedResolved.getAllIndices();
            String tenantIndexName = this.toUserIndexName(dashboardsIndexName, requestedTenant);
            if (indices.size() == 1 && indices.iterator().next().startsWith(tenantIndexName) && this.isTenantAllowed(request, action, user, tenants, requestedTenant)) {
                return ACCESS_GRANTED_REPLACE_RESULT;
            }
        }
        if (dashboardsIndexOnly) {
            if (isDebugEnabled) {
                this.log.debug("requestedTenant: " + requestedTenant);
                this.log.debug("is user tenant: " + requestedTenant.equals(user.getName()));
            }
            if (!this.isTenantAllowed(request, action, user, tenants, requestedTenant)) {
                return ACCESS_DENIED_REPLACE_RESULT;
            }
            String tenantIndexName = this.toUserIndexName(dashboardsIndexName, requestedTenant);
            return PrivilegesInterceptorImpl.newAccessGrantedReplaceResult(this.replaceIndex(request, dashboardsIndexName, tenantIndexName, action));
        }
        if (!user.getName().equals(dashboardsServerUsername) && isTraceEnabled) {
            this.log.trace("not a request to only the .kibana index");
            this.log.trace(user.getName() + "/" + dashboardsServerUsername);
            this.log.trace(String.valueOf(requestedResolved) + " does not contain only " + dashboardsIndexName);
        }
        return CONTINUE_EVALUATION_REPLACE_RESULT;
    }

    private String getConcreteIndexName(String name, Map<String, IndexAbstraction> indicesLookup) {
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            String concreteName = name.concat("_" + i);
            if (indicesLookup.get(concreteName) != null) continue;
            return concreteName;
        }
        this.log.warn("Can not find a suitable name for kibana multi-tenant index {}", (Object)name);
        return null;
    }

    private CreateIndexRequestBuilder newCreateIndexRequestBuilderIfAbsent(String name) {
        SortedMap indicesLookup = this.clusterService.state().getMetadata().getIndicesLookup();
        IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(name);
        if (indexAbstraction != null) {
            if (indexAbstraction.getType() == IndexAbstraction.Type.ALIAS) {
                this.log.debug("Alias {} already exists", (Object)name);
            } else {
                this.log.warn("Can not create kibana multi-tenant alias {} as an index with the same name already exists", (Object)name);
            }
            return null;
        }
        String concreteName = this.getConcreteIndexName(name, indicesLookup);
        if (concreteName != null) {
            return this.client.admin().indices().prepareCreate(concreteName).addAlias(new Alias(name)).setSettings(KIBANA_INDEX_SETTINGS).setCause("auto(multi-tenant)");
        }
        return null;
    }

    private CreateIndexRequestBuilder replaceIndex(ActionRequest request, String oldIndexName, String newIndexName, String action) {
        boolean kibOk = false;
        CreateIndexRequestBuilder createIndexRequestBuilder = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} index will be replaced with {} in this {} request", (Object)oldIndexName, (Object)newIndexName, (Object)request.getClass().getName());
        }
        String[] newIndexNames = new String[]{newIndexName};
        if (request instanceof CreateIndexRequest) {
            String concreteName = this.getConcreteIndexName(newIndexName, this.clusterService.state().getMetadata().getIndicesLookup());
            if (concreteName != null) {
                ((CreateIndexRequest)request).index(concreteName).alias(new Alias(newIndexName));
            } else {
                ((CreateIndexRequest)request).index(newIndexName);
            }
            kibOk = true;
        } else if (request instanceof BulkRequest) {
            BulkRequest bulkRequest = (BulkRequest)request;
            for (DocWriteRequest ar : bulkRequest.requests()) {
                if (ar instanceof DeleteRequest) {
                    ((DeleteRequest)ar).index(newIndexName);
                }
                if (ar instanceof IndexRequest) {
                    ((IndexRequest)ar).index(newIndexName);
                }
                if (!(ar instanceof UpdateRequest)) continue;
                ((UpdateRequest)ar).index(newIndexName);
            }
            if (!bulkRequest.requests().isEmpty()) {
                createIndexRequestBuilder = this.newCreateIndexRequestBuilderIfAbsent(newIndexName);
            }
            kibOk = true;
        } else if (request instanceof MultiGetRequest) {
            for (MultiGetRequest.Item item : ((MultiGetRequest)request).getItems()) {
                item.index(newIndexName);
            }
            kibOk = true;
        } else if (request instanceof MultiSearchRequest) {
            for (SearchRequest ar : ((MultiSearchRequest)request).requests()) {
                ar.indices(newIndexNames);
            }
            kibOk = true;
        } else if (request instanceof MultiTermVectorsRequest) {
            for (TermVectorsRequest ar : () -> ((MultiTermVectorsRequest)request).iterator()) {
                ar.index(newIndexName);
            }
            kibOk = true;
        } else if (request instanceof UpdateRequest) {
            ((UpdateRequest)request).index(newIndexName);
            createIndexRequestBuilder = this.newCreateIndexRequestBuilderIfAbsent(newIndexName);
            kibOk = true;
        } else if (request instanceof IndexRequest) {
            createIndexRequestBuilder = this.newCreateIndexRequestBuilderIfAbsent(newIndexName);
            ((IndexRequest)request).index(newIndexName);
            kibOk = true;
        } else if (request instanceof DeleteRequest) {
            ((DeleteRequest)request).index(newIndexName);
            createIndexRequestBuilder = this.newCreateIndexRequestBuilderIfAbsent(newIndexName);
            kibOk = true;
        } else if (request instanceof SingleShardRequest) {
            ((SingleShardRequest)request).index(newIndexName);
            kibOk = true;
        } else if (request instanceof RefreshRequest) {
            ((RefreshRequest)request).indices(newIndexNames);
            kibOk = true;
        } else if (request instanceof ReplicationRequest) {
            ((ReplicationRequest)request).index(newIndexName);
            kibOk = true;
        } else if (request instanceof IndicesRequest.Replaceable) {
            IndicesRequest.Replaceable replaceableRequest = (IndicesRequest.Replaceable)request;
            replaceableRequest.indices(newIndexNames);
            kibOk = true;
        } else if (request instanceof GetFieldMappingsIndexRequest || request instanceof GetFieldMappingsRequest) {
            kibOk = true;
        } else {
            this.log.warn("Dont know what to do (1) with {}", request.getClass());
        }
        if (!kibOk) {
            this.log.warn("Dont know what to do (2) with {}", request.getClass());
        }
        return createIndexRequestBuilder;
    }

    private String toUserIndexName(String originalDashboardsIndex, String tenant) {
        if (tenant == null) {
            throw new OpenSearchException("tenant must not be null here", new Object[0]);
        }
        return originalDashboardsIndex + "_" + tenant.hashCode() + "_" + tenant.toLowerCase().replaceAll("[^a-z0-9]+", EMPTY_STRING);
    }

    private static boolean resolveToDashboardsIndexOrAlias(IndexResolverReplacer.Resolved requestedResolved, String dashboardsIndexName) {
        if (requestedResolved.isLocalAll()) {
            return false;
        }
        Set<String> allIndices = requestedResolved.getAllIndices();
        if (allIndices.size() == 1 && allIndices.iterator().next().equals(dashboardsIndexName)) {
            return true;
        }
        Set<String> aliases = requestedResolved.getAliases();
        return aliases.size() == 1 && aliases.iterator().next().equals(dashboardsIndexName);
    }
}

