/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.Application;
import ai.djl.repository.AbstractRepository;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.util.Progress;
import ai.djl.util.Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleUrlRepository
extends AbstractRepository {
    private static final Logger logger = LoggerFactory.getLogger(SimpleUrlRepository.class);
    private String artifactId;
    private String modelName;
    private Metadata metadata;
    private boolean resolved;

    SimpleUrlRepository(String name, URI uri, String fileName) {
        super(name, uri);
        this.modelName = (String)this.arguments.get("model_name");
        this.artifactId = (String)this.arguments.get("artifact_id");
        if (this.artifactId == null) {
            this.artifactId = fileName;
        }
        if (this.modelName == null) {
            this.modelName = this.artifactId;
        }
    }

    @Override
    public boolean isRemote() {
        return true;
    }

    @Override
    public Metadata locate(MRL mrl) throws IOException {
        return this.getMetadata();
    }

    @Override
    public Artifact resolve(MRL mrl, Map<String, String> filter) throws IOException {
        List<Artifact> artifacts = this.locate(mrl).getArtifacts();
        if (artifacts.isEmpty()) {
            return null;
        }
        return artifacts.get(0);
    }

    @Override
    public List<MRL> getResources() {
        try {
            Metadata m = this.getMetadata();
            if (m != null && !m.getArtifacts().isEmpty()) {
                MRL mrl = MRL.undefined(this, m.getGroupId(), m.getArtifactId());
                return Collections.singletonList(mrl);
            }
        }
        catch (IOException e) {
            logger.warn("Failed to connect URL: {}", (Object)this.uri, (Object)e);
        }
        return Collections.emptyList();
    }

    @Override
    protected void download(Path tmp, URI baseUri, Artifact.Item item, Progress progress) throws IOException {
        logger.debug("Downloading artifact: {} ...", (Object)this.uri);
        try (BufferedInputStream is = new BufferedInputStream(this.uri.toURL().openStream());){
            this.save(is, tmp, item, progress);
        }
    }

    private synchronized Metadata getMetadata() throws IOException {
        if (this.resolved) {
            return this.metadata;
        }
        Artifact artifact = new Artifact();
        artifact.setName(this.modelName);
        artifact.getArguments().putAll(this.arguments);
        ConcurrentHashMap<String, Artifact.Item> files = new ConcurrentHashMap<String, Artifact.Item>();
        Artifact.Item item = new Artifact.Item();
        item.setUri(this.uri.getPath());
        item.setName("");
        item.setArtifact(artifact);
        item.setSize(this.getContentLength());
        files.put(this.artifactId, item);
        artifact.setFiles(files);
        this.metadata = new Metadata.MatchAllMetadata();
        this.metadata.setArtifactId(this.artifactId);
        this.metadata.setArtifacts(Collections.singletonList(artifact));
        String hash = Utils.hash(this.uri.toString());
        MRL mrl = this.model(Application.UNDEFINED, "ai.djl.localmodelzoo", hash);
        this.metadata.setRepositoryUri(mrl.toURI());
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getContentLength() throws IOException {
        String scheme = this.uri.getScheme();
        if ("http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme)) {
            HttpURLConnection conn = null;
            try {
                this.resolved = true;
                conn = (HttpURLConnection)this.uri.toURL().openConnection();
                conn.setRequestMethod("HEAD");
                int code = conn.getResponseCode();
                if (code != 200) {
                    logger.info("request error: {}", (Object)code);
                    long l = -1L;
                    return l;
                }
                long l = conn.getContentLength();
                return l;
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        return -1L;
    }
}

