"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomImportMapPlugin = void 0;

var _operators = require("rxjs/operators");

var _flights_saved_objects = require("./services/sample_data/flights_saved_objects");

var _clusters = require("./clusters");

var _services = require("./services");

var _routes = require("../server/routes");

var _saved_objects = require("./saved_objects");

var _capabilities_provider = require("./saved_objects/capabilities_provider");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CustomImportMapPlugin {
  constructor(initializerContext) {
    _defineProperty(this, "logger", void 0);

    _defineProperty(this, "globalConfig$", void 0);

    _defineProperty(this, "config$", void 0);

    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
    this.config$ = initializerContext.config.create();
  } // Adds dashboards-maps saved objects to existing sample datasets using home plugin


  addMapsSavedObjects(home, config) {
    home.sampleData.addSavedObjectsToSampleDataset('flights', (0, _flights_saved_objects.getFlightsSavedObjects)(config));
  }

  async setup(core, plugins) {
    this.logger.debug('customImportMap: Setup'); // @ts-ignore

    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise(); // @ts-ignore

    const config = await this.config$.pipe((0, _operators.first)()).toPromise();
    const geospatialClient = (0, _clusters.createGeospatialCluster)(core, globalConfig); // Initialize services

    const geospatialService = new _services.GeospatialService(geospatialClient);
    const opensearchService = new _services.OpensearchService(geospatialClient);
    const router = core.http.createRouter();
    const {
      home
    } = plugins; // Register server side APIs

    (0, _routes.geospatial)(geospatialService, router);
    (0, _routes.opensearch)(opensearchService, router);
    (0, _routes.statsRoute)(router, this.logger); // Register saved object types

    core.savedObjects.registerType(_saved_objects.mapSavedObjectsType); // Register capabilities

    core.capabilities.registerProvider(_capabilities_provider.capabilitiesProvider);
    if (home) this.addMapsSavedObjects(home, config);
    return {};
  }

  start(core) {
    this.logger.debug('customImportMap: Started');
    return {};
  }

  stop() {}

}

exports.CustomImportMapPlugin = CustomImportMapPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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