/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.percolator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.BlendedTermQuery;
import org.apache.lucene.queries.spans.SpanOrQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.opensearch.Version;
import org.opensearch.common.lucene.search.function.FunctionScoreQuery;
import org.opensearch.index.query.DateRangeIncludingNowQuery;

final class QueryAnalyzer {
    private static final Set<Class<?>> verifiedQueries = new HashSet<Class>(Arrays.asList(TermQuery.class, TermInSetQuery.class, SynonymQuery.class, SpanTermQuery.class, SpanOrQuery.class, BooleanQuery.class, DisjunctionMaxQuery.class, ConstantScoreQuery.class, BoostQuery.class, BlendedTermQuery.class));

    private QueryAnalyzer() {
    }

    static Result analyze(Query query, Version indexVersion) {
        ResultBuilder builder = new ResultBuilder(indexVersion, false);
        query.visit((QueryVisitor)builder);
        return builder.getResult();
    }

    private static boolean isVerified(Query query) {
        if (query instanceof FunctionScoreQuery) {
            return ((FunctionScoreQuery)query).getMinScore() == null;
        }
        for (Class<?> cls : verifiedQueries) {
            if (!cls.isAssignableFrom(query.getClass())) continue;
            return true;
        }
        return false;
    }

    private static Result pointRangeQuery(PointRangeQuery query) {
        byte[] upperPoint;
        if (query.getNumDims() != 1) {
            return Result.UNKNOWN;
        }
        byte[] lowerPoint = query.getLowerPoint();
        if (new BytesRef(lowerPoint).compareTo(new BytesRef(upperPoint = query.getUpperPoint())) > 0) {
            return new Result(true, Collections.emptySet(), 0);
        }
        byte[] interval = new byte[16];
        NumericUtils.subtract((int)16, (int)0, (byte[])QueryAnalyzer.prepad(upperPoint), (byte[])QueryAnalyzer.prepad(lowerPoint), (byte[])interval);
        return new Result(false, Collections.singleton(new QueryExtraction(new Range(query.getField(), lowerPoint, upperPoint, interval))), 1);
    }

    private static byte[] prepad(byte[] original) {
        int offset = 16 - original.length;
        byte[] result = new byte[16];
        System.arraycopy(original, 0, result, offset, original.length);
        return result;
    }

    private static Result handleConjunction(List<Result> conjunctionsWithUnknowns, Version version) {
        List conjunctions = conjunctionsWithUnknowns.stream().filter(r -> !r.isUnknown()).collect(Collectors.toList());
        if (conjunctions.isEmpty()) {
            if (conjunctionsWithUnknowns.isEmpty()) {
                throw new IllegalArgumentException("Must have at least one conjunction sub result");
            }
            return conjunctionsWithUnknowns.get(0);
        }
        if (conjunctionsWithUnknowns.size() == 1) {
            return conjunctionsWithUnknowns.get(0);
        }
        for (Result subResult : conjunctions) {
            if (!subResult.isMatchNoDocs()) continue;
            return subResult;
        }
        int msm = 0;
        boolean verified = conjunctionsWithUnknowns.size() == conjunctions.size();
        boolean matchAllDocs = true;
        HashSet<QueryExtraction> extractions = new HashSet<QueryExtraction>();
        HashSet seenRangeFields = new HashSet();
        for (Result result : conjunctions) {
            int resultMsm = result.minimumShouldMatch;
            for (QueryExtraction queryExtraction : result.extractions) {
                if (queryExtraction.range != null) {
                    if (!seenRangeFields.contains(queryExtraction.range.fieldName)) continue;
                    resultMsm = Math.max(0, resultMsm - 1);
                    verified = false;
                    continue;
                }
                if (!extractions.contains(queryExtraction)) continue;
                resultMsm = Math.max(0, resultMsm - 1);
                verified = false;
            }
            msm += resultMsm;
            result.extractions.stream().map(e -> e.range).filter(Objects::nonNull).map(e -> e.fieldName).forEach(seenRangeFields::add);
            if (!result.verified || result.minimumShouldMatch < result.extractions.size()) {
                verified = false;
            }
            matchAllDocs &= result.matchAllDocs;
            extractions.addAll(result.extractions);
        }
        if (matchAllDocs) {
            return new Result(matchAllDocs, verified);
        }
        return new Result(verified, extractions, msm);
    }

    private static Result handleDisjunction(List<Result> disjunctions, int requiredShouldClauses, Version version) {
        if (disjunctions.stream().anyMatch(Result::isUnknown)) {
            return Result.UNKNOWN;
        }
        if (disjunctions.size() == 1) {
            return disjunctions.get(0);
        }
        List<Object> clauses = new ArrayList(disjunctions.size());
        boolean verified = true;
        int numMatchAllClauses = 0;
        boolean hasRangeExtractions = false;
        boolean hasDuplicateTerms = false;
        HashSet<QueryExtraction> terms = new HashSet<QueryExtraction>();
        for (int i = 0; i < disjunctions.size(); ++i) {
            Result subResult = disjunctions.get(i);
            if (!subResult.verified || subResult.minimumShouldMatch > 1 || subResult.extractions.size() > 1 && requiredShouldClauses > 1) {
                verified = false;
            }
            if (subResult.matchAllDocs) {
                ++numMatchAllClauses;
            }
            int resultMsm = subResult.minimumShouldMatch;
            for (QueryExtraction extraction : subResult.extractions) {
                if (terms.add(extraction)) continue;
                verified = false;
                hasDuplicateTerms = true;
            }
            if (!hasRangeExtractions) {
                hasRangeExtractions = subResult.extractions.stream().anyMatch(qe -> qe.range != null);
            }
            clauses.add(resultMsm);
        }
        boolean matchAllDocs = numMatchAllClauses > 0 && numMatchAllClauses >= requiredShouldClauses;
        int msm = 0;
        if (!hasRangeExtractions) {
            clauses = clauses.stream().filter(val -> val > 0).sorted().collect(Collectors.toList());
            if (hasDuplicateTerms) {
                msm = (Integer)clauses.get(0);
            } else {
                int limit = Math.min(clauses.size(), Math.max(1, requiredShouldClauses));
                for (int i = 0; i < limit; ++i) {
                    msm += ((Integer)clauses.get(i)).intValue();
                }
            }
        } else {
            msm = 1;
        }
        if (matchAllDocs) {
            return new Result(matchAllDocs, verified);
        }
        return new Result(verified, terms, msm);
    }

    static Result selectBestResult(Result result1, Result result2) {
        int extraction2ShortestTerm;
        assert (result1 != null || result2 != null);
        if (result1 == null) {
            return result2;
        }
        if (result2 == null) {
            return result1;
        }
        if (result1.matchAllDocs) {
            Result result = result2;
            if (!result1.verified) {
                result = result.unverify();
            }
            return result;
        }
        if (result2.matchAllDocs) {
            Result result = result1;
            if (!result2.verified) {
                result = result.unverify();
            }
            return result;
        }
        boolean onlyRangeBasedExtractions = true;
        for (QueryExtraction clause : result1.extractions) {
            if (clause.term == null) continue;
            onlyRangeBasedExtractions = false;
            break;
        }
        for (QueryExtraction clause : result2.extractions) {
            if (clause.term == null) continue;
            onlyRangeBasedExtractions = false;
            break;
        }
        if (onlyRangeBasedExtractions) {
            BytesRef extraction1SmallestRange = QueryAnalyzer.smallestRange(result1.extractions);
            BytesRef extraction2SmallestRange = QueryAnalyzer.smallestRange(result2.extractions);
            if (extraction1SmallestRange == null) {
                return result2.unverify();
            }
            if (extraction2SmallestRange == null) {
                return result1.unverify();
            }
            if (extraction1SmallestRange.compareTo(extraction2SmallestRange) <= 0) {
                return result1.unverify();
            }
            return result2.unverify();
        }
        int extraction1ShortestTerm = QueryAnalyzer.minTermLength(result1.extractions);
        if (extraction1ShortestTerm >= (extraction2ShortestTerm = QueryAnalyzer.minTermLength(result2.extractions))) {
            return result1.unverify();
        }
        return result2.unverify();
    }

    private static int minTermLength(Set<QueryExtraction> extractions) {
        if (extractions.stream().filter(queryExtraction -> queryExtraction.term != null).count() == 0L && extractions.stream().filter(queryExtraction -> queryExtraction.range != null).count() > 0L) {
            return Integer.MIN_VALUE;
        }
        int min = Integer.MAX_VALUE;
        for (QueryExtraction qt : extractions) {
            if (qt.term == null) continue;
            min = Math.min(min, qt.bytes().length);
        }
        return min;
    }

    private static BytesRef smallestRange(Set<QueryExtraction> terms) {
        BytesRef min = null;
        for (QueryExtraction qt : terms) {
            if (qt.range == null || min != null && qt.range.interval.compareTo(min) >= 0) continue;
            min = qt.range.interval;
        }
        return min;
    }

    static class Range {
        final String fieldName;
        final byte[] lowerPoint;
        final byte[] upperPoint;
        final BytesRef interval;

        Range(String fieldName, byte[] lowerPoint, byte[] upperPoint, byte[] interval) {
            this.fieldName = fieldName;
            this.lowerPoint = lowerPoint;
            this.upperPoint = upperPoint;
            this.interval = new BytesRef(interval);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            return Objects.equals(this.fieldName, range.fieldName) && Arrays.equals(this.lowerPoint, range.lowerPoint) && Arrays.equals(this.upperPoint, range.upperPoint);
        }

        public int hashCode() {
            int result = 1;
            result += 31 * this.fieldName.hashCode();
            result += Arrays.hashCode(this.lowerPoint);
            return result += Arrays.hashCode(this.upperPoint);
        }

        public String toString() {
            return "Range{, fieldName='" + this.fieldName + "', interval=" + this.interval + "}";
        }
    }

    static class QueryExtraction {
        final Term term;
        final Range range;

        QueryExtraction(Term term) {
            this.term = term;
            this.range = null;
        }

        QueryExtraction(Range range) {
            this.term = null;
            this.range = range;
        }

        String field() {
            return this.term != null ? this.term.field() : null;
        }

        BytesRef bytes() {
            return this.term != null ? this.term.bytes() : null;
        }

        String text() {
            return this.term != null ? this.term.text() : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryExtraction queryExtraction = (QueryExtraction)o;
            return Objects.equals(this.term, queryExtraction.term) && Objects.equals(this.range, queryExtraction.range);
        }

        public int hashCode() {
            return Objects.hash(this.term, this.range);
        }

        public String toString() {
            return "QueryExtraction{term=" + this.term + ",range=" + this.range + "}";
        }
    }

    static class Result {
        final Set<QueryExtraction> extractions;
        final boolean verified;
        final int minimumShouldMatch;
        final boolean matchAllDocs;
        static final Result UNKNOWN = new Result(false, false, Collections.emptySet(), 0){

            @Override
            boolean isUnknown() {
                return true;
            }

            @Override
            boolean isMatchNoDocs() {
                return false;
            }

            @Override
            public String toString() {
                return "UNKNOWN";
            }
        };
        static final Result MATCH_NONE = new Result(false, true, Collections.emptySet(), 0){

            @Override
            boolean isMatchNoDocs() {
                return true;
            }
        };

        Result(boolean matchAllDocs, boolean verified, Set<QueryExtraction> extractions, int minimumShouldMatch) {
            if (minimumShouldMatch > extractions.size()) {
                throw new IllegalArgumentException("minimumShouldMatch can't be greater than the number of extractions: " + minimumShouldMatch + " > " + extractions.size());
            }
            this.matchAllDocs = matchAllDocs;
            this.extractions = extractions;
            this.verified = verified;
            this.minimumShouldMatch = minimumShouldMatch;
        }

        Result(boolean verified, Set<QueryExtraction> extractions, int minimumShouldMatch) {
            this(false, verified, extractions, minimumShouldMatch);
        }

        Result(boolean matchAllDocs, boolean verified) {
            this(matchAllDocs, verified, Collections.emptySet(), 0);
        }

        public String toString() {
            return this.extractions.toString();
        }

        Result unverify() {
            if (this.verified) {
                return new Result(this.matchAllDocs, false, this.extractions, this.minimumShouldMatch);
            }
            return this;
        }

        boolean isUnknown() {
            return false;
        }

        boolean isMatchNoDocs() {
            return !this.matchAllDocs && this.extractions.isEmpty();
        }
    }

    private static class ResultBuilder
    extends QueryVisitor {
        final boolean conjunction;
        final Version version;
        List<ResultBuilder> children = new ArrayList<ResultBuilder>();
        boolean verified = true;
        int minimumShouldMatch = 0;
        List<Result> terms = new ArrayList<Result>();

        private ResultBuilder(Version version, boolean conjunction) {
            this.conjunction = conjunction;
            this.version = version;
        }

        public String toString() {
            return (this.conjunction ? "CONJ" : "DISJ") + this.children + this.terms + "~" + this.minimumShouldMatch;
        }

        Result getResult() {
            Result result;
            ArrayList<Result> partialResults = new ArrayList<Result>();
            if (this.terms.size() > 0) {
                partialResults.addAll(this.terms);
            }
            if (!this.children.isEmpty()) {
                List childResults = this.children.stream().map(ResultBuilder::getResult).collect(Collectors.toList());
                partialResults.addAll(childResults);
            }
            if (partialResults.isEmpty()) {
                return this.verified ? Result.MATCH_NONE : Result.UNKNOWN;
            }
            if (partialResults.size() == 1) {
                result = (Result)partialResults.get(0);
            } else {
                Result result2 = result = this.conjunction ? QueryAnalyzer.handleConjunction(partialResults, this.version) : QueryAnalyzer.handleDisjunction(partialResults, this.minimumShouldMatch, this.version);
            }
            if (!this.verified) {
                result = result.unverify();
            }
            return result;
        }

        public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
            if (parent instanceof DateRangeIncludingNowQuery) {
                this.terms.add(Result.UNKNOWN);
                return QueryVisitor.EMPTY_VISITOR;
            }
            this.verified = QueryAnalyzer.isVerified(parent);
            if (occur == BooleanClause.Occur.MUST || occur == BooleanClause.Occur.FILTER) {
                ResultBuilder builder = new ResultBuilder(this.version, true);
                this.children.add(builder);
                return builder;
            }
            if (occur == BooleanClause.Occur.MUST_NOT) {
                this.verified = false;
                return QueryVisitor.EMPTY_VISITOR;
            }
            int minimumShouldMatch = 0;
            if (parent instanceof BooleanQuery) {
                BooleanQuery bq = (BooleanQuery)parent;
                if (bq.getMinimumNumberShouldMatch() == 0 && bq.clauses().stream().anyMatch(c -> c.getOccur() == BooleanClause.Occur.MUST || c.getOccur() == BooleanClause.Occur.FILTER)) {
                    return QueryVisitor.EMPTY_VISITOR;
                }
                minimumShouldMatch = bq.getMinimumNumberShouldMatch();
            }
            ResultBuilder child = new ResultBuilder(this.version, false);
            child.minimumShouldMatch = minimumShouldMatch;
            this.children.add(child);
            return child;
        }

        public void visitLeaf(Query query) {
            if (query instanceof MatchAllDocsQuery) {
                this.terms.add(new Result(true, true));
            } else if (query instanceof MatchNoDocsQuery) {
                this.terms.add(Result.MATCH_NONE);
            } else if (query instanceof PointRangeQuery) {
                this.terms.add(QueryAnalyzer.pointRangeQuery((PointRangeQuery)query));
            } else {
                this.terms.add(Result.UNKNOWN);
            }
        }

        public void consumeTerms(Query query, Term ... terms) {
            boolean verified = QueryAnalyzer.isVerified(query);
            Set<QueryExtraction> qe = Arrays.stream(terms).map(QueryExtraction::new).collect(Collectors.toSet());
            if (qe.size() > 0) {
                this.terms.add(new Result(verified, qe, this.conjunction ? qe.size() : 1));
            }
        }

        public void consumeTermsMatching(Query query, String field, Supplier<ByteRunAutomaton> automaton) {
            if (query instanceof TermInSetQuery) {
                BytesRef term;
                TermInSetQuery q = (TermInSetQuery)query;
                PrefixCodedTerms.TermIterator ti = q.getTermData().iterator();
                HashSet<QueryExtraction> qe = new HashSet<QueryExtraction>();
                while ((term = ti.next()) != null) {
                    qe.add(new QueryExtraction(new Term(field, term)));
                }
                this.terms.add(new Result(true, qe, 1));
            } else {
                super.consumeTermsMatching(query, field, automaton);
            }
        }
    }
}

