/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.threadpool;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.service.ReportingService;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.threadpool.ThreadPool;

public class ThreadPoolInfo
implements ReportingService.Info,
Iterable<ThreadPool.Info> {
    private final List<ThreadPool.Info> infos;

    public ThreadPoolInfo(List<ThreadPool.Info> infos) {
        this.infos = Collections.unmodifiableList(infos);
    }

    public ThreadPoolInfo(StreamInput in) throws IOException {
        this.infos = Collections.unmodifiableList(in.readList(ThreadPool.Info::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.infos);
    }

    @Override
    public Iterator<ThreadPool.Info> iterator() {
        return this.infos.iterator();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("thread_pool");
        for (ThreadPool.Info info : this.infos) {
            info.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String THREAD_POOL = "thread_pool";

        Fields() {
        }
    }
}

