/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile.aggregation;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opensearch.search.profile.ProfileResult;
import org.opensearch.search.profile.aggregation.AggregationProfiler;
import org.opensearch.search.profile.aggregation.AggregationTimingType;

public class ConcurrentAggregationProfiler
extends AggregationProfiler {
    private static final String MAX_PREFIX = "max_";
    private static final String MIN_PREFIX = "min_";
    private static final String AVG_PREFIX = "avg_";
    private static final String START_TIME_KEY = AggregationTimingType.INITIALIZE + "_start_time";
    private static final String[] breakdownCountStatsTypes = new String[]{"build_leaf_collector_count", "collect_count"};

    @Override
    public List<ProfileResult> getTree() {
        List<ProfileResult> tree = this.profileTree.getTree();
        LinkedList<ProfileResult> reducedTree = new LinkedList<ProfileResult>();
        Map<String, List<ProfileResult>> sliceLevelAggregationMap = ConcurrentAggregationProfiler.getSliceLevelAggregationMap(tree);
        for (List<ProfileResult> profileResultsAcrossSlices : sliceLevelAggregationMap.values()) {
            reducedTree.addAll(this.reduceProfileResultsTree(profileResultsAcrossSlices));
        }
        return reducedTree;
    }

    private List<ProfileResult> reduceProfileResultsTree(List<ProfileResult> profileResultsAcrossSlices) {
        String type = profileResultsAcrossSlices.get(0).getQueryName();
        String description = profileResultsAcrossSlices.get(0).getLuceneDescription();
        long maxSliceNodeEndTime = Long.MIN_VALUE;
        long minSliceNodeStartTime = Long.MAX_VALUE;
        long maxSliceNodeTime = Long.MIN_VALUE;
        long minSliceNodeTime = Long.MAX_VALUE;
        long avgSliceNodeTime = 0L;
        HashMap<String, Long> breakdown = new HashMap<String, Long>();
        HashMap<String, Long> timeStatsMap = new HashMap<String, Long>();
        HashMap<String, Long> minSliceStartTimeMap = new HashMap<String, Long>();
        HashMap<String, Long> maxSliceEndTimeMap = new HashMap<String, Long>();
        HashMap<String, Long> countStatsMap = new HashMap<String, Long>();
        Map<String, Object> debug = new HashMap<String, Object>();
        LinkedList<ProfileResult> children = new LinkedList<ProfileResult>();
        for (ProfileResult profileResult : profileResultsAcrossSlices) {
            long l = profileResult.getTime();
            long sliceStartTime = profileResult.getTimeBreakdown().get(START_TIME_KEY);
            maxSliceNodeEndTime = Math.max(maxSliceNodeEndTime, sliceStartTime + l);
            minSliceNodeStartTime = Math.min(minSliceNodeStartTime, sliceStartTime);
            maxSliceNodeTime = Math.max(maxSliceNodeTime, l);
            minSliceNodeTime = Math.min(minSliceNodeTime, l);
            avgSliceNodeTime += l;
            for (AggregationTimingType aggregationTimingType : AggregationTimingType.values()) {
                ConcurrentAggregationProfiler.buildBreakdownStatsMap(timeStatsMap, profileResult, aggregationTimingType.toString());
            }
            for (AggregationTimingType aggregationTimingType : AggregationTimingType.values()) {
                String breakdownTimingType = aggregationTimingType.toString();
                Long startTime = profileResult.getTimeBreakdown().get(breakdownTimingType + "_start_time");
                Long endTime = startTime + profileResult.getTimeBreakdown().get(breakdownTimingType);
                minSliceStartTimeMap.put(breakdownTimingType, Math.min(minSliceStartTimeMap.getOrDefault(breakdownTimingType, Long.MAX_VALUE), startTime));
                maxSliceEndTimeMap.put(breakdownTimingType, Math.max(maxSliceEndTimeMap.getOrDefault(breakdownTimingType, Long.MIN_VALUE), endTime));
            }
            for (String string : breakdownCountStatsTypes) {
                ConcurrentAggregationProfiler.buildBreakdownStatsMap(countStatsMap, profileResult, string);
            }
            for (AggregationTimingType aggregationTimingType : AggregationTimingType.values()) {
                String breakdownType = aggregationTimingType.toString();
                String breakdownTypeCount = breakdownType + "_count";
                breakdown.put(breakdownTypeCount, breakdown.getOrDefault(breakdownTypeCount, 0L) + profileResult.getTimeBreakdown().get(breakdownTypeCount));
            }
            debug = profileResult.getDebugInfo();
            children.addAll(profileResult.getProfiledChildren());
        }
        long nodeTime = maxSliceNodeEndTime - minSliceNodeStartTime;
        avgSliceNodeTime /= (long)profileResultsAcrossSlices.size();
        for (AggregationTimingType aggregationTimingType : AggregationTimingType.values()) {
            ConcurrentAggregationProfiler.buildBreakdownMap(profileResultsAcrossSlices.size(), breakdown, timeStatsMap, aggregationTimingType.toString());
        }
        for (AggregationTimingType aggregationTimingType : AggregationTimingType.values()) {
            String string = aggregationTimingType.toString();
            breakdown.put(string, (Long)maxSliceEndTimeMap.get(string) - (Long)minSliceStartTimeMap.get(string));
        }
        for (String string : breakdownCountStatsTypes) {
            ConcurrentAggregationProfiler.buildBreakdownMap(profileResultsAcrossSlices.size(), breakdown, countStatsMap, string);
        }
        LinkedList<ProfileResult> linkedList = new LinkedList<ProfileResult>();
        if (!children.isEmpty()) {
            Map<String, List<ProfileResult>> sliceLevelAggregationMap = ConcurrentAggregationProfiler.getSliceLevelAggregationMap(children);
            for (List<ProfileResult> list : sliceLevelAggregationMap.values()) {
                linkedList.addAll(this.reduceProfileResultsTree(list));
            }
        }
        ProfileResult reducedResult = new ProfileResult(type, description, breakdown, debug, nodeTime, linkedList, maxSliceNodeTime, minSliceNodeTime, avgSliceNodeTime);
        return List.of(reducedResult);
    }

    static void buildBreakdownMap(int treeSize, Map<String, Long> breakdown, Map<String, Long> statsMap, String breakdownType) {
        String maxBreakdownType = MAX_PREFIX + breakdownType;
        String minBreakdownType = MIN_PREFIX + breakdownType;
        String avgBreakdownType = AVG_PREFIX + breakdownType;
        breakdown.put(maxBreakdownType, statsMap.get(maxBreakdownType));
        breakdown.put(minBreakdownType, statsMap.get(minBreakdownType));
        breakdown.put(avgBreakdownType, statsMap.get(avgBreakdownType) / (long)treeSize);
    }

    static void buildBreakdownStatsMap(Map<String, Long> statsMap, ProfileResult result, String breakdownType) {
        String maxBreakdownType = MAX_PREFIX + breakdownType;
        String minBreakdownType = MIN_PREFIX + breakdownType;
        String avgBreakdownType = AVG_PREFIX + breakdownType;
        statsMap.put(maxBreakdownType, Math.max(statsMap.getOrDefault(maxBreakdownType, Long.MIN_VALUE), result.getTimeBreakdown().get(breakdownType)));
        statsMap.put(minBreakdownType, Math.min(statsMap.getOrDefault(minBreakdownType, Long.MAX_VALUE), result.getTimeBreakdown().get(breakdownType)));
        statsMap.put(avgBreakdownType, statsMap.getOrDefault(avgBreakdownType, 0L) + result.getTimeBreakdown().get(breakdownType));
    }

    static Map<String, List<ProfileResult>> getSliceLevelAggregationMap(List<ProfileResult> tree) {
        HashMap<String, List<ProfileResult>> sliceLevelAggregationMap = new HashMap<String, List<ProfileResult>>();
        for (ProfileResult result : tree) {
            String description = result.getLuceneDescription();
            List sliceLevelAggregationList = sliceLevelAggregationMap.computeIfAbsent(description, k -> new LinkedList());
            sliceLevelAggregationList.add(result);
        }
        return sliceLevelAggregationMap;
    }
}

