/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensearch.search.internal.ContextIndexSearcher;
import org.opensearch.search.profile.aggregation.AggregationProfiler;
import org.opensearch.search.profile.aggregation.ConcurrentAggregationProfiler;
import org.opensearch.search.profile.query.QueryProfiler;

public final class Profilers {
    private final ContextIndexSearcher searcher;
    private final List<QueryProfiler> queryProfilers;
    private final AggregationProfiler aggProfiler;
    private final boolean isConcurrentSegmentSearchEnabled;

    public Profilers(ContextIndexSearcher searcher, boolean isConcurrentSegmentSearchEnabled) {
        this.searcher = searcher;
        this.isConcurrentSegmentSearchEnabled = isConcurrentSegmentSearchEnabled;
        this.queryProfilers = new ArrayList<QueryProfiler>();
        this.aggProfiler = isConcurrentSegmentSearchEnabled ? new ConcurrentAggregationProfiler() : new AggregationProfiler();
        this.addQueryProfiler();
    }

    public QueryProfiler addQueryProfiler() {
        QueryProfiler profiler = new QueryProfiler(this.isConcurrentSegmentSearchEnabled);
        this.searcher.setProfiler(profiler);
        this.queryProfilers.add(profiler);
        return profiler;
    }

    public QueryProfiler getCurrentQueryProfiler() {
        return this.queryProfilers.get(this.queryProfilers.size() - 1);
    }

    public List<QueryProfiler> getQueryProfilers() {
        return Collections.unmodifiableList(this.queryProfilers);
    }

    public AggregationProfiler getAggregationProfiler() {
        return this.aggProfiler;
    }
}

