/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.internal;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public final class ShardSearchContextId
implements Writeable {
    private final String sessionId;
    private final long id;

    public ShardSearchContextId(String sessionId, long id) {
        this.sessionId = Objects.requireNonNull(sessionId);
        this.id = id;
    }

    public ShardSearchContextId(StreamInput in) throws IOException {
        this.id = in.readLong();
        this.sessionId = in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_7_0) ? in.readString() : "";
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.id);
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_7_0)) {
            out.writeString(this.sessionId);
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardSearchContextId other = (ShardSearchContextId)o;
        return this.id == other.id && this.sessionId.equals(other.sessionId);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.id);
    }

    public String toString() {
        return "[" + this.sessionId + "][" + this.id + "]";
    }
}

