/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.recovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.action.admin.cluster.remotestore.restore.RestoreRemoteStoreRequest;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.block.ClusterBlocks;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataCreateIndexService;
import org.opensearch.cluster.metadata.MetadataIndexUpgradeService;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.UUIDs;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.gateway.remote.RemoteClusterStateService;
import org.opensearch.indices.ShardLimitValidator;
import org.opensearch.repositories.IndexId;
import org.opensearch.snapshots.RestoreInfo;
import org.opensearch.snapshots.RestoreService;

public class RemoteStoreRestoreService {
    private static final Logger logger = LogManager.getLogger(RemoteStoreRestoreService.class);
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final MetadataCreateIndexService createIndexService;
    private final MetadataIndexUpgradeService metadataIndexUpgradeService;
    private final ShardLimitValidator shardLimitValidator;
    private final RemoteClusterStateService remoteClusterStateService;

    public RemoteStoreRestoreService(ClusterService clusterService, AllocationService allocationService, MetadataCreateIndexService createIndexService, MetadataIndexUpgradeService metadataIndexUpgradeService, ShardLimitValidator shardLimitValidator, RemoteClusterStateService remoteClusterStateService) {
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        this.metadataIndexUpgradeService = metadataIndexUpgradeService;
        this.shardLimitValidator = shardLimitValidator;
        this.remoteClusterStateService = remoteClusterStateService;
    }

    public void restore(final RestoreRemoteStoreRequest request, final ActionListener<RestoreService.RestoreCompletionResponse> listener) {
        this.clusterService.submitStateUpdateTask("restore[remote_store]", new ClusterStateUpdateTask(){
            String restoreUUID;
            RestoreInfo restoreInfo = null;

            @Override
            public ClusterState execute(ClusterState currentState) {
                RemoteRestoreResult remoteRestoreResult = RemoteStoreRestoreService.this.restore(currentState, null, request.restoreAllShards(), request.indices());
                this.restoreUUID = remoteRestoreResult.getRestoreUUID();
                this.restoreInfo = remoteRestoreResult.getRestoreInfo();
                return remoteRestoreResult.getClusterState();
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn("failed to restore from remote store", (Throwable)e);
                listener.onFailure(e);
            }

            @Override
            public TimeValue timeout() {
                return request.clusterManagerNodeTimeout();
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse((Object)new RestoreService.RestoreCompletionResponse(this.restoreUUID, null, this.restoreInfo));
            }
        });
    }

    public RemoteRestoreResult restore(ClusterState currentState, @Nullable String restoreClusterUUID, boolean restoreAllShards, String[] indexNames) {
        boolean metadataFromRemoteStore;
        HashMap<String, Tuple<Boolean, IndexMetadata>> indexMetadataMap = new HashMap<String, Tuple<Boolean, IndexMetadata>>();
        boolean bl = metadataFromRemoteStore = !(restoreClusterUUID == null || restoreClusterUUID.isEmpty() || restoreClusterUUID.isBlank());
        if (metadataFromRemoteStore) {
            try {
                this.remoteClusterStateService.getLatestIndexMetadata(currentState.getClusterName().value(), restoreClusterUUID).values().forEach(indexMetadata -> indexMetadataMap.put(indexMetadata.getIndex().getName(), new Tuple((Object)true, indexMetadata)));
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to restore remote index metadata", e);
            }
        } else {
            for (String indexName : indexNames) {
                IndexMetadata indexMetadata2 = currentState.metadata().index(indexName);
                if (indexMetadata2 == null) {
                    logger.warn("Index restore is not supported for non-existent index. Skipping: {}", (Object)indexName);
                    continue;
                }
                indexMetadataMap.put(indexName, (Tuple<Boolean, IndexMetadata>)new Tuple((Object)false, (Object)indexMetadata2));
            }
        }
        this.validate(currentState, indexMetadataMap, restoreClusterUUID, restoreAllShards);
        return this.executeRestore(currentState, indexMetadataMap, restoreAllShards);
    }

    private RemoteRestoreResult executeRestore(ClusterState currentState, Map<String, Tuple<Boolean, IndexMetadata>> indexMetadataMap, boolean restoreAllShards) {
        String restoreUUID = UUIDs.randomBase64UUID();
        ArrayList<String> indicesToBeRestored = new ArrayList<String>();
        int totalShards = 0;
        ClusterState.Builder builder = ClusterState.builder(currentState);
        Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        RoutingTable.Builder rtBuilder = RoutingTable.builder(currentState.routingTable());
        for (Map.Entry<String, Tuple<Boolean, IndexMetadata>> indexMetadataEntry : indexMetadataMap.entrySet()) {
            String indexName = indexMetadataEntry.getKey();
            IndexMetadata indexMetadata = (IndexMetadata)indexMetadataEntry.getValue().v2();
            boolean metadataFromRemoteStore = (Boolean)indexMetadataEntry.getValue().v1();
            IndexMetadata updatedIndexMetadata = indexMetadata;
            if (!metadataFromRemoteStore && restoreAllShards) {
                updatedIndexMetadata = IndexMetadata.builder(indexMetadata).state(IndexMetadata.State.OPEN).version(1L + indexMetadata.getVersion()).mappingVersion(1L + indexMetadata.getMappingVersion()).settingsVersion(1L + indexMetadata.getSettingsVersion()).aliasesVersion(1L + indexMetadata.getAliasesVersion()).build();
            }
            IndexId indexId = new IndexId(indexName, updatedIndexMetadata.getIndexUUID());
            Map<ShardId, IndexShardRoutingTable> indexShardRoutingTableMap = new HashMap<ShardId, IndexShardRoutingTable>();
            if (!metadataFromRemoteStore) {
                indexShardRoutingTableMap = currentState.routingTable().index(indexName).shards().values().stream().collect(Collectors.toMap(IndexShardRoutingTable::shardId, Function.identity()));
            }
            RecoverySource.RemoteStoreRecoverySource recoverySource = new RecoverySource.RemoteStoreRecoverySource(restoreUUID, updatedIndexMetadata.getCreationVersion(), indexId);
            rtBuilder.addAsRemoteStoreRestore(updatedIndexMetadata, recoverySource, indexShardRoutingTableMap, restoreAllShards || metadataFromRemoteStore);
            blocks.updateBlocks(updatedIndexMetadata);
            mdBuilder.put(updatedIndexMetadata, true);
            indicesToBeRestored.add(indexName);
            totalShards += updatedIndexMetadata.getNumberOfShards();
        }
        RestoreInfo restoreInfo = new RestoreInfo("remote_store", indicesToBeRestored, totalShards, totalShards);
        RoutingTable rt = rtBuilder.build();
        ClusterState updatedState = builder.metadata(mdBuilder).blocks(blocks).routingTable(rt).build();
        return RemoteRestoreResult.build(restoreUUID, restoreInfo, this.allocationService.reroute(updatedState, "restored from remote store"));
    }

    private void validate(ClusterState currentState, Map<String, Tuple<Boolean, IndexMetadata>> indexMetadataMap, @Nullable String restoreClusterUUID, boolean restoreAllShards) throws IllegalStateException, IllegalArgumentException {
        String errorMsg = "cannot restore index [%s] because an open index with same name/uuid already exists in the cluster.";
        if (currentState.metadata().clusterUUID().equals(restoreClusterUUID)) {
            throw new IllegalArgumentException("clusterUUID to restore from should be different from current cluster UUID");
        }
        for (Map.Entry<String, Tuple<Boolean, IndexMetadata>> indexMetadataEntry : indexMetadataMap.entrySet()) {
            String indexName = indexMetadataEntry.getKey();
            IndexMetadata indexMetadata = (IndexMetadata)indexMetadataEntry.getValue().v2();
            String indexUUID = indexMetadata.getIndexUUID();
            boolean metadataFromRemoteStore = (Boolean)indexMetadataEntry.getValue().v1();
            if (indexMetadata.getSettings().getAsBoolean("index.remote_store.enabled", false).booleanValue()) {
                if (metadataFromRemoteStore) {
                    HashSet graveyardIndexNames = new HashSet();
                    HashSet graveyardIndexUUID = new HashSet();
                    Set liveClusterIndexUUIDs = currentState.metadata().indices().values().stream().map(IndexMetadata::getIndexUUID).collect(Collectors.toSet());
                    currentState.metadata().indexGraveyard().getTombstones().forEach(tombstone -> {
                        graveyardIndexNames.add(tombstone.getIndex().getName());
                        graveyardIndexUUID.add(tombstone.getIndex().getUUID());
                    });
                    assert (!graveyardIndexNames.contains(indexName)) : String.format(Locale.ROOT, "Index name [%s] exists in graveyard!", indexName);
                    assert (!graveyardIndexUUID.contains(indexUUID)) : String.format(Locale.ROOT, "Index UUID [%s] exists in graveyard!", indexUUID);
                    boolean sameNameIndexExists = currentState.metadata().hasIndex(indexName);
                    boolean sameUUIDIndexExists = liveClusterIndexUUIDs.contains(indexUUID);
                    if (sameNameIndexExists || sameUUIDIndexExists) {
                        String finalErrorMsg = String.format(Locale.ROOT, errorMsg, indexName);
                        logger.info(finalErrorMsg);
                        throw new IllegalStateException(finalErrorMsg);
                    }
                    Version minIndexCompatibilityVersion = currentState.getNodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
                    this.metadataIndexUpgradeService.upgradeIndexMetadata(indexMetadata, minIndexCompatibilityVersion);
                    boolean isHidden = IndexMetadata.INDEX_HIDDEN_SETTING.get(indexMetadata.getSettings());
                    this.createIndexService.validateIndexName(indexName, currentState);
                    this.createIndexService.validateDotIndex(indexName, isHidden);
                    this.shardLimitValidator.validateShardLimit(indexName, indexMetadata.getSettings(), currentState);
                    continue;
                }
                if (!restoreAllShards || IndexMetadata.State.CLOSE.equals((Object)indexMetadata.getState())) continue;
                throw new IllegalStateException(String.format(Locale.ROOT, errorMsg, indexName) + " Close the existing index.");
            }
            logger.warn("Remote store is not enabled for index: {}", (Object)indexName);
        }
    }

    public static class RemoteRestoreResult {
        private final ClusterState clusterState;
        private final RestoreInfo restoreInfo;
        private final String restoreUUID;

        private RemoteRestoreResult(String restoreUUID, RestoreInfo restoreInfo, ClusterState clusterState) {
            this.clusterState = clusterState;
            this.restoreInfo = restoreInfo;
            this.restoreUUID = restoreUUID;
        }

        public static RemoteRestoreResult build(String restoreUUID, RestoreInfo restoreInfo, ClusterState clusterState) {
            return new RemoteRestoreResult(restoreUUID, restoreInfo, clusterState);
        }

        public ClusterState getClusterState() {
            return this.clusterState;
        }

        public RestoreInfo getRestoreInfo() {
            return this.restoreInfo;
        }

        public String getRestoreUUID() {
            return this.restoreUUID;
        }
    }
}

