/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.TermQueryPrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.PackedQuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;
import org.opensearch.LegacyESVersion;
import org.opensearch.OpenSearchParseException;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.Explicit;
import org.opensearch.common.geo.GeoUtils;
import org.opensearch.common.geo.GeometryParser;
import org.opensearch.common.geo.ShapeRelation;
import org.opensearch.common.geo.ShapesAvailability;
import org.opensearch.common.geo.SpatialStrategy;
import org.opensearch.common.geo.builders.ShapeBuilder;
import org.opensearch.common.geo.parsers.ShapeParser;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.DistanceUnit;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.geometry.Geometry;
import org.opensearch.index.mapper.AbstractGeometryFieldMapper;
import org.opensearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.GeoShapeFieldMapper;
import org.opensearch.index.mapper.GeoShapeQueryable;
import org.opensearch.index.mapper.LegacyGeoShapeIndexer;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.query.LegacyGeoShapeQueryProcessor;
import org.opensearch.index.query.QueryShardContext;

@Deprecated
public class LegacyGeoShapeFieldMapper
extends AbstractShapeGeometryFieldMapper<ShapeBuilder<?, ?, ?>, Shape> {
    public static final String CONTENT_TYPE = "geo_shape";
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(LegacyGeoShapeFieldMapper.class);
    private final Version indexCreatedVersion;

    public LegacyGeoShapeFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<ShapeBuilder.Orientation> orientation, Explicit<Boolean> ignoreZValue, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, ignoreMalformed, coerce, ignoreZValue, orientation, multiFields, copyTo);
        this.indexCreatedVersion = IndexMetadata.indexCreated(indexSettings);
    }

    @Override
    public GeoShapeFieldType fieldType() {
        return (GeoShapeFieldType)super.fieldType();
    }

    @Override
    protected void addStoredFields(ParseContext context, Shape geometry) {
    }

    @Override
    protected void addDocValuesFields(String name, Shape geometry, List<IndexableField> fields, ParseContext context) {
    }

    @Override
    protected void addMultiFields(ParseContext context, Shape geometry) {
    }

    @Override
    protected boolean docValuesByDefault() {
        return false;
    }

    @Override
    public void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || !this.fieldType().tree().equals("quadtree")) {
            builder.field(DeprecatedParameters.Names.TREE.getPreferredName(), this.fieldType().tree());
        }
        if (this.fieldType().treeLevels() != 0) {
            builder.field(DeprecatedParameters.Names.TREE_LEVELS.getPreferredName(), this.fieldType().treeLevels());
        } else if (includeDefaults && this.fieldType().precisionInMeters() == -1.0) {
            if ("geohash".equals(this.fieldType().tree())) {
                builder.field(DeprecatedParameters.Names.TREE_LEVELS.getPreferredName(), DeprecatedParameters.Defaults.GEOHASH_TREE_LEVELS);
            } else if ("legacyquadtree".equals(this.fieldType().tree())) {
                builder.field(DeprecatedParameters.Names.TREE_LEVELS.getPreferredName(), DeprecatedParameters.Defaults.QUADTREE_LEVELS);
            } else if ("quadtree".equals(this.fieldType().tree())) {
                builder.field(DeprecatedParameters.Names.TREE_LEVELS.getPreferredName(), DeprecatedParameters.Defaults.QUADTREE_LEVELS);
            } else {
                throw new IllegalArgumentException("Unknown prefix tree type [" + this.fieldType().tree() + "]");
            }
        }
        if (this.fieldType().precisionInMeters() != -1.0) {
            builder.field(DeprecatedParameters.Names.PRECISION.getPreferredName(), DistanceUnit.METERS.toString(this.fieldType().precisionInMeters()));
        } else if (includeDefaults && this.fieldType().treeLevels() == 0) {
            builder.field(DeprecatedParameters.Names.PRECISION.getPreferredName(), DistanceUnit.METERS.toString(50.0));
        }
        if (this.indexCreatedVersion.onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
            builder.field(DeprecatedParameters.Names.STRATEGY.getPreferredName(), this.fieldType().strategy().getStrategyName());
        }
        if (includeDefaults || this.fieldType().distanceErrorPct() != this.fieldType().defaultDistanceErrorPct) {
            builder.field(DeprecatedParameters.Names.DISTANCE_ERROR_PCT.getPreferredName(), this.fieldType().distanceErrorPct());
        }
        if (this.fieldType().strategy() == SpatialStrategy.TERM) {
            if (includeDefaults || !this.fieldType().pointsOnly()) {
                builder.field(DeprecatedParameters.Names.POINTS_ONLY.getPreferredName(), this.fieldType().pointsOnly());
            }
        } else if (includeDefaults || this.fieldType().pointsOnly()) {
            builder.field(DeprecatedParameters.Names.POINTS_ONLY.getPreferredName(), this.fieldType().pointsOnly());
        }
    }

    @Override
    protected void mergeGeoOptions(AbstractShapeGeometryFieldMapper<?, ?> mergeWith, List<String> conflicts) {
        if (mergeWith instanceof GeoShapeFieldMapper) {
            GeoShapeFieldMapper fieldMapper = (GeoShapeFieldMapper)mergeWith;
            throw new IllegalArgumentException("[" + this.fieldType().name() + "] with field mapper [" + this.fieldType().typeName() + "] using [" + this.fieldType().strategy() + "] strategy cannot be merged with [" + fieldMapper.typeName() + "] with [BKD] strategy");
        }
        GeoShapeFieldType g = (GeoShapeFieldType)mergeWith.fieldType();
        if (this.fieldType().strategy() != g.strategy()) {
            conflicts.add("mapper [" + this.name() + "] has different [strategy]");
        }
        if (!this.fieldType().tree().equals(g.tree())) {
            conflicts.add("mapper [" + this.name() + "] has different [tree]");
        }
        if (this.fieldType().pointsOnly() != g.pointsOnly()) {
            conflicts.add("mapper [" + this.name() + "] has different points_only");
        }
        if (this.fieldType().treeLevels() != g.treeLevels()) {
            conflicts.add("mapper [" + this.name() + "] has different [tree_levels]");
        }
        if (this.fieldType().precisionInMeters() != g.precisionInMeters()) {
            conflicts.add("mapper [" + this.name() + "] has different [precision]");
        }
        this.orientation = mergeWith.orientation;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class GeoShapeFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType<ShapeBuilder<?, ?, ?>, Shape>
    implements GeoShapeQueryable {
        private String tree = "quadtree";
        private SpatialStrategy strategy = DeprecatedParameters.Defaults.STRATEGY;
        private boolean pointsOnly = false;
        private int treeLevels = 0;
        private double precisionInMeters = -1.0;
        private Double distanceErrorPct;
        private double defaultDistanceErrorPct = 0.0;
        private PrefixTreeStrategy defaultPrefixTreeStrategy;
        private RecursivePrefixTreeStrategy recursiveStrategy;
        private TermQueryPrefixTreeStrategy termStrategy;
        private final LegacyGeoShapeQueryProcessor queryProcessor = new LegacyGeoShapeQueryProcessor(this);

        private GeoShapeFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, false, meta);
        }

        public GeoShapeFieldType(String name) {
            this(name, true, false, true, Collections.emptyMap());
        }

        @Override
        public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
            throw new UnsupportedOperationException("process method should not be called for PrefixTree based geo_shapes");
        }

        @Override
        public Query geoShapeQuery(Geometry shape, String fieldName, SpatialStrategy strategy, ShapeRelation relation, QueryShardContext context) {
            return this.queryProcessor.geoShapeQuery(shape, fieldName, strategy, relation, context);
        }

        @Override
        public String typeName() {
            return LegacyGeoShapeFieldMapper.CONTENT_TYPE;
        }

        public String tree() {
            return this.tree;
        }

        public void setTree(String tree) {
            this.tree = tree;
        }

        public SpatialStrategy strategy() {
            return this.strategy;
        }

        public void setStrategy(SpatialStrategy strategy) {
            this.strategy = strategy;
            if (this.strategy.equals((Object)SpatialStrategy.TERM)) {
                this.pointsOnly = true;
            }
        }

        public boolean pointsOnly() {
            return this.pointsOnly;
        }

        public void setPointsOnly(boolean pointsOnly) {
            this.pointsOnly = pointsOnly;
        }

        public int treeLevels() {
            return this.treeLevels;
        }

        public void setTreeLevels(int treeLevels) {
            this.treeLevels = treeLevels;
        }

        public double precisionInMeters() {
            return this.precisionInMeters;
        }

        public void setPrecisionInMeters(double precisionInMeters) {
            this.precisionInMeters = precisionInMeters;
        }

        public double distanceErrorPct() {
            return this.distanceErrorPct == null ? this.defaultDistanceErrorPct : this.distanceErrorPct;
        }

        public void setDistanceErrorPct(double distanceErrorPct) {
            this.distanceErrorPct = distanceErrorPct;
        }

        public void setDefaultDistanceErrorPct(double defaultDistanceErrorPct) {
            this.defaultDistanceErrorPct = defaultDistanceErrorPct;
        }

        public PrefixTreeStrategy defaultPrefixTreeStrategy() {
            return this.defaultPrefixTreeStrategy;
        }

        public PrefixTreeStrategy resolvePrefixTreeStrategy(SpatialStrategy strategy) {
            return this.resolvePrefixTreeStrategy(strategy.getStrategyName());
        }

        public PrefixTreeStrategy resolvePrefixTreeStrategy(String strategyName) {
            if (SpatialStrategy.RECURSIVE.getStrategyName().equals(strategyName)) {
                return this.recursiveStrategy;
            }
            if (SpatialStrategy.TERM.getStrategyName().equals(strategyName)) {
                return this.termStrategy;
            }
            throw new IllegalArgumentException("Unknown prefix tree strategy [" + strategyName + "]");
        }
    }

    private static class LegacyGeoShapeParser
    extends AbstractGeometryFieldMapper.Parser<ShapeBuilder<?, ?, ?>> {
        private final GeometryParser geometryParser = new GeometryParser(true, true, true);

        private LegacyGeoShapeParser() {
        }

        @Override
        public ShapeBuilder<?, ?, ?> parse(XContentParser parser) throws IOException, ParseException {
            return ShapeParser.parse(parser);
        }

        @Override
        public Object format(ShapeBuilder<?, ?, ?> value, String format) {
            Object geometry = value.buildGeometry();
            return this.geometryParser.geometryFormat(format).toXContentAsObject((Geometry)geometry);
        }
    }

    public static class Builder
    extends AbstractShapeGeometryFieldMapper.Builder<Builder, GeoShapeFieldType> {
        DeprecatedParameters deprecatedParameters;

        public Builder(String name) {
            this(name, new DeprecatedParameters());
        }

        public Builder(String name, DeprecatedParameters deprecatedParameters) {
            super(name, AbstractShapeGeometryFieldMapper.Defaults.FIELD_TYPE);
            this.deprecatedParameters = deprecatedParameters;
        }

        private void setupFieldTypeDeprecatedParameters(Mapper.BuilderContext context, GeoShapeFieldType ft) {
            if (this.deprecatedParameters.strategy != null) {
                ft.setStrategy(this.deprecatedParameters.strategy);
            }
            if (this.deprecatedParameters.tree != null) {
                ft.setTree(this.deprecatedParameters.tree);
            }
            if (this.deprecatedParameters.treeLevels != null) {
                ft.setTreeLevels(this.deprecatedParameters.treeLevels);
            }
            if (this.deprecatedParameters.precision != null) {
                ft.setPrecisionInMeters(DistanceUnit.parse(this.deprecatedParameters.precision, DistanceUnit.DEFAULT, DistanceUnit.DEFAULT));
            }
            if (this.deprecatedParameters.distanceErrorPct != null) {
                ft.setDistanceErrorPct(this.deprecatedParameters.distanceErrorPct);
            }
            if (this.deprecatedParameters.pointsOnly != null) {
                ft.setPointsOnly(this.deprecatedParameters.pointsOnly);
            }
            if (ft.treeLevels() == 0 && ft.precisionInMeters() < 0.0) {
                ft.setDefaultDistanceErrorPct(0.025);
            }
        }

        private void setupPrefixTrees(GeoShapeFieldType ft) {
            GeohashPrefixTree prefixTree;
            if (ft.tree().equals("geohash")) {
                prefixTree = new GeohashPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, Builder.getLevels(ft.treeLevels(), ft.precisionInMeters(), DeprecatedParameters.Defaults.GEOHASH_TREE_LEVELS, true));
            } else if (ft.tree().equals("legacyquadtree")) {
                prefixTree = new QuadPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, Builder.getLevels(ft.treeLevels(), ft.precisionInMeters(), DeprecatedParameters.Defaults.QUADTREE_LEVELS, false));
            } else if (ft.tree().equals("quadtree")) {
                prefixTree = new PackedQuadPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, Builder.getLevels(ft.treeLevels(), ft.precisionInMeters(), DeprecatedParameters.Defaults.QUADTREE_LEVELS, false));
            } else {
                throw new IllegalArgumentException("Unknown prefix tree type [" + ft.tree() + "]");
            }
            RecursivePrefixTreeStrategy rpts = new RecursivePrefixTreeStrategy((SpatialPrefixTree)prefixTree, ft.name());
            rpts.setDistErrPct(ft.distanceErrorPct());
            rpts.setPruneLeafyBranches(false);
            ft.recursiveStrategy = rpts;
            TermQueryPrefixTreeStrategy termStrategy = new TermQueryPrefixTreeStrategy((SpatialPrefixTree)prefixTree, ft.name());
            termStrategy.setDistErrPct(ft.distanceErrorPct());
            ft.termStrategy = termStrategy;
            ft.defaultPrefixTreeStrategy = ft.resolvePrefixTreeStrategy(ft.strategy());
            ft.defaultPrefixTreeStrategy.setPointsOnly(ft.pointsOnly());
        }

        private GeoShapeFieldType buildFieldType(Mapper.BuilderContext context) {
            GeoShapeFieldType ft = new GeoShapeFieldType(this.buildFullName(context), this.indexed, this.fieldType.stored(), false, this.meta);
            this.setupFieldTypeDeprecatedParameters(context, ft);
            this.setupPrefixTrees(ft);
            ft.setGeometryIndexer(new LegacyGeoShapeIndexer(ft));
            ft.setGeometryParser(new LegacyGeoShapeParser());
            ft.setOrientation(this.orientation == null ? (ShapeBuilder.Orientation)((Object)AbstractShapeGeometryFieldMapper.Defaults.ORIENTATION.value()) : this.orientation);
            return ft;
        }

        private static int getLevels(int treeLevels, double precisionInMeters, int defaultLevels, boolean geoHash) {
            if (treeLevels > 0 || precisionInMeters >= 0.0) {
                return Math.max(treeLevels, precisionInMeters >= 0.0 ? (geoHash ? GeoUtils.geoHashLevelsForPrecision(precisionInMeters) : GeoUtils.quadTreeLevelsForPrecision(precisionInMeters)) : 0);
            }
            return defaultLevels;
        }

        @Override
        public LegacyGeoShapeFieldMapper build(Mapper.BuilderContext context) {
            if (this.name.isEmpty()) {
                throw new IllegalArgumentException("name cannot be empty string");
            }
            return new LegacyGeoShapeFieldMapper(this.name, this.fieldType, this.buildFieldType(context), this.ignoreMalformed(context), this.coerce(context), this.orientation(), this.ignoreZValue(), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    @Deprecated
    public static class DeprecatedParameters {
        public SpatialStrategy strategy = null;
        public String tree = null;
        public Integer treeLevels = null;
        public String precision = null;
        public Boolean pointsOnly = null;
        public Double distanceErrorPct = null;

        public void setSpatialStrategy(SpatialStrategy strategy) {
            this.strategy = strategy;
        }

        public void setTree(String prefixTree) {
            this.tree = prefixTree;
        }

        public void setTreeLevels(int treeLevels) {
            this.treeLevels = treeLevels;
        }

        public void setPrecision(String precision) {
            this.precision = precision;
        }

        public void setPointsOnly(boolean pointsOnly) {
            if (this.strategy == SpatialStrategy.TERM && !pointsOnly) {
                throw new OpenSearchParseException("points_only cannot be set to false for term strategy", new Object[0]);
            }
            this.pointsOnly = pointsOnly;
        }

        public void setDistanceErrorPct(double distanceErrorPct) {
            this.distanceErrorPct = distanceErrorPct;
        }

        public static boolean parse(String name, String fieldName, Object fieldNode, DeprecatedParameters deprecatedParameters) {
            if (Names.STRATEGY.match(fieldName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                DeprecatedParameters.checkPrefixTreeSupport(fieldName);
                deprecatedParameters.setSpatialStrategy(SpatialStrategy.fromString(fieldNode.toString()));
            } else if (Names.TREE.match(fieldName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                DeprecatedParameters.checkPrefixTreeSupport(fieldName);
                deprecatedParameters.setTree(fieldNode.toString());
            } else if (Names.TREE_LEVELS.match(fieldName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                DeprecatedParameters.checkPrefixTreeSupport(fieldName);
                deprecatedParameters.setTreeLevels(Integer.parseInt(fieldNode.toString()));
            } else if (Names.PRECISION.match(fieldName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                DeprecatedParameters.checkPrefixTreeSupport(fieldName);
                deprecatedParameters.setPrecision(fieldNode.toString());
            } else if (Names.DISTANCE_ERROR_PCT.match(fieldName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                DeprecatedParameters.checkPrefixTreeSupport(fieldName);
                deprecatedParameters.setDistanceErrorPct(Double.parseDouble(fieldNode.toString()));
            } else if (Names.POINTS_ONLY.match(fieldName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                DeprecatedParameters.checkPrefixTreeSupport(fieldName);
                deprecatedParameters.setPointsOnly(XContentMapValues.nodeBooleanValue(fieldNode, name + "." + Names.POINTS_ONLY));
            } else {
                return false;
            }
            return true;
        }

        private static void checkPrefixTreeSupport(String fieldName) {
            if (!ShapesAvailability.JTS_AVAILABLE || !ShapesAvailability.SPATIAL4J_AVAILABLE) {
                throw new OpenSearchParseException("Field parameter [{}] is not supported for [{}] field type", new Object[]{fieldName, LegacyGeoShapeFieldMapper.CONTENT_TYPE});
            }
            DEPRECATION_LOGGER.deprecate("geo_mapper_field_parameter_" + fieldName, "Field parameter [{}] is deprecated and will be removed in a future version.", fieldName);
        }

        public static class Defaults {
            public static final SpatialStrategy STRATEGY = SpatialStrategy.RECURSIVE;
            public static final String TREE = "quadtree";
            public static final String PRECISION = "50m";
            public static final int QUADTREE_LEVELS = GeoUtils.quadTreeLevelsForPrecision("50m");
            public static final int GEOHASH_TREE_LEVELS = GeoUtils.geoHashLevelsForPrecision("50m");
            public static final boolean POINTS_ONLY = false;
            public static final double DISTANCE_ERROR_PCT = 0.025;
        }

        public static class PrefixTrees {
            public static final String LEGACY_QUADTREE = "legacyquadtree";
            public static final String QUADTREE = "quadtree";
            public static final String GEOHASH = "geohash";
        }

        public static class Names {
            public static final ParseField STRATEGY = new ParseField("strategy", new String[0]);
            public static final ParseField TREE = new ParseField("tree", new String[0]);
            public static final ParseField TREE_LEVELS = new ParseField("tree_levels", new String[0]);
            public static final ParseField PRECISION = new ParseField("precision", new String[0]);
            public static final ParseField DISTANCE_ERROR_PCT = new ParseField("distance_error_pct", new String[0]);
            public static final ParseField POINTS_ONLY = new ParseField("points_only", new String[0]);
        }
    }
}

