/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.Version;
import org.opensearch.action.LatchedActionListener;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.Index;
import org.opensearch.gateway.PersistedClusterStateService;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.opensearch.node.Node;
import org.opensearch.node.remotestore.RemoteStoreNodeAttribute;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.repositories.blobstore.ChecksumBlobStoreFormat;
import org.opensearch.threadpool.ThreadPool;

public class RemoteClusterStateService
implements Closeable {
    public static final String METADATA_NAME_FORMAT = "%s.dat";
    public static final String METADATA_MANIFEST_NAME_FORMAT = "%s";
    public static final int RETAINED_MANIFESTS = 10;
    public static final String DELIMITER = "__";
    private static final Logger logger = LogManager.getLogger(RemoteClusterStateService.class);
    public static final int INDEX_METADATA_UPLOAD_WAIT_MILLIS = 20000;
    public static final ChecksumBlobStoreFormat<IndexMetadata> INDEX_METADATA_FORMAT = new ChecksumBlobStoreFormat("index-metadata", "%s.dat", IndexMetadata::fromXContent);
    public static final ChecksumBlobStoreFormat<ClusterMetadataManifest> CLUSTER_METADATA_MANIFEST_FORMAT = new ChecksumBlobStoreFormat("cluster-metadata-manifest", "%s", ClusterMetadataManifest::fromXContent);
    public static final Setting<Boolean> REMOTE_CLUSTER_STATE_ENABLED_SETTING = Setting.boolSetting("cluster.remote_store.state.enabled", false, Setting.Property.NodeScope, Setting.Property.Final);
    public static final String CLUSTER_STATE_PATH_TOKEN = "cluster-state";
    public static final String INDEX_PATH_TOKEN = "index";
    public static final String MANIFEST_PATH_TOKEN = "manifest";
    public static final String MANIFEST_FILE_PREFIX = "manifest";
    public static final String INDEX_METADATA_FILE_PREFIX = "metadata";
    private final String nodeId;
    private final Supplier<RepositoriesService> repositoriesService;
    private final Settings settings;
    private final LongSupplier relativeTimeNanosSupplier;
    private final ThreadPool threadpool;
    private BlobStoreRepository blobStoreRepository;
    private BlobStoreTransferService blobStoreTransferService;
    private volatile TimeValue slowWriteLoggingThreshold;
    private final AtomicBoolean deleteStaleMetadataRunning = new AtomicBoolean(false);

    public RemoteClusterStateService(String nodeId, Supplier<RepositoriesService> repositoriesService, Settings settings, ClusterSettings clusterSettings, LongSupplier relativeTimeNanosSupplier, ThreadPool threadPool) {
        assert (RemoteStoreNodeAttribute.isRemoteStoreClusterStateEnabled(settings)) : "Remote cluster state is not enabled";
        this.nodeId = nodeId;
        this.repositoriesService = repositoriesService;
        this.settings = settings;
        this.relativeTimeNanosSupplier = relativeTimeNanosSupplier;
        this.threadpool = threadPool;
        this.slowWriteLoggingThreshold = clusterSettings.get(PersistedClusterStateService.SLOW_WRITE_LOGGING_THRESHOLD);
        clusterSettings.addSettingsUpdateConsumer(PersistedClusterStateService.SLOW_WRITE_LOGGING_THRESHOLD, this::setSlowWriteLoggingThreshold);
    }

    private BlobStoreTransferService getBlobStoreTransferService() {
        if (this.blobStoreTransferService == null) {
            this.blobStoreTransferService = new BlobStoreTransferService(this.blobStoreRepository.blobStore(), this.threadpool);
        }
        return this.blobStoreTransferService;
    }

    @Nullable
    public ClusterMetadataManifest writeFullMetadata(ClusterState clusterState, String previousClusterUUID) throws IOException {
        long startTimeNanos = this.relativeTimeNanosSupplier.getAsLong();
        if (!clusterState.nodes().isLocalNodeElectedClusterManager()) {
            logger.error("Local node is not elected cluster manager. Exiting");
            return null;
        }
        List<ClusterMetadataManifest.UploadedIndexMetadata> allUploadedIndexMetadata = this.writeIndexMetadataParallel(clusterState, new ArrayList<IndexMetadata>(clusterState.metadata().indices().values()));
        ClusterMetadataManifest manifest = this.uploadManifest(clusterState, allUploadedIndexMetadata, previousClusterUUID, false);
        long durationMillis = TimeValue.nsecToMSec((long)(this.relativeTimeNanosSupplier.getAsLong() - startTimeNanos));
        if (durationMillis >= this.slowWriteLoggingThreshold.getMillis()) {
            logger.warn("writing cluster state took [{}ms] which is above the warn threshold of [{}]; wrote full state with [{}] indices", (Object)durationMillis, (Object)this.slowWriteLoggingThreshold, (Object)allUploadedIndexMetadata.size());
        } else {
            logger.info("writing cluster state took [{}ms]; wrote full state with [{}] indices", (Object)durationMillis, (Object)allUploadedIndexMetadata.size());
        }
        return manifest;
    }

    @Nullable
    public ClusterMetadataManifest writeIncrementalMetadata(ClusterState previousClusterState, ClusterState clusterState, ClusterMetadataManifest previousManifest) throws IOException {
        long startTimeNanos = this.relativeTimeNanosSupplier.getAsLong();
        if (!clusterState.nodes().isLocalNodeElectedClusterManager()) {
            logger.error("Local node is not elected cluster manager. Exiting");
            return null;
        }
        assert (previousClusterState.metadata().coordinationMetadata().term() == clusterState.metadata().coordinationMetadata().term());
        HashMap<String, Long> previousStateIndexMetadataVersionByName = new HashMap<String, Long>();
        for (IndexMetadata indexMetadata : previousClusterState.metadata().indices().values()) {
            previousStateIndexMetadataVersionByName.put(indexMetadata.getIndex().getName(), indexMetadata.getVersion());
        }
        int numIndicesUpdated = 0;
        int numIndicesUnchanged = 0;
        Map allUploadedIndexMetadata = previousManifest.getIndices().stream().collect(Collectors.toMap(ClusterMetadataManifest.UploadedIndexMetadata::getIndexName, Function.identity()));
        ArrayList<IndexMetadata> toUpload = new ArrayList<IndexMetadata>();
        for (IndexMetadata indexMetadata : clusterState.metadata().indices().values()) {
            Long previousVersion = (Long)previousStateIndexMetadataVersionByName.get(indexMetadata.getIndex().getName());
            if (previousVersion == null || indexMetadata.getVersion() != previousVersion.longValue()) {
                logger.trace("updating metadata for [{}], changing version from [{}] to [{}]", (Object)indexMetadata.getIndex(), (Object)previousVersion, (Object)indexMetadata.getVersion());
                ++numIndicesUpdated;
                toUpload.add(indexMetadata);
            } else {
                ++numIndicesUnchanged;
            }
            previousStateIndexMetadataVersionByName.remove(indexMetadata.getIndex().getName());
        }
        List<ClusterMetadataManifest.UploadedIndexMetadata> uploadedIndexMetadataList = this.writeIndexMetadataParallel(clusterState, toUpload);
        uploadedIndexMetadataList.forEach(uploadedIndexMetadata -> allUploadedIndexMetadata.put(uploadedIndexMetadata.getIndexName(), uploadedIndexMetadata));
        for (String removedIndexName : previousStateIndexMetadataVersionByName.keySet()) {
            allUploadedIndexMetadata.remove(removedIndexName);
        }
        ClusterMetadataManifest clusterMetadataManifest = this.uploadManifest(clusterState, new ArrayList<ClusterMetadataManifest.UploadedIndexMetadata>(allUploadedIndexMetadata.values()), previousManifest.getPreviousClusterUUID(), false);
        this.deleteStaleClusterMetadata(clusterState.getClusterName().value(), clusterState.metadata().clusterUUID(), 10);
        long durationMillis = TimeValue.nsecToMSec((long)(this.relativeTimeNanosSupplier.getAsLong() - startTimeNanos));
        if (durationMillis >= this.slowWriteLoggingThreshold.getMillis()) {
            logger.warn("writing cluster state took [{}ms] which is above the warn threshold of [{}]; wrote  metadata for [{}] indices and skipped [{}] unchanged indices", (Object)durationMillis, (Object)this.slowWriteLoggingThreshold, (Object)numIndicesUpdated, (Object)numIndicesUnchanged);
        } else {
            logger.trace("writing cluster state took [{}ms]; wrote metadata for [{}] indices and skipped [{}] unchanged indices", (Object)durationMillis, (Object)numIndicesUpdated, (Object)numIndicesUnchanged);
        }
        return clusterMetadataManifest;
    }

    private List<ClusterMetadataManifest.UploadedIndexMetadata> writeIndexMetadataParallel(ClusterState clusterState, List<IndexMetadata> toUpload) throws IOException {
        List exceptionList = Collections.synchronizedList(new ArrayList(toUpload.size()));
        CountDownLatch latch = new CountDownLatch(toUpload.size());
        ArrayList<ClusterMetadataManifest.UploadedIndexMetadata> result = new ArrayList<ClusterMetadataManifest.UploadedIndexMetadata>(toUpload.size());
        LatchedActionListener<ClusterMetadataManifest.UploadedIndexMetadata> latchedActionListener = new LatchedActionListener<ClusterMetadataManifest.UploadedIndexMetadata>(ActionListener.wrap(uploadedIndexMetadata -> {
            logger.trace(String.format(Locale.ROOT, "IndexMetadata uploaded successfully for %s", uploadedIndexMetadata.getIndexName()));
            result.add((ClusterMetadataManifest.UploadedIndexMetadata)uploadedIndexMetadata);
        }, ex -> {
            assert (ex instanceof IndexMetadataTransferException);
            logger.error(() -> new ParameterizedMessage("Exception during transfer of IndexMetadata to Remote {}", (Object)ex.getMessage()), (Throwable)ex);
            exceptionList.add(ex);
        }), latch);
        for (IndexMetadata indexMetadata : toUpload) {
            this.writeIndexMetadataAsync(clusterState, indexMetadata, latchedActionListener);
        }
        try {
            if (!latch.await(20000L, TimeUnit.MILLISECONDS)) {
                IndexMetadataTransferException ex2 = new IndexMetadataTransferException(String.format(Locale.ROOT, "Timed out waiting for transfer of index metadata to complete - %s", toUpload.stream().map(IndexMetadata::getIndex).map(Index::toString).collect(Collectors.joining(""))));
                exceptionList.forEach(ex2::addSuppressed);
                throw ex2;
            }
        }
        catch (InterruptedException ex3) {
            exceptionList.forEach(ex3::addSuppressed);
            IndexMetadataTransferException exception = new IndexMetadataTransferException(String.format(Locale.ROOT, "Timed out waiting for transfer of index metadata to complete - %s", toUpload.stream().map(IndexMetadata::getIndex).map(Index::toString).collect(Collectors.joining(""))), ex3);
            Thread.currentThread().interrupt();
            throw exception;
        }
        if (exceptionList.size() > 0) {
            IndexMetadataTransferException exception = new IndexMetadataTransferException(String.format(Locale.ROOT, "Exception during transfer of IndexMetadata to Remote %s", toUpload.stream().map(IndexMetadata::getIndex).map(Index::toString).collect(Collectors.joining(""))));
            exceptionList.forEach(exception::addSuppressed);
            throw exception;
        }
        return result;
    }

    private void writeIndexMetadataAsync(ClusterState clusterState, IndexMetadata indexMetadata, LatchedActionListener<ClusterMetadataManifest.UploadedIndexMetadata> latchedActionListener) throws IOException {
        BlobContainer indexMetadataContainer = this.indexMetadataContainer(clusterState.getClusterName().value(), clusterState.metadata().clusterUUID(), indexMetadata.getIndexUUID());
        String indexMetadataFilename = RemoteClusterStateService.indexMetadataFileName(indexMetadata);
        ActionListener completionListener = ActionListener.wrap(resp -> latchedActionListener.onResponse(new ClusterMetadataManifest.UploadedIndexMetadata(indexMetadata.getIndex().getName(), indexMetadata.getIndexUUID(), indexMetadataContainer.path().buildAsString() + indexMetadataFilename)), ex -> latchedActionListener.onFailure(new IndexMetadataTransferException(indexMetadata.getIndex().toString(), (Throwable)ex)));
        INDEX_METADATA_FORMAT.writeAsync(indexMetadata, indexMetadataContainer, indexMetadataFilename, this.blobStoreRepository.getCompressor(), (ActionListener<Void>)completionListener);
    }

    @Nullable
    public ClusterMetadataManifest markLastStateAsCommitted(ClusterState clusterState, ClusterMetadataManifest previousManifest) throws IOException {
        assert (clusterState != null) : "Last accepted cluster state is not set";
        if (!clusterState.nodes().isLocalNodeElectedClusterManager()) {
            logger.error("Local node is not elected cluster manager. Exiting");
            return null;
        }
        assert (previousManifest != null) : "Last cluster metadata manifest is not set";
        ClusterMetadataManifest committedManifest = this.uploadManifest(clusterState, previousManifest.getIndices(), previousManifest.getPreviousClusterUUID(), true);
        this.deleteStaleClusterUUIDs(clusterState, committedManifest);
        return committedManifest;
    }

    @Override
    public void close() throws IOException {
        if (this.blobStoreRepository != null) {
            IOUtils.close((Closeable)((Object)this.blobStoreRepository));
        }
    }

    public void start() {
        assert (RemoteStoreNodeAttribute.isRemoteStoreClusterStateEnabled(this.settings)) : "Remote cluster state is not enabled";
        String remoteStoreRepo = this.settings.get(Node.NODE_ATTRIBUTES.getKey() + "remote_store.state.repository");
        assert (remoteStoreRepo != null) : "Remote Cluster State repository is not configured";
        Repository repository = this.repositoriesService.get().repository(remoteStoreRepo);
        assert (repository instanceof BlobStoreRepository) : "Repository should be instance of BlobStoreRepository";
        this.blobStoreRepository = (BlobStoreRepository)repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterMetadataManifest uploadManifest(ClusterState clusterState, List<ClusterMetadataManifest.UploadedIndexMetadata> uploadedIndexMetadata, String previousClusterUUID, boolean committed) throws IOException {
        RemoteClusterStateService remoteClusterStateService = this;
        synchronized (remoteClusterStateService) {
            String manifestFileName = RemoteClusterStateService.getManifestFileName(clusterState.term(), clusterState.version());
            ClusterMetadataManifest manifest = new ClusterMetadataManifest(clusterState.term(), clusterState.getVersion(), clusterState.metadata().clusterUUID(), clusterState.stateUUID(), Version.CURRENT, this.nodeId, committed, uploadedIndexMetadata, previousClusterUUID, clusterState.metadata().clusterUUIDCommitted());
            this.writeMetadataManifest(clusterState.getClusterName().value(), clusterState.metadata().clusterUUID(), manifest, manifestFileName);
            return manifest;
        }
    }

    private void writeMetadataManifest(String clusterName, String clusterUUID, ClusterMetadataManifest uploadManifest, String fileName) throws IOException {
        BlobContainer metadataManifestContainer = this.manifestContainer(clusterName, clusterUUID);
        CLUSTER_METADATA_MANIFEST_FORMAT.write(uploadManifest, metadataManifestContainer, fileName, this.blobStoreRepository.getCompressor());
    }

    private String fetchPreviousClusterUUID(String clusterName, String clusterUUID) {
        Optional<ClusterMetadataManifest> latestManifest = this.getLatestClusterMetadataManifest(clusterName, clusterUUID);
        if (!latestManifest.isPresent()) {
            String previousClusterUUID = this.getLastKnownUUIDFromRemote(clusterName);
            assert (!clusterUUID.equals(previousClusterUUID)) : "Last cluster UUID is same current cluster UUID";
            return previousClusterUUID;
        }
        return latestManifest.get().getPreviousClusterUUID();
    }

    private BlobContainer indexMetadataContainer(String clusterName, String clusterUUID, String indexUUID) {
        return this.blobStoreRepository.blobStore().blobContainer(this.getCusterMetadataBasePath(clusterName, clusterUUID).add(INDEX_PATH_TOKEN).add(indexUUID));
    }

    private BlobContainer manifestContainer(String clusterName, String clusterUUID) {
        return this.blobStoreRepository.blobStore().blobContainer(this.getManifestFolderPath(clusterName, clusterUUID));
    }

    private BlobPath getCusterMetadataBasePath(String clusterName, String clusterUUID) {
        return this.blobStoreRepository.basePath().add(RemoteClusterStateService.encodeString(clusterName)).add(CLUSTER_STATE_PATH_TOKEN).add(clusterUUID);
    }

    private BlobContainer clusterUUIDContainer(String clusterName) {
        return this.blobStoreRepository.blobStore().blobContainer(this.blobStoreRepository.basePath().add(Base64.getUrlEncoder().withoutPadding().encodeToString(clusterName.getBytes(StandardCharsets.UTF_8))).add(CLUSTER_STATE_PATH_TOKEN));
    }

    private void setSlowWriteLoggingThreshold(TimeValue slowWriteLoggingThreshold) {
        this.slowWriteLoggingThreshold = slowWriteLoggingThreshold;
    }

    private static String getManifestFileName(long term, long version) {
        return String.join((CharSequence)DELIMITER, RemoteClusterStateService.getManifestFileNamePrefix(term, version), RemoteStoreUtils.invertLong(System.currentTimeMillis()));
    }

    private static String getManifestFileNamePrefix(long term, long version) {
        return String.join((CharSequence)DELIMITER, "manifest", RemoteStoreUtils.invertLong(term), RemoteStoreUtils.invertLong(version));
    }

    private static String indexMetadataFileName(IndexMetadata indexMetadata) {
        return String.join((CharSequence)DELIMITER, INDEX_METADATA_FILE_PREFIX, String.valueOf(indexMetadata.getVersion()), String.valueOf(System.currentTimeMillis()));
    }

    private BlobPath getManifestFolderPath(String clusterName, String clusterUUID) {
        return this.getCusterMetadataBasePath(clusterName, clusterUUID).add("manifest");
    }

    public Map<String, IndexMetadata> getLatestIndexMetadata(String clusterName, String clusterUUID) throws IOException {
        this.start();
        HashMap<String, IndexMetadata> remoteIndexMetadata = new HashMap<String, IndexMetadata>();
        Optional<ClusterMetadataManifest> clusterMetadataManifest = this.getLatestClusterMetadataManifest(clusterName, clusterUUID);
        if (!clusterMetadataManifest.isPresent()) {
            throw new IllegalStateException("Latest index metadata is not present for the provided clusterUUID");
        }
        assert (Objects.equals(clusterUUID, clusterMetadataManifest.get().getClusterUUID())) : "Corrupt ClusterMetadataManifest found. Cluster UUID mismatch.";
        for (ClusterMetadataManifest.UploadedIndexMetadata uploadedIndexMetadata : clusterMetadataManifest.get().getIndices()) {
            IndexMetadata indexMetadata = this.getIndexMetadata(clusterName, clusterUUID, uploadedIndexMetadata);
            remoteIndexMetadata.put(uploadedIndexMetadata.getIndexUUID(), indexMetadata);
        }
        return remoteIndexMetadata;
    }

    private IndexMetadata getIndexMetadata(String clusterName, String clusterUUID, ClusterMetadataManifest.UploadedIndexMetadata uploadedIndexMetadata) {
        try {
            String[] splitPath = uploadedIndexMetadata.getUploadedFilename().split("/");
            return INDEX_METADATA_FORMAT.read(this.indexMetadataContainer(clusterName, clusterUUID, uploadedIndexMetadata.getIndexUUID()), splitPath[splitPath.length - 1], this.blobStoreRepository.getNamedXContentRegistry());
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Error while downloading IndexMetadata - %s", uploadedIndexMetadata.getUploadedFilename()), e);
        }
    }

    public Optional<ClusterMetadataManifest> getLatestClusterMetadataManifest(String clusterName, String clusterUUID) {
        Optional<String> latestManifestFileName = this.getLatestManifestFileName(clusterName, clusterUUID);
        if (latestManifestFileName.isPresent()) {
            return Optional.of(this.fetchRemoteClusterMetadataManifest(clusterName, clusterUUID, latestManifestFileName.get()));
        }
        return Optional.empty();
    }

    public String getLastKnownUUIDFromRemote(String clusterName) {
        try {
            Set<String> clusterUUIDs = this.getAllClusterUUIDs(clusterName);
            Map<String, ClusterMetadataManifest> latestManifests = this.getLatestManifestForAllClusterUUIDs(clusterName, clusterUUIDs);
            List<String> validChain = this.createClusterChain(latestManifests, clusterName);
            if (validChain.isEmpty()) {
                return "_na_";
            }
            return validChain.get(0);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Error while fetching previous UUIDs from remote store for cluster name: %s", clusterName));
        }
    }

    private Set<String> getAllClusterUUIDs(String clusterName) throws IOException {
        Map<String, BlobContainer> clusterUUIDMetadata = this.clusterUUIDContainer(clusterName).children();
        if (clusterUUIDMetadata == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(clusterUUIDMetadata.keySet());
    }

    private Map<String, ClusterMetadataManifest> getLatestManifestForAllClusterUUIDs(String clusterName, Set<String> clusterUUIDs) {
        HashMap<String, ClusterMetadataManifest> manifestsByClusterUUID = new HashMap<String, ClusterMetadataManifest>();
        for (String clusterUUID : clusterUUIDs) {
            try {
                Optional<ClusterMetadataManifest> manifest = this.getLatestClusterMetadataManifest(clusterName, clusterUUID);
                manifest.ifPresent(clusterMetadataManifest -> manifestsByClusterUUID.put(clusterUUID, (ClusterMetadataManifest)clusterMetadataManifest));
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Exception in fetching manifest for clusterUUID: %s", clusterUUID));
            }
        }
        return manifestsByClusterUUID;
    }

    private List<String> createClusterChain(Map<String, ClusterMetadataManifest> manifestsByClusterUUID, String clusterName) {
        Map<String, String> clusterUUIDGraph = manifestsByClusterUUID.values().stream().collect(Collectors.toMap(ClusterMetadataManifest::getClusterUUID, ClusterMetadataManifest::getPreviousClusterUUID));
        List<String> validClusterUUIDs = manifestsByClusterUUID.values().stream().filter(m -> !this.isInvalidClusterUUID((ClusterMetadataManifest)m) && !clusterUUIDGraph.containsValue(m.getClusterUUID())).map(ClusterMetadataManifest::getClusterUUID).collect(Collectors.toList());
        if (validClusterUUIDs.isEmpty()) {
            logger.info("There is no valid previous cluster UUID");
            return Collections.emptyList();
        }
        if (validClusterUUIDs.size() > 1) {
            Map<String, ClusterMetadataManifest> manifestsByClusterUUIDTrimmed = this.trimClusterUUIDs(manifestsByClusterUUID, validClusterUUIDs, clusterName);
            if (manifestsByClusterUUID.size() == manifestsByClusterUUIDTrimmed.size()) {
                throw new IllegalStateException(String.format(Locale.ROOT, "The system has ended into multiple valid cluster states in the remote store. Please check their latest manifest to decide which one you want to keep. Valid Cluster UUIDs: - %s", validClusterUUIDs));
            }
            return this.createClusterChain(manifestsByClusterUUIDTrimmed, clusterName);
        }
        ArrayList<String> validChain = new ArrayList<String>();
        String currentUUID = validClusterUUIDs.get(0);
        while (currentUUID != null && !"_na_".equals(currentUUID)) {
            validChain.add(currentUUID);
            currentUUID = clusterUUIDGraph.get(currentUUID);
        }
        return validChain;
    }

    private Map<String, ClusterMetadataManifest> trimClusterUUIDs(Map<String, ClusterMetadataManifest> latestManifestsByClusterUUID, List<String> validClusterUUIDs, String clusterName) {
        HashMap<String, ClusterMetadataManifest> trimmedUUIDs = new HashMap<String, ClusterMetadataManifest>(latestManifestsByClusterUUID);
        for (String clusterUUID : validClusterUUIDs) {
            ClusterMetadataManifest currentManifest = (ClusterMetadataManifest)trimmedUUIDs.get(clusterUUID);
            if ("_na_".equals(currentManifest.getPreviousClusterUUID())) {
                if (!currentManifest.getIndices().isEmpty()) continue;
                trimmedUUIDs.remove(clusterUUID);
                continue;
            }
            ClusterMetadataManifest previousManifest = (ClusterMetadataManifest)trimmedUUIDs.get(currentManifest.getPreviousClusterUUID());
            if (!this.isMetadataEqual(currentManifest, previousManifest, clusterName)) continue;
            trimmedUUIDs.remove(clusterUUID);
        }
        return trimmedUUIDs;
    }

    private boolean isMetadataEqual(ClusterMetadataManifest first, ClusterMetadataManifest second, String clusterName) {
        if (first.getIndices().size() != second.getIndices().size()) {
            return false;
        }
        Map secondIndices = second.getIndices().stream().collect(Collectors.toMap(md -> md.getIndexName(), Function.identity()));
        for (ClusterMetadataManifest.UploadedIndexMetadata uploadedIndexMetadata : first.getIndices()) {
            IndexMetadata firstIndexMetadata = this.getIndexMetadata(clusterName, first.getClusterUUID(), uploadedIndexMetadata);
            ClusterMetadataManifest.UploadedIndexMetadata secondUploadedIndexMetadata = (ClusterMetadataManifest.UploadedIndexMetadata)secondIndices.get(uploadedIndexMetadata.getIndexName());
            if (secondUploadedIndexMetadata == null) {
                return false;
            }
            IndexMetadata secondIndexMetadata = this.getIndexMetadata(clusterName, second.getClusterUUID(), secondUploadedIndexMetadata);
            if (firstIndexMetadata.equals(secondIndexMetadata)) continue;
            return false;
        }
        return true;
    }

    private boolean isInvalidClusterUUID(ClusterMetadataManifest manifest) {
        return !manifest.isClusterUUIDCommitted();
    }

    private List<BlobMetadata> getManifestFileNames(String clusterName, String clusterUUID, int limit) throws IllegalStateException {
        try {
            return this.manifestContainer(clusterName, clusterUUID).listBlobsByPrefixInSortedOrder("manifest__", limit, BlobContainer.BlobNameSortOrder.LEXICOGRAPHIC);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while fetching latest manifest file for remote cluster state", e);
        }
    }

    private Optional<String> getLatestManifestFileName(String clusterName, String clusterUUID) throws IllegalStateException {
        List<BlobMetadata> manifestFilesMetadata = this.getManifestFileNames(clusterName, clusterUUID, 1);
        if (manifestFilesMetadata != null && !manifestFilesMetadata.isEmpty()) {
            return Optional.of(manifestFilesMetadata.get(0).name());
        }
        logger.info("No manifest file present in remote store for cluster name: {}, cluster UUID: {}", (Object)clusterName, (Object)clusterUUID);
        return Optional.empty();
    }

    private ClusterMetadataManifest fetchRemoteClusterMetadataManifest(String clusterName, String clusterUUID, String filename) throws IllegalStateException {
        try {
            return CLUSTER_METADATA_MANIFEST_FORMAT.read(this.manifestContainer(clusterName, clusterUUID), filename, this.blobStoreRepository.getNamedXContentRegistry());
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Error while downloading cluster metadata - %s", filename), e);
        }
    }

    public static String encodeString(String content) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(content.getBytes(StandardCharsets.UTF_8));
    }

    private void deleteStaleUUIDsClusterMetadata(String clusterName, List<String> clusterUUIDs) {
        clusterUUIDs.forEach(clusterUUID -> this.getBlobStoreTransferService().deleteAsync("remote_purge", this.getCusterMetadataBasePath(clusterName, (String)clusterUUID), new ActionListener<Void>(){

            public void onResponse(Void unused) {
                logger.info("Deleted all remote cluster metadata for cluster UUID - {}", (Object)clusterUUID);
            }

            public void onFailure(Exception e) {
                logger.error((Message)new ParameterizedMessage("Exception occurred while deleting all remote cluster metadata for cluster UUID {}", (Object)clusterUUID), (Throwable)e);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteStaleClusterMetadata(final String clusterName, final String clusterUUID, final int manifestsToRetain) {
        if (!this.deleteStaleMetadataRunning.compareAndSet(false, true)) {
            logger.info("Delete stale cluster metadata task is already in progress.");
            return;
        }
        try {
            this.getBlobStoreTransferService().listAllInSortedOrderAsync("remote_purge", this.getManifestFolderPath(clusterName, clusterUUID), "manifest", Integer.MAX_VALUE, new ActionListener<List<BlobMetadata>>(){

                public void onResponse(List<BlobMetadata> blobMetadata) {
                    if (blobMetadata.size() > manifestsToRetain) {
                        RemoteClusterStateService.this.deleteClusterMetadata(clusterName, clusterUUID, blobMetadata.subList(0, manifestsToRetain - 1), blobMetadata.subList(manifestsToRetain - 1, blobMetadata.size()));
                    }
                    RemoteClusterStateService.this.deleteStaleMetadataRunning.set(false);
                }

                public void onFailure(Exception e) {
                    logger.error((Message)new ParameterizedMessage("Exception occurred while deleting Remote Cluster Metadata for clusterUUIDs {}", (Object)clusterUUID));
                    RemoteClusterStateService.this.deleteStaleMetadataRunning.set(false);
                }
            });
        }
        finally {
            this.deleteStaleMetadataRunning.set(false);
        }
    }

    private void deleteClusterMetadata(String clusterName, String clusterUUID, List<BlobMetadata> activeManifestBlobMetadata, List<BlobMetadata> staleManifestBlobMetadata) {
        try {
            HashSet filesToKeep = new HashSet();
            HashSet staleManifestPaths = new HashSet();
            HashSet staleIndexMetadataPaths = new HashSet();
            activeManifestBlobMetadata.forEach(blobMetadata -> {
                ClusterMetadataManifest clusterMetadataManifest = this.fetchRemoteClusterMetadataManifest(clusterName, clusterUUID, blobMetadata.name());
                clusterMetadataManifest.getIndices().forEach(uploadedIndexMetadata -> filesToKeep.add(uploadedIndexMetadata.getUploadedFilename()));
            });
            staleManifestBlobMetadata.forEach(blobMetadata -> {
                ClusterMetadataManifest clusterMetadataManifest = this.fetchRemoteClusterMetadataManifest(clusterName, clusterUUID, blobMetadata.name());
                staleManifestPaths.add(new BlobPath().add("manifest").buildAsString() + blobMetadata.name());
                clusterMetadataManifest.getIndices().forEach(uploadedIndexMetadata -> {
                    if (!filesToKeep.contains(uploadedIndexMetadata.getUploadedFilename())) {
                        staleIndexMetadataPaths.add(new BlobPath().add(INDEX_PATH_TOKEN).add(uploadedIndexMetadata.getIndexUUID()).buildAsString() + uploadedIndexMetadata.getUploadedFilename() + ".dat");
                    }
                });
            });
            if (staleManifestPaths.isEmpty()) {
                logger.info("No stale Remote Cluster Metadata files found");
                return;
            }
            this.deleteStalePaths(clusterName, clusterUUID, new ArrayList<String>(staleIndexMetadataPaths));
            this.deleteStalePaths(clusterName, clusterUUID, new ArrayList<String>(staleManifestPaths));
        }
        catch (IllegalStateException e) {
            logger.error("Error while fetching Remote Cluster Metadata manifests", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error while deleting stale Remote Cluster Metadata files", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unexpected error while deleting stale Remote Cluster Metadata files", (Throwable)e);
        }
    }

    private void deleteStalePaths(String clusterName, String clusterUUID, List<String> stalePaths) throws IOException {
        logger.debug(String.format(Locale.ROOT, "Deleting stale files from remote - %s", stalePaths));
        this.getBlobStoreTransferService().deleteBlobs(this.getCusterMetadataBasePath(clusterName, clusterUUID), stalePaths);
    }

    public void deleteStaleClusterUUIDs(ClusterState clusterState, ClusterMetadataManifest committedManifest) {
        this.threadpool.executor("remote_purge").execute(() -> {
            HashSet<String> allClustersUUIDsInRemote;
            String clusterName = clusterState.getClusterName().value();
            logger.info("Deleting stale cluster UUIDs data from remote [{}]", (Object)clusterName);
            try {
                allClustersUUIDsInRemote = new HashSet<String>(this.getAllClusterUUIDs(clusterState.getClusterName().value()));
            }
            catch (IOException e) {
                logger.info(String.format(Locale.ROOT, "Error while fetching all cluster UUIDs for [%s]", clusterName));
                return;
            }
            allClustersUUIDsInRemote.remove(committedManifest.getClusterUUID());
            allClustersUUIDsInRemote.remove(committedManifest.getPreviousClusterUUID());
            this.deleteStaleUUIDsClusterMetadata(clusterName, new ArrayList<String>(allClustersUUIDsInRemote));
        });
    }

    static class IndexMetadataTransferException
    extends RuntimeException {
        public IndexMetadataTransferException(String errorDesc) {
            super(errorDesc);
        }

        public IndexMetadataTransferException(String errorDesc, Throwable cause) {
            super(errorDesc, cause);
        }
    }
}

