/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.BulkOperation;
import org.apache.lucene.util.packed.DirectPacked64SingleBlockReader;
import org.apache.lucene.util.packed.DirectPackedReader;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PackedReaderIterator;
import org.apache.lucene.util.packed.XPacked64;
import org.apache.lucene.util.packed.XPacked64SingleBlock;

public class XPackedInts {
    public static final float FASTEST = 7.0f;
    public static final float FAST = 0.5f;
    public static final float DEFAULT = 0.25f;
    public static final float COMPACT = 0.0f;
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final String CODEC_NAME = "PackedInts";
    public static final int VERSION_MONOTONIC_WITHOUT_ZIGZAG = 2;
    public static final int VERSION_START = 2;
    public static final int VERSION_CURRENT = 2;

    public static void checkVersion(int version) {
        if (version < 2) {
            throw new IllegalArgumentException("Version is too old, should be at least 2 (got " + version + ")");
        }
        if (version > 2) {
            throw new IllegalArgumentException("Version is too new, should be at most 2 (got " + version + ")");
        }
    }

    public static PackedInts.FormatAndBits fastestFormatAndBits(int valueCount, int bitsPerValue, float acceptableOverheadRatio) {
        if (valueCount == -1) {
            valueCount = Integer.MAX_VALUE;
        }
        acceptableOverheadRatio = Math.max(0.0f, acceptableOverheadRatio);
        acceptableOverheadRatio = Math.min(7.0f, acceptableOverheadRatio);
        float acceptableOverheadPerValue = acceptableOverheadRatio * (float)bitsPerValue;
        int maxBitsPerValue = bitsPerValue + (int)acceptableOverheadPerValue;
        int actualBitsPerValue = -1;
        actualBitsPerValue = bitsPerValue <= 8 && maxBitsPerValue >= 8 ? 8 : (bitsPerValue <= 16 && maxBitsPerValue >= 16 ? 16 : (bitsPerValue <= 32 && maxBitsPerValue >= 32 ? 32 : (bitsPerValue <= 64 && maxBitsPerValue >= 64 ? 64 : bitsPerValue)));
        return new PackedInts.FormatAndBits(PackedInts.Format.PACKED, actualBitsPerValue);
    }

    public static PackedInts.Decoder getDecoder(PackedInts.Format format, int version, int bitsPerValue) {
        XPackedInts.checkVersion(version);
        return BulkOperation.of((PackedInts.Format)format, (int)bitsPerValue);
    }

    public static PackedInts.Encoder getEncoder(PackedInts.Format format, int version, int bitsPerValue) {
        XPackedInts.checkVersion(version);
        return BulkOperation.of((PackedInts.Format)format, (int)bitsPerValue);
    }

    public static PackedInts.Reader getReaderNoHeader(DataInput in, PackedInts.Format format, int version, int valueCount, int bitsPerValue) throws IOException {
        XPackedInts.checkVersion(version);
        switch (format) {
            case PACKED_SINGLE_BLOCK: {
                return XPacked64SingleBlock.create(in, valueCount, bitsPerValue);
            }
            case PACKED: {
                return new XPacked64(version, in, valueCount, bitsPerValue);
            }
        }
        throw new AssertionError((Object)("Unknown Writer format: " + format));
    }

    public static PackedInts.Reader getReader(DataInput in) throws IOException {
        int version = CodecUtil.checkHeader((DataInput)in, (String)CODEC_NAME, (int)2, (int)2);
        int bitsPerValue = in.readVInt();
        assert (bitsPerValue > 0 && bitsPerValue <= 64) : "bitsPerValue=" + bitsPerValue;
        int valueCount = in.readVInt();
        PackedInts.Format format = PackedInts.Format.byId((int)in.readVInt());
        return XPackedInts.getReaderNoHeader(in, format, version, valueCount, bitsPerValue);
    }

    public static PackedInts.ReaderIterator getReaderIteratorNoHeader(DataInput in, PackedInts.Format format, int version, int valueCount, int bitsPerValue, int mem) {
        XPackedInts.checkVersion(version);
        return new PackedReaderIterator(format, version, valueCount, bitsPerValue, in, mem);
    }

    public static PackedInts.ReaderIterator getReaderIterator(DataInput in, int mem) throws IOException {
        int version = CodecUtil.checkHeader((DataInput)in, (String)CODEC_NAME, (int)2, (int)2);
        int bitsPerValue = in.readVInt();
        assert (bitsPerValue > 0 && bitsPerValue <= 64) : "bitsPerValue=" + bitsPerValue;
        int valueCount = in.readVInt();
        PackedInts.Format format = PackedInts.Format.byId((int)in.readVInt());
        return XPackedInts.getReaderIteratorNoHeader(in, format, version, valueCount, bitsPerValue, mem);
    }

    public static PackedInts.Reader getDirectReaderNoHeader(IndexInput in, PackedInts.Format format, int version, int valueCount, int bitsPerValue) {
        XPackedInts.checkVersion(version);
        switch (format) {
            case PACKED: {
                return new DirectPackedReader(bitsPerValue, valueCount, in);
            }
            case PACKED_SINGLE_BLOCK: {
                return new DirectPacked64SingleBlockReader(bitsPerValue, valueCount, in);
            }
        }
        throw new AssertionError((Object)("Unknown format: " + format));
    }

    public static PackedInts.Reader getDirectReader(IndexInput in) throws IOException {
        int version = CodecUtil.checkHeader((DataInput)in, (String)CODEC_NAME, (int)2, (int)2);
        int bitsPerValue = in.readVInt();
        assert (bitsPerValue > 0 && bitsPerValue <= 64) : "bitsPerValue=" + bitsPerValue;
        int valueCount = in.readVInt();
        PackedInts.Format format = PackedInts.Format.byId((int)in.readVInt());
        return XPackedInts.getDirectReaderNoHeader(in, format, version, valueCount, bitsPerValue);
    }

    public static Mutable getMutable(int valueCount, int bitsPerValue, float acceptableOverheadRatio) {
        PackedInts.FormatAndBits formatAndBits = XPackedInts.fastestFormatAndBits(valueCount, bitsPerValue, acceptableOverheadRatio);
        return XPackedInts.getMutable(valueCount, formatAndBits.bitsPerValue, formatAndBits.format);
    }

    public static Mutable getMutable(int valueCount, int bitsPerValue, PackedInts.Format format) {
        assert (valueCount >= 0);
        switch (format) {
            case PACKED_SINGLE_BLOCK: {
                return XPacked64SingleBlock.create(valueCount, bitsPerValue);
            }
            case PACKED: {
                return new XPacked64(valueCount, bitsPerValue);
            }
        }
        throw new AssertionError();
    }

    public static XWriter getWriterNoHeader(DataOutput out, PackedInts.Format format, int valueCount, int bitsPerValue, int mem) {
        return new XPackedWriter(format, out, valueCount, bitsPerValue, mem);
    }

    public static PackedInts.Writer getWriter(DataOutput out, int valueCount, int bitsPerValue, float acceptableOverheadRatio) throws IOException {
        assert (valueCount >= 0);
        PackedInts.FormatAndBits formatAndBits = XPackedInts.fastestFormatAndBits(valueCount, bitsPerValue, acceptableOverheadRatio);
        XWriter writer = XPackedInts.getWriterNoHeader(out, formatAndBits.format, valueCount, formatAndBits.bitsPerValue, 1024);
        writer.writeHeader();
        return writer;
    }

    public static int bitsRequired(long maxValue) {
        if (maxValue < 0L) {
            throw new IllegalArgumentException("maxValue must be non-negative (got: " + maxValue + ")");
        }
        return XPackedInts.unsignedBitsRequired(maxValue);
    }

    public static int unsignedBitsRequired(long bits) {
        return Math.max(1, 64 - Long.numberOfLeadingZeros(bits));
    }

    public static long maxValue(int bitsPerValue) {
        return bitsPerValue == 64 ? Long.MAX_VALUE : -1L << bitsPerValue ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void copy(PackedInts.Reader src, int srcPos, Mutable dest, int destPos, int len, int mem) {
        assert (srcPos + len <= src.size());
        assert (destPos + len <= dest.size());
        int capacity = mem >>> 3;
        if (capacity == 0) {
            for (int i = 0; i < len; ++i) {
                dest.set(destPos++, src.get(srcPos++));
            }
        } else if (len > 0) {
            long[] buf = new long[Math.min(capacity, len)];
            XPackedInts.copy(src, srcPos, dest, destPos, len, buf);
        }
    }

    static void copy(PackedInts.Reader src, int srcPos, Mutable dest, int destPos, int len, long[] buf) {
        assert (buf.length > 0);
        int remaining = 0;
        while (len > 0) {
            int read = src.get(srcPos, buf, remaining, Math.min(len, buf.length - remaining));
            assert (read > 0);
            srcPos += read;
            len -= read;
            int written = dest.set(destPos, buf, 0, remaining += read);
            assert (written > 0);
            destPos += written;
            if (written < remaining) {
                System.arraycopy(buf, written, buf, 0, remaining - written);
            }
            remaining -= written;
        }
        while (remaining > 0) {
            int written = dest.set(destPos, buf, 0, remaining);
            destPos += written;
            System.arraycopy(buf, written, buf, 0, remaining -= written);
        }
    }

    static int checkBlockSize(int blockSize, int minBlockSize, int maxBlockSize) {
        if (blockSize < minBlockSize || blockSize > maxBlockSize) {
            throw new IllegalArgumentException("blockSize must be >= " + minBlockSize + " and <= " + maxBlockSize + ", got " + blockSize);
        }
        if ((blockSize & blockSize - 1) != 0) {
            throw new IllegalArgumentException("blockSize must be a power of two, got " + blockSize);
        }
        return Integer.numberOfTrailingZeros(blockSize);
    }

    static int numBlocks(long size, int blockSize) {
        int numBlocks = (int)(size / (long)blockSize) + (size % (long)blockSize == 0L ? 0 : 1);
        if ((long)numBlocks * (long)blockSize < size) {
            throw new IllegalArgumentException("size is too large for this block size");
        }
        return numBlocks;
    }

    public static abstract class XWriter
    extends PackedInts.Writer {
        protected XWriter(DataOutput out, int valueCount, int bitsPerValue) {
            super(out, valueCount, bitsPerValue);
        }

        void writeHeader() throws IOException {
            assert (this.valueCount != -1);
            CodecUtil.writeHeader((DataOutput)this.out, (String)XPackedInts.CODEC_NAME, (int)2);
            this.out.writeVInt(this.bitsPerValue);
            this.out.writeVInt(this.valueCount);
            this.out.writeVInt(this.getFormat().getId());
        }
    }

    public static final class NullReader
    extends PackedInts.Reader {
        private final int valueCount;

        public NullReader(int valueCount) {
            this.valueCount = valueCount;
        }

        public long get(int index) {
            return 0L;
        }

        public int get(int index, long[] arr, int off, int len) {
            assert (len > 0) : "len must be > 0 (got " + len + ")";
            assert (index >= 0 && index < this.valueCount);
            len = Math.min(len, this.valueCount - index);
            Arrays.fill(arr, off, off + len, 0L);
            return len;
        }

        public int size() {
            return this.valueCount;
        }

        public long ramBytesUsed() {
            return RamUsageEstimator.alignObjectSize((long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4));
        }
    }

    static abstract class MutableImpl
    extends Mutable {
        protected final int valueCount;
        protected final int bitsPerValue;

        protected MutableImpl(int valueCount, int bitsPerValue) {
            this.valueCount = valueCount;
            assert (bitsPerValue > 0 && bitsPerValue <= 64) : "bitsPerValue=" + bitsPerValue;
            this.bitsPerValue = bitsPerValue;
        }

        @Override
        public final int getBitsPerValue() {
            return this.bitsPerValue;
        }

        public final int size() {
            return this.valueCount;
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(valueCount=" + this.valueCount + ",bitsPerValue=" + this.bitsPerValue + ")";
        }
    }

    static abstract class ReaderImpl
    extends PackedInts.Reader {
        protected final int valueCount;

        protected ReaderImpl(int valueCount) {
            this.valueCount = valueCount;
        }

        public abstract long get(int var1);

        public final int size() {
            return this.valueCount;
        }
    }

    public static abstract class Mutable
    extends PackedInts.Reader {
        public abstract int getBitsPerValue();

        public abstract void set(int var1, long var2);

        public int set(int index, long[] arr, int off, int len) {
            assert (len > 0) : "len must be > 0 (got " + len + ")";
            assert (index >= 0 && index < this.size());
            len = Math.min(len, this.size() - index);
            assert (off + len <= arr.length);
            int i = index;
            int o = off;
            int end = index + len;
            while (i < end) {
                this.set(i, arr[o]);
                ++i;
                ++o;
            }
            return len;
        }

        public void fill(int fromIndex, int toIndex, long val) {
            assert (val <= XPackedInts.maxValue(this.getBitsPerValue()));
            assert (fromIndex <= toIndex);
            for (int i = fromIndex; i < toIndex; ++i) {
                this.set(i, val);
            }
        }

        public void clear() {
            this.fill(0, this.size(), 0L);
        }

        public void save(DataOutput out) throws IOException {
            XWriter writer = XPackedInts.getWriterNoHeader(out, this.getFormat(), this.size(), this.getBitsPerValue(), 1024);
            writer.writeHeader();
            for (int i = 0; i < this.size(); ++i) {
                writer.add(this.get(i));
            }
            writer.finish();
        }

        PackedInts.Format getFormat() {
            return PackedInts.Format.PACKED;
        }
    }

    static final class XPackedWriter
    extends XWriter {
        boolean finished;
        final PackedInts.Format format;
        final BulkOperation encoder;
        final byte[] nextBlocks;
        final long[] nextValues;
        final int iterations;
        int off;
        int written;

        XPackedWriter(PackedInts.Format format, DataOutput out, int valueCount, int bitsPerValue, int mem) {
            super(out, valueCount, bitsPerValue);
            this.format = format;
            this.encoder = BulkOperation.of((PackedInts.Format)format, (int)bitsPerValue);
            this.iterations = this.encoder.computeIterations(valueCount, mem);
            this.nextBlocks = new byte[this.iterations * this.encoder.byteBlockCount()];
            this.nextValues = new long[this.iterations * this.encoder.byteValueCount()];
            this.off = 0;
            this.written = 0;
            this.finished = false;
        }

        protected PackedInts.Format getFormat() {
            return this.format;
        }

        public void add(long v) throws IOException {
            assert (PackedInts.unsignedBitsRequired((long)v) <= this.bitsPerValue);
            assert (!this.finished);
            if (this.valueCount != -1 && this.written >= this.valueCount) {
                throw new EOFException("Writing past end of stream");
            }
            this.nextValues[this.off++] = v;
            if (this.off == this.nextValues.length) {
                this.flush();
            }
            ++this.written;
        }

        public void finish() throws IOException {
            assert (!this.finished);
            if (this.valueCount != -1) {
                while (this.written < this.valueCount) {
                    this.add(0L);
                }
            }
            this.flush();
            this.finished = true;
        }

        private void flush() throws IOException {
            this.encoder.encode(this.nextValues, 0, this.nextBlocks, 0, this.iterations);
            int blockCount = (int)this.format.byteCount(2, this.off, this.bitsPerValue);
            this.out.writeBytes(this.nextBlocks, blockCount);
            Arrays.fill(this.nextValues, 0L);
            this.off = 0;
        }

        public int ord() {
            return this.written - 1;
        }
    }
}

