/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.settings;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.opensearch.cli.KeyStoreAwareCommand;
import org.opensearch.cli.Terminal;
import org.opensearch.cli.UserException;
import org.opensearch.common.settings.KeyStoreWrapper;
import org.opensearch.core.common.settings.SecureString;
import org.opensearch.env.Environment;

class CreateKeyStoreCommand
extends KeyStoreAwareCommand {
    private final OptionSpec<Void> passwordOption;

    CreateKeyStoreCommand() {
        super("Creates a new opensearch keystore");
        this.passwordOption = this.parser.acceptsAll(Arrays.asList("p", "password"), "Prompt for password to encrypt the keystore");
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        try (SecureString password = options.has(this.passwordOption) ? CreateKeyStoreCommand.readPassword((Terminal)terminal, (boolean)true) : new SecureString(new char[0]);){
            Path keystoreFile = KeyStoreWrapper.keystorePath((Path)env.configFile());
            if (Files.exists(keystoreFile, new LinkOption[0]) && !terminal.promptYesNo("An opensearch keystore already exists. Overwrite?", false)) {
                terminal.println("Exiting without creating keystore.");
                return;
            }
            KeyStoreWrapper keystore = KeyStoreWrapper.create();
            keystore.save(env.configFile(), password.getChars());
            terminal.println("Created opensearch keystore in " + KeyStoreWrapper.keystorePath((Path)env.configFile()));
        }
        catch (SecurityException e) {
            throw new UserException(74, "Error creating the opensearch keystore.");
        }
    }
}

