/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing;

import java.util.Objects;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.telemetry.tracing.SpanScope;
import org.opensearch.telemetry.tracing.TracerContextStorage;

@InternalApi
class DefaultSpanScope
implements SpanScope {
    private final Span span;
    private final SpanScope previousSpanScope;
    private static final ThreadLocal<SpanScope> spanScopeThreadLocal = new ThreadLocal();
    private final TracerContextStorage<String, Span> tracerContextStorage;

    private DefaultSpanScope(Span span, SpanScope previousSpanScope, TracerContextStorage<String, Span> tracerContextStorage) {
        this.span = Objects.requireNonNull(span);
        this.previousSpanScope = previousSpanScope;
        this.tracerContextStorage = tracerContextStorage;
    }

    public static SpanScope create(Span span, TracerContextStorage<String, Span> tracerContextStorage) {
        SpanScope beforeSpanScope = spanScopeThreadLocal.get();
        DefaultSpanScope newSpanScope = new DefaultSpanScope(span, beforeSpanScope, tracerContextStorage);
        spanScopeThreadLocal.set(newSpanScope);
        return newSpanScope;
    }

    @Override
    public void close() {
        this.detach();
        spanScopeThreadLocal.set(this.previousSpanScope);
    }

    @Override
    public SpanScope attach() {
        this.tracerContextStorage.put("current_span", this.span);
        return this;
    }

    private void detach() {
        if (this.previousSpanScope != null) {
            this.tracerContextStorage.put("current_span", this.previousSpanScope.getSpan());
        } else {
            this.tracerContextStorage.put("current_span", null);
        }
    }

    @Override
    public Span getSpan() {
        return this.span;
    }

    static SpanScope getCurrentSpanScope() {
        return spanScopeThreadLocal.get();
    }
}

