/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExceptionUtil
extends ExceptionUtilRt {
    @NotNull
    public static Throwable getRootCause(@NotNull Throwable e) {
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(0);
        }
        while (true) {
            if (e.getCause() == null) {
                Throwable throwable = e;
                if (throwable == null) {
                    ExceptionUtil.$$$reportNull$$$0(1);
                }
                return throwable;
            }
            e = e.getCause();
        }
    }

    public static <T> List<T> findCauseAndSuppressed(@NotNull Throwable error, @NotNull Class<T> klass) {
        if (error == null) {
            ExceptionUtil.$$$reportNull$$$0(2);
        }
        if (klass == null) {
            ExceptionUtil.$$$reportNull$$$0(3);
        }
        LinkedHashSet<Throwable> allThrowables = new LinkedHashSet<Throwable>();
        ArrayDeque<Throwable> deque = new ArrayDeque<Throwable>();
        deque.add(error);
        while (!deque.isEmpty()) {
            Throwable t = (Throwable)deque.removeFirst();
            if (!allThrowables.add(t)) continue;
            for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
                deque.addLast(cause);
            }
            for (Throwable s : t.getSuppressed()) {
                deque.addLast(s);
            }
        }
        return ContainerUtil.filterIsInstance(allThrowables, klass);
    }

    @NotNull
    public static Throwable makeStackTraceRelative(@NotNull Throwable th, @NotNull Throwable relativeTo) {
        if (th == null) {
            ExceptionUtil.$$$reportNull$$$0(4);
        }
        if (relativeTo == null) {
            ExceptionUtil.$$$reportNull$$$0(5);
        }
        StackTraceElement[] trace = th.getStackTrace();
        StackTraceElement[] rootTrace = relativeTo.getStackTrace();
        int len = Math.min(trace.length, rootTrace.length);
        for (int i = 0; i < len; ++i) {
            if (trace[trace.length - i - 1].equals(rootTrace[rootTrace.length - i - 1])) continue;
            int newDepth = trace.length - i;
            th.setStackTrace(Arrays.copyOf(trace, newDepth));
            break;
        }
        Throwable throwable = th;
        if (throwable == null) {
            ExceptionUtil.$$$reportNull$$$0(6);
        }
        return throwable;
    }

    @NotNull
    public static String currentStackTrace() {
        return ExceptionUtil.getThrowableText(new Throwable());
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable t) {
        if (t == null) {
            ExceptionUtil.$$$reportNull$$$0(7);
        }
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String string2 = writer.getBuffer().toString();
        if (string2 == null) {
            ExceptionUtil.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Nullable
    public static String getMessage(@NotNull Throwable e) {
        if (e == null) {
            ExceptionUtil.$$$reportNull$$$0(15);
        }
        String result2 = e.getMessage();
        String exceptionPattern = "Exception: ";
        String errorPattern = "Error: ";
        while (e.getCause() != null && (result2 == null || result2.contains(exceptionPattern) || result2.contains(errorPattern))) {
            e = e.getCause();
            result2 = e.getMessage();
        }
        if (result2 != null) {
            result2 = ExceptionUtil.extractMessage(result2, exceptionPattern);
            result2 = ExceptionUtil.extractMessage(result2, errorPattern);
        }
        return result2;
    }

    @NotNull
    private static String extractMessage(@NotNull String result2, @NotNull String errorPattern) {
        if (result2 == null) {
            ExceptionUtil.$$$reportNull$$$0(16);
        }
        if (errorPattern == null) {
            ExceptionUtil.$$$reportNull$$$0(17);
        }
        if (result2.lastIndexOf(errorPattern) >= 0) {
            result2 = result2.substring(result2.lastIndexOf(errorPattern) + errorPattern.length());
        }
        String string2 = result2;
        if (string2 == null) {
            ExceptionUtil.$$$reportNull$$$0(18);
        }
        return string2;
    }

    public static void rethrowUnchecked(@Nullable Throwable t) {
        ExceptionUtilRt.rethrowUnchecked(t);
    }

    @Contract(value="_->fail")
    public static void rethrow(@Nullable Throwable throwable) {
        ExceptionUtil.rethrowUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    @Contract(value="!null->fail")
    public static void rethrowAllAsUnchecked(@Nullable Throwable t) {
        if (t != null) {
            ExceptionUtil.rethrow(t);
        }
    }

    @Nullable
    public static Exception runAndCatch(@NotNull ThrowableRunnable<? extends Exception> runnable) {
        if (runnable == null) {
            ExceptionUtil.$$$reportNull$$$0(22);
        }
        try {
            runnable.run();
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 21: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ExceptionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeTo";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameSkipPattern";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorPattern";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMessage";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ExceptionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootCause";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "makeStackTraceRelative";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserStackTrace";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMessage";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEmptyMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootCause";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 21: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findCauseAndSuppressed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makeStackTraceRelative";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUserStackTrace";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extractMessage";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyMessage";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runAndCatch";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

