/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.cache.TypeAnnotationContainer;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.AnnotationTextCollector;
import com.intellij.psi.impl.compiled.ClsParsingUtil;
import com.intellij.psi.impl.compiled.ClsTypeAnnotationCollector;
import com.intellij.psi.impl.compiled.FirstPassData;
import com.intellij.psi.impl.compiled.InnerClassSourceStrategy;
import com.intellij.psi.impl.compiled.OutOfOrderInnerClassException;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.impl.java.stubs.JavaClassReferenceListElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.java.stubs.PsiRecordComponentStub;
import com.intellij.psi.impl.java.stubs.PsiRecordHeaderStub;
import com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiFieldStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiMethodStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiModifierListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiRecordComponentStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiRecordHeaderStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterListStubImpl;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Array;
import java.text.StringCharacterIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.RecordComponentVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.TypeReference;

public class StubBuildingVisitor<T>
extends ClassVisitor {
    private static final Logger LOG = Logger.getInstance(StubBuildingVisitor.class);
    private final T mySource;
    private final InnerClassSourceStrategy<T> myInnersStrategy;
    private final StubElement<?> myParent;
    private final int myAccess;
    private final String myShortName;
    @NotNull
    private final FirstPassData myFirstPassData;
    private final boolean myAnonymousInner;
    private final boolean myLocalClassInner;
    private String myInternalName;
    private PsiClassStub<?> myResult;
    private PsiModifierListStub myModList;
    private PsiRecordHeaderStub myHeaderStub;
    private Map<TypeInfo, ClsTypeAnnotationCollector> myAnnoBuilders;
    private ClassInfo myClassInfo;
    private static final String[] parameterNames = new String[]{"p1", "p2", "p3", "p4", "p5", "p6", "p7", "p8", "p9"};
    public static final Function<String, String> GUESSING_MAPPER = internalName2 -> {
        String canonicalText = internalName2;
        if (canonicalText.indexOf(36) >= 0) {
            int start;
            StringBuilder sb = new StringBuilder(canonicalText);
            boolean updated = false;
            for (int p = start = canonicalText.lastIndexOf(47) + 2; p < sb.length(); ++p) {
                char c = sb.charAt(p);
                if (c != '$' || p >= sb.length() - 1 || sb.charAt(p + 1) == '$') continue;
                sb.setCharAt(p, '.');
                updated = true;
            }
            if (updated) {
                canonicalText = sb.toString();
            }
        }
        return canonicalText.replace('/', '.');
    };

    public StubBuildingVisitor(T classSource, InnerClassSourceStrategy<T> innersStrategy, StubElement<?> parent2, int access, String shortName) {
        this(classSource, innersStrategy, parent2, access, shortName, false, false);
    }

    public StubBuildingVisitor(T classSource, InnerClassSourceStrategy<T> innersStrategy, StubElement<?> parent2, int access, String shortName, boolean anonymousInner, boolean localClassInner) {
        super(589824);
        this.mySource = classSource;
        this.myInnersStrategy = innersStrategy;
        this.myParent = parent2;
        this.myAccess = access;
        this.myShortName = shortName;
        this.myFirstPassData = FirstPassData.create(classSource);
        this.myAnonymousInner = anonymousInner;
        this.myLocalClassInner = localClassInner;
    }

    public PsiClassStub<?> getResult() {
        return this.myResult;
    }

    @Override
    public void visit(int version2, int access, String name2, String signature2, String superName, String[] interfaces) {
        block10: {
            String fqn;
            this.myInternalName = name2;
            String parentName = this.myParent instanceof PsiClassStub ? ((PsiClassStub)this.myParent).getQualifiedName() : (this.myParent instanceof PsiJavaFileStub ? ((PsiJavaFileStub)this.myParent).getPackageName() : null);
            String string2 = fqn = this.myAnonymousInner || this.myLocalClassInner ? null : this.getFqn(name2, this.myShortName, parentName);
            String shortName = this.myShortName != null && name2.endsWith(this.myShortName) ? this.myShortName : (fqn != null ? PsiNameHelper.getShortClassName(fqn) : this.myShortName);
            int flags = this.myAccess | access;
            boolean isDeprecated = BitUtil.isSet(flags, 131072);
            boolean isInterface = BitUtil.isSet(flags, 512);
            boolean isEnum = BitUtil.isSet(flags, 16384);
            boolean isAnnotationType = BitUtil.isSet(flags, 8192);
            boolean isRecord = BitUtil.isSet(flags, 65536);
            short stubFlags = PsiClassStubImpl.packFlags(isDeprecated, isInterface, isEnum, false, false, isAnnotationType, false, false, this.myAnonymousInner, this.myLocalClassInner, false, isRecord);
            this.myResult = new PsiClassStubImpl(JavaStubElementTypes.CLASS, this.myParent, fqn, shortName, null, stubFlags);
            this.myModList = new PsiModifierListStubImpl(this.myResult, StubBuildingVisitor.packClassFlags(flags));
            if (isRecord) {
                this.myHeaderStub = new PsiRecordHeaderStubImpl(this.myResult);
            }
            if (signature2 != null) {
                try {
                    this.myClassInfo = this.parseClassSignature(signature2);
                }
                catch (ClsFormatException e) {
                    if (!LOG.isDebugEnabled()) break block10;
                    LOG.debug("source=" + this.mySource + " signature=" + signature2, e);
                }
            }
        }
        if (this.myClassInfo == null) {
            this.myClassInfo = this.parseClassDescription(superName, interfaces);
        }
        new PsiTypeParameterListStubImpl(this.myResult);
        if (this.myResult.isInterface()) {
            if (this.myClassInfo.interfaces != null && this.myResult.isAnnotationType()) {
                this.myClassInfo.interfaces.removeIf(info -> info.text.equals("java.lang.annotation.Annotation"));
            }
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_LIST, this.myResult, this.myClassInfo.interfaces);
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.IMPLEMENTS_LIST, this.myResult, Collections.emptyList());
        } else {
            if (this.myClassInfo.superType == null || this.myResult.isEnum() && "java/lang/Enum".equals(superName) || this.myResult.isRecord() && "java/lang/Record".equals(superName)) {
                StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_LIST, this.myResult, Collections.emptyList());
            } else {
                StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_LIST, this.myResult, Collections.singletonList(this.myClassInfo.superType));
            }
            StubBuildingVisitor.newReferenceList(JavaStubElementTypes.IMPLEMENTS_LIST, this.myResult, this.myClassInfo.interfaces);
        }
    }

    private String getFqn(@NotNull String internalName2, @Nullable String shortName, @Nullable String parentName) {
        if (internalName2 == null) {
            StubBuildingVisitor.$$$reportNull$$$0(0);
        }
        if (shortName == null || !internalName2.endsWith(shortName)) {
            return this.myFirstPassData.mapJvmClassNameToJava(internalName2);
        }
        if (internalName2.length() == shortName.length()) {
            return shortName;
        }
        if (parentName == null) {
            parentName = this.myFirstPassData.mapJvmClassNameToJava(internalName2.substring(0, internalName2.length() - shortName.length() - 1));
        }
        return parentName + '.' + shortName;
    }

    private ClassInfo parseClassSignature(String signature2) throws ClsFormatException {
        ClassInfo result2 = new ClassInfo();
        StringCharacterIterator iterator2 = new StringCharacterIterator(signature2);
        result2.typeParameters = SignatureParsing.parseTypeParametersDeclaration(iterator2, this.myFirstPassData);
        String superName = SignatureParsing.parseTopLevelClassRefSignature(iterator2, this.myFirstPassData);
        result2.superType = superName == null ? null : new TypeInfo(superName);
        while (iterator2.current() != '\uffff') {
            String name2 = SignatureParsing.parseTopLevelClassRefSignature(iterator2, this.myFirstPassData);
            if (name2 == null) {
                throw new ClsFormatException();
            }
            if (result2.interfaces == null) {
                result2.interfaces = new SmartList();
            }
            result2.interfaces.add(new TypeInfo(name2));
        }
        return result2;
    }

    private ClassInfo parseClassDescription(String superClass, String[] superInterfaces) {
        ClassInfo result2 = new ClassInfo();
        result2.typeParameters = SignatureParsing.TypeParametersDeclaration.EMPTY;
        result2.superType = superClass != null ? new TypeInfo(this.myFirstPassData.mapJvmClassNameToJava(superClass, false)) : null;
        result2.interfaces = this.myFirstPassData.createTypes(superInterfaces);
        return result2;
    }

    private static void newReferenceList(@NotNull JavaClassReferenceListElementType type2, StubElement<?> parent2, @Nullable List<TypeInfo> types2) {
        if (type2 == null) {
            StubBuildingVisitor.$$$reportNull$$$0(1);
        }
        new PsiClassReferenceListStubImpl(type2, parent2, types2 == null ? TypeInfo.EMPTY_ARRAY : types2.toArray(TypeInfo.EMPTY_ARRAY));
    }

    private static int packCommonFlags(int access) {
        int flags = 0;
        flags = BitUtil.isSet(access, 2) ? (flags |= 2) : (BitUtil.isSet(access, 4) ? (flags |= 4) : (BitUtil.isSet(access, 1) ? (flags |= 1) : (flags |= 0x1000)));
        if (BitUtil.isSet(access, 8)) {
            flags |= 8;
        }
        if (BitUtil.isSet(access, 16)) {
            flags |= 0x10;
        }
        return flags;
    }

    private static int packClassFlags(int access) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if (BitUtil.isSet(access, 1024)) {
            flags |= 0x400;
        }
        return flags;
    }

    private static int packFieldFlags(int access) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if (BitUtil.isSet(access, 64)) {
            flags |= 0x40;
        }
        if (BitUtil.isSet(access, 128)) {
            flags |= 0x80;
        }
        return flags;
    }

    private static int packMethodFlags(int access, boolean isInterface) {
        int flags = StubBuildingVisitor.packCommonFlags(access);
        if (BitUtil.isSet(access, 32)) {
            flags |= 0x20;
        }
        if (BitUtil.isSet(access, 256)) {
            flags |= 0x100;
        }
        if (BitUtil.isSet(access, 2048)) {
            flags |= 0x800;
        }
        if (BitUtil.isSet(access, 1024)) {
            flags |= 0x400;
        } else if (isInterface && !BitUtil.isSet(access, 8)) {
            flags |= 0x200;
        }
        return flags;
    }

    @Override
    public void visitSource(String source, String debug) {
        ((PsiClassStubImpl)this.myResult).setSourceFileName(source);
    }

    @Override
    public void visitOuterClass(String owner, String name2, String desc) {
        if (this.myParent instanceof PsiFileStub) {
            throw new OutOfOrderInnerClassException();
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new AnnotationTextCollector(desc, this.myFirstPassData, text2 -> new PsiAnnotationStubImpl((StubElement)this.myModList, (String)text2));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        TypeReference ref = new TypeReference(typeRef);
        TypeInfo info = null;
        if (ref.getSort() == 17) {
            info = this.myClassInfo.typeParameters.getBoundType(ref);
        } else if (ref.getSort() == 0) {
            info = this.myClassInfo.typeParameters.getParameterType(ref);
        } else if (ref.getSort() == 16) {
            int index2 = ref.getSuperTypeIndex();
            if (index2 == -1) {
                info = this.myClassInfo.superType;
            } else if (index2 >= 0 && index2 < this.myClassInfo.interfaces.size()) {
                info = (TypeInfo)this.myClassInfo.interfaces.get(index2);
            }
        }
        if (info == null) {
            return null;
        }
        if (this.myAnnoBuilders == null) {
            this.myAnnoBuilders = new HashMap<TypeInfo, ClsTypeAnnotationCollector>();
        }
        return this.myAnnoBuilders.computeIfAbsent(info, typeInfo -> new ClsTypeAnnotationCollector((TypeInfo)typeInfo, this.myFirstPassData)).collect(typePath, desc);
    }

    @Override
    public void visitEnd() {
        if (this.myAnnoBuilders != null) {
            this.myAnnoBuilders.values().forEach(TypeAnnotationContainer.Collector::install);
        }
        this.myClassInfo.typeParameters.fillInTypeParameterList(this.myResult);
    }

    @Override
    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        T innerClass;
        boolean isLocalClassInner;
        if (BitUtil.isSet(access, 4096)) {
            return;
        }
        String jvmClassName = innerName;
        boolean isAnonymousInner = innerName == null;
        boolean bl = isLocalClassInner = !isAnonymousInner && outerName == null;
        if (innerName == null || outerName == null) {
            int $index;
            if (this.myInternalName.equals(name2) || ($index = name2.lastIndexOf(36)) == -1) {
                return;
            }
            if (isAnonymousInner) {
                innerName = jvmClassName = name2.substring($index + 1);
                outerName = name2.substring(0, $index);
            } else {
                outerName = name2.substring(0, $index);
                jvmClassName = name2.substring($index + 1);
            }
        }
        if (this.myParent instanceof PsiFileStub && this.myInternalName.equals(name2)) {
            throw new OutOfOrderInnerClassException();
        }
        if (this.myInternalName.equals(outerName) && (innerClass = this.myInnersStrategy.findInnerClass(jvmClassName, this.mySource)) != null) {
            StubBuildingVisitor<T> visitor2 = new StubBuildingVisitor<T>(innerClass, this.myInnersStrategy, this.myResult, access, innerName, isAnonymousInner, isLocalClassInner);
            this.myInnersStrategy.accept(innerClass, visitor2);
        }
    }

    @Override
    public RecordComponentVisitor visitRecordComponent(String name2, String descriptor2, String signature2) {
        if (this.myHeaderStub == null) {
            return null;
        }
        boolean isEllipsis = this.myFirstPassData.isVarArgComponent(name2);
        byte flags = PsiRecordComponentStubImpl.packFlags(isEllipsis, false);
        TypeInfo type2 = this.fieldType(descriptor2, signature2);
        if (isEllipsis) {
            type2 = new TypeInfo(type2.text, type2.arrayCount, true);
        }
        PsiRecordComponentStubImpl stub = new PsiRecordComponentStubImpl(this.myHeaderStub, name2, type2, flags);
        PsiModifierListStubImpl modList = new PsiModifierListStubImpl((StubElement)stub, 0);
        return new RecordComponentAnnotationCollectingVisitor(stub, modList, this.myFirstPassData);
    }

    @Override
    public FieldVisitor visitField(int access, String name2, String desc, String signature2, Object value2) {
        if (BitUtil.isSet(access, 4096)) {
            return null;
        }
        if (name2 == null) {
            return null;
        }
        if (this.myResult.isRecord() && access == 18) {
            return null;
        }
        byte flags = PsiFieldStubImpl.packFlags(BitUtil.isSet(access, 16384), BitUtil.isSet(access, 131072), false, false);
        TypeInfo type2 = this.fieldType(desc, signature2);
        String initializer2 = StubBuildingVisitor.constToString(value2, type2.text, false, this.myFirstPassData);
        PsiFieldStubImpl stub = new PsiFieldStubImpl(this.myResult, name2, type2, initializer2, flags);
        PsiModifierListStubImpl modList = new PsiModifierListStubImpl((StubElement)stub, StubBuildingVisitor.packFieldFlags(access));
        return new FieldAnnotationCollectingVisitor(stub, modList, this.myFirstPassData);
    }

    private TypeInfo fieldType(String desc, String signature2) {
        String type2;
        block4: {
            type2 = null;
            if (signature2 != null) {
                try {
                    type2 = SignatureParsing.parseTypeString(new StringCharacterIterator(signature2), this.myFirstPassData);
                }
                catch (ClsFormatException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug("source=" + this.mySource + " signature=" + signature2, e);
                }
            }
        }
        if (type2 == null) {
            type2 = StubBuildingVisitor.toJavaType(Type.getType(desc), this.myFirstPassData);
        }
        return TypeInfo.fromString(type2, false);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name2, String desc, String signature2, String[] exceptions) {
        int paramIgnoreCount;
        boolean hasSignature;
        MethodInfo info;
        String canonicalMethodName;
        byte flags;
        boolean isStatic;
        boolean isVarargs;
        boolean isEnum;
        boolean isConstructor;
        block15: {
            if (BitUtil.isSet(access, 4096) || name2 == null || "<clinit>".equals(name2)) {
                return null;
            }
            isConstructor = "<init>".equals(name2);
            if (isConstructor && this.myAnonymousInner) {
                return null;
            }
            isEnum = this.myResult.isEnum();
            if (isEnum) {
                if ("values".equals(name2) && desc.startsWith("()")) {
                    return null;
                }
                if ("valueOf".equals(name2) && desc.startsWith("(Ljava/lang/String;)")) {
                    return null;
                }
            }
            if (this.myFirstPassData.isSyntheticRecordMethod(name2, desc)) {
                return null;
            }
            boolean isDeprecated = BitUtil.isSet(access, 131072);
            isVarargs = BitUtil.isSet(access, 128);
            isStatic = BitUtil.isSet(access, 8);
            boolean isAnnotationMethod = this.myResult.isAnnotationType();
            flags = PsiMethodStubImpl.packFlags(isConstructor, isAnnotationMethod, isVarargs, isDeprecated, false, false);
            canonicalMethodName = isConstructor ? this.myResult.getName() : name2;
            info = null;
            hasSignature = false;
            if (signature2 != null) {
                try {
                    info = this.parseMethodSignature(signature2, exceptions);
                    hasSignature = true;
                }
                catch (ClsFormatException e) {
                    if (!LOG.isDebugEnabled()) break block15;
                    LOG.debug("source=" + this.mySource + " signature=" + signature2, e);
                }
            }
        }
        if (info == null) {
            info = this.parseMethodDescription(desc, exceptions);
        }
        PsiMethodStubImpl stub = new PsiMethodStubImpl(this.myResult, canonicalMethodName, TypeInfo.fromString(info.returnType, false), flags, null);
        PsiModifierListStubImpl modList = new PsiModifierListStubImpl((StubElement)stub, StubBuildingVisitor.packMethodFlags(access, this.myResult.isInterface()));
        new PsiTypeParameterListStubImpl(stub);
        boolean isEnumConstructor = isConstructor && isEnum;
        boolean isInnerClassConstructor = isConstructor && !isEnum && this.isInner() && !this.isGroovyClosure(canonicalMethodName);
        List args = info.argTypes;
        if (!hasSignature) {
            if (isEnumConstructor && args.size() >= 2 && "java.lang.String".equals(args.get(0)) && "int".equals(args.get(1))) {
                args = args.subList(2, args.size());
            } else if (isInnerClassConstructor && args.size() >= 1) {
                args = args.subList(1, args.size());
            }
        }
        PsiParameterListStubImpl parameterList2 = new PsiParameterListStubImpl(stub);
        int paramCount = args.size();
        PsiParameterStubImpl[] paramStubs = new PsiParameterStubImpl[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            PsiParameterStubImpl parameterStub;
            String arg = (String)args.get(i);
            boolean isEllipsisParam = isVarargs && i == paramCount - 1;
            TypeInfo typeInfo = TypeInfo.fromString(arg, isEllipsisParam);
            String paramName = i < parameterNames.length ? parameterNames[i] : "p" + (i + 1);
            paramStubs[i] = parameterStub = new PsiParameterStubImpl(parameterList2, paramName, typeInfo, isEllipsisParam, true);
            new PsiModifierListStubImpl((StubElement)parameterStub, 0);
        }
        StubBuildingVisitor.newReferenceList(JavaStubElementTypes.THROWS_LIST, stub, info.throwTypes);
        int n = isEnumConstructor ? 2 : (paramIgnoreCount = isInnerClassConstructor ? 1 : 0);
        int localVarIgnoreCount = isEnumConstructor ? 3 : (isInnerClassConstructor ? 2 : (!isStatic ? 1 : 0));
        return new MethodAnnotationCollectingVisitor(stub, info, modList, paramStubs, paramIgnoreCount, localVarIgnoreCount, this.myFirstPassData);
    }

    private boolean isInner() {
        return this.myParent instanceof PsiClassStub && !BitUtil.isSet(this.myModList.getModifiersMask(), 8);
    }

    private boolean isGroovyClosure(String canonicalMethodName) {
        PsiClassReferenceListStub extendsList;
        if (canonicalMethodName != null && canonicalMethodName.startsWith("_closure") && (extendsList = this.myResult.findChildStubByType(JavaStubElementTypes.EXTENDS_LIST)) != null) {
            String[] names2 = extendsList.getReferencedNames();
            return names2.length == 1 && "groovy.lang.Closure".equals(names2[0]);
        }
        return false;
    }

    private MethodInfo parseMethodSignature(String signature2, String[] exceptions) throws ClsFormatException {
        MethodInfo result2 = new MethodInfo();
        StringCharacterIterator iterator2 = new StringCharacterIterator(signature2);
        result2.typeParameters = SignatureParsing.parseTypeParametersDeclaration(iterator2, this.myFirstPassData);
        if (iterator2.current() != '(') {
            throw new ClsFormatException();
        }
        iterator2.next();
        if (iterator2.current() == ')') {
            result2.argTypes = ContainerUtil.emptyList();
        } else {
            result2.argTypes = new SmartList();
            while (iterator2.current() != ')' && iterator2.current() != '\uffff') {
                result2.argTypes.add(SignatureParsing.parseTypeString(iterator2, this.myFirstPassData));
            }
            if (iterator2.current() != ')') {
                throw new ClsFormatException();
            }
        }
        iterator2.next();
        result2.returnType = SignatureParsing.parseTypeString(iterator2, this.myFirstPassData);
        result2.throwTypes = null;
        while (iterator2.current() == '^') {
            iterator2.next();
            if (result2.throwTypes == null) {
                result2.throwTypes = new SmartList();
            }
            result2.throwTypes.add(new TypeInfo(SignatureParsing.parseTypeString(iterator2, this.myFirstPassData)));
        }
        if (exceptions != null && (result2.throwTypes == null || exceptions.length > result2.throwTypes.size())) {
            result2.throwTypes = this.myFirstPassData.createTypes(exceptions);
        }
        return result2;
    }

    private MethodInfo parseMethodDescription(String desc, String[] exceptions) {
        MethodInfo result2 = new MethodInfo();
        result2.typeParameters = SignatureParsing.TypeParametersDeclaration.EMPTY;
        result2.returnType = StubBuildingVisitor.toJavaType(Type.getReturnType(desc), this.myFirstPassData);
        result2.argTypes = ContainerUtil.map(Type.getArgumentTypes(desc), type2 -> StubBuildingVisitor.toJavaType(type2, this.myFirstPassData));
        result2.throwTypes = this.myFirstPassData.createTypes(exceptions);
        return result2;
    }

    @Nullable
    static String constToString(@Nullable Object value2, @Nullable String type2, boolean anno, Function<? super String, String> mapping2) {
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof String) {
            return "\"" + StringUtil.escapeStringCharacters((String)value2) + "\"";
        }
        if (value2 instanceof Boolean || value2 instanceof Short || value2 instanceof Byte) {
            return value2.toString();
        }
        if (value2 instanceof Character) {
            return "'" + StringUtil.escapeCharCharacters(value2.toString()) + "'";
        }
        if (value2 instanceof Long) {
            return value2.toString() + 'L';
        }
        if (value2 instanceof Integer) {
            if ("boolean".equals(type2)) {
                if (value2.equals(0)) {
                    return "false";
                }
                if (value2.equals(1)) {
                    return "true";
                }
            }
            if ("char".equals(type2)) {
                char ch = (char)((Integer)value2).intValue();
                return "'" + StringUtil.escapeCharCharacters(String.valueOf(ch)) + "'";
            }
            return value2.toString();
        }
        if (value2 instanceof Double) {
            double d = (Double)value2;
            if (Double.isInfinite(d)) {
                return d > 0.0 ? "1.0 / 0.0" : "-1.0 / 0.0";
            }
            if (Double.isNaN(d)) {
                return "0.0d / 0.0";
            }
            return Double.toString(d);
        }
        if (value2 instanceof Float) {
            float v = ((Float)value2).floatValue();
            if (Float.isInfinite(v)) {
                return v > 0.0f ? "1.0f / 0.0" : "-1.0f / 0.0";
            }
            if (Float.isNaN(v)) {
                return "0.0f / 0.0";
            }
            return Float.toString(v) + 'f';
        }
        if (value2.getClass().isArray()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append('{');
            int length = Array.getLength(value2);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(StubBuildingVisitor.constToString(Array.get(value2, i), type2, anno, mapping2));
            }
            buffer.append('}');
            return buffer.toString();
        }
        if (anno && value2 instanceof Type) {
            return StubBuildingVisitor.toJavaType((Type)value2, mapping2) + ".class";
        }
        return null;
    }

    static String toJavaType(Type type2, @NotNull Function<? super String, String> mapping2) {
        String text2;
        if (mapping2 == null) {
            StubBuildingVisitor.$$$reportNull$$$0(2);
        }
        int dimensions = 0;
        if (type2.getSort() == 9) {
            dimensions = type2.getDimensions();
            type2 = type2.getElementType();
        }
        String string2 = text2 = type2.getSort() == 10 ? mapping2.fun(type2.getInternalName()) : type2.getClassName();
        if (dimensions > 0) {
            text2 = text2 + StringUtil.repeat("[]", dimensions);
        }
        return text2;
    }

    public static AnnotationVisitor getAnnotationTextCollector(String desc, Consumer<? super String> consumer) {
        return new AnnotationTextCollector(desc, GUESSING_MAPPER, consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/compiled/StubBuildingVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFqn";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "newReferenceList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "toJavaType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MethodAnnotationCollectingVisitor
    extends MethodVisitor {
        private final PsiMethodStub myOwner;
        @NotNull
        private final MethodInfo myMethodInfo;
        @NotNull
        private final PsiModifierListStub myModList;
        private final PsiParameterStubImpl[] myParamStubs;
        private final int myParamCount;
        private final int myLocalVarIgnoreCount;
        @NotNull
        private final FirstPassData myFirstPassData;
        private int myParamIgnoreCount;
        private int myParamNameIndex;
        private int myUsedParamSize;
        private int myUsedParamCount;
        private Map<TypeInfo, ClsTypeAnnotationCollector> myAnnoBuilders;

        private MethodAnnotationCollectingVisitor(PsiMethodStub owner, @NotNull MethodInfo methodInfo, @NotNull PsiModifierListStub modList, PsiParameterStubImpl[] paramStubs, int paramIgnoreCount, int localVarIgnoreCount, @NotNull FirstPassData firstPassData) {
            if (methodInfo == null) {
                MethodAnnotationCollectingVisitor.$$$reportNull$$$0(0);
            }
            if (modList == null) {
                MethodAnnotationCollectingVisitor.$$$reportNull$$$0(1);
            }
            if (firstPassData == null) {
                MethodAnnotationCollectingVisitor.$$$reportNull$$$0(2);
            }
            super(589824);
            this.myOwner = owner;
            this.myMethodInfo = methodInfo;
            this.myModList = modList;
            this.myParamStubs = paramStubs;
            this.myParamCount = paramStubs.length;
            this.myLocalVarIgnoreCount = localVarIgnoreCount;
            this.myParamIgnoreCount = paramIgnoreCount;
            this.myFirstPassData = firstPassData;
        }

        @Override
        public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
            if (this.myParamIgnoreCount > 0 && parameterCount == this.myParamCount) {
                this.myParamIgnoreCount = 0;
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationTextCollector(desc, this.myFirstPassData, text2 -> new PsiAnnotationStubImpl((StubElement)this.myModList, (String)text2));
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter2, String desc, boolean visible) {
            return parameter2 < this.myParamIgnoreCount ? null : new AnnotationTextCollector(desc, this.myFirstPassData, text2 -> {
                int idx = parameter2 - this.myParamIgnoreCount;
                new PsiAnnotationStubImpl((StubElement)this.myOwner.findParameter(idx).getModList(), (String)text2);
            });
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            int index2;
            TypeReference ref = new TypeReference(typeRef);
            TypeInfo info = null;
            if (ref.getSort() == 20) {
                info = this.myOwner.getReturnTypeText();
            } else if (ref.getSort() == 22) {
                int parameterIndex = ref.getFormalParameterIndex();
                if (parameterIndex < this.myParamStubs.length) {
                    info = this.myParamStubs[parameterIndex].getType();
                }
            } else if (ref.getSort() == 1) {
                info = this.myMethodInfo.typeParameters.getParameterType(ref);
            } else if (ref.getSort() == 18) {
                info = this.myMethodInfo.typeParameters.getBoundType(ref);
            } else if (ref.getSort() == 23 && (index2 = ref.getExceptionIndex()) < this.myMethodInfo.throwTypes.size()) {
                info = (TypeInfo)this.myMethodInfo.throwTypes.get(index2);
            }
            if (info == null) {
                return null;
            }
            if (this.myAnnoBuilders == null) {
                this.myAnnoBuilders = new HashMap<TypeInfo, ClsTypeAnnotationCollector>();
            }
            return this.myAnnoBuilders.computeIfAbsent(info, typeInfo -> new ClsTypeAnnotationCollector((TypeInfo)typeInfo, this.myFirstPassData)).collect(typePath, desc);
        }

        @Override
        public void visitEnd() {
            if (this.myAnnoBuilders != null) {
                this.myAnnoBuilders.values().forEach(TypeAnnotationContainer.Collector::install);
            }
            this.myMethodInfo.typeParameters.fillInTypeParameterList(this.myOwner);
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return new AnnotationTextCollector(null, this.myFirstPassData, text2 -> ((PsiMethodStubImpl)this.myOwner).setDefaultValueText((String)text2));
        }

        @Override
        public void visitParameter(String name2, int access) {
            int paramIndex = this.myParamNameIndex++ - this.myParamIgnoreCount;
            if (name2 != null && !BitUtil.isSet(access, 4096) && paramIndex >= 0 && paramIndex < this.myParamCount) {
                this.setParameterName(name2, paramIndex);
            }
        }

        @Override
        public void visitLocalVariable(String name2, String desc, String signature2, Label start, Label end, int index2) {
            if (index2 >= this.myLocalVarIgnoreCount) {
                int paramIndex;
                int n = paramIndex = index2 - this.myLocalVarIgnoreCount == this.myUsedParamSize ? this.myUsedParamCount : index2 - this.myLocalVarIgnoreCount;
                if (paramIndex < this.myParamCount) {
                    this.setParameterName(name2, paramIndex);
                    this.myUsedParamCount = paramIndex + 1;
                    this.myUsedParamSize += "D".equals(desc) || "J".equals(desc) ? 2 : 1;
                }
            }
        }

        private void setParameterName(@NotNull String name2, int paramIndex) {
            if (name2 == null) {
                MethodAnnotationCollectingVisitor.$$$reportNull$$$0(3);
            }
            if (ClsParsingUtil.isJavaIdentifier(name2, LanguageLevel.HIGHEST)) {
                this.myParamStubs[paramIndex].setName(name2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstPassData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/compiled/StubBuildingVisitor$MethodAnnotationCollectingVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setParameterName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class RecordComponentAnnotationCollectingVisitor
    extends RecordComponentVisitor {
        @NotNull
        private final PsiModifierListStub myModList;
        @NotNull
        private final FirstPassData myFirstPassData;
        @NotNull
        private final ClsTypeAnnotationCollector myAnnoBuilder;

        private RecordComponentAnnotationCollectingVisitor(@NotNull PsiRecordComponentStub stub, @NotNull PsiModifierListStub modList, @NotNull FirstPassData firstPassData) {
            if (stub == null) {
                RecordComponentAnnotationCollectingVisitor.$$$reportNull$$$0(0);
            }
            if (modList == null) {
                RecordComponentAnnotationCollectingVisitor.$$$reportNull$$$0(1);
            }
            if (firstPassData == null) {
                RecordComponentAnnotationCollectingVisitor.$$$reportNull$$$0(2);
            }
            super(589824);
            this.myModList = modList;
            this.myFirstPassData = firstPassData;
            this.myAnnoBuilder = new ClsTypeAnnotationCollector(stub.getType(), firstPassData);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationTextCollector(desc, this.myFirstPassData, text2 -> new PsiAnnotationStubImpl((StubElement)this.myModList, (String)text2));
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return this.myAnnoBuilder.collect(typePath, desc);
        }

        @Override
        public void visitEnd() {
            this.myAnnoBuilder.install();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stub";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstPassData";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/compiled/StubBuildingVisitor$RecordComponentAnnotationCollectingVisitor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class FieldAnnotationCollectingVisitor
    extends FieldVisitor {
        @NotNull
        private final PsiModifierListStub myModList;
        @NotNull
        private final FirstPassData myFirstPassData;
        @NotNull
        private final ClsTypeAnnotationCollector myAnnoBuilder;

        private FieldAnnotationCollectingVisitor(@NotNull PsiFieldStub stub, @NotNull PsiModifierListStub modList, @NotNull FirstPassData firstPassData) {
            if (stub == null) {
                FieldAnnotationCollectingVisitor.$$$reportNull$$$0(0);
            }
            if (modList == null) {
                FieldAnnotationCollectingVisitor.$$$reportNull$$$0(1);
            }
            if (firstPassData == null) {
                FieldAnnotationCollectingVisitor.$$$reportNull$$$0(2);
            }
            super(589824);
            this.myModList = modList;
            this.myFirstPassData = firstPassData;
            this.myAnnoBuilder = new ClsTypeAnnotationCollector(stub.getType(), firstPassData);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationTextCollector(desc, this.myFirstPassData, text2 -> new PsiAnnotationStubImpl((StubElement)this.myModList, (String)text2));
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return this.myAnnoBuilder.collect(typePath, desc);
        }

        @Override
        public void visitEnd() {
            this.myAnnoBuilder.install();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stub";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modList";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstPassData";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/compiled/StubBuildingVisitor$FieldAnnotationCollectingVisitor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MethodInfo {
        private SignatureParsing.TypeParametersDeclaration typeParameters;
        private String returnType;
        private List<String> argTypes;
        private List<TypeInfo> throwTypes;

        private MethodInfo() {
        }
    }

    private static class ClassInfo {
        private SignatureParsing.TypeParametersDeclaration typeParameters;
        private TypeInfo superType;
        private List<TypeInfo> interfaces;

        private ClassInfo() {
        }
    }
}

