/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base;

import com.sun.tools.javac.util.Context;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.base.kapt3.KaptFlag;
import org.jetbrains.kotlin.base.kapt3.KaptFlags;
import org.jetbrains.kotlin.base.kapt3.KaptOptions;
import org.jetbrains.kotlin.base.kapt3.KaptOptionsKt;
import org.jetbrains.kotlin.kapt3.base.AnnotationProcessingKt;
import org.jetbrains.kotlin.kapt3.base.KaptContext;
import org.jetbrains.kotlin.kapt3.base.LoadedProcessors;
import org.jetbrains.kotlin.kapt3.base.ProcessorLoader;
import org.jetbrains.kotlin.kapt3.base.util.KaptLogger;
import org.jetbrains.kotlin.kapt3.base.util.WriterBackedKaptLogger;
import org.jetbrains.kotlin.kapt3.util.ModuleManipulationUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/Kapt;", "", "()V", "JAVAC_CONTEXT_CLASS", "", "checkJavacComponentsAccess", "", "logger", "Lorg/jetbrains/kotlin/kapt3/base/util/KaptLogger;", "findClassLoaderWithJavac", "Ljava/lang/ClassLoader;", "kapt", "options", "Lorg/jetbrains/kotlin/base/kapt3/KaptOptions;", "kaptFlags", "Lorg/jetbrains/kotlin/base/kapt3/KaptFlags;", "rawFlags", "", "kotlin-annotation-processing-base"})
@SourceDebugExtension(value={"SMAP\nKapt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Kapt.kt\norg/jetbrains/kotlin/kapt3/base/Kapt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 KaptLogger.kt\norg/jetbrains/kotlin/kapt3/base/util/KaptLoggerKt\n+ 4 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,74:1\n4307#2,2:75\n25#3,4:77\n25#3,4:87\n17#4,6:81\n*S KotlinDebug\n*F\n+ 1 Kapt.kt\norg/jetbrains/kotlin/kapt3/base/Kapt\n*L\n22#1:75,2\n37#1:77,4\n54#1:87,4\n46#1:81,6\n*E\n"})
public final class Kapt {
    @NotNull
    public static final Kapt INSTANCE = new Kapt();
    @NotNull
    private static final String JAVAC_CONTEXT_CLASS = "com.sun.tools.javac.util.Context";

    private Kapt() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final KaptFlags kaptFlags(@NotNull Set<String> rawFlags) {
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(rawFlags, (String)"rawFlags");
        KaptFlag[] kaptFlagArray = KaptFlag.values();
        Collection collection = new LinkedHashSet();
        KaptFlags.Companion companion = KaptFlags.Companion;
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv).length;
        for (int i = 0; i < n; ++i) {
            void destination$iv;
            void element$iv;
            void it = element$iv = $this$filterTo$iv[i];
            boolean bl = false;
            if (!rawFlags.contains(it.name())) continue;
            destination$iv.add(element$iv);
        }
        return companion.fromSet((Set)collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final boolean kapt(@NotNull KaptOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        ModuleManipulationUtilsKt.doOpenInternalPackagesIfRequired();
        WriterBackedKaptLogger logger = new WriterBackedKaptLogger(options.get(KaptFlag.VERBOSE), null, null, null, 14, null);
        if (!INSTANCE.checkJavacComponentsAccess(logger)) {
            return false;
        }
        KaptContext kaptContext = new KaptContext(options, false, logger);
        KaptLogger $this$info$iv = logger;
        boolean $i$f$info = false;
        if ($this$info$iv.isVerbose()) {
            KaptLogger kaptLogger = $this$info$iv;
            boolean bl = false;
            kaptLogger.info(KaptOptionsKt.logString(options, "stand-alone mode"));
        }
        List<File> javaSourceFiles = KaptOptionsKt.collectJavaSourceFiles(options, kaptContext.getSourcesToReprocess());
        ProcessorLoader processorLoader = new ProcessorLoader(options, logger);
        Closeable closeable = processorLoader;
        Throwable throwable = null;
        try {
            ProcessorLoader it = (ProcessorLoader)closeable;
            boolean bl = false;
            LoadedProcessors processors = processorLoader.loadProcessors(INSTANCE.findClassLoaderWithJavac());
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl2 = false;
            AnnotationProcessingKt.doAnnotationProcessing$default(kaptContext, javaSourceFiles, processors.getProcessors(), null, KaptOptionsKt.collectAggregatedTypes(kaptContext.getSourcesToReprocess()), 4, null);
            long annotationProcessingTime = System.currentTimeMillis() - start$iv;
            KaptLogger $this$info$iv2 = logger;
            boolean $i$f$info2 = false;
            if ($this$info$iv2.isVerbose()) {
                KaptLogger kaptLogger = $this$info$iv2;
                boolean bl3 = false;
                kaptLogger.info("Annotation processing took " + annotationProcessingTime + " ms");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return true;
    }

    public final boolean checkJavacComponentsAccess(@NotNull KaptLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        try {
            Class.forName(JAVAC_CONTEXT_CLASS);
            return true;
        }
        catch (ClassNotFoundException e) {
            logger.error("'com.sun.tools.javac.util.Context' class can't be found ('tools.jar' is absent in the plugin classpath). Kapt won't work.");
            return false;
        }
    }

    private final ClassLoader findClassLoaderWithJavac() {
        ClassLoader classLoader = Context.class.getClassLoader();
        if (classLoader == null) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            classLoader = classLoader2;
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getSystemClassLoader(...)");
        }
        return classLoader;
    }
}

