/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.api.targets;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.targets.LLFirResolveTargetWithDedicatedElement;
import org.jetbrains.kotlin.fir.FirElementWithResolveState;
import org.jetbrains.kotlin.fir.FirFileAnnotationsContainer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirScript;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/targets/LLFirSingleResolveTarget;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/targets/LLFirResolveTargetWithDedicatedElement;", "Lorg/jetbrains/kotlin/fir/FirElementWithResolveState;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "classPath", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "target", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/util/List;Lorg/jetbrains/kotlin/fir/FirElementWithResolveState;)V", "forEachTarget", "", "action", "Lkotlin/Function1;", "toStringForTarget", "", "low-level-api-fir"})
public final class LLFirSingleResolveTarget
extends LLFirResolveTargetWithDedicatedElement<FirElementWithResolveState> {
    public LLFirSingleResolveTarget(@NotNull FirFile firFile, @NotNull List<? extends FirRegularClass> classPath, @NotNull FirElementWithResolveState target) {
        Intrinsics.checkNotNullParameter((Object)firFile, (String)"firFile");
        Intrinsics.checkNotNullParameter(classPath, (String)"classPath");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        super(firFile, classPath, target, null);
    }

    @Override
    public void forEachTarget(@NotNull Function1<? super FirElementWithResolveState, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        action.invoke(this.getTarget());
    }

    @Override
    @NotNull
    protected String toStringForTarget() {
        String string;
        Object t = this.getTarget();
        if (t instanceof FirConstructor) {
            string = "constructor";
        } else if (t instanceof FirClassLikeDeclaration) {
            String string2 = ((FirClassLikeDeclaration)this.getTarget()).getSymbol().getName().asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        } else if (t instanceof FirCallableDeclaration) {
            String string3 = ((FirCallableDeclaration)this.getTarget()).getSymbol().getName().asString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        } else if (t instanceof FirAnonymousInitializer) {
            string = "<init-block>";
        } else if (t instanceof FirFileAnnotationsContainer) {
            string = "<file annotations>";
        } else if (t instanceof FirScript) {
            String string4 = ((FirScript)this.getTarget()).getName().asString();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
        } else {
            string = "???";
        }
        return string;
    }
}

