/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.anno;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import org.jruby.anno.JRubyMethod;

public abstract class MethodDescriptor<T> {
    public static final String IRUBYOBJECT_ARRAY_CLASS_NAME = "[Lorg.jruby.runtime.builtin.IRubyObject;";
    public final boolean isStatic;
    public final boolean hasContext;
    public final boolean hasBlock;
    public final boolean hasVarArgs;
    public final int actualRequired;
    public final int arity;
    public final int required;
    public final int optional;
    public final boolean rest;
    public final JRubyMethod anno;
    public final int modifiers;
    public final String declaringClassName;
    public final String declaringClassPath;
    public final String name;
    public final String rubyName;
    public static final int MAX_REQUIRED_UNBOXED_ARITY = 3;

    protected abstract <A extends Annotation> A getAnnotation(T var1, Class<A> var2);

    protected abstract int getModifiers(T var1);

    protected abstract String getDeclaringClassName(T var1);

    protected abstract String getSimpleName(T var1);

    protected abstract boolean hasContext(T var1);

    protected abstract boolean hasBlock(T var1);

    protected abstract int parameterCount(T var1);

    protected abstract String parameterAsString(T var1, int var2);

    public MethodDescriptor(T methodObject) {
        this.anno = this.getAnnotation(methodObject, JRubyMethod.class);
        this.modifiers = this.getModifiers(methodObject);
        this.declaringClassName = this.getDeclaringClassName(methodObject);
        this.declaringClassPath = this.declaringClassName.replace('.', '/');
        this.name = this.getSimpleName(methodObject);
        String[] names2 = this.anno.name();
        this.rubyName = names2 != null && names2.length > 0 ? names2[0] : this.name;
        this.isStatic = Modifier.isStatic(this.modifiers);
        this.hasContext = this.hasContext(methodObject);
        this.hasBlock = this.hasBlock(methodObject);
        int parameterCount = this.parameterCount(methodObject);
        if (this.hasContext) {
            if (this.isStatic && (parameterCount < 2 || !this.parameterAsString(methodObject, 1).equals("org.jruby.runtime.builtin.IRubyObject"))) {
                throw new RuntimeException("static method without self argument: " + String.valueOf(methodObject));
            }
            this.hasVarArgs = this.hasBlock ? this.parameterAsString(methodObject, parameterCount - 2).equals(IRUBYOBJECT_ARRAY_CLASS_NAME) : this.parameterAsString(methodObject, parameterCount - 1).equals(IRUBYOBJECT_ARRAY_CLASS_NAME);
        } else {
            if (this.isStatic && (parameterCount < 1 || !this.parameterAsString(methodObject, 0).equals("org.jruby.runtime.builtin.IRubyObject"))) {
                throw new RuntimeException("static method without self argument: " + String.valueOf(methodObject));
            }
            this.hasVarArgs = this.hasBlock ? parameterCount > 1 && this.parameterAsString(methodObject, parameterCount - 2).equals(IRUBYOBJECT_ARRAY_CLASS_NAME) : parameterCount > 0 && this.parameterAsString(methodObject, parameterCount - 1).equals(IRUBYOBJECT_ARRAY_CLASS_NAME);
        }
        this.optional = this.anno.optional();
        this.rest = this.anno.rest();
        this.required = this.anno.required();
        if (this.optional == 0 && !this.rest) {
            args = parameterCount;
            if (args == 0) {
                this.actualRequired = 0;
            } else {
                if (this.isStatic) {
                    --args;
                }
                if (this.hasContext) {
                    --args;
                }
                if (this.hasBlock) {
                    --args;
                }
                this.actualRequired = args;
            }
        } else {
            args = parameterCount;
            if (args == 0) {
                this.actualRequired = 0;
            } else {
                if (this.isStatic) {
                    --args;
                }
                if (this.hasContext) {
                    --args;
                }
                if (this.hasBlock) {
                    --args;
                }
                this.actualRequired = --args;
            }
            if (this.actualRequired != 0) {
                throw new RuntimeException("Combining specific args with IRubyObject[] is not yet supported: " + String.valueOf(methodObject));
            }
        }
        int arityRequired = Math.max(this.required, this.actualRequired);
        this.arity = this.optional > 0 || this.rest ? -(arityRequired + 1) : arityRequired;
    }

    public int calculateSpecificCallArity() {
        if (this.optional == 0 && !this.rest) {
            if (this.required == 0) {
                if (this.actualRequired <= 3) {
                    return this.actualRequired;
                }
            } else if (this.required >= 0 && this.required <= 3) {
                return this.required;
            }
        }
        return -1;
    }
}

