/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache.jcache;

import io.micronaut.cache.SyncCache;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.cache.Cache;

@Internal
public class JCacheSyncCache
implements SyncCache<Cache> {
    private final Cache nativeCache;
    private final ConversionService<?> conversionService;
    private final ExecutorService ioExecutor;

    protected JCacheSyncCache(@NonNull Cache<?, ?> nativeCache, ConversionService<?> conversionService, ExecutorService ioExecutor) {
        ArgumentUtils.requireNonNull((String)"nativeCache", nativeCache);
        this.nativeCache = nativeCache;
        this.conversionService = conversionService;
        this.ioExecutor = ioExecutor;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.ioExecutor;
    }

    @Override
    public <T> Optional<T> get(Object key, Argument<T> requiredType) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        Object v = this.nativeCache.get(key);
        if (v != null) {
            return this.conversionService.convert(v, requiredType);
        }
        return Optional.empty();
    }

    @Override
    public <T> T get(@NonNull Object key, @NonNull Argument<T> requiredType, @NonNull Supplier<T> supplier) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        Optional<T> t = this.get(key, requiredType);
        if (t.isPresent()) {
            return t.get();
        }
        T v = supplier.get();
        this.put(key, v);
        return v;
    }

    @Override
    @NonNull
    public <T> Optional<T> putIfAbsent(@NonNull Object key, @NonNull T value) {
        Object v = this.nativeCache.get(key);
        this.nativeCache.putIfAbsent(key, value);
        Class<?> aClass = value.getClass();
        return this.conversionService.convert(v, aClass);
    }

    @Override
    public void put(Object key, Object value) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        if (value != null) {
            this.nativeCache.put(key, value);
        }
    }

    @Override
    public void invalidate(Object key) {
        ArgumentUtils.requireNonNull((String)"key", (Object)key);
        this.nativeCache.remove(key);
    }

    @Override
    public void invalidateAll() {
        this.nativeCache.clear();
    }

    @Override
    public String getName() {
        return this.nativeCache.getName();
    }

    @Override
    public Cache<?, ?> getNativeCache() {
        return this.nativeCache;
    }
}

