/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.cache;

import io.micronaut.cache.Cache;
import io.micronaut.cache.CacheErrorHandler;
import io.micronaut.cache.interceptor.CacheInterceptor;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="async")
public class AsyncCacheErrorHandler
implements CacheErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CacheInterceptor.class);

    @Override
    public boolean handleInvalidateError(Cache<?> cache, Object key, RuntimeException e) {
        if (LOG.isErrorEnabled()) {
            LOG.error("Error invalidating cache [" + cache.getName() + "] for key: " + key, (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean handleInvalidateError(Cache<?> cache, RuntimeException e) {
        if (LOG.isErrorEnabled()) {
            LOG.error("Error invalidating cache: " + cache.getName(), (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean handlePutError(Cache<?> cache, Object key, Object result, RuntimeException e) {
        if (LOG.isErrorEnabled()) {
            LOG.error("Error caching value [" + result + "] for key [" + key + "] in cache: " + cache.getName(), (Throwable)e);
        }
        return false;
    }
}

