/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.visitor.JavaElementFactory;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.aop.Around;
import io.micronaut.aop.InterceptorKind;
import io.micronaut.aop.internal.intercepted.InterceptedMethodUtil;
import io.micronaut.aop.writer.AopProxyWriter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.beans.BeanParameterElement;
import io.micronaut.inject.configuration.ConfigurationMetadataBuilder;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.AbstractBeanDefinitionBuilder;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import java.lang.annotation.Annotation;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

class JavaBeanDefinitionBuilder
extends AbstractBeanDefinitionBuilder {
    private final JavaVisitorContext javaVisitorContext;

    JavaBeanDefinitionBuilder(Element originatingElement, ClassElement beanType, ConfigurationMetadataBuilder<?> metadataBuilder, JavaVisitorContext visitorContext) {
        super(originatingElement, beanType, metadataBuilder, (VisitorContext)visitorContext);
        this.javaVisitorContext = visitorContext;
        if (visitorContext.getVisitorKind() == TypeElementVisitor.VisitorKind.ISOLATING) {
            if (((Object)((Object)this)).getClass() == JavaBeanDefinitionBuilder.class) {
                visitorContext.addBeanDefinitionBuilder(this);
            }
        } else {
            visitorContext.fail("Cannot add bean definition using addAssociatedBean(..) from a AGGREGATING TypeElementVisitor, consider overriding getVisitorKind()", originatingElement);
        }
    }

    protected AbstractBeanDefinitionBuilder createChildBean(final FieldElement producerField) {
        final ClassElement parentType = this.getBeanType();
        return new JavaBeanDefinitionBuilder(this.getOriginatingElement(), producerField.getGenericField().getType(), this.metadataBuilder, (JavaVisitorContext)this.visitorContext){

            public Element getProducingElement() {
                return producerField;
            }

            public ClassElement getDeclaringElement() {
                return producerField.getDeclaringType();
            }

            protected BeanDefinitionVisitor createBeanDefinitionWriter() {
                BeanDefinitionVisitor writer = super.createBeanDefinitionWriter();
                JavaElementFactory elementFactory = ((JavaVisitorContext)this.visitorContext).getElementFactory();
                VariableElement variableElement = (VariableElement)producerField.getNativeType();
                ClassElement resolvedParent = JavaBeanDefinitionBuilder.this.resolveParentType(parentType, elementFactory);
                writer.visitBeanFactoryField(resolvedParent, (FieldElement)elementFactory.newFieldElement(resolvedParent, variableElement, (AnnotationMetadata)new AnnotationMetadataHierarchy(new AnnotationMetadata[]{resolvedParent.getDeclaredMetadata(), producerField.getDeclaredMetadata()})));
                return writer;
            }
        };
    }

    protected BeanDefinitionVisitor createAopWriter(BeanDefinitionWriter beanDefinitionWriter, AnnotationMetadata annotationMetadata) {
        AnnotationValue[] interceptorTypes = InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)annotationMetadata, (InterceptorKind)InterceptorKind.AROUND);
        return new AopProxyWriter(beanDefinitionWriter, annotationMetadata.getValues(Around.class, Boolean.class), (ConfigurationMetadataBuilder)ConfigurationMetadataBuilder.getConfigurationMetadataBuilder().orElse(null), this.visitorContext, interceptorTypes);
    }

    protected BiConsumer<TypedElement, MethodElement> createAroundMethodVisitor(BeanDefinitionVisitor aopWriter) {
        AopProxyWriter aopProxyWriter = (AopProxyWriter)aopWriter;
        return (bean, method) -> {
            AnnotationValue[] newTypes = InterceptedMethodUtil.resolveInterceptorBinding((AnnotationMetadata)method.getAnnotationMetadata(), (InterceptorKind)InterceptorKind.AROUND);
            aopProxyWriter.visitInterceptorBinding(newTypes);
            aopProxyWriter.visitAroundMethod(bean, method);
        };
    }

    protected AbstractBeanDefinitionBuilder createChildBean(final MethodElement producerMethod) {
        final ClassElement parentType = this.getBeanType();
        return new JavaBeanDefinitionBuilder(this.getOriginatingElement(), producerMethod.getGenericReturnType(), this.metadataBuilder, (JavaVisitorContext)this.visitorContext){
            BeanParameterElement[] parameters;

            public Element getProducingElement() {
                return producerMethod;
            }

            public ClassElement getDeclaringElement() {
                return producerMethod.getDeclaringType();
            }

            protected BeanParameterElement[] getParameters() {
                if (this.parameters == null) {
                    this.parameters = this.initBeanParameters(producerMethod.getParameters());
                }
                return this.parameters;
            }

            protected BeanDefinitionVisitor createBeanDefinitionWriter() {
                BeanDefinitionVisitor writer = super.createBeanDefinitionWriter();
                JavaElementFactory elementFactory = ((JavaVisitorContext)this.visitorContext).getElementFactory();
                ExecutableElement variableElement = (ExecutableElement)producerMethod.getNativeType();
                ClassElement resolvedParent = JavaBeanDefinitionBuilder.this.resolveParentType(parentType, elementFactory);
                writer.visitBeanFactoryMethod(resolvedParent, (MethodElement)elementFactory.newMethodElement(resolvedParent, variableElement, (AnnotationMetadata)new AnnotationMetadataHierarchy(new AnnotationMetadata[]{resolvedParent.getDeclaredMetadata(), producerMethod.getDeclaredMetadata()})), (ParameterElement[])this.getParameters());
                return writer;
            }
        };
    }

    protected <T extends Annotation> void annotate(AnnotationMetadata annotationMetadata, AnnotationValue<T> annotationValue) {
        ArgumentUtils.requireNonNull((String)"annotationMetadata", (Object)annotationMetadata);
        ArgumentUtils.requireNonNull((String)"annotationValue", annotationValue);
        AnnotationUtils annotationUtils = this.javaVisitorContext.getAnnotationUtils();
        annotationUtils.newAnnotationBuilder().annotate(annotationMetadata, annotationValue);
    }

    protected <T extends Annotation> void annotate(AnnotationMetadata annotationMetadata, String annotationType, Consumer<AnnotationValueBuilder<T>> consumer) {
        ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
        ArgumentUtils.requireNonNull((String)"consumer", consumer);
        AnnotationValueBuilder builder = AnnotationValue.builder((String)annotationType);
        consumer.accept(builder);
        AnnotationValue av = builder.build();
        AnnotationUtils annotationUtils = this.javaVisitorContext.getAnnotationUtils();
        annotationUtils.newAnnotationBuilder().annotate(annotationMetadata, av);
    }

    protected void removeStereotype(AnnotationMetadata annotationMetadata, String annotationType) {
        ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
        AnnotationUtils annotationUtils = this.javaVisitorContext.getAnnotationUtils();
        annotationUtils.newAnnotationBuilder().removeStereotype(annotationMetadata, annotationType);
    }

    protected <T extends Annotation> void removeAnnotationIf(AnnotationMetadata annotationMetadata, Predicate<AnnotationValue<T>> predicate) {
        ArgumentUtils.requireNonNull((String)"predicate", predicate);
        AnnotationUtils annotationUtils = this.javaVisitorContext.getAnnotationUtils();
        annotationUtils.newAnnotationBuilder().removeAnnotationIf(annotationMetadata, predicate);
    }

    protected void removeAnnotation(AnnotationMetadata annotationMetadata, String annotationType) {
        ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
        AnnotationUtils annotationUtils = this.javaVisitorContext.getAnnotationUtils();
        annotationUtils.newAnnotationBuilder().removeAnnotation(annotationMetadata, annotationType);
    }

    private ClassElement resolveParentType(ClassElement parentType, JavaElementFactory elementFactory) {
        Object nativeType = parentType.getNativeType();
        Object resolvedParent = parentType;
        if (nativeType instanceof TypeElement) {
            resolvedParent = elementFactory.newClassElement((TypeElement)nativeType, this.getAnnotationMetadata());
        }
        return resolvedParent;
    }
}

