#############################################################################
##
#W  samegroups.g               GAP4 Package `RCWA'                Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing lists of
##  equal groups.
##
##  For all i in [1..52394], samegroups[i] is a list of indices j such that
##  grps[j] equals grps[i].
##
#############################################################################

local  samegroups, equalityclasses, i, j;

equalityclasses := 
  ReadAsFunction(Concatenation(PackageInfo("rcwa")[1].InstallationPath,
                               "/data/3ctsgroups6/equalityclasses.g"))();

samegroups := List([1..52394],i->[]);
for i in [1..Length(equalityclasses)] do
  for j in equalityclasses[i] do
    samegroups[j] := equalityclasses[i];
  od;
od;
return samegroups;

#############################################################################
##
#E  samegroups.g . . . . . . . . . . . . . . . . . . . . . . . . . ends here
