# GeneralizedMorphismsForCAP, single 2
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("generalizedmorphismsforcap02.tst");

# doc/_Chapter_Examples_and_Tests.xml:92-141
gap> Q := HomalgFieldOfRationals();;
gap> V := VectorSpaceObject( 3, Q );;
gap> mat := HomalgMatrix( [ [ 9, 8, 7 ], [ 6, 5, 4 ], [ 3, 2, 1 ] ], 3, 3, Q );;
gap> alpha := VectorSpaceMorphism( V, mat, V );;
gap> graph := FiberProductEmbeddingInDirectSum( 
>             [ alpha, IdentityMorphism( V ) ] );;
gap> Display( graph );
[ [     1,    -2,     1,     0,     0,     0 ],
  [  -4/3,   7/3,     0,     2,     1,     0 ],
  [   5/3,  -8/3,     0,    -1,     0,     1 ] ]

A morphism in Category of matrices over Q
gap> D := DirectSum( V, V );;
gap> rotmat := HomalgMatrix( [ [ 0, 0, 0, -1, 0, 0 ],
>                              [ 0, 1, 0, 0, 0, 0 ],
>                              [ 0, 0, 1, 0, 0, 0 ],
>                              [ 1, 0, 0, 0, 0, 0 ],
>                              [ 0, 0, 0, 0, 1, 0 ],
>                              [ 0, 0, 0, 0, 0, 1 ] ],
>                              6, 6, Q );;
gap> rot := VectorSpaceMorphism( D, rotmat, D );;
gap> p := PreCompose( graph, rot );;
gap> Display( p );
[ [     0,    -2,     1,    -1,     0,     0 ],
  [     2,   7/3,     0,   4/3,     1,     0 ],
  [    -1,  -8/3,     0,  -5/3,     0,     1 ] ]

A morphism in Category of matrices over Q
gap> pi1 := ProjectionInFactorOfDirectSum( [ V, V ], 1 );;
gap> pi2 := ProjectionInFactorOfDirectSum( [ V, V ], 2 );;
gap> reversed_arrow := PreCompose( p, pi1 );;
gap> arrow := PreCompose( p, pi2 );;
gap> g := GeneralizedMorphismBySpan( reversed_arrow, arrow );;
gap> IsHonest( g );
true
gap> sweep_1_alpha := HonestRepresentative( g );;
gap> Display( sweep_1_alpha );
[ [  -1/9,   8/9,   7/9 ],
  [   2/3,  -1/3,  -2/3 ],
  [   1/3,  -2/3,  -4/3 ] ]

A morphism in Category of matrices over Q
gap> Display( alpha );
[ [  9,  8,  7 ],
  [  6,  5,  4 ],
  [  3,  2,  1 ] ]

A morphism in Category of matrices over Q

#
gap> STOP_TEST("generalizedmorphismsforcap02.tst", 1);
