
# 13 "plugins/ssr/ssrtacs.mlg"
 

let vmCast = Constr.VMcast
open Names
open Pp
open Pcoq
open Ltac_plugin
open Stdarg
open Libnames
open Tactics
open Util
open Locus
open Tacexpr
open Tacinterp
open Pltac
open Extraargs
open Ppconstr

open Proofview
open Proofview.Notations

open Ssrmatching_plugin.Ssrmatching

open Ssrprinters
open Ssrcommon
open Ssrtacticals
open Ssrbwd
open Ssrequality
open Ssripats

open Ssrparser
open Ssrparser.Internal

open Ssrmatching_plugin.G_ssrmatching



let _ = Mltop.add_known_module "coq-core.plugins.ssreflect"

# 51 "plugins/ssr/ssrtacs.mlg"
 

(* Defining grammar rules with "xx" in it automatically declares keywords too,
 * we thus save the lexer to restore it at the end of the file *)
let frozen_lexer = ref (Pcoq.get_keyword_state ()) ;;
let () = Mltop.add_init_function "coq-core.plugins.ssreflect" (fun () ->
    frozen_lexer := Pcoq.get_keyword_state ())




# 70 "plugins/ssr/ssrtacs.mlg"
 

let ssrautoprop =
  Proofview.Goal.enter begin fun gl ->
  try
    let tacname =
      try Tacenv.locate_tactic (qualid_of_ident (Id.of_string "ssrautoprop"))
      with Not_found -> Tacenv.locate_tactic (ssrqid "ssrautoprop") in
    let tacexpr = CAst.make @@ Tacexpr.Reference (ArgArg (Loc.tag @@ tacname)) in
    eval_tactic (CAst.make @@ Tacexpr.TacArg CAst.(tacexpr.v))
  with Not_found -> Auto.gen_trivial [] None
  end

let () = ssrautoprop_tac := ssrautoprop

let tclBY tac = Tacticals.tclTHEN tac (donetac ~-1)

(** Tactical arguments. *)

(* We have four kinds: simple tactics, [|]-bracketed lists, hints, and swaps *)
(* The latter two are used in forward-chaining tactics (have, suffice, wlog) *)
(* and subgoal reordering tacticals (; first & ; last), respectively.        *)

(* Force use of the ltac_expr parsing entry, to rule out tick marks. *)

(** The "by" tactical. *)


open Ssrfwd



let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrtclby" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("by", Tacentries.TyArg (
                                                      Extend.TUentry (Genarg.get_arg_tag wit_ssrhintarg), 
                                                      Tacentries.TyNil)), 
           (fun tac ist -> 
# 103 "plugins/ssr/ssrtacs.mlg"
                                hinttac ist true tac 
           )))]

let _ = let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ssreflect", "ssrtacs.mlg:0")
        ssrhint
        (Pcoq.Reuse (None, [Pcoq.Production.make
                            (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                            ((Pcoq.Symbol.token (Tok.PKEYWORD ("by")))))
                                            ((Pcoq.Symbol.nterm ssrhintarg)))
                            (fun arg _ loc -> 
# 111 "plugins/ssr/ssrtacs.mlg"
                                              arg 
                                              )]))
        in ()


# 116 "plugins/ssr/ssrtacs.mlg"
 

open Genarg

let ssrtac_expr ?loc key args =
  CAst.make ?loc (TacAlias (key, (List.map (fun x -> Tacexpr.TacGeneric (None, x)) args)))

let mk_non_term wit id =
  let open Pptactic in
  TacNonTerm (None, (Extend.Uentry (Genarg.ArgT.Any (Genarg.get_arg_tag wit)), Some id))

let cast_arg wit v = Taccoerce.Value.cast (Genarg.topwit wit) v

let tcldokey =
  let open Pptactic in
  let prods = [ TacTerm "do"; mk_non_term wit_ssrdoarg (Names.Id.of_string "arg") ] in
  let tac = begin fun args ist -> match args with
    | [arg] ->
      let arg = cast_arg wit_ssrdoarg arg in
      ssrdotac ist arg
    | _ -> assert false
  end in
  register_ssrtac "tcldo" tac prods

let ssrdotac_expr ?loc n m tac clauses =
  let arg = ((n, m), tac), clauses in
  ssrtac_expr ?loc tcldokey [in_gen (rawwit wit_ssrdoarg) arg]



let _ = let ssrdotac = Pcoq.Entry.make "ssrdotac"
        in
        let () = assert (Pcoq.Entry.is_empty ssrdotac) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ssreflect", "ssrtacs.mlg:1")
        ssrdotac
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm ssrortacarg)))
                                  (fun tacs loc -> 
# 150 "plugins/ssr/ssrtacs.mlg"
                              tacs 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterml ltac_expr ("3"))))
                                 (fun tac loc -> 
# 149 "plugins/ssr/ssrtacs.mlg"
                                     mk_hint tac 
                                                 )])]))
        in let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ssreflect", "ssrtacs.mlg:2")
        ltac_expr
        (Pcoq.Reuse (Some
        ("3"), [Pcoq.Production.make
                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                                ("do"))))))
                                                                ((Pcoq.Symbol.nterm nat_or_var)))
                                                                ((Pcoq.Symbol.nterm ssrmmod)))
                                                ((Pcoq.Symbol.nterm ssrdotac)))
                                ((Pcoq.Symbol.nterm ssrclauses)))
                (fun clauses tac m n _ loc -> 
# 159 "plugins/ssr/ssrtacs.mlg"
        ssrdotac_expr ~loc (mk_index ~loc n) m tac clauses 
                                              );
               Pcoq.Production.make
               (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                               ("do"))))))
                                               ((Pcoq.Symbol.nterm ssrortacarg)))
                               ((Pcoq.Symbol.nterm ssrclauses)))
               (fun clauses tac _ loc -> 
# 156 "plugins/ssr/ssrtacs.mlg"
        ssrdotac_expr ~loc noindex Once tac clauses 
                                         );
               Pcoq.Production.make
               (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                               ("do"))))))
                                                               ((Pcoq.Symbol.nterm ssrmmod)))
                                               ((Pcoq.Symbol.nterm ssrdotac)))
                               ((Pcoq.Symbol.nterm ssrclauses)))
               (fun clauses tac m _ loc -> 
# 154 "plugins/ssr/ssrtacs.mlg"
        ssrdotac_expr ~loc noindex m tac clauses 
                                           )]))
        in ()


# 163 "plugins/ssr/ssrtacs.mlg"
 

(* We can't actually parse the direction separately because this   *)
(* would introduce conflicts with the basic ltac syntax.           *)
let pr_ssrseqdir _ _ _ = function
  | L2R -> str ";" ++ spc () ++ str "first "
  | R2L -> str ";" ++ spc () ++ str "last "



let (wit_ssrseqdir, ssrseqdir) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrseqdir" 
                                 {
                                 Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                          []);
                                 Tacentries.arg_tag = Some
                                                      (Geninterp.val_tag (Genarg.topwit wit_ssrdir));
                                 Tacentries.arg_intern = Tacentries.ArgInternWit (wit_ssrdir);
                                 Tacentries.arg_subst = Tacentries.ArgSubstWit (wit_ssrdir);
                                 Tacentries.arg_interp = Tacentries.ArgInterpWit (wit_ssrdir);
                                 Tacentries.arg_printer = ((fun env sigma -> 
                                                          
# 173 "plugins/ssr/ssrtacs.mlg"
                                                       pr_ssrseqdir 
                                                          ), (fun env sigma -> 
                                                          
# 173 "plugins/ssr/ssrtacs.mlg"
                                                       pr_ssrseqdir 
                                                          ), (fun env sigma -> 
                                                          
# 173 "plugins/ssr/ssrtacs.mlg"
                                                       pr_ssrseqdir 
                                                          ));
                                 }
let _ = (wit_ssrseqdir, ssrseqdir)


# 176 "plugins/ssr/ssrtacs.mlg"
 

let tclseqkey =
  let prods =
    [ mk_non_term wit_ssrtclarg (Names.Id.of_string "tac")
    ; mk_non_term wit_ssrseqdir (Names.Id.of_string "dir")
    ; mk_non_term wit_ssrseqarg (Names.Id.of_string "arg") ] in
  let tac =  begin fun args ist -> match args with
    | [tac; dir; arg] ->
      let tac = cast_arg wit_ssrtclarg tac in
      let dir = cast_arg wit_ssrseqdir dir in
      let arg = cast_arg wit_ssrseqarg arg in
      tclSEQAT ist tac dir arg
    | _ -> assert false
  end in
  register_ssrtac "tclseq" tac prods

let check_seqtacarg dir arg = match snd arg, dir with
  | ((true, []), Some { CAst.loc; v=(TacAtom _)}), L2R ->
    CErrors.user_err ?loc (str "expected \"last\"")
  | ((false, []), Some { CAst.loc; v=(TacAtom _) }), R2L ->
    CErrors.user_err ?loc (str "expected \"first\"")
  | _, _ -> arg

let tclseq_expr ?loc tac dir arg =
  let arg1 = in_gen (rawwit wit_ssrtclarg) tac in
  let arg2 = in_gen (rawwit wit_ssrseqdir) dir in
  let arg3 = in_gen (rawwit wit_ssrseqarg) (check_seqtacarg dir arg) in
  ssrtac_expr ?loc tclseqkey [arg1; arg2; arg3]



let _ = let ssr_first = Pcoq.Entry.make "ssr_first"
        and ssr_first_else = Pcoq.Entry.make "ssr_first_else"
        in
        let () = assert (Pcoq.Entry.is_empty ssr_first) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ssreflect", "ssrtacs.mlg:3")
        ssr_first
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("[")))))
                                                                  ((Pcoq.Symbol.list0sep ((Pcoq.Symbol.nterm ltac_expr)) ((Pcoq.Symbol.tokens [Pcoq.TPattern (Tok.PKEYWORD ("|"))])) false)))
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("]")))))
                                  (fun _ tacl _ loc -> 
# 212 "plugins/ssr/ssrtacs.mlg"
                                                    CAst.make ~loc (TacFirst tacl) 
                                                       );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm ssr_first)))
                                                 ((Pcoq.Symbol.nterm ssrintros_ne)))
                                 (fun ipats tac loc -> 
# 211 "plugins/ssr/ssrtacs.mlg"
                                                 tclintros_expr ~loc tac ipats 
                                                       )])]))
        in let () = assert (Pcoq.Entry.is_empty ssr_first_else) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ssreflect", "ssrtacs.mlg:4")
        ssr_first_else
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.nterm ssr_first)))
                                  (fun tac loc -> 
# 216 "plugins/ssr/ssrtacs.mlg"
                           tac 
                                                  );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm ssr_first)))
                                                 ((Pcoq.Symbol.nterm ssrorelse)))
                                 (fun tac2 tac1 loc -> 
# 215 "plugins/ssr/ssrtacs.mlg"
                                              CAst.make ~loc (TacOrelse (tac1, tac2)) 
                                                       )])]))
        in let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ssreflect", "ssrtacs.mlg:5")
        ltac_expr
        (Pcoq.Reuse (Some
        ("4"), [Pcoq.Production.make
                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.nterm ltac_expr)))
                                                                ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                                ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                ("last"))))))
                                ((Pcoq.Symbol.nterm ssrseqarg)))
                (fun arg _ _ tac loc -> 
# 223 "plugins/ssr/ssrtacs.mlg"
        tclseq_expr ~loc tac R2L arg 
                                        );
               Pcoq.Production.make
               (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.nterm ltac_expr)))
                                                               ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                               ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                               ("first"))))))
                               ((Pcoq.Symbol.nterm ssrseqarg)))
               (fun arg _ _ tac loc -> 
# 221 "plugins/ssr/ssrtacs.mlg"
        tclseq_expr ~loc tac L2R arg 
                                       );
               Pcoq.Production.make
               (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.nterm ltac_expr)))
                                                               ((Pcoq.Symbol.token (Tok.PKEYWORD (";")))))
                                               ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                               ("first"))))))
                               ((Pcoq.Symbol.nterm ssr_first_else)))
               (fun tac2 _ _ tac1 loc -> 
# 219 "plugins/ssr/ssrtacs.mlg"
        CAst.make ~loc (TacThen (tac1, tac2)) 
                                         )]))
        in ()


# 235 "plugins/ssr/ssrtacs.mlg"
 

let pr_docc = function
  | None, occ -> pr_occ occ
  | Some clr, _ -> pr_clear mt clr

let pr_gen (docc, dt) = pr_docc docc ++ pr_cpattern dt

let pr_ssrgen _ _ _ = pr_gen



let (wit_ssrgen, ssrgen) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrgen" 
                           {
                           Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                    [(Pcoq.Production.make
                                                      (Pcoq.Rule.next 
                                                      (Pcoq.Rule.stop)
                                                      ((Pcoq.Symbol.nterm cpattern)))
                                                      (fun dt loc -> 
# 252 "plugins/ssr/ssrtacs.mlg"
                        nodocc, dt 
                                                                    ));
                                                    (Pcoq.Production.make
                                                     (Pcoq.Rule.next 
                                                     (Pcoq.Rule.next 
                                                     (Pcoq.Rule.stop)
                                                     ((Pcoq.Symbol.nterm ssrdocc)))
                                                     ((Pcoq.Symbol.nterm cpattern)))
                                                     (fun dt docc loc -> 
# 248 "plugins/ssr/ssrtacs.mlg"
                                     
     match docc with
     | Some [], _ -> CErrors.user_err ~loc (str"Clear flag {} not allowed here")
     | _ -> docc, dt 
                                                                    ))]);
                           Tacentries.arg_tag = Some
                                                (Geninterp.Val.Pair (
                                                (Geninterp.val_tag (Genarg.topwit wit_ssrdocc)), 
                                                (Geninterp.val_tag (Genarg.topwit wit_cpattern))));
                           Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.PairArg (
                                                   (wit_ssrdocc), (wit_cpattern)));
                           Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.PairArg (
                                                  (wit_ssrdocc), (wit_cpattern)));
                           Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.PairArg (
                                                   (wit_ssrdocc), (wit_cpattern)));
                           Tacentries.arg_printer = ((fun env sigma -> 
                                                    
# 247 "plugins/ssr/ssrtacs.mlg"
                                                                  pr_ssrgen 
                                                    ), (fun env sigma -> 
                                                    
# 247 "plugins/ssr/ssrtacs.mlg"
                                                                  pr_ssrgen 
                                                    ), (fun env sigma -> 
                                                    
# 247 "plugins/ssr/ssrtacs.mlg"
                                                                  pr_ssrgen 
                                                    ));
                           }
let _ = (wit_ssrgen, ssrgen)


# 255 "plugins/ssr/ssrtacs.mlg"
 

let has_occ ((_, occ), _) = occ <> None

(** Generalization (discharge) sequence *)

(* A discharge sequence is represented as a list of up to two   *)
(* lists of d-items, plus an ident list set (the possibly empty *)
(* final clear switch). The main list is empty iff the command  *)
(* is defective, and has length two if there is a sequence of   *)
(* dependent terms (and in that case it is the first of the two *)
(* lists). Thus, the first of the two lists is never empty.     *)

(* type ssrgens = ssrgen list *)
(* type ssrdgens = ssrgens list * ssrclear *)

let gens_sep = function [], [] -> mt | _ -> spc

let pr_dgens pr_gen (gensl, clr) =
  let prgens s gens =
  if CList.is_empty gens then mt () else str s ++ pr_list spc pr_gen gens in
  let prdeps deps = prgens ": " deps ++ spc () ++ str "/" in
  match gensl with
  | [deps; []] -> prdeps deps ++ pr_clear pr_spc clr
  | [deps; gens] -> prdeps deps ++ prgens " " gens ++ pr_clear spc clr
  | [gens] -> prgens ": " gens ++ pr_clear spc clr
  | _ -> pr_clear pr_spc clr

let pr_ssrdgens _ _ _ = pr_dgens pr_gen

let cons_gen gen = function
  | gens :: gensl, clr -> (gen :: gens) :: gensl, clr
  | _ -> anomaly "missing gen list"

let cons_dep (gensl, clr) =
  if List.length gensl = 1 then ([] :: gensl, clr) else
  CErrors.user_err (Pp.str "multiple dependents switches '/'")



let (wit_ssrdgens_tl, ssrdgens_tl) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrdgens_tl" 
                                     {
                                     Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                              [(Pcoq.Production.make
                                                                (Pcoq.Rule.stop)
                                                                (fun loc -> 
# 308 "plugins/ssr/ssrtacs.mlg"
    [[]], [] 
                                                                    ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.nterm cpattern)))
                                                               (Pcoq.Symbol.self))
                                                               (fun dgens dt
                                                               loc -> 
                                                               
# 306 "plugins/ssr/ssrtacs.mlg"
    cons_gen (nodocc, dt) dgens 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.token (Pcoq.terminal "/"))))
                                                               (Pcoq.Symbol.self))
                                                               (fun dgens _
                                                               loc -> 
                                                               
# 304 "plugins/ssr/ssrtacs.mlg"
    cons_dep dgens 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.token (Pcoq.terminal "{"))))
                                                               ((Pcoq.Symbol.nterm ssrocc)))
                                                               ((Pcoq.Symbol.token (Pcoq.terminal "}"))))
                                                               ((Pcoq.Symbol.nterm cpattern)))
                                                               (Pcoq.Symbol.self))
                                                               (fun dgens dt
                                                               _ occ _ loc ->
                                                               
# 302 "plugins/ssr/ssrtacs.mlg"
    cons_gen (mkocc occ, dt) dgens 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.token (Pcoq.terminal "{"))))
                                                               ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm ssrhyp)))))
                                                               ((Pcoq.Symbol.token (Pcoq.terminal "}"))))
                                                               (fun _ clr _
                                                               loc -> 
                                                               
# 300 "plugins/ssr/ssrtacs.mlg"
    [[]], clr 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.token (Pcoq.terminal "{"))))
                                                               ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm ssrhyp)))))
                                                               ((Pcoq.Symbol.token (Pcoq.terminal "}"))))
                                                               ((Pcoq.Symbol.nterm cpattern)))
                                                               (Pcoq.Symbol.self))
                                                               (fun dgens dt
                                                               _ clr _ loc ->
                                                               
# 298 "plugins/ssr/ssrtacs.mlg"
    cons_gen (mkclr clr, dt) dgens 
                                                               ))]);
                                     Tacentries.arg_tag = Some
                                                          (Geninterp.Val.Pair (
                                                          (Geninterp.Val.List 
                                                          (Geninterp.Val.List 
                                                          (Geninterp.val_tag (Genarg.topwit wit_ssrgen)))), 
                                                          (Geninterp.val_tag (Genarg.topwit wit_ssrclear))));
                                     Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.PairArg (
                                                             (Genarg.ListArg 
                                                             (Genarg.ListArg 
                                                             (wit_ssrgen))), 
                                                             (wit_ssrclear)));
                                     Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.PairArg (
                                                            (Genarg.ListArg 
                                                            (Genarg.ListArg 
                                                            (wit_ssrgen))), 
                                                            (wit_ssrclear)));
                                     Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.PairArg (
                                                             (Genarg.ListArg 
                                                             (Genarg.ListArg 
                                                             (wit_ssrgen))), 
                                                             (wit_ssrclear)));
                                     Tacentries.arg_printer = ((fun env sigma -> 
                                                              
# 296 "plugins/ssr/ssrtacs.mlg"
                                         pr_ssrdgens 
                                                              ), (fun env sigma -> 
                                                              
# 296 "plugins/ssr/ssrtacs.mlg"
                                         pr_ssrdgens 
                                                              ), (fun env sigma -> 
                                                              
# 296 "plugins/ssr/ssrtacs.mlg"
                                         pr_ssrdgens 
                                                              ));
                                     }
let _ = (wit_ssrdgens_tl, ssrdgens_tl)

let (wit_ssrdgens, ssrdgens) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrdgens" 
                               {
                               Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                        [(Pcoq.Production.make
                                                          (Pcoq.Rule.next 
                                                          (Pcoq.Rule.next 
                                                          (Pcoq.Rule.next 
                                                          (Pcoq.Rule.stop)
                                                          ((Pcoq.Symbol.token (Pcoq.terminal ":"))))
                                                          ((Pcoq.Symbol.nterm ssrgen)))
                                                          ((Pcoq.Symbol.nterm ssrdgens_tl)))
                                                          (fun dgens gen _
                                                          loc -> 
# 312 "plugins/ssr/ssrtacs.mlg"
                                              cons_gen gen dgens 
                                                                 ))]);
                               Tacentries.arg_tag = Some
                                                    (Geninterp.val_tag (Genarg.topwit wit_ssrdgens_tl));
                               Tacentries.arg_intern = Tacentries.ArgInternWit (wit_ssrdgens_tl);
                               Tacentries.arg_subst = Tacentries.ArgSubstWit (wit_ssrdgens_tl);
                               Tacentries.arg_interp = Tacentries.ArgInterpWit (wit_ssrdgens_tl);
                               Tacentries.arg_printer = ((fun env sigma -> 
                                                        
# 311 "plugins/ssr/ssrtacs.mlg"
                                                           pr_ssrdgens 
                                                        ), (fun env sigma -> 
                                                        
# 311 "plugins/ssr/ssrtacs.mlg"
                                                           pr_ssrdgens 
                                                        ), (fun env sigma -> 
                                                        
# 311 "plugins/ssr/ssrtacs.mlg"
                                                           pr_ssrdgens 
                                                        ));
                               }
let _ = (wit_ssrdgens, ssrdgens)


# 319 "plugins/ssr/ssrtacs.mlg"
 

let pr_eqid = function Some pat -> str " " ++ pr_ipat pat | None -> mt ()
let pr_ssreqid _ _ _ = pr_eqid

let intern_ipat_option ist = Option.map (intern_ipat ist)

let interp_ipat_option ist env sigma o = Option.map (interp_ipat ist env sigma) o



let (wit_ssreqid, ssreqid) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssreqid" 
                             {
                             Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                      []);
                             Tacentries.arg_tag = Some
                                                  (Geninterp.Val.Opt 
                                                  (Geninterp.val_tag (Genarg.topwit wit_ssripatrep)));
                             Tacentries.arg_intern = Tacentries.ArgInternFun ((fun f ist v -> (ist, f ist v)) (
                                                     
# 334 "plugins/ssr/ssrtacs.mlg"
                  intern_ipat_option 
                                                     ));
                             Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.OptArg 
                                                    (wit_ssripatrep));
                             Tacentries.arg_interp = Tacentries.ArgInterpSimple (
                                                     
# 333 "plugins/ssr/ssrtacs.mlg"
                   interp_ipat_option 
                                                     );
                             Tacentries.arg_printer = ((fun env sigma -> 
                                                      
# 332 "plugins/ssr/ssrtacs.mlg"
                                                                pr_ssreqid 
                                                      ), (fun env sigma -> 
                                                      
# 332 "plugins/ssr/ssrtacs.mlg"
                                                                pr_ssreqid 
                                                      ), (fun env sigma -> 
                                                      
# 332 "plugins/ssr/ssrtacs.mlg"
                                                                pr_ssreqid 
                                                      ));
                             }
let _ = (wit_ssreqid, ssreqid)


# 338 "plugins/ssr/ssrtacs.mlg"
 

let test_ssreqid =
  let open Pcoq.Lookahead in
  to_entry "test_ssreqid" begin
    ((lk_ident <+> lk_kws ["_"; "?"; "->"; "<-"]) >> lk_kw ":") <+> lk_kw ":"
  end

open Ssrast



let _ = let ssreqpat = Pcoq.Entry.make "ssreqpat"
        in
        let () = assert (Pcoq.Entry.is_empty ssreqpat) in
        let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ssreflect", "ssrtacs.mlg:6")
        ssreqpat
        (Pcoq.Fresh
        (Gramlib.Gramext.First, [(None, None,
                                 [Pcoq.Production.make
                                  (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                  ((Pcoq.Symbol.token (Tok.PKEYWORD ("<-")))))
                                  (fun _ loc -> 
# 364 "plugins/ssr/ssrtacs.mlg"
                IPatRewrite (allocc, R2L) 
                                                );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("->")))))
                                 (fun _ loc -> 
# 363 "plugins/ssr/ssrtacs.mlg"
                IPatRewrite (allocc, L2R) 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm ssrdocc)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("<-")))))
                                 (fun _ occ loc -> 
# 360 "plugins/ssr/ssrtacs.mlg"
                               match occ with
      | None, occ ->  IPatRewrite (occ, R2L)
      | _ -> CErrors.user_err ~loc (str "Only occurrences are allowed here") 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.nterm ssrdocc)))
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("->")))))
                                 (fun _ occ loc -> 
# 357 "plugins/ssr/ssrtacs.mlg"
                               match occ with
      | None, occ -> IPatRewrite (occ, L2R)
      | _ -> CErrors.user_err ~loc (str"Only occurrences are allowed here") 
                                                   );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("+")))))
                                 (fun _ loc -> 
# 356 "plugins/ssr/ssrtacs.mlg"
               IPatAnon Temporary 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("?")))))
                                 (fun _ loc -> 
# 355 "plugins/ssr/ssrtacs.mlg"
               IPatAnon (One None) 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.token (Tok.PKEYWORD ("_")))))
                                 (fun _ loc -> 
# 354 "plugins/ssr/ssrtacs.mlg"
               IPatAnon Drop 
                                               );
                                 Pcoq.Production.make
                                 (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                 ((Pcoq.Symbol.nterm Prim.ident)))
                                 (fun id loc -> 
# 353 "plugins/ssr/ssrtacs.mlg"
                           IPatId id 
                                                )])]))
        in let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ssreflect", "ssrtacs.mlg:7")
        ssreqid
        (Pcoq.Reuse (None, [Pcoq.Production.make
                            (Pcoq.Rule.next (Pcoq.Rule.stop)
                                            ((Pcoq.Symbol.nterm test_ssreqid)))
                            (fun _ loc -> 
# 368 "plugins/ssr/ssrtacs.mlg"
                        None 
                                          );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.nterm test_ssreqid)))
                                           ((Pcoq.Symbol.nterm ssreqpat)))
                           (fun pat _ loc -> 
# 367 "plugins/ssr/ssrtacs.mlg"
                                        Some pat 
                                             )]))
        in ()


# 379 "plugins/ssr/ssrtacs.mlg"
 

(* type ssrarg = ssrbwdview * (ssreqid * (ssrdgens * ssripats)) *)

let pr_ssrarg _ _ _ (view, (eqid, (dgens, ipats))) =
  let pri = pr_intros (gens_sep dgens) in
  pr_view2 view ++ pr_eqid eqid ++ pr_dgens pr_gen dgens ++ pri ipats



let (wit_ssrarg, ssrarg) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrarg" 
                           {
                           Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                    [(Pcoq.Production.make
                                                      (Pcoq.Rule.next 
                                                      (Pcoq.Rule.stop)
                                                      ((Pcoq.Symbol.nterm ssrintros_ne)))
                                                      (fun ipats loc -> 
# 400 "plugins/ssr/ssrtacs.mlg"
    [], (None, (([], []), ipats)) 
                                                                    ));
                                                    (Pcoq.Production.make
                                                     (Pcoq.Rule.next 
                                                     (Pcoq.Rule.next 
                                                     (Pcoq.Rule.stop)
                                                     ((Pcoq.Symbol.nterm ssrclear_ne)))
                                                     ((Pcoq.Symbol.nterm ssrintros)))
                                                     (fun ipats clr loc -> 
# 398 "plugins/ssr/ssrtacs.mlg"
    [], (None, (([], clr), ipats)) 
                                                                    ));
                                                    (Pcoq.Production.make
                                                     (Pcoq.Rule.next 
                                                     (Pcoq.Rule.next 
                                                     (Pcoq.Rule.next 
                                                     (Pcoq.Rule.stop)
                                                     ((Pcoq.Symbol.nterm ssreqid)))
                                                     ((Pcoq.Symbol.nterm ssrdgens)))
                                                     ((Pcoq.Symbol.nterm ssrintros)))
                                                     (fun ipats dgens eqid
                                                     loc -> 
# 396 "plugins/ssr/ssrtacs.mlg"
    [], (eqid, (dgens, ipats)) 
                                                            ));
                                                    (Pcoq.Production.make
                                                     (Pcoq.Rule.next 
                                                     (Pcoq.Rule.next 
                                                     (Pcoq.Rule.next 
                                                     (Pcoq.Rule.stop)
                                                     ((Pcoq.Symbol.nterm ssrfwdview)))
                                                     ((Pcoq.Symbol.nterm ssrclear)))
                                                     ((Pcoq.Symbol.nterm ssrintros)))
                                                     (fun ipats clr view
                                                     loc -> 
# 394 "plugins/ssr/ssrtacs.mlg"
    view, (None, (([], clr), ipats)) 
                                                            ));
                                                    (Pcoq.Production.make
                                                     (Pcoq.Rule.next 
                                                     (Pcoq.Rule.next 
                                                     (Pcoq.Rule.next 
                                                     (Pcoq.Rule.next 
                                                     (Pcoq.Rule.stop)
                                                     ((Pcoq.Symbol.nterm ssrfwdview)))
                                                     ((Pcoq.Symbol.nterm ssreqid)))
                                                     ((Pcoq.Symbol.nterm ssrdgens)))
                                                     ((Pcoq.Symbol.nterm ssrintros)))
                                                     (fun ipats dgens eqid
                                                     view loc -> 
# 392 "plugins/ssr/ssrtacs.mlg"
    view, (eqid, (dgens, ipats)) 
                                                                 ))]);
                           Tacentries.arg_tag = Some
                                                (Geninterp.Val.Pair (
                                                (Geninterp.val_tag (Genarg.topwit wit_ssrfwdview)), 
                                                (Geninterp.Val.Pair (
                                                (Geninterp.val_tag (Genarg.topwit wit_ssreqid)), 
                                                (Geninterp.Val.Pair (
                                                (Geninterp.val_tag (Genarg.topwit wit_ssrdgens)), 
                                                (Geninterp.val_tag (Genarg.topwit wit_ssrintros))))))));
                           Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.PairArg (
                                                   (wit_ssrfwdview), 
                                                   (Genarg.PairArg ((wit_ssreqid), 
                                                   (Genarg.PairArg ((wit_ssrdgens), 
                                                   (wit_ssrintros)))))));
                           Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.PairArg (
                                                  (wit_ssrfwdview), (Genarg.PairArg (
                                                                    (wit_ssreqid), 
                                                                    (Genarg.PairArg (
                                                                    (wit_ssrdgens), 
                                                                    (wit_ssrintros)))))));
                           Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.PairArg (
                                                   (wit_ssrfwdview), 
                                                   (Genarg.PairArg ((wit_ssreqid), 
                                                   (Genarg.PairArg ((wit_ssrdgens), 
                                                   (wit_ssrintros)))))));
                           Tacentries.arg_printer = ((fun env sigma -> 
                                                    
# 390 "plugins/ssr/ssrtacs.mlg"
                pr_ssrarg 
                                                    ), (fun env sigma -> 
                                                    
# 390 "plugins/ssr/ssrtacs.mlg"
                pr_ssrarg 
                                                    ), (fun env sigma -> 
                                                    
# 390 "plugins/ssr/ssrtacs.mlg"
                pr_ssrarg 
                                                    ));
                           }
let _ = (wit_ssrarg, ssrarg)

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrclear" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("clear", Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_natural), 
                                                         Tacentries.TyNil)), 
           (fun n ist -> 
# 408 "plugins/ssr/ssrtacs.mlg"
                                tclIPAT (List.init n (fun _ -> IOpDrop)) 
           )))]


# 413 "plugins/ssr/ssrtacs.mlg"
 

(* TODO: review this, in particular the => _ and => [] cases *)
let rec improper_intros = function
  | IPatSimpl _ :: ipats -> improper_intros ipats
  | (IPatId _ | IPatAnon _ | IPatCase _ | IPatDispatch _) :: _ -> false
  | _ -> true (* FIXME *)

let check_movearg = function
  | view, (eqid, _) when view <> [] && eqid <> None ->
    CErrors.user_err (Pp.str "incompatible view and equation in move tactic")
  | view, (_, (([gen :: _], _), _)) when view <> [] && has_occ gen ->
    CErrors.user_err (Pp.str "incompatible view and occurrence switch in move tactic")
  | _, (_, ((dgens, _), _)) when List.length dgens > 1 ->
    CErrors.user_err (Pp.str "dependents switch `/' in move tactic")
  | _, (eqid, (_, ipats)) when eqid <> None && improper_intros ipats ->
    CErrors.user_err (Pp.str "no proper intro pattern for equation in move tactic")
  | arg -> arg



let (wit_ssrmovearg, ssrmovearg) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrmovearg" 
                                   {
                                   Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                            [(Pcoq.Production.make
                                                              (Pcoq.Rule.next 
                                                              (Pcoq.Rule.stop)
                                                              ((Pcoq.Symbol.nterm ssrarg)))
                                                              (fun arg loc ->
                                                              
# 435 "plugins/ssr/ssrtacs.mlg"
                       check_movearg arg 
                                                              ))]);
                                   Tacentries.arg_tag = Some
                                                        (Geninterp.val_tag (Genarg.topwit wit_ssrarg));
                                   Tacentries.arg_intern = Tacentries.ArgInternWit (wit_ssrarg);
                                   Tacentries.arg_subst = Tacentries.ArgSubstWit (wit_ssrarg);
                                   Tacentries.arg_interp = Tacentries.ArgInterpWit (wit_ssrarg);
                                   Tacentries.arg_printer = ((fun env sigma -> 
                                                            
# 434 "plugins/ssr/ssrtacs.mlg"
                                                        pr_ssrarg 
                                                            ), (fun env sigma -> 
                                                            
# 434 "plugins/ssr/ssrtacs.mlg"
                                                        pr_ssrarg 
                                                            ), (fun env sigma -> 
                                                            
# 434 "plugins/ssr/ssrtacs.mlg"
                                                        pr_ssrarg 
                                                            ));
                                   }
let _ = (wit_ssrmovearg, ssrmovearg)


# 438 "plugins/ssr/ssrtacs.mlg"
 

let movearg_of_parsed_movearg (v,(eq,(dg,ip))) =
  (v,(eq,(ssrdgens_of_parsed_dgens dg,ip)))



let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrmove" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("move", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrmovearg), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrrpat), 
                                                        Tacentries.TyNil))), 
           (fun arg pat ist -> 
# 447 "plugins/ssr/ssrtacs.mlg"
    ssrmovetac (movearg_of_parsed_movearg arg) <*> tclIPAT (tclCompileIPats [pat]) 
           )));
         (Tacentries.TyML (Tacentries.TyIdent ("move", Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_ssrmovearg), 
                                                       Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_ssrclauses), 
                                                       Tacentries.TyNil))), 
          (fun arg clauses ist -> 
# 449 "plugins/ssr/ssrtacs.mlg"
    tclCLAUSES (ssrmovetac (movearg_of_parsed_movearg arg)) clauses 
          )));
         (Tacentries.TyML (Tacentries.TyIdent ("move", Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_ssrrpat), 
                                                       Tacentries.TyNil)), 
          (fun pat ist -> 
# 450 "plugins/ssr/ssrtacs.mlg"
                               tclIPAT (tclCompileIPats [pat]) 
          )));
         (Tacentries.TyML (Tacentries.TyIdent ("move", Tacentries.TyNil), 
          (fun ist -> 
# 451 "plugins/ssr/ssrtacs.mlg"
                  ssrsmovetac 
          )))]


# 454 "plugins/ssr/ssrtacs.mlg"
 

let check_casearg = function
| view, (_, (([_; gen :: _], _), _)) when view <> [] && has_occ gen ->
  CErrors.user_err (Pp.str "incompatible view and occurrence switch in dependent case tactic")
| arg -> arg



let (wit_ssrcasearg, ssrcasearg) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrcasearg" 
                                   {
                                   Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                            [(Pcoq.Production.make
                                                              (Pcoq.Rule.next 
                                                              (Pcoq.Rule.stop)
                                                              ((Pcoq.Symbol.nterm ssrarg)))
                                                              (fun arg loc ->
                                                              
# 464 "plugins/ssr/ssrtacs.mlg"
                       check_casearg arg 
                                                              ))]);
                                   Tacentries.arg_tag = Some
                                                        (Geninterp.val_tag (Genarg.topwit wit_ssrarg));
                                   Tacentries.arg_intern = Tacentries.ArgInternWit (wit_ssrarg);
                                   Tacentries.arg_subst = Tacentries.ArgSubstWit (wit_ssrarg);
                                   Tacentries.arg_interp = Tacentries.ArgInterpWit (wit_ssrarg);
                                   Tacentries.arg_printer = ((fun env sigma -> 
                                                            
# 463 "plugins/ssr/ssrtacs.mlg"
                                                        pr_ssrarg 
                                                            ), (fun env sigma -> 
                                                            
# 463 "plugins/ssr/ssrtacs.mlg"
                                                        pr_ssrarg 
                                                            ), (fun env sigma -> 
                                                            
# 463 "plugins/ssr/ssrtacs.mlg"
                                                        pr_ssrarg 
                                                            ));
                                   }
let _ = (wit_ssrcasearg, ssrcasearg)

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrcase" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("case", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrcasearg), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrclauses), 
                                                        Tacentries.TyNil))), 
           (fun arg clauses ist -> 
# 469 "plugins/ssr/ssrtacs.mlg"
    tclCLAUSES (ssrcasetac (movearg_of_parsed_movearg arg)) clauses 
           )));
         (Tacentries.TyML (Tacentries.TyIdent ("case", Tacentries.TyNil), 
          (fun ist -> 
# 470 "plugins/ssr/ssrtacs.mlg"
                  ssrscasetoptac 
          )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrelim" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("elim", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrarg), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrclauses), 
                                                        Tacentries.TyNil))), 
           (fun arg clauses ist -> 
# 477 "plugins/ssr/ssrtacs.mlg"
    tclCLAUSES (ssrelimtac (movearg_of_parsed_movearg arg)) clauses 
           )));
         (Tacentries.TyML (Tacentries.TyIdent ("elim", Tacentries.TyNil), 
          (fun ist -> 
# 478 "plugins/ssr/ssrtacs.mlg"
                  ssrselimtoptac 
          )))]


# 485 "plugins/ssr/ssrtacs.mlg"
 

let pr_agen (docc, dt) = pr_docc docc ++ pr_term dt
let pr_ssragen _ _ _ = pr_agen
let pr_ssragens _ _ _ = pr_dgens pr_agen



let (wit_ssragen, ssragen) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssragen" 
                             {
                             Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                      [(Pcoq.Production.make
                                                        (Pcoq.Rule.next 
                                                        (Pcoq.Rule.stop)
                                                        ((Pcoq.Symbol.nterm ssrterm)))
                                                        (fun dt loc -> 
# 495 "plugins/ssr/ssrtacs.mlg"
                       nodocc, dt 
                                                                    ));
                                                      (Pcoq.Production.make
                                                       (Pcoq.Rule.next 
                                                       (Pcoq.Rule.next 
                                                       (Pcoq.Rule.next 
                                                       (Pcoq.Rule.next 
                                                       (Pcoq.Rule.stop)
                                                       ((Pcoq.Symbol.token (Pcoq.terminal "{"))))
                                                       ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm ssrhyp)))))
                                                       ((Pcoq.Symbol.token (Pcoq.terminal "}"))))
                                                       ((Pcoq.Symbol.nterm ssrterm)))
                                                       (fun dt _ clr _ loc ->
                                                       
# 494 "plugins/ssr/ssrtacs.mlg"
                                                   mkclr clr, dt 
                                                       ))]);
                             Tacentries.arg_tag = Some
                                                  (Geninterp.Val.Pair (
                                                  (Geninterp.val_tag (Genarg.topwit wit_ssrdocc)), 
                                                  (Geninterp.val_tag (Genarg.topwit wit_ssrterm))));
                             Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.PairArg (
                                                     (wit_ssrdocc), (wit_ssrterm)));
                             Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.PairArg (
                                                    (wit_ssrdocc), (wit_ssrterm)));
                             Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.PairArg (
                                                     (wit_ssrdocc), (wit_ssrterm)));
                             Tacentries.arg_printer = ((fun env sigma -> 
                                                      
# 493 "plugins/ssr/ssrtacs.mlg"
                                                                  pr_ssragen 
                                                      ), (fun env sigma -> 
                                                      
# 493 "plugins/ssr/ssrtacs.mlg"
                                                                  pr_ssragen 
                                                      ), (fun env sigma -> 
                                                      
# 493 "plugins/ssr/ssrtacs.mlg"
                                                                  pr_ssragen 
                                                      ));
                             }
let _ = (wit_ssragen, ssragen)

let (wit_ssragens, ssragens) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssragens" 
                               {
                               Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                        [(Pcoq.Production.make
                                                          (Pcoq.Rule.stop)
                                                          (fun loc -> 
# 505 "plugins/ssr/ssrtacs.mlg"
           [[]], [] 
                                                                    ));
                                                        (Pcoq.Production.make
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.stop)
                                                         ((Pcoq.Symbol.nterm ssrterm)))
                                                         (Pcoq.Symbol.self))
                                                         (fun agens dt loc ->
                                                         
# 504 "plugins/ssr/ssrtacs.mlg"
    cons_gen (nodocc, dt) agens 
                                                         ));
                                                        (Pcoq.Production.make
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.stop)
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "{"))))
                                                         ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm ssrhyp)))))
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "}"))))
                                                         (fun _ clr _ loc ->
                                                         
# 502 "plugins/ssr/ssrtacs.mlg"
                                       [[]], clr
                                                         ));
                                                        (Pcoq.Production.make
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.stop)
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "{"))))
                                                         ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm ssrhyp)))))
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "}"))))
                                                         ((Pcoq.Symbol.nterm ssrterm)))
                                                         (Pcoq.Symbol.self))
                                                         (fun agens dt _ clr
                                                         _ loc -> 
# 501 "plugins/ssr/ssrtacs.mlg"
    cons_gen (mkclr clr, dt) agens 
                                                                  ))]);
                               Tacentries.arg_tag = Some
                                                    (Geninterp.Val.Pair (
                                                    (Geninterp.Val.List 
                                                    (Geninterp.Val.List 
                                                    (Geninterp.val_tag (Genarg.topwit wit_ssragen)))), 
                                                    (Geninterp.val_tag (Genarg.topwit wit_ssrclear))));
                               Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.PairArg (
                                                       (Genarg.ListArg 
                                                       (Genarg.ListArg 
                                                       (wit_ssragen))), 
                                                       (wit_ssrclear)));
                               Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.PairArg (
                                                      (Genarg.ListArg 
                                                      (Genarg.ListArg 
                                                      (wit_ssragen))), 
                                                      (wit_ssrclear)));
                               Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.PairArg (
                                                       (Genarg.ListArg 
                                                       (Genarg.ListArg 
                                                       (wit_ssragen))), 
                                                       (wit_ssrclear)));
                               Tacentries.arg_printer = ((fun env sigma -> 
                                                        
# 499 "plugins/ssr/ssrtacs.mlg"
             pr_ssragens 
                                                        ), (fun env sigma -> 
                                                        
# 499 "plugins/ssr/ssrtacs.mlg"
             pr_ssragens 
                                                        ), (fun env sigma -> 
                                                        
# 499 "plugins/ssr/ssrtacs.mlg"
             pr_ssragens 
                                                        ));
                               }
let _ = (wit_ssragens, ssragens)


# 508 "plugins/ssr/ssrtacs.mlg"
 

let mk_applyarg views agens intros = views, (agens, intros)

let pr_ssraarg _ _ _ (view, (dgens, ipats)) =
  let pri = pr_intros (gens_sep dgens) in
  pr_view view ++ pr_dgens pr_agen dgens ++ pri ipats



let (wit_ssrapplyarg, ssrapplyarg) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrapplyarg" 
                                     {
                                     Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                              [(Pcoq.Production.make
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.nterm ssrbwdview)))
                                                                ((Pcoq.Symbol.nterm ssrclear)))
                                                                ((Pcoq.Symbol.nterm ssrintros)))
                                                                (fun intros
                                                                clr view
                                                                loc -> 
                                                                
# 530 "plugins/ssr/ssrtacs.mlg"
    mk_applyarg view ([], clr) intros 
                                                                ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.nterm ssrbwdview)))
                                                               ((Pcoq.Symbol.token (Pcoq.terminal ":"))))
                                                               ((Pcoq.Symbol.nterm ssragen)))
                                                               ((Pcoq.Symbol.nterm ssragens)))
                                                               ((Pcoq.Symbol.nterm ssrintros)))
                                                               (fun intros
                                                               dgens gen _
                                                               view loc -> 
                                                               
# 528 "plugins/ssr/ssrtacs.mlg"
    mk_applyarg view (cons_gen gen dgens) intros 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.nterm ssrintros_ne)))
                                                               (fun intros
                                                               loc -> 
                                                               
# 526 "plugins/ssr/ssrtacs.mlg"
    mk_applyarg [] ([], []) intros 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.nterm ssrclear_ne)))
                                                               ((Pcoq.Symbol.nterm ssrintros)))
                                                               (fun intros
                                                               clr loc -> 
                                                               
# 524 "plugins/ssr/ssrtacs.mlg"
    mk_applyarg [] ([], clr) intros 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.token (Pcoq.terminal ":"))))
                                                               ((Pcoq.Symbol.nterm ssragen)))
                                                               ((Pcoq.Symbol.nterm ssragens)))
                                                               ((Pcoq.Symbol.nterm ssrintros)))
                                                               (fun intros
                                                               dgens gen _
                                                               loc -> 
                                                               
# 522 "plugins/ssr/ssrtacs.mlg"
    mk_applyarg [] (cons_gen gen dgens) intros 
                                                               ))]);
                                     Tacentries.arg_tag = Some
                                                          (Geninterp.Val.Pair (
                                                          (Geninterp.val_tag (Genarg.topwit wit_ssrbwdview)), 
                                                          (Geninterp.Val.Pair (
                                                          (Geninterp.val_tag (Genarg.topwit wit_ssragens)), 
                                                          (Geninterp.val_tag (Genarg.topwit wit_ssrintros))))));
                                     Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.PairArg (
                                                             (wit_ssrbwdview), 
                                                             (Genarg.PairArg (
                                                             (wit_ssragens), 
                                                             (wit_ssrintros)))));
                                     Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.PairArg (
                                                            (wit_ssrbwdview), 
                                                            (Genarg.PairArg (
                                                            (wit_ssragens), 
                                                            (wit_ssrintros)))));
                                     Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.PairArg (
                                                             (wit_ssrbwdview), 
                                                             (Genarg.PairArg (
                                                             (wit_ssragens), 
                                                             (wit_ssrintros)))));
                                     Tacentries.arg_printer = ((fun env sigma -> 
                                                              
# 520 "plugins/ssr/ssrtacs.mlg"
             pr_ssraarg 
                                                              ), (fun env sigma -> 
                                                              
# 520 "plugins/ssr/ssrtacs.mlg"
             pr_ssraarg 
                                                              ), (fun env sigma -> 
                                                              
# 520 "plugins/ssr/ssrtacs.mlg"
             pr_ssraarg 
                                                              ));
                                     }
let _ = (wit_ssrapplyarg, ssrapplyarg)

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrapply" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("apply", Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_ssrapplyarg), 
                                                         Tacentries.TyNil)), 
           (fun arg ist -> 
# 534 "plugins/ssr/ssrtacs.mlg"
                                   
     let views, (gens_clr, intros) = arg in
     inner_ssrapplytac views gens_clr ist <*> tclIPATssr intros 
           )));
         (Tacentries.TyML (Tacentries.TyIdent ("apply", Tacentries.TyNil), 
          (fun ist -> 
# 537 "plugins/ssr/ssrtacs.mlg"
                   apply_top_tac 
          )))]


# 542 "plugins/ssr/ssrtacs.mlg"
 

let mk_exactarg views dgens = mk_applyarg views dgens []



let (wit_ssrexactarg, ssrexactarg) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrexactarg" 
                                     {
                                     Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                              [(Pcoq.Production.make
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.nterm ssrclear_ne)))
                                                                (fun clr
                                                                loc -> 
                                                                
# 554 "plugins/ssr/ssrtacs.mlg"
    mk_exactarg [] ([], clr) 
                                                                ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.nterm ssrbwdview)))
                                                               ((Pcoq.Symbol.nterm ssrclear)))
                                                               (fun clr view
                                                               loc -> 
                                                               
# 552 "plugins/ssr/ssrtacs.mlg"
    mk_exactarg view ([], clr) 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.token (Pcoq.terminal ":"))))
                                                               ((Pcoq.Symbol.nterm ssragen)))
                                                               ((Pcoq.Symbol.nterm ssragens)))
                                                               (fun dgens gen
                                                               _ loc -> 
                                                               
# 550 "plugins/ssr/ssrtacs.mlg"
    mk_exactarg [] (cons_gen gen dgens) 
                                                               ))]);
                                     Tacentries.arg_tag = Some
                                                          (Geninterp.val_tag (Genarg.topwit wit_ssrapplyarg));
                                     Tacentries.arg_intern = Tacentries.ArgInternWit (wit_ssrapplyarg);
                                     Tacentries.arg_subst = Tacentries.ArgSubstWit (wit_ssrapplyarg);
                                     Tacentries.arg_interp = Tacentries.ArgInterpWit (wit_ssrapplyarg);
                                     Tacentries.arg_printer = ((fun env sigma -> 
                                                              
# 548 "plugins/ssr/ssrtacs.mlg"
                                                              pr_ssraarg 
                                                              ), (fun env sigma -> 
                                                              
# 548 "plugins/ssr/ssrtacs.mlg"
                                                              pr_ssraarg 
                                                              ), (fun env sigma -> 
                                                              
# 548 "plugins/ssr/ssrtacs.mlg"
                                                              pr_ssraarg 
                                                              ));
                                     }
let _ = (wit_ssrexactarg, ssrexactarg)


# 557 "plugins/ssr/ssrtacs.mlg"
 

let vmexacttac pf =
  Goal.enter begin fun gl ->
  exact_no_check (EConstr.mkCast (pf, vmCast, Tacmach.pf_concl gl))
  end



let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrexact" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("exact", Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_ssrexactarg), 
                                                         Tacentries.TyNil)), 
           (fun arg ist -> 
# 567 "plugins/ssr/ssrtacs.mlg"
                                   
     let views, (gens_clr, _) = arg in
     tclBY (inner_ssrapplytac views gens_clr ist) 
           )));
         (Tacentries.TyML (Tacentries.TyIdent ("exact", Tacentries.TyNil), 
          (fun ist -> 
# 570 "plugins/ssr/ssrtacs.mlg"
                  
     Tacticals.tclORELSE (donetac ~-1) (tclBY apply_top_tac) 
          )));
         (Tacentries.TyML (Tacentries.TyIdent ("exact", Tacentries.TyIdent ("<:", 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_lconstr), 
                                                        Tacentries.TyNil))), 
          (fun pf ist -> 
# 572 "plugins/ssr/ssrtacs.mlg"
                                    vmexacttac pf 
          )))]


# 577 "plugins/ssr/ssrtacs.mlg"
 

let pr_ssrcongrarg _ _ _ ((n, f), dgens) =
  (if n <= 0 then mt () else str " " ++ int n) ++
  pr_term f ++ pr_dgens pr_gen dgens

open Pcoq.Constr
open Pcoq.Prim



let (wit_ssrcongrarg, ssrcongrarg) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrcongrarg" 
                                     {
                                     Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                              [(Pcoq.Production.make
                                                                (Pcoq.Rule.next 
                                                                (Pcoq.Rule.stop)
                                                                ((Pcoq.Symbol.nterm constr)))
                                                                (fun c loc ->
                                                                
# 593 "plugins/ssr/ssrtacs.mlg"
                     (0, mk_term NoFlag c), ([[]],[]) 
                                                                ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.nterm constr)))
                                                               ((Pcoq.Symbol.nterm ssrdgens)))
                                                               (fun dgens c
                                                               loc -> 
                                                               
# 592 "plugins/ssr/ssrtacs.mlg"
                                     (0, mk_term NoFlag c), dgens 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.nterm natural)))
                                                               ((Pcoq.Symbol.nterm constr)))
                                                               (fun c n
                                                               loc -> 
                                                               
# 591 "plugins/ssr/ssrtacs.mlg"
                                (n, mk_term NoFlag c),([[]],[]) 
                                                               ));
                                                              (Pcoq.Production.make
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.next 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.nterm natural)))
                                                               ((Pcoq.Symbol.nterm constr)))
                                                               ((Pcoq.Symbol.nterm ssrdgens)))
                                                               (fun dgens c n
                                                               loc -> 
                                                               
# 590 "plugins/ssr/ssrtacs.mlg"
                                                (n, mk_term NoFlag c), dgens 
                                                               ))]);
                                     Tacentries.arg_tag = Some
                                                          (Geninterp.Val.Pair (
                                                          (Geninterp.Val.Pair (
                                                          (Geninterp.val_tag (Genarg.topwit wit_int)), 
                                                          (Geninterp.val_tag (Genarg.topwit wit_ssrterm)))), 
                                                          (Geninterp.val_tag (Genarg.topwit wit_ssrdgens))));
                                     Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.PairArg (
                                                             (Genarg.PairArg (
                                                             (wit_int), 
                                                             (wit_ssrterm))), 
                                                             (wit_ssrdgens)));
                                     Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.PairArg (
                                                            (Genarg.PairArg (
                                                            (wit_int), 
                                                            (wit_ssrterm))), 
                                                            (wit_ssrdgens)));
                                     Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.PairArg (
                                                             (Genarg.PairArg (
                                                             (wit_int), 
                                                             (wit_ssrterm))), 
                                                             (wit_ssrdgens)));
                                     Tacentries.arg_printer = ((fun env sigma -> 
                                                              
# 589 "plugins/ssr/ssrtacs.mlg"
               pr_ssrcongrarg 
                                                              ), (fun env sigma -> 
                                                              
# 589 "plugins/ssr/ssrtacs.mlg"
               pr_ssrcongrarg 
                                                              ), (fun env sigma -> 
                                                              
# 589 "plugins/ssr/ssrtacs.mlg"
               pr_ssrcongrarg 
                                                              ));
                                     }
let _ = (wit_ssrcongrarg, ssrcongrarg)

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrcongr" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("congr", Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_ssrcongrarg), 
                                                         Tacentries.TyNil)), 
           (fun arg ist -> 
# 600 "plugins/ssr/ssrtacs.mlg"
  let arg, dgens = arg in
  Proofview.Goal.enter begin fun _ ->
    match dgens with
    | [gens], clr -> Tacticals.tclTHEN (genstac (gens,clr)) (newssrcongrtac arg ist)
    | _ -> errorstrm (str"Dependent family abstractions not allowed in congr")
  end 
           )))]


# 614 "plugins/ssr/ssrtacs.mlg"
 

let pr_rwocc = function
  | None, None -> mt ()
  | None, occ -> pr_occ occ
  | Some clr,  _ ->  pr_clear_ne clr

let pr_ssrrwocc _ _ _ = pr_rwocc



let (wit_ssrrwocc, ssrrwocc) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrrwocc" 
                               {
                               Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                        [(Pcoq.Production.make
                                                          (Pcoq.Rule.stop)
                                                          (fun loc -> 
# 628 "plugins/ssr/ssrtacs.mlg"
           noclr 
                                                                    ));
                                                        (Pcoq.Production.make
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.stop)
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "{"))))
                                                         ((Pcoq.Symbol.nterm ssrocc)))
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "}"))))
                                                         (fun _ occ _ loc ->
                                                         
# 627 "plugins/ssr/ssrtacs.mlg"
                               mkocc occ 
                                                         ));
                                                        (Pcoq.Production.make
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.stop)
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "{"))))
                                                         ((Pcoq.Symbol.list0 (Pcoq.Symbol.nterm ssrhyp))))
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "}"))))
                                                         (fun _ clr _ loc ->
                                                         
# 626 "plugins/ssr/ssrtacs.mlg"
                                    mkclr clr 
                                                         ))]);
                               Tacentries.arg_tag = Some
                                                    (Geninterp.val_tag (Genarg.topwit wit_ssrdocc));
                               Tacentries.arg_intern = Tacentries.ArgInternWit (wit_ssrdocc);
                               Tacentries.arg_subst = Tacentries.ArgSubstWit (wit_ssrdocc);
                               Tacentries.arg_interp = Tacentries.ArgInterpWit (wit_ssrdocc);
                               Tacentries.arg_printer = ((fun env sigma -> 
                                                        
# 625 "plugins/ssr/ssrtacs.mlg"
                                                       pr_ssrrwocc 
                                                        ), (fun env sigma -> 
                                                        
# 625 "plugins/ssr/ssrtacs.mlg"
                                                       pr_ssrrwocc 
                                                        ), (fun env sigma -> 
                                                        
# 625 "plugins/ssr/ssrtacs.mlg"
                                                       pr_ssrrwocc 
                                                        ));
                               }
let _ = (wit_ssrrwocc, ssrrwocc)


# 633 "plugins/ssr/ssrtacs.mlg"
 

let pr_rwkind = function
  | RWred s -> pr_simpl s
  | RWdef -> str "/"
  | RWeq -> mt ()

let wit_ssrrwkind = add_genarg "ssrrwkind" (fun env sigma -> pr_rwkind)

let pr_rule = function
  | RWred s, _ -> pr_simpl s
  | RWdef, r-> str "/" ++ pr_term r
  | RWeq, r -> pr_term r

let pr_ssrrule _ _ _ = pr_rule

let noruleterm loc = mk_term NoFlag (mkCProp loc)



let (wit_ssrrule_ne, ssrrule_ne) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrrule_ne" 
                                   {
                                   Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                            []);
                                   Tacentries.arg_tag = Some
                                                        (Geninterp.Val.Pair (
                                                        (Geninterp.val_tag (Genarg.topwit wit_ssrrwkind)), 
                                                        (Geninterp.val_tag (Genarg.topwit wit_ssrterm))));
                                   Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.PairArg (
                                                           (wit_ssrrwkind), 
                                                           (wit_ssrterm)));
                                   Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.PairArg (
                                                          (wit_ssrrwkind), 
                                                          (wit_ssrterm)));
                                   Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.PairArg (
                                                           (wit_ssrrwkind), 
                                                           (wit_ssrterm)));
                                   Tacentries.arg_printer = ((fun env sigma -> 
                                                            
# 653 "plugins/ssr/ssrtacs.mlg"
                                                                       pr_ssrrule 
                                                            ), (fun env sigma -> 
                                                            
# 653 "plugins/ssr/ssrtacs.mlg"
                                                                       pr_ssrrule 
                                                            ), (fun env sigma -> 
                                                            
# 653 "plugins/ssr/ssrtacs.mlg"
                                                                       pr_ssrrule 
                                                            ));
                                   }
let _ = (wit_ssrrule_ne, ssrrule_ne)

let _ = let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ssreflect", "ssrtacs.mlg:8")
        ssrrule_ne
        (Pcoq.Reuse (None, [Pcoq.Production.make
                            (Pcoq.Rule.next (Pcoq.Rule.stop)
                                            ((Pcoq.Symbol.nterm ssrsimpl_ne)))
                            (fun s loc -> 
# 664 "plugins/ssr/ssrtacs.mlg"
                           RWred s, noruleterm (Some loc) 
                                          );
                           Pcoq.Production.make
                           (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.nterm test_not_ssrslashnum)))
                                           ((Pcoq.Symbol.rules [Pcoq.Rules.make 
                                                               (Pcoq.Rule.next_norec 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.nterm ssrsimpl_ne)))
                                                               (fun s loc ->
                                                               
# 662 "plugins/ssr/ssrtacs.mlg"
                               RWred s, noruleterm (Some loc) 
                                                               );
                                                               Pcoq.Rules.make 
                                                               (Pcoq.Rule.next_norec 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.nterm ssrterm)))
                                                               (fun t loc ->
                                                               
# 661 "plugins/ssr/ssrtacs.mlg"
                           RWeq, t 
                                                               );
                                                               Pcoq.Rules.make 
                                                               (Pcoq.Rule.next_norec 
                                                               (Pcoq.Rule.next_norec 
                                                               (Pcoq.Rule.stop)
                                                               ((Pcoq.Symbol.token (Tok.PKEYWORD ("/")))))
                                                               ((Pcoq.Symbol.nterm ssrterm)))
                                                               (fun t _
                                                               loc -> 
                                                               
# 660 "plugins/ssr/ssrtacs.mlg"
                                RWdef, t 
                                                               )])))
                           (fun x _ loc -> 
# 663 "plugins/ssr/ssrtacs.mlg"
               x 
                                           )]))
        in ()

let (wit_ssrrule, ssrrule) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrrule" 
                             {
                             Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                      [(Pcoq.Production.make
                                                        (Pcoq.Rule.stop)
                                                        (fun loc -> 
# 670 "plugins/ssr/ssrtacs.mlg"
             RWred Nop, noruleterm (Some loc) 
                                                                    ));
                                                      (Pcoq.Production.make
                                                       (Pcoq.Rule.next 
                                                       (Pcoq.Rule.stop)
                                                       ((Pcoq.Symbol.nterm ssrrule_ne)))
                                                       (fun r loc -> 
# 669 "plugins/ssr/ssrtacs.mlg"
                           r 
                                                                    ))]);
                             Tacentries.arg_tag = Some
                                                  (Geninterp.val_tag (Genarg.topwit wit_ssrrule_ne));
                             Tacentries.arg_intern = Tacentries.ArgInternWit (wit_ssrrule_ne);
                             Tacentries.arg_subst = Tacentries.ArgSubstWit (wit_ssrrule_ne);
                             Tacentries.arg_interp = Tacentries.ArgInterpWit (wit_ssrrule_ne);
                             Tacentries.arg_printer = ((fun env sigma -> 
                                                      
# 668 "plugins/ssr/ssrtacs.mlg"
                                                         pr_ssrrule 
                                                      ), (fun env sigma -> 
                                                      
# 668 "plugins/ssr/ssrtacs.mlg"
                                                         pr_ssrrule 
                                                      ), (fun env sigma -> 
                                                      
# 668 "plugins/ssr/ssrtacs.mlg"
                                                         pr_ssrrule 
                                                      ));
                             }
let _ = (wit_ssrrule, ssrrule)


# 675 "plugins/ssr/ssrtacs.mlg"
 
let pr_rwdir = function L2R -> mt() | R2L -> str "-"

let pr_option f = function None -> mt() | Some x -> f x
let pr_pattern_squarep= pr_option (fun r -> str "[" ++ pr_rpattern r ++ str "]")
let pr_ssrpattern_squarep _ _ _ = pr_pattern_squarep
let pr_rwarg ((d, m), ((docc, rx), r)) =
  pr_rwdir d ++ pr_mult m ++ pr_rwocc docc ++ pr_pattern_squarep rx ++ pr_rule r

let pr_ssrrwarg _ _ _ = pr_rwarg



let (wit_ssrpattern_squarep, ssrpattern_squarep) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrpattern_squarep" 
                                                   {
                                                   Tacentries.arg_parsing = 
                                                   Vernacextend.Arg_rules (
                                                   [(Pcoq.Production.make
                                                     (Pcoq.Rule.stop)
                                                     (fun loc -> 
# 691 "plugins/ssr/ssrtacs.mlg"
             None 
                                                                 ));
                                                   (Pcoq.Production.make
                                                    (Pcoq.Rule.next (Pcoq.Rule.next 
                                                                    (Pcoq.Rule.next 
                                                                    (Pcoq.Rule.stop)
                                                                    ((Pcoq.Symbol.token (Pcoq.terminal "["))))
                                                                    ((Pcoq.Symbol.nterm rpattern)))
                                                                    ((Pcoq.Symbol.token (Pcoq.terminal "]"))))
                                                    (fun _ rdx _ loc -> 
# 690 "plugins/ssr/ssrtacs.mlg"
                                   Some rdx 
                                                                    ))]);
                                                   Tacentries.arg_tag = 
                                                   Some
                                                   (Geninterp.Val.Opt 
                                                   (Geninterp.val_tag (Genarg.topwit wit_rpattern)));
                                                   Tacentries.arg_intern = 
                                                   Tacentries.ArgInternWit (Genarg.OptArg 
                                                   (wit_rpattern));
                                                   Tacentries.arg_subst = 
                                                   Tacentries.ArgSubstWit (Genarg.OptArg 
                                                   (wit_rpattern));
                                                   Tacentries.arg_interp = 
                                                   Tacentries.ArgInterpWit (Genarg.OptArg 
                                                   (wit_rpattern));
                                                   Tacentries.arg_printer = 
                                                   ((fun env sigma -> 
                                                   
# 689 "plugins/ssr/ssrtacs.mlg"
                                      pr_ssrpattern_squarep 
                                                   ), (fun env sigma -> 
                                                   
# 689 "plugins/ssr/ssrtacs.mlg"
                                      pr_ssrpattern_squarep 
                                                   ), (fun env sigma -> 
                                                   
# 689 "plugins/ssr/ssrtacs.mlg"
                                      pr_ssrpattern_squarep 
                                                   ));
                                                   }
let _ = (wit_ssrpattern_squarep, ssrpattern_squarep)

let (wit_ssrpattern_ne_squarep, ssrpattern_ne_squarep) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrpattern_ne_squarep" 
                                                         {
                                                         Tacentries.arg_parsing = 
                                                         Vernacextend.Arg_rules (
                                                         [(Pcoq.Production.make
                                                           (Pcoq.Rule.next 
                                                           (Pcoq.Rule.next 
                                                           (Pcoq.Rule.next 
                                                           (Pcoq.Rule.stop)
                                                           ((Pcoq.Symbol.token (Pcoq.terminal "["))))
                                                           ((Pcoq.Symbol.nterm rpattern)))
                                                           ((Pcoq.Symbol.token (Pcoq.terminal "]"))))
                                                           (fun _ rdx _
                                                           loc -> 
# 696 "plugins/ssr/ssrtacs.mlg"
                                   Some rdx 
                                                                  ))]);
                                                         Tacentries.arg_tag = 
                                                         Some
                                                         (Geninterp.Val.Opt 
                                                         (Geninterp.val_tag (Genarg.topwit wit_rpattern)));
                                                         Tacentries.arg_intern = 
                                                         Tacentries.ArgInternWit (Genarg.OptArg 
                                                         (wit_rpattern));
                                                         Tacentries.arg_subst = 
                                                         Tacentries.ArgSubstWit (Genarg.OptArg 
                                                         (wit_rpattern));
                                                         Tacentries.arg_interp = 
                                                         Tacentries.ArgInterpWit (Genarg.OptArg 
                                                         (wit_rpattern));
                                                         Tacentries.arg_printer = 
                                                         ((fun env sigma -> 
                                                         
# 695 "plugins/ssr/ssrtacs.mlg"
                                      pr_ssrpattern_squarep 
                                                         ), (fun env sigma -> 
                                                         
# 695 "plugins/ssr/ssrtacs.mlg"
                                      pr_ssrpattern_squarep 
                                                         ), (fun env sigma -> 
                                                         
# 695 "plugins/ssr/ssrtacs.mlg"
                                      pr_ssrpattern_squarep 
                                                         ));
                                                         }
let _ = (wit_ssrpattern_ne_squarep, ssrpattern_ne_squarep)

let (wit_ssrrwarg, ssrrwarg) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrrwarg" 
                               {
                               Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                        [(Pcoq.Production.make
                                                          (Pcoq.Rule.next 
                                                          (Pcoq.Rule.stop)
                                                          ((Pcoq.Symbol.nterm ssrrule_ne)))
                                                          (fun r loc -> 
# 720 "plugins/ssr/ssrtacs.mlg"
      mk_rwarg norwmult norwocc r 
                                                                    ));
                                                        (Pcoq.Production.make
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.stop)
                                                         ((Pcoq.Symbol.nterm ssrpattern_ne_squarep)))
                                                         ((Pcoq.Symbol.nterm ssrrule_ne)))
                                                         (fun r rx loc -> 
# 718 "plugins/ssr/ssrtacs.mlg"
      mk_rwarg norwmult (noclr, rx) r 
                                                                    ));
                                                        (Pcoq.Production.make
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.stop)
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "{"))))
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "}"))))
                                                         ((Pcoq.Symbol.nterm ssrpattern_squarep)))
                                                         ((Pcoq.Symbol.nterm ssrrule_ne)))
                                                         (fun r rx _ _ loc ->
                                                         
# 716 "plugins/ssr/ssrtacs.mlg"
      mk_rwarg norwmult (nodocc, rx) r 
                                                         ));
                                                        (Pcoq.Production.make
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.stop)
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "{"))))
                                                         ((Pcoq.Symbol.nterm ssrocc)))
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "}"))))
                                                         ((Pcoq.Symbol.nterm ssrpattern_squarep)))
                                                         ((Pcoq.Symbol.nterm ssrrule_ne)))
                                                         (fun r rx _ occ _
                                                         loc -> 
# 714 "plugins/ssr/ssrtacs.mlg"
      mk_rwarg norwmult (mkocc occ, rx) r 
                                                                ));
                                                        (Pcoq.Production.make
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.stop)
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "{"))))
                                                         ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm ssrhyp)))))
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "}"))))
                                                         ((Pcoq.Symbol.nterm ssrrule)))
                                                         (fun r _ clr _
                                                         loc -> 
# 712 "plugins/ssr/ssrtacs.mlg"
      mk_rwarg norwmult (mkclr clr, None) r 
                                                                ));
                                                        (Pcoq.Production.make
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.stop)
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "{"))))
                                                         ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm ssrhyp)))))
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "}"))))
                                                         ((Pcoq.Symbol.nterm ssrpattern_ne_squarep)))
                                                         ((Pcoq.Symbol.nterm ssrrule_ne)))
                                                         (fun r rx _ clr _
                                                         loc -> 
# 710 "plugins/ssr/ssrtacs.mlg"
      mk_rwarg norwmult (mkclr clr, rx) r 
                                                                ));
                                                        (Pcoq.Production.make
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.stop)
                                                         ((Pcoq.Symbol.nterm ssrmult_ne)))
                                                         ((Pcoq.Symbol.nterm ssrrwocc)))
                                                         ((Pcoq.Symbol.nterm ssrpattern_squarep)))
                                                         ((Pcoq.Symbol.nterm ssrrule_ne)))
                                                         (fun r rx docc m
                                                         loc -> 
# 708 "plugins/ssr/ssrtacs.mlg"
      mk_rwarg (L2R, m) (docc, rx) r 
                                                                ));
                                                        (Pcoq.Production.make
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.stop)
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "-/"))))
                                                         ((Pcoq.Symbol.nterm ssrterm)))
                                                         (fun t _ loc -> 
# 706 "plugins/ssr/ssrtacs.mlg"
      mk_rwarg (R2L, nomult) norwocc (RWdef, t) 
                                                                    ));
                                                        (Pcoq.Production.make
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.next 
                                                         (Pcoq.Rule.stop)
                                                         ((Pcoq.Symbol.token (Pcoq.terminal "-"))))
                                                         ((Pcoq.Symbol.nterm ssrmult)))
                                                         ((Pcoq.Symbol.nterm ssrrwocc)))
                                                         ((Pcoq.Symbol.nterm ssrpattern_squarep)))
                                                         ((Pcoq.Symbol.nterm ssrrule_ne)))
                                                         (fun r rx docc m _
                                                         loc -> 
# 704 "plugins/ssr/ssrtacs.mlg"
      mk_rwarg (R2L, m) (docc, rx) r 
                                                                ))]);
                               Tacentries.arg_tag = Some
                                                    (Geninterp.Val.Pair (
                                                    (Geninterp.Val.Pair (
                                                    (Geninterp.val_tag (Genarg.topwit wit_ssrdir)), 
                                                    (Geninterp.val_tag (Genarg.topwit wit_ssrmult)))), 
                                                    (Geninterp.Val.Pair (
                                                    (Geninterp.Val.Pair (
                                                    (Geninterp.val_tag (Genarg.topwit wit_ssrdocc)), 
                                                    (Geninterp.Val.Opt 
                                                    (Geninterp.val_tag (Genarg.topwit wit_rpattern))))), 
                                                    (Geninterp.val_tag (Genarg.topwit wit_ssrrule))))));
                               Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.PairArg (
                                                       (Genarg.PairArg (
                                                       (wit_ssrdir), 
                                                       (wit_ssrmult))), 
                                                       (Genarg.PairArg (
                                                       (Genarg.PairArg (
                                                       (wit_ssrdocc), 
                                                       (Genarg.OptArg 
                                                       (wit_rpattern)))), 
                                                       (wit_ssrrule)))));
                               Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.PairArg (
                                                      (Genarg.PairArg (
                                                      (wit_ssrdir), (wit_ssrmult))), 
                                                      (Genarg.PairArg (
                                                      (Genarg.PairArg (
                                                      (wit_ssrdocc), 
                                                      (Genarg.OptArg 
                                                      (wit_rpattern)))), 
                                                      (wit_ssrrule)))));
                               Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.PairArg (
                                                       (Genarg.PairArg (
                                                       (wit_ssrdir), 
                                                       (wit_ssrmult))), 
                                                       (Genarg.PairArg (
                                                       (Genarg.PairArg (
                                                       (wit_ssrdocc), 
                                                       (Genarg.OptArg 
                                                       (wit_rpattern)))), 
                                                       (wit_ssrrule)))));
                               Tacentries.arg_printer = ((fun env sigma -> 
                                                        
# 702 "plugins/ssr/ssrtacs.mlg"
               pr_ssrrwarg 
                                                        ), (fun env sigma -> 
                                                        
# 702 "plugins/ssr/ssrtacs.mlg"
               pr_ssrrwarg 
                                                        ), (fun env sigma -> 
                                                        
# 702 "plugins/ssr/ssrtacs.mlg"
               pr_ssrrwarg 
                                                        ));
                               }
let _ = (wit_ssrrwarg, ssrrwarg)

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrinstofruleL2R" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("ssrinstancesofruleL2R", 
                            Tacentries.TyArg (Extend.TUentry (Genarg.get_arg_tag wit_ssrterm), 
                            Tacentries.TyNil)), (fun arg ist -> 
# 724 "plugins/ssr/ssrtacs.mlg"
                                                ssrinstancesofrule ist L2R arg 
                                                )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrinstofruleR2L" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("ssrinstancesofruleR2L", 
                            Tacentries.TyArg (Extend.TUentry (Genarg.get_arg_tag wit_ssrterm), 
                            Tacentries.TyNil)), (fun arg ist -> 
# 727 "plugins/ssr/ssrtacs.mlg"
                                                ssrinstancesofrule ist R2L arg 
                                                )))]


# 734 "plugins/ssr/ssrtacs.mlg"
 

let pr_ssrrwargs _ _ _ rwargs = pr_list spc pr_rwarg rwargs



let (wit_ssrrwargs, ssrrwargs) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrrwargs" 
                                 {
                                 Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                          []);
                                 Tacentries.arg_tag = Some
                                                      (Geninterp.Val.List 
                                                      (Geninterp.val_tag (Genarg.topwit wit_ssrrwarg)));
                                 Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.ListArg 
                                                         (wit_ssrrwarg));
                                 Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.ListArg 
                                                        (wit_ssrrwarg));
                                 Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.ListArg 
                                                         (wit_ssrrwarg));
                                 Tacentries.arg_printer = ((fun env sigma -> 
                                                          
# 740 "plugins/ssr/ssrtacs.mlg"
                                                              pr_ssrrwargs 
                                                          ), (fun env sigma -> 
                                                          
# 740 "plugins/ssr/ssrtacs.mlg"
                                                              pr_ssrrwargs 
                                                          ), (fun env sigma -> 
                                                          
# 740 "plugins/ssr/ssrtacs.mlg"
                                                              pr_ssrrwargs 
                                                          ));
                                 }
let _ = (wit_ssrrwargs, ssrrwargs)


# 743 "plugins/ssr/ssrtacs.mlg"
 

let ssr_rw_syntax = Summary.ref ~name:"SSR:rewrite" true

let () =
  Goptions.(declare_bool_option
    { optstage = Summary.Stage.Synterp;
      optkey   = ["SsrRewrite"];
      optread  = (fun _ -> !ssr_rw_syntax);
      optdepr  = None;
      optwrite = (fun b -> ssr_rw_syntax := b) })

let lbrace = Char.chr 123
(** Workaround to a limitation of coqpp *)

let test_ssr_rw_syntax =
  let test kwstate strm =
    if not !ssr_rw_syntax then raise Stream.Failure else
    if is_ssr_loaded () then () else
    match LStream.peek_nth kwstate 0 strm with
    | Tok.KEYWORD key when List.mem key.[0] [lbrace; '['; '/'] -> ()
    | _ -> raise Stream.Failure in
  Pcoq.Entry.(of_parser "test_ssr_rw_syntax" { parser_fun = test })



let _ = let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ssreflect", "ssrtacs.mlg:9")
        ssrrwargs
        (Pcoq.Reuse (None, [Pcoq.Production.make
                            (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                            ((Pcoq.Symbol.nterm test_ssr_rw_syntax)))
                                            ((Pcoq.Symbol.list1 ((Pcoq.Symbol.nterm ssrrwarg)))))
                            (fun a _ loc -> 
# 771 "plugins/ssr/ssrtacs.mlg"
                                                                a 
                                            )]))
        in ()

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrrewrite" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("rewrite", Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_ssrrwargs), 
                                                           Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_ssrclauses), 
                                                           Tacentries.TyNil))), 
           (fun args clauses ist -> 
# 778 "plugins/ssr/ssrtacs.mlg"
      tclCLAUSES (ssrrewritetac ist args) clauses 
           )))]


# 783 "plugins/ssr/ssrtacs.mlg"
 

let pr_unlockarg (occ, t) =
  (match occ with
   | None -> Pp.mt ()
   | _ -> pr_occ occ) ++ pr_term t
let pr_ssrunlockarg _ _ _ = pr_unlockarg



let (wit_ssrunlockarg, ssrunlockarg) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrunlockarg" 
                                       {
                                       Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                                [(Pcoq.Production.make
                                                                  (Pcoq.Rule.next 
                                                                  (Pcoq.Rule.stop)
                                                                  ((Pcoq.Symbol.nterm ssrterm)))
                                                                  (fun t
                                                                  loc -> 
                                                                  
# 796 "plugins/ssr/ssrtacs.mlg"
                         None, t 
                                                                  ));
                                                                (Pcoq.Production.make
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.next 
                                                                 (Pcoq.Rule.stop)
                                                                 ((Pcoq.Symbol.token (Pcoq.terminal "{"))))
                                                                 ((Pcoq.Symbol.nterm ssrocc)))
                                                                 ((Pcoq.Symbol.token (Pcoq.terminal "}"))))
                                                                 ((Pcoq.Symbol.nterm ssrterm)))
                                                                 (fun t _ occ
                                                                 _ loc -> 
                                                                 
# 795 "plugins/ssr/ssrtacs.mlg"
                                             occ, t 
                                                                 ))]);
                                       Tacentries.arg_tag = Some
                                                            (Geninterp.Val.Pair (
                                                            (Geninterp.val_tag (Genarg.topwit wit_ssrocc)), 
                                                            (Geninterp.val_tag (Genarg.topwit wit_ssrterm))));
                                       Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.PairArg (
                                                               (wit_ssrocc), 
                                                               (wit_ssrterm)));
                                       Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.PairArg (
                                                              (wit_ssrocc), 
                                                              (wit_ssrterm)));
                                       Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.PairArg (
                                                               (wit_ssrocc), 
                                                               (wit_ssrterm)));
                                       Tacentries.arg_printer = ((fun env sigma -> 
                                                                
# 794 "plugins/ssr/ssrtacs.mlg"
               pr_ssrunlockarg 
                                                                ), (fun env sigma -> 
                                                                
# 794 "plugins/ssr/ssrtacs.mlg"
               pr_ssrunlockarg 
                                                                ), (fun env sigma -> 
                                                                
# 794 "plugins/ssr/ssrtacs.mlg"
               pr_ssrunlockarg 
                                                                ));
                                       }
let _ = (wit_ssrunlockarg, ssrunlockarg)


# 799 "plugins/ssr/ssrtacs.mlg"
 

let pr_ssrunlockargs _ _ _ args = pr_list spc pr_unlockarg args



let (wit_ssrunlockargs, ssrunlockargs) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrunlockargs" 
                                         {
                                         Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                                  [(Pcoq.Production.make
                                                                    (Pcoq.Rule.next 
                                                                    (Pcoq.Rule.stop)
                                                                    ((Pcoq.Symbol.list0 (Pcoq.Symbol.nterm ssrunlockarg))))
                                                                    (fun args
                                                                    loc -> 
                                                                    
# 807 "plugins/ssr/ssrtacs.mlg"
                                      args 
                                                                    ))]);
                                         Tacentries.arg_tag = Some
                                                              (Geninterp.Val.List 
                                                              (Geninterp.val_tag (Genarg.topwit wit_ssrunlockarg)));
                                         Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.ListArg 
                                                                 (wit_ssrunlockarg));
                                         Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.ListArg 
                                                                (wit_ssrunlockarg));
                                         Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.ListArg 
                                                                 (wit_ssrunlockarg));
                                         Tacentries.arg_printer = ((fun env sigma -> 
                                                                  
# 806 "plugins/ssr/ssrtacs.mlg"
               pr_ssrunlockargs 
                                                                  ), (fun env sigma -> 
                                                                  
# 806 "plugins/ssr/ssrtacs.mlg"
               pr_ssrunlockargs 
                                                                  ), (fun env sigma -> 
                                                                  
# 806 "plugins/ssr/ssrtacs.mlg"
               pr_ssrunlockargs 
                                                                  ));
                                         }
let _ = (wit_ssrunlockargs, ssrunlockargs)

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrunlock" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("unlock", Tacentries.TyArg (
                                                          Extend.TUentry (Genarg.get_arg_tag wit_ssrunlockargs), 
                                                          Tacentries.TyArg (
                                                          Extend.TUentry (Genarg.get_arg_tag wit_ssrclauses), 
                                                          Tacentries.TyNil))), 
           (fun args clauses ist -> 
# 812 "plugins/ssr/ssrtacs.mlg"
      tclCLAUSES (unlocktac ist args) clauses 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrpose" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("pose", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrfixfwd), 
                                                        Tacentries.TyNil)), 
           (fun ffwd ist -> 
# 819 "plugins/ssr/ssrtacs.mlg"
                                  ssrposetac ffwd 
           )));
         (Tacentries.TyML (Tacentries.TyIdent ("pose", Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_ssrcofixfwd), 
                                                       Tacentries.TyNil)), 
          (fun ffwd ist -> 
# 820 "plugins/ssr/ssrtacs.mlg"
                                    ssrposetac ffwd 
          )));
         (Tacentries.TyML (Tacentries.TyIdent ("pose", Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_ssrfwdid), 
                                                       Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_ssrposefwd), 
                                                       Tacentries.TyNil))), 
          (fun id fwd ist -> 
# 821 "plugins/ssr/ssrtacs.mlg"
                                               ssrposetac (id, fwd) 
          )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrset" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("set", Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_ssrfwdid), 
                                                       Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_ssrsetfwd), 
                                                       Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_ssrclauses), 
                                                       Tacentries.TyNil)))), 
           (fun id fwd clauses ist -> 
# 830 "plugins/ssr/ssrtacs.mlg"
    tclCLAUSES (ssrsettac id fwd) clauses 
           )))]


# 840 "plugins/ssr/ssrtacs.mlg"
 

  let tclabstractkey =
    let open Pptactic in
    let prods = [ TacTerm "abstract"; mk_non_term wit_ssrdgens (Names.Id.of_string "gens") ] in
    let tac = begin fun args ist -> match args with
      | [gens] ->
        let gens = cast_arg wit_ssrdgens gens in
        if List.length (fst gens) <> 1 then
          errorstrm (str"dependents switches '/' not allowed here");
        Ssripats.ssrabstract (ssrdgens_of_parsed_dgens gens)
      | _ -> assert false
      end in
    register_ssrtac "tclabstract" tac prods

let tclabstract_expr ?loc gens =
  let arg = in_gen (rawwit wit_ssrdgens) gens in
  ssrtac_expr ?loc tclabstractkey [arg]



let _ = let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ssreflect", "ssrtacs.mlg:10")
        ltac_expr
        (Pcoq.Reuse (Some
        ("3"), [Pcoq.Production.make
                (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.stop)
                                                ((Pcoq.Symbol.token (Tok.PIDENT (Some
                                                ("abstract"))))))
                                ((Pcoq.Symbol.nterm ssrdgens)))
                (fun gens _ loc -> 
# 865 "plugins/ssr/ssrtacs.mlg"
                                               tclabstract_expr ~loc gens 
                                   )]))
        in ()

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrhave" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("have", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrhavefwdwbinders), 
                                                        Tacentries.TyNil)), 
           (fun fwd ist -> 
# 870 "plugins/ssr/ssrtacs.mlg"
    havetac ist fwd false false 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrhavesuff" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("have", Tacentries.TyIdent ("suff", 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrhpats_nobs), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrhavefwd), 
                                                        Tacentries.TyNil)))), 
           (fun pats fwd ist -> 
# 875 "plugins/ssr/ssrtacs.mlg"
    havetac ist (false,(pats,fwd)) true false 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrhavesuffices" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("have", Tacentries.TyIdent ("suffices", 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrhpats_nobs), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrhavefwd), 
                                                        Tacentries.TyNil)))), 
           (fun pats fwd ist -> 
# 880 "plugins/ssr/ssrtacs.mlg"
    havetac ist (false,(pats,fwd)) true false 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrsuffhave" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("suff", Tacentries.TyIdent ("have", 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrhpats_nobs), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrhavefwd), 
                                                        Tacentries.TyNil)))), 
           (fun pats fwd ist -> 
# 885 "plugins/ssr/ssrtacs.mlg"
    havetac ist (false,(pats,fwd)) true true 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrsufficeshave" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("suffices", Tacentries.TyIdent ("have", 
                                                            Tacentries.TyArg (
                                                            Extend.TUentry (Genarg.get_arg_tag wit_ssrhpats_nobs), 
                                                            Tacentries.TyArg (
                                                            Extend.TUentry (Genarg.get_arg_tag wit_ssrhavefwd), 
                                                            Tacentries.TyNil)))), 
           (fun pats fwd ist -> 
# 890 "plugins/ssr/ssrtacs.mlg"
    havetac ist (false,(pats,fwd)) true true 
           )))]


# 895 "plugins/ssr/ssrtacs.mlg"
 

let pr_ssrsufffwdwbinders env sigma _ _ prt (hpats, (fwd, hint)) =
  pr_hpats hpats ++ pr_fwd fwd ++ pr_hint env sigma prt hint



let (wit_ssrsufffwd, ssrsufffwd) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrsufffwd" 
                                   {
                                   Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                            [(Pcoq.Production.make
                                                              (Pcoq.Rule.next 
                                                              (Pcoq.Rule.next 
                                                              (Pcoq.Rule.next 
                                                              (Pcoq.Rule.next 
                                                              (Pcoq.Rule.next 
                                                              (Pcoq.Rule.stop)
                                                              ((Pcoq.Symbol.nterm ssrhpats)))
                                                              ((Pcoq.Symbol.list0 (Pcoq.Symbol.nterm ssrbinder))))
                                                              ((Pcoq.Symbol.token (Pcoq.terminal ":"))))
                                                              ((Pcoq.Symbol.nterm ast_closure_lterm)))
                                                              ((Pcoq.Symbol.nterm ssrhint)))
                                                              (fun hint t _
                                                              bs pats loc ->
                                                              
# 905 "plugins/ssr/ssrtacs.mlg"
    let ((clr, pats), binders), simpl = pats in
    let allbs = intro_id_to_binder binders @ bs in
    let allbinders = binders @ List.flatten (binder_to_intro_id bs) in
    let fwd = mkFwdHint ":" t in
    (((clr, pats), allbinders), simpl), (bind_fwd allbs fwd, hint) 
                                                              ))]);
                                   Tacentries.arg_tag = Some
                                                        (Geninterp.Val.Pair (
                                                        (Geninterp.val_tag (Genarg.topwit wit_ssrhpats)), 
                                                        (Geninterp.Val.Pair (
                                                        (Geninterp.val_tag (Genarg.topwit wit_ssrfwd)), 
                                                        (Geninterp.val_tag (Genarg.topwit wit_ssrhint))))));
                                   Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.PairArg (
                                                           (wit_ssrhpats), 
                                                           (Genarg.PairArg (
                                                           (wit_ssrfwd), 
                                                           (wit_ssrhint)))));
                                   Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.PairArg (
                                                          (wit_ssrhpats), 
                                                          (Genarg.PairArg (
                                                          (wit_ssrfwd), 
                                                          (wit_ssrhint)))));
                                   Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.PairArg (
                                                           (wit_ssrhpats), 
                                                           (Genarg.PairArg (
                                                           (wit_ssrfwd), 
                                                           (wit_ssrhint)))));
                                   Tacentries.arg_printer = ((fun env sigma -> 
                                                            
# 903 "plugins/ssr/ssrtacs.mlg"
                                                        pr_ssrsufffwdwbinders env sigma 
                                                            ), (fun env sigma -> 
                                                            
# 903 "plugins/ssr/ssrtacs.mlg"
                                                        pr_ssrsufffwdwbinders env sigma 
                                                            ), (fun env sigma -> 
                                                            
# 903 "plugins/ssr/ssrtacs.mlg"
                                                        pr_ssrsufffwdwbinders env sigma 
                                                            ));
                                   }
let _ = (wit_ssrsufffwd, ssrsufffwd)

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrsuff" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("suff", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrsufffwd), 
                                                        Tacentries.TyNil)), 
           (fun fwd ist -> 
# 914 "plugins/ssr/ssrtacs.mlg"
                                  sufftac ist fwd 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrsuffices" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("suffices", Tacentries.TyArg (
                                                            Extend.TUentry (Genarg.get_arg_tag wit_ssrsufffwd), 
                                                            Tacentries.TyNil)), 
           (fun fwd ist -> 
# 918 "plugins/ssr/ssrtacs.mlg"
                                      sufftac ist fwd 
           )))]


# 925 "plugins/ssr/ssrtacs.mlg"
 

let pr_ssrwlogfwd _ _ _ (gens, t) =
  str ":" ++ pr_list mt pr_wgen gens ++ spc() ++ pr_fwd t



let (wit_ssrwlogfwd, ssrwlogfwd) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssrwlogfwd" 
                                   {
                                   Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                            [(Pcoq.Production.make
                                                              (Pcoq.Rule.next 
                                                              (Pcoq.Rule.next 
                                                              (Pcoq.Rule.next 
                                                              (Pcoq.Rule.next 
                                                              (Pcoq.Rule.stop)
                                                              ((Pcoq.Symbol.token (Pcoq.terminal ":"))))
                                                              ((Pcoq.Symbol.list0 (Pcoq.Symbol.nterm ssrwgen))))
                                                              ((Pcoq.Symbol.token (Pcoq.terminal "/"))))
                                                              ((Pcoq.Symbol.nterm ast_closure_lterm)))
                                                              (fun t _ gens _
                                                              loc -> 
                                                              
# 934 "plugins/ssr/ssrtacs.mlg"
                                                           gens, mkFwdHint "/" t
                                                              ))]);
                                   Tacentries.arg_tag = Some
                                                        (Geninterp.Val.Pair (
                                                        (Geninterp.Val.List 
                                                        (Geninterp.val_tag (Genarg.topwit wit_ssrwgen))), 
                                                        (Geninterp.val_tag (Genarg.topwit wit_ssrfwd))));
                                   Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.PairArg (
                                                           (Genarg.ListArg 
                                                           (wit_ssrwgen)), 
                                                           (wit_ssrfwd)));
                                   Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.PairArg (
                                                          (Genarg.ListArg 
                                                          (wit_ssrwgen)), 
                                                          (wit_ssrfwd)));
                                   Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.PairArg (
                                                           (Genarg.ListArg 
                                                           (wit_ssrwgen)), 
                                                           (wit_ssrfwd)));
                                   Tacentries.arg_printer = ((fun env sigma -> 
                                                            
# 933 "plugins/ssr/ssrtacs.mlg"
                                      pr_ssrwlogfwd 
                                                            ), (fun env sigma -> 
                                                            
# 933 "plugins/ssr/ssrtacs.mlg"
                                      pr_ssrwlogfwd 
                                                            ), (fun env sigma -> 
                                                            
# 933 "plugins/ssr/ssrtacs.mlg"
                                      pr_ssrwlogfwd 
                                                            ));
                                   }
let _ = (wit_ssrwlogfwd, ssrwlogfwd)

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrwlog" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("wlog", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrhpats_nobs), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrwlogfwd), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrhint), 
                                                        Tacentries.TyNil)))), 
           (fun pats fwd hint ist -> 
# 940 "plugins/ssr/ssrtacs.mlg"
    wlogtac ist pats fwd hint false `NoGen 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrwlogs" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("wlog", Tacentries.TyIdent ("suff", 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrhpats_nobs), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrwlogfwd), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrhint), 
                                                        Tacentries.TyNil))))), 
           (fun pats fwd hint ist -> 
# 945 "plugins/ssr/ssrtacs.mlg"
    wlogtac ist pats fwd hint true `NoGen 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrwlogss" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("wlog", Tacentries.TyIdent ("suffices", 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrhpats_nobs), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrwlogfwd), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrhint), 
                                                        Tacentries.TyNil))))), 
           (fun pats fwd hint ist -> 
# 950 "plugins/ssr/ssrtacs.mlg"
    wlogtac ist pats fwd hint true `NoGen 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrwithoutloss" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("without", Tacentries.TyIdent ("loss", 
                                                           Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_ssrhpats_nobs), 
                                                           Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_ssrwlogfwd), 
                                                           Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_ssrhint), 
                                                           Tacentries.TyNil))))), 
           (fun pats fwd hint ist -> 
# 955 "plugins/ssr/ssrtacs.mlg"
    wlogtac ist pats fwd hint false `NoGen 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrwithoutlosss" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("without", Tacentries.TyIdent ("loss", 
                                                           Tacentries.TyIdent ("suff", 
                                                           Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_ssrhpats_nobs), 
                                                           Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_ssrwlogfwd), 
                                                           Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_ssrhint), 
                                                           Tacentries.TyNil)))))), 
           (fun pats fwd hint ist -> 
# 961 "plugins/ssr/ssrtacs.mlg"
    wlogtac ist pats fwd hint true `NoGen 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrwithoutlossss" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("without", Tacentries.TyIdent ("loss", 
                                                           Tacentries.TyIdent ("suffices", 
                                                           Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_ssrhpats_nobs), 
                                                           Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_ssrwlogfwd), 
                                                           Tacentries.TyArg (
                                                           Extend.TUentry (Genarg.get_arg_tag wit_ssrhint), 
                                                           Tacentries.TyNil)))))), 
           (fun pats fwd hint ist -> 
# 967 "plugins/ssr/ssrtacs.mlg"
    wlogtac ist pats fwd hint true `NoGen 
           )))]


# 970 "plugins/ssr/ssrtacs.mlg"
 

(* Generally have *)
let pr_idcomma _ _ _ = function
  | None -> mt()
  | Some None -> str"_, "
  | Some (Some id) -> pr_id id ++ str", "



let (wit_ssr_idcomma, ssr_idcomma) = Tacentries.argument_extend ~plugin:"coq-core.plugins.ssreflect" ~name:"ssr_idcomma" 
                                     {
                                     Tacentries.arg_parsing = Vernacextend.Arg_rules (
                                                              [(Pcoq.Production.make
                                                                (Pcoq.Rule.stop)
                                                                (fun loc -> 
# 981 "plugins/ssr/ssrtacs.mlg"
             None 
                                                                    ))]);
                                     Tacentries.arg_tag = Some
                                                          (Geninterp.Val.Opt 
                                                          (Geninterp.Val.Opt 
                                                          (Geninterp.val_tag (Genarg.topwit wit_ident))));
                                     Tacentries.arg_intern = Tacentries.ArgInternWit (Genarg.OptArg 
                                                             (Genarg.OptArg 
                                                             (wit_ident)));
                                     Tacentries.arg_subst = Tacentries.ArgSubstWit (Genarg.OptArg 
                                                            (Genarg.OptArg 
                                                            (wit_ident)));
                                     Tacentries.arg_interp = Tacentries.ArgInterpWit (Genarg.OptArg 
                                                             (Genarg.OptArg 
                                                             (wit_ident)));
                                     Tacentries.arg_printer = ((fun env sigma -> 
                                                              
# 980 "plugins/ssr/ssrtacs.mlg"
                                                                      pr_idcomma 
                                                              ), (fun env sigma -> 
                                                              
# 980 "plugins/ssr/ssrtacs.mlg"
                                                                      pr_idcomma 
                                                              ), (fun env sigma -> 
                                                              
# 980 "plugins/ssr/ssrtacs.mlg"
                                                                      pr_idcomma 
                                                              ));
                                     }
let _ = (wit_ssr_idcomma, ssr_idcomma)


# 984 "plugins/ssr/ssrtacs.mlg"
 

let test_idcomma =
  let open Pcoq.Lookahead in
  to_entry "test_idcomma" begin
    (lk_ident <+> lk_kw "_") >> lk_kw ","
  end



let _ = let () =
        Egramml.grammar_extend ~plugin_uid:("coq-core.plugins.ssreflect", "ssrtacs.mlg:11")
        ssr_idcomma
        (Pcoq.Reuse (None, [Pcoq.Production.make
                            (Pcoq.Rule.next (Pcoq.Rule.next (Pcoq.Rule.next 
                                                            (Pcoq.Rule.stop)
                                                            ((Pcoq.Symbol.nterm test_idcomma)))
                                                            ((Pcoq.Symbol.rules 
                                                            [Pcoq.Rules.make 
                                                            (Pcoq.Rule.next_norec 
                                                            (Pcoq.Rule.stop)
                                                            ((Pcoq.Symbol.token (Tok.PKEYWORD ("_")))))
                                                            (fun _ loc -> 
                                                            
# 997 "plugins/ssr/ssrtacs.mlg"
                                                               None 
                                                            );
                                                            Pcoq.Rules.make 
                                                            (Pcoq.Rule.next_norec 
                                                            (Pcoq.Rule.stop)
                                                            ((Pcoq.Symbol.token (Tok.PIDENT (None)))))
                                                            (fun id loc -> 
                                                            
# 997 "plugins/ssr/ssrtacs.mlg"
                           Some (Id.of_string id) 
                                                            )])))
                                            ((Pcoq.Symbol.token (Tok.PKEYWORD (",")))))
                            (fun _ ip _ loc -> 
# 998 "plugins/ssr/ssrtacs.mlg"
      Some ip 
                                               )]))
        in ()


# 1002 "plugins/ssr/ssrtacs.mlg"
 

let augment_preclr clr1 (((clr0, x),y),z) =
  let cl = match clr0 with
    | None -> if clr1 = [] then None else Some clr1
    | Some clr0 -> Some (clr1 @ clr0) in
  (((cl, x),y),z)



let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrgenhave" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("gen", Tacentries.TyIdent ("have", 
                                                       Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_ssrclear), 
                                                       Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_ssr_idcomma), 
                                                       Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_ssrhpats_nobs), 
                                                       Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_ssrwlogfwd), 
                                                       Tacentries.TyArg (
                                                       Extend.TUentry (Genarg.get_arg_tag wit_ssrhint), 
                                                       Tacentries.TyNil))))))), 
           (fun clr id pats fwd hint ist -> 
# 1015 "plugins/ssr/ssrtacs.mlg"
    let pats = augment_preclr clr pats in
    wlogtac ist pats fwd hint false (`Gen id) 
           )))]

let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "ssrgenhave2" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("generally", Tacentries.TyIdent ("have", 
                                                             Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_ssrclear), 
                                                             Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_ssr_idcomma), 
                                                             Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_ssrhpats_nobs), 
                                                             Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_ssrwlogfwd), 
                                                             Tacentries.TyArg (
                                                             Extend.TUentry (Genarg.get_arg_tag wit_ssrhint), 
                                                             Tacentries.TyNil))))))), 
           (fun clr id pats fwd hint ist -> 
# 1022 "plugins/ssr/ssrtacs.mlg"
    let pats = augment_preclr clr pats in
    wlogtac ist pats fwd hint false (`Gen id) 
           )))]


# 1026 "plugins/ssr/ssrtacs.mlg"
 

let check_under_arg ((_dir,mult),((_occ,_rpattern),_rule)) =
  if mult <> nomult then
    CErrors.user_err Pp.(str"under does not support multipliers")



let () = Tacentries.tactic_extend "coq-core.plugins.ssreflect" "under" ~level:0 
         [(Tacentries.TyML (Tacentries.TyIdent ("under", Tacentries.TyArg (
                                                         Extend.TUentry (Genarg.get_arg_tag wit_ssrrwarg), 
                                                         Tacentries.TyNil)), 
           (fun arg ist -> 
# 1036 "plugins/ssr/ssrtacs.mlg"
                                  
    check_under_arg arg;
    Ssrfwd.undertac ist None arg nohint
    
           )));
         (Tacentries.TyML (Tacentries.TyIdent ("under", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrrwarg), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrintros_ne), 
                                                        Tacentries.TyNil))), 
          (fun arg ipats ist -> 
# 1040 "plugins/ssr/ssrtacs.mlg"
                                                      
    check_under_arg arg;
    Ssrfwd.undertac ist (Some ipats) arg nohint
    
          )));
         (Tacentries.TyML (Tacentries.TyIdent ("under", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrrwarg), 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrintros_ne), 
                                                        Tacentries.TyIdent ("do", 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrhint3arg), 
                                                        Tacentries.TyNil))))), 
          (fun arg ipats h ist -> 
# 1044 "plugins/ssr/ssrtacs.mlg"
                                                                          
    check_under_arg arg;
    Ssrfwd.undertac ist (Some ipats) arg h
    
          )));
         (Tacentries.TyML (Tacentries.TyIdent ("under", Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrrwarg), 
                                                        Tacentries.TyIdent ("do", 
                                                        Tacentries.TyArg (
                                                        Extend.TUentry (Genarg.get_arg_tag wit_ssrhint3arg), 
                                                        Tacentries.TyNil)))), 
          (fun arg h ist -> 
# 1048 "plugins/ssr/ssrtacs.mlg"
                                                       (* implicit "=> [*|*]" *)
    check_under_arg arg;
    Ssrfwd.undertac ~pad_intro:true ist (Some [IPatAnon All]) arg h
    
          )))]


# 1054 "plugins/ssr/ssrtacs.mlg"
 

(* We wipe out all the keywords generated by the grammar rules we defined. *)
(* The user is supposed to Require Import ssreflect or Require ssreflect   *)
(* and Import ssreflect.SsrSyntax to obtain these keywords and as a         *)
(* consequence the extended ssreflect grammar.                             *)
let () = Mltop.add_init_function "coq-core.plugins.ssreflect" (fun () ->
      Pcoq.set_keyword_state !frozen_lexer) ;;



