/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.sendopts;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.modules.sendopts.DefaultProcessor;
import org.netbeans.modules.sendopts.OptionImpl;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class CommandLine {
    private static final int ERROR_BASE = 50345;
    private final Collection<? extends OptionProcessor> processors;

    CommandLine(Collection<? extends OptionProcessor> collection) {
        this.processors = collection;
    }

    public static CommandLine getDefault() {
        return new CommandLine(null);
    }

    public static CommandLine create(Class<?> ... classArray) {
        return CommandLine.createImpl(classArray);
    }

    public static CommandLine create(Object ... objectArray) {
        return CommandLine.createImpl(objectArray);
    }

    private static CommandLine createImpl(Object[] objectArray) {
        ArrayList<OptionProcessor> arrayList = new ArrayList<OptionProcessor>();
        for (Object object : objectArray) {
            Object object2;
            Class<?> clazz;
            if (object instanceof Class) {
                clazz = (Class<?>)object;
                object2 = null;
            } else {
                clazz = object.getClass();
                object2 = object;
            }
            if (OptionProcessor.class.isAssignableFrom(clazz)) {
                try {
                    if (object2 == null) {
                        object2 = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    arrayList.add((OptionProcessor)object2);
                    continue;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new IllegalStateException(reflectiveOperationException);
                }
            }
            arrayList.add(DefaultProcessor.create(clazz, object2));
        }
        return new CommandLine(arrayList);
    }

    public void process(String ... stringArray) throws CommandException {
        this.process(stringArray, (InputStream)null, (OutputStream)null, (OutputStream)null, (File)null);
    }

    public void process(String[] stringArray, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2, File file) throws CommandException {
        int n;
        int n2;
        if (inputStream == null) {
            inputStream = System.in;
        }
        if (outputStream == null) {
            outputStream = System.out;
        }
        if (outputStream2 == null) {
            outputStream2 = System.err;
        }
        if (file == null) {
            file = new File(System.getProperty("user.dir"));
        }
        Env env = OptionImpl.Trampoline.DEFAULT.create(this, inputStream, outputStream, outputStream2, file);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<OptionImpl> arrayList2 = new ArrayList<OptionImpl>();
        OptionImpl optionImpl = null;
        OptionImpl[] optionImplArray = this.getOptions();
        LinkedHashSet<OptionImpl> linkedHashSet = new LinkedHashSet<OptionImpl>();
        for (int i = 0; i < optionImplArray.length; ++i) {
            optionImplArray[i] = optionImplArray[i].addWorkingCopy(linkedHashSet);
        }
        OptionImpl[] optionImplArray2 = linkedHashSet.toArray(new OptionImpl[0]);
        boolean bl = true;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2] == null) continue;
            if (bl) {
                Object object;
                if (stringArray[n2].startsWith("--")) {
                    if (stringArray[n2].length() == 2) {
                        bl = false;
                        continue;
                    }
                    String string = stringArray[n2].substring(2);
                    String string2 = null;
                    int n3 = string.indexOf(61);
                    if (n3 >= 0) {
                        string2 = string.substring(n3 + 1);
                        string = string.substring(0, n3);
                    }
                    if ((object = this.findByLongName(string, optionImplArray2)) == null) {
                        throw new CommandException(stringArray[n2], 50346, CommandLine.getMessage("MSG_Unknown", stringArray[n2]));
                    }
                    if (((OptionImpl)object).getArgumentType() == 1 && string2 == null) {
                        while (true) {
                            if (++n2 == stringArray.length) {
                                throw new CommandException(CommandLine.getMessage("MSG_MissingArgument", "--" + ((OptionImpl)object).getLongName()), 50347);
                            }
                            if (!stringArray[n2].equals("--")) break;
                            bl = false;
                        }
                        if (bl && stringArray[n2].startsWith("-")) {
                            throw new CommandException(CommandLine.getMessage("MSG_MissingArgument", "--" + ((OptionImpl)object).getLongName()), 50347);
                        }
                        string2 = stringArray[n2];
                    }
                    if (string2 != null) {
                        if (((OptionImpl)object).getArgumentType() != 1 && ((OptionImpl)object).getArgumentType() != 2) {
                            throw new CommandException(CommandLine.getMessage("MSG_OPTION_CANNOT_HAVE_VALUE", object, string2), 50347);
                        }
                        ((OptionImpl)object).associateValue(string2);
                    }
                    if (((OptionImpl)object).getArgumentType() == 3) {
                        if (optionImpl != null) {
                            String string3 = CommandLine.findOptionName(optionImpl, stringArray);
                            String string4 = CommandLine.findOptionName((OptionImpl)object, stringArray);
                            String string5 = CommandLine.getMessage("MSG_CannotTogether", string3, string4);
                            throw new CommandException(string5, 50348);
                        }
                        optionImpl = object;
                    }
                    arrayList2.add((OptionImpl)object);
                    continue;
                }
                if (stringArray[n2].startsWith("-") && stringArray[n2].length() > 1) {
                    for (int i = 1; i < stringArray[n2].length(); ++i) {
                        char c = stringArray[n2].charAt(i);
                        OptionImpl optionImpl2 = this.findByShortName(c, optionImplArray2);
                        if (optionImpl2 == null) {
                            throw new CommandException(CommandLine.getMessage("MSG_UNKNOWN_OPTION", stringArray[n2]), 50346);
                        }
                        if (stringArray[n2].length() == i + 1 && optionImpl2.getArgumentType() == 1) {
                            throw new CommandException(CommandLine.getMessage("MSG_MissingArgument", stringArray[n2]), 50347);
                        }
                        if (stringArray[n2].length() > i && (optionImpl2.getArgumentType() == 1 || optionImpl2.getArgumentType() == 2)) {
                            optionImpl2.associateValue(stringArray[n2].substring(i + 1));
                            i = stringArray[n2].length();
                        }
                        if (optionImpl2.getArgumentType() == 3) {
                            if (optionImpl != null) {
                                object = CommandLine.findOptionName(optionImpl, stringArray);
                                String string = CommandLine.findOptionName(optionImpl2, stringArray);
                                String string6 = CommandLine.getMessage("MSG_CannotTogether", object, string);
                                throw new CommandException(string6, 50348);
                            }
                            optionImpl = optionImpl2;
                        }
                        arrayList2.add(optionImpl2);
                    }
                    continue;
                }
            }
            arrayList.add(stringArray[n2]);
        }
        if (optionImpl == null && !arrayList.isEmpty()) {
            for (n2 = 0; n2 < optionImplArray2.length; ++n2) {
                if (optionImplArray2[n2].getArgumentType() != 4) continue;
                if (optionImpl != null) {
                    throw new CommandException(CommandLine.getMessage("MSG_TWO_DEFAULT_OPTIONS", optionImpl, optionImplArray2[n2]), 50348);
                }
                optionImpl = optionImplArray2[n2];
                arrayList2.add(optionImpl);
            }
            if (optionImpl == null) {
                throw new CommandException(CommandLine.getMessage("MSG_NOT_PROCESSED_PARAMS", arrayList), 50347);
            }
        }
        OptionImpl.Appearance[] appearanceArray = new OptionImpl.Appearance[optionImplArray.length];
        Cloneable cloneable = new HashSet<OptionImpl>(arrayList2);
        for (n = 0; n < optionImplArray.length; ++n) {
            OptionImpl.Appearance appearance;
            appearanceArray[n] = appearance = optionImplArray[n].checkConsistent((Set<OptionImpl>)((Object)cloneable));
            if (!appearance.isThere()) continue;
            optionImplArray[n].markConsistent(appearance);
        }
        cloneable = new HashSet(arrayList2);
        for (n = 0; n < optionImplArray.length; ++n) {
            OptionImpl optionImpl3;
            if (!appearanceArray[n].isError() || (optionImpl3 = optionImplArray[n].findNotUsedOption((Set<OptionImpl>)((Object)cloneable))) == null) continue;
            throw new CommandException(appearanceArray[n].errorMessage(stringArray), 50349);
        }
        cloneable = new LinkedHashMap();
        for (n = 0; n < optionImplArray.length; ++n) {
            if (!appearanceArray[n].isThere()) continue;
            HashMap<Option, String[]> hashMap = (HashMap<Option, String[]>)cloneable.get(optionImplArray[n].getProvider());
            if (hashMap == null) {
                hashMap = new HashMap<Option, String[]>();
                cloneable.put(optionImplArray[n].getProvider(), hashMap);
            }
            optionImplArray[n].process(arrayList.toArray(new String[0]), hashMap);
        }
        for (Map.Entry entry : cloneable.entrySet()) {
            OptionImpl.Trampoline.DEFAULT.process((OptionProcessor)entry.getKey(), env, (Map)entry.getValue());
        }
    }

    public void usage(PrintWriter printWriter) {
        int n;
        OptionImpl[] optionImplArray = this.getOptions();
        LinkedHashSet<OptionImpl> linkedHashSet = new LinkedHashSet<OptionImpl>();
        for (int i = 0; i < optionImplArray.length; ++i) {
            optionImplArray[i].addWorkingCopy(linkedHashSet);
        }
        OptionImpl[] optionImplArray2 = linkedHashSet.toArray(new OptionImpl[0]);
        int n2 = 25;
        String[] stringArray = new String[optionImplArray2.length];
        for (n = 0; n < optionImplArray2.length; ++n) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = OptionImpl.Trampoline.DEFAULT.getDisplayName(optionImplArray2[n].getOption(), Locale.getDefault());
            if (string != null) {
                stringBuilder.append(string);
            } else {
                String string2 = "";
                if (optionImplArray2[n].getShortName() != -1) {
                    stringBuilder.append('-');
                    stringBuilder.append((char)optionImplArray2[n].getShortName());
                    string2 = ", ";
                }
                if (optionImplArray2[n].getLongName() != null) {
                    stringBuilder.append(string2);
                    stringBuilder.append("--");
                    stringBuilder.append(optionImplArray2[n].getLongName());
                } else if (string2.length() == 0) continue;
                switch (optionImplArray2[n].getArgumentType()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        stringBuilder.append(' ');
                        stringBuilder.append(CommandLine.getMessage("MSG_OneArg", new Object[0]));
                        break;
                    }
                    case 2: {
                        stringBuilder.append(' ');
                        stringBuilder.append(CommandLine.getMessage("MSG_OptionalArg", new Object[0]));
                        break;
                    }
                    case 3: {
                        stringBuilder.append(' ');
                        stringBuilder.append(CommandLine.getMessage("MSG_AddionalArgs", new Object[0]));
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            if (stringBuilder.length() > n2) {
                n2 = stringBuilder.length();
            }
            stringArray[n] = stringBuilder.toString();
        }
        for (n = 0; n < optionImplArray2.length; ++n) {
            if (stringArray[n] == null) continue;
            printWriter.print("  ");
            printWriter.print(stringArray[n]);
            for (int i = stringArray[n].length(); i < n2; ++i) {
                printWriter.print(' ');
            }
            printWriter.print(' ');
            optionImplArray2[n].usage(printWriter, n2);
            printWriter.println();
        }
        printWriter.flush();
    }

    private OptionImpl[] getOptions() {
        ArrayList<OptionImpl> arrayList = new ArrayList<OptionImpl>();
        Iterable<OptionProcessor> iterable = this.processors;
        if (iterable == null) {
            try {
                iterable = this.lookupOptionProcessors();
            }
            catch (LinkageError linkageError) {
                iterable = ServiceLoader.load(OptionProcessor.class);
            }
        }
        for (OptionProcessor optionProcessor : iterable) {
            Option[] optionArray = OptionImpl.Trampoline.DEFAULT.getOptions(optionProcessor);
            for (int i = 0; i < optionArray.length; ++i) {
                arrayList.add(OptionImpl.cloneImpl(OptionImpl.find(optionArray[i]), optionArray[i], optionProcessor));
            }
        }
        return arrayList.toArray(new OptionImpl[0]);
    }

    private Collection<? extends OptionProcessor> lookupOptionProcessors() {
        return Lookup.getDefault().lookupAll(OptionProcessor.class);
    }

    private OptionImpl findByLongName(String string, OptionImpl[] optionImplArray) {
        boolean bl = false;
        OptionImpl optionImpl = null;
        for (int i = 0; i < optionImplArray.length; ++i) {
            String string2 = optionImplArray[i].getLongName();
            if (string2 == null) continue;
            if (string.equals(string2)) {
                return optionImplArray[i];
            }
            if (!string2.startsWith(string)) continue;
            bl = optionImpl == null;
            optionImpl = optionImplArray[i];
        }
        return bl ? optionImpl : null;
    }

    private OptionImpl findByShortName(char c, OptionImpl[] optionImplArray) {
        for (int i = 0; i < optionImplArray.length; ++i) {
            if (c != optionImplArray[i].getShortName()) continue;
            return optionImplArray[i];
        }
        return null;
    }

    private static String findOptionName(OptionImpl optionImpl, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("-")) continue;
            if (stringArray[i].startsWith("--")) {
                String string = stringArray[i].substring(2);
                int n = string.indexOf(61);
                if (n >= 0) {
                    string = string.substring(0, n);
                }
                if (!string.startsWith(optionImpl.getLongName())) continue;
                return stringArray[i];
            }
            if (optionImpl.getShortName() != stringArray[i].charAt(1)) continue;
            return "-" + (char)optionImpl.getShortName();
        }
        return optionImpl.toString();
    }

    private static String getMessage(String string, Object ... objectArray) {
        Class<CommandException> clazz = CommandException.class;
        try {
            return NbBundle.getMessage(clazz, (String)string, (Object[])objectArray);
        }
        catch (LinkageError linkageError) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(clazz.getPackage().getName() + ".Bundle");
            String string2 = resourceBundle.getString(string);
            if (objectArray != null && objectArray.length > 0) {
                string2 = MessageFormat.format(string2, objectArray);
            }
            return string2;
        }
    }
}

