# (C) Copyright 2020-2025 Enthought, Inc., Austin, TX
# All rights reserved.
#
# This software is provided without warranty under the terms of the BSD
# license included in LICENSE.txt and may be redistributed only under
# the conditions described in the aforementioned license. The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
#
# Thanks for using Enthought open source!

from enum import IntEnum
from typing import Any


class TraitKind(IntEnum):
    trait: int = ...
    python: int = ...
    event: int = ...
    delegate: int = ...
    property: int = ...
    disallow: int = ...
    read_only: int = ...
    constant: int = ...
    generic: int = ...


# Alias for the built-in int type, to avoid confusion with the 'int' attribute
# in the ValidateTrait namespace.
_int = int

class ValidateTrait(IntEnum):
    type: _int = ...
    instance: _int = ...
    self_type: _int = ...
    int_range: _int = ...
    float_range: _int = ...
    enum: _int = ...
    map: _int = ...
    complex: _int = ...
    slow: _int = ...
    tuple: _int = ...
    prefix_map: _int = ...
    coerce: _int = ...
    cast: _int = ...
    function: _int = ...
    python: _int = ...
    adapt: _int = ...
    int: _int = ...
    float: _int = ...
    callable: _int = ...

class ComparisonMode(IntEnum):
    none: int = ...
    identity: int = ...
    equality: int = ...

NO_COMPARE: Any
OBJECT_IDENTITY_COMPARE: Any
RICH_COMPARE: Any

class DefaultValue(IntEnum):
    unspecified: int = ...
    constant: int = ...
    missing: int = ...
    object: int = ...
    list_copy: int = ...
    dict_copy: int = ...
    trait_list_object: int = ...
    trait_dict_object: int = ...
    callable_and_args: int = ...
    callable: int = ...
    trait_set_object: int = ...
    disallow: int = ...


MAXIMUM_DEFAULT_VALUE_TYPE: Any
default_value_map: Any
