/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.notifications.core.setting.PluginSettings;
import org.opensearch.notifications.core.utils.HelpersKt;
import org.opensearch.notifications.core.utils.OpenForTesting;
import org.opensearch.notifications.core.utils.ValidationHelpersKt;
import org.opensearch.notifications.spi.model.MessageContent;
import org.opensearch.notifications.spi.model.destination.ChimeDestination;
import org.opensearch.notifications.spi.model.destination.CustomWebhookDestination;
import org.opensearch.notifications.spi.model.destination.MicrosoftTeamsDestination;
import org.opensearch.notifications.spi.model.destination.SlackDestination;
import org.opensearch.notifications.spi.model.destination.WebhookDestination;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u001e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0007J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0017J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J*\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001cH\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020'H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/opensearch/notifications/core/client/DestinationHttpClient;", "", "()V", "httpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "(Lorg/apache/http/impl/client/CloseableHttpClient;)V", "buildRequestBody", "", "destination", "Lorg/opensearch/notifications/spi/model/destination/WebhookDestination;", "message", "Lorg/opensearch/notifications/spi/model/MessageContent;", "checkContentLength", "", "entity", "Lorg/apache/http/HttpEntity;", "constructHttpRequest", "Lorg/apache/http/client/methods/HttpRequestBase;", "method", "url", "execute", "referenceId", "getHttpResponse", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "getResponseString", "response", "httpResponseToString", "maxResultLength", "", "toCharArrayBuffer", "Lorg/apache/http/util/CharArrayBuffer;", "inStream", "Ljava/io/InputStream;", "contentLength", "charset", "Ljava/nio/charset/Charset;", "toContentLength", "validateResponseStatus", "", "Lorg/apache/http/HttpResponse;", "Companion", "opensearch-notifications-core"})
@SourceDebugExtension(value={"SMAP\nDestinationHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DestinationHttpClient.kt\norg/opensearch/notifications/core/client/DestinationHttpClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
public final class DestinationHttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloseableHttpClient httpClient;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(DestinationHttpClient.class);
    private static final int DEFAULT_CHAR_BUFFER_SIZE = 1024;
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 4096;
    private static final Set<Integer> VALID_RESPONSE_STATUS;
    private static final Map<String, ContentType> CONTENT_TYPE_MAP;

    public DestinationHttpClient() {
        this.httpClient = DestinationHttpClient.Companion.createHttpClient();
    }

    @OpenForTesting
    public DestinationHttpClient(@NotNull CloseableHttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String execute(@NotNull WebhookDestination destination, @NotNull MessageContent message, @NotNull String referenceId) throws Exception {
        String string;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        CloseableHttpResponse response = null;
        try {
            ValidationHelpersKt.validateUrlHost(destination.getUrl(), PluginSettings.INSTANCE.getHostDenyList());
            response = this.getHttpResponse(destination, message);
            this.validateResponseStatus((HttpResponse)response);
            String responseString = this.getResponseString(response);
            DestinationHttpClient.Companion.getLog().debug("Http response for id " + referenceId + ": " + responseString);
            string = responseString;
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
        return string;
    }

    private final CloseableHttpResponse getHttpResponse(WebhookDestination destination, MessageContent message) throws Exception {
        HttpRequestBase httpRequest = (HttpRequestBase)new HttpPost(destination.getUrl());
        if (destination instanceof CustomWebhookDestination) {
            httpRequest = this.constructHttpRequest(((CustomWebhookDestination)destination).getMethod(), destination.getUrl());
            if (((CustomWebhookDestination)destination).getHeaderParams().isEmpty()) {
                httpRequest.setHeader("Content-type", "application/json");
            } else {
                for (Map.Entry entry : ((CustomWebhookDestination)destination).getHeaderParams().entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    httpRequest.setHeader(key, value);
                }
            }
        }
        StringEntity entity = new StringEntity(this.buildRequestBody(destination, message), StandardCharsets.UTF_8);
        HttpRequestBase httpRequestBase = httpRequest;
        Intrinsics.checkNotNull((Object)httpRequestBase, (String)"null cannot be cast to non-null type org.apache.http.client.methods.HttpEntityEnclosingRequestBase");
        ((HttpEntityEnclosingRequestBase)httpRequestBase).setEntity((HttpEntity)entity);
        CloseableHttpResponse closeableHttpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
        Intrinsics.checkNotNullExpressionValue((Object)closeableHttpResponse, (String)"httpClient.execute(httpRequest)");
        return closeableHttpResponse;
    }

    private final HttpRequestBase constructHttpRequest(String method, String url) {
        HttpRequestBase httpRequestBase;
        switch (method) {
            case "POST": {
                httpRequestBase = (HttpRequestBase)new HttpPost(url);
                break;
            }
            case "PUT": {
                httpRequestBase = (HttpRequestBase)new HttpPut(url);
                break;
            }
            case "PATCH": {
                httpRequestBase = (HttpRequestBase)new HttpPatch(url);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid or empty method supplied. Only POST, PUT and PATCH are allowed");
            }
        }
        return httpRequestBase;
    }

    @NotNull
    public final String getResponseString(@NotNull CloseableHttpResponse response) throws IOException {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        HttpEntity httpEntity = response.getEntity();
        if (httpEntity == null) {
            return "{}";
        }
        HttpEntity entity = httpEntity;
        String responseString = this.httpResponseToString(entity, PluginSettings.INSTANCE.getMaxHttpResponseSize() / 2);
        CharSequence charSequence = responseString;
        return charSequence == null || charSequence.length() == 0 ? "{}" : responseString;
    }

    private final void validateResponseStatus(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (!VALID_RESPONSE_STATUS.contains(statusCode)) {
            throw new IOException("Failed: " + EntityUtils.toString((HttpEntity)response.getEntity()));
        }
    }

    @NotNull
    public final String buildRequestBody(@NotNull WebhookDestination destination, @NotNull MessageContent message) {
        String string;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        XContentBuilder builder = MediaTypeRegistry.contentBuilder((MediaType)((MediaType)XContentType.JSON));
        WebhookDestination webhookDestination = destination;
        if (webhookDestination instanceof SlackDestination) {
            string = "text";
        } else if (webhookDestination instanceof ChimeDestination) {
            string = "Content";
        } else if (webhookDestination instanceof MicrosoftTeamsDestination) {
            string = "text";
        } else {
            if (webhookDestination instanceof CustomWebhookDestination) {
                return message.getTextDescription();
            }
            throw new IllegalArgumentException("Invalid destination type is provided, Only Slack, Chime, Microsoft Teams and CustomWebhook are allowed");
        }
        String keyName = string;
        builder.startObject().field(keyName, message.buildMessageWithTitle()).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        return HelpersKt.string(builder);
    }

    private final String httpResponseToString(HttpEntity entity, int maxResultLength) {
        if (entity == null) {
            throw new IllegalArgumentException("HttpEntity received was null");
        }
        ContentType contentType = entity.getContentType() != null ? ContentType.parse((String)entity.getContentType().getValue()) : null;
        int contentLength = this.toContentLength((int)this.checkContentLength(entity));
        InputStream inputStream = entity.getContent();
        if (inputStream == null) {
            return null;
        }
        InputStream inStream = inputStream;
        Charset charset = null;
        if (contentType != null && (charset = contentType.getCharset()) == null) {
            ContentType contentType2 = CONTENT_TYPE_MAP.get(contentType.getMimeType());
            charset = contentType2 != null ? contentType2.getCharset() : null;
        }
        return this.toCharArrayBuffer(inStream, contentLength, charset, maxResultLength).toString();
    }

    private final long checkContentLength(HttpEntity entity) {
        if (entity.getContentLength() < -1L || entity.getContentLength() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("HTTP entity too large to be buffered in memory: " + entity.getContentLength() + " is out of range [-1, 2147483647]");
        }
        return entity.getContentLength();
    }

    private final int toContentLength(int contentLength) {
        return contentLength < 0 ? 4096 : contentLength;
    }

    private final CharArrayBuffer toCharArrayBuffer(InputStream inStream, int contentLength, Charset charset, int maxResultLength) {
        if (!(maxResultLength > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Charset charset2 = charset;
        if (charset2 == null) {
            charset2 = StandardCharsets.UTF_8;
        }
        Charset actualCharSet = charset2;
        CharArrayBuffer buf = new CharArrayBuffer(Math.min(maxResultLength, contentLength > 0 ? contentLength : 1024));
        InputStreamReader reader = new InputStreamReader(inStream, actualCharSet);
        char[] tmp = new char[1024];
        int chReadCount = 0;
        while (true) {
            int n;
            int it = n = reader.read(tmp);
            boolean bl = false;
            chReadCount = it;
            if (n == -1 || buf.length() >= maxResultLength) break;
            buf.append(tmp, 0, chReadCount);
        }
        buf.setLength(Math.min(buf.length(), maxResultLength));
        return buf;
    }

    static {
        Object[] objectArray = new Integer[]{RestStatus.OK.getStatus(), RestStatus.CREATED.getStatus(), RestStatus.ACCEPTED.getStatus(), RestStatus.NON_AUTHORITATIVE_INFORMATION.getStatus(), RestStatus.NO_CONTENT.getStatus(), RestStatus.RESET_CONTENT.getStatus(), RestStatus.PARTIAL_CONTENT.getStatus(), RestStatus.MULTI_STATUS.getStatus()};
        VALID_RESPONSE_STATUS = Collections.unmodifiableSet(new HashSet(CollectionsKt.listOf((Object[])objectArray)));
        objectArray = new Pair[]{TuplesKt.to((Object)ContentType.APPLICATION_ATOM_XML.getMimeType(), (Object)ContentType.APPLICATION_ATOM_XML), TuplesKt.to((Object)ContentType.APPLICATION_FORM_URLENCODED.getMimeType(), (Object)ContentType.APPLICATION_FORM_URLENCODED), TuplesKt.to((Object)ContentType.APPLICATION_JSON.getMimeType(), (Object)ContentType.APPLICATION_JSON), TuplesKt.to((Object)ContentType.APPLICATION_SVG_XML.getMimeType(), (Object)ContentType.APPLICATION_SVG_XML), TuplesKt.to((Object)ContentType.APPLICATION_XHTML_XML.getMimeType(), (Object)ContentType.APPLICATION_XHTML_XML), TuplesKt.to((Object)ContentType.APPLICATION_XML.getMimeType(), (Object)ContentType.APPLICATION_XML), TuplesKt.to((Object)ContentType.MULTIPART_FORM_DATA.getMimeType(), (Object)ContentType.MULTIPART_FORM_DATA), TuplesKt.to((Object)ContentType.TEXT_HTML.getMimeType(), (Object)ContentType.TEXT_HTML), TuplesKt.to((Object)ContentType.TEXT_PLAIN.getMimeType(), (Object)ContentType.TEXT_PLAIN), TuplesKt.to((Object)ContentType.TEXT_XML.getMimeType(), (Object)ContentType.TEXT_XML)};
        CONTENT_TYPE_MAP = Collections.unmodifiableMap(MapsKt.mapOf((Pair[])objectArray));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\n0\n\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/opensearch/notifications/core/client/DestinationHttpClient$Companion;", "", "()V", "CONTENT_TYPE_MAP", "", "", "kotlin.jvm.PlatformType", "Lorg/apache/http/entity/ContentType;", "", "DEFAULT_BYTE_BUFFER_SIZE", "", "DEFAULT_CHAR_BUFFER_SIZE", "VALID_RESPONSE_STATUS", "", "", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "createHttpClient", "Lorg/apache/http/impl/client/CloseableHttpClient;", "opensearch-notifications-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        private final CloseableHttpClient createHttpClient() {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(PluginSettings.INSTANCE.getConnectionTimeout()).setConnectionRequestTimeout(PluginSettings.INSTANCE.getConnectionTimeout()).setSocketTimeout(PluginSettings.INSTANCE.getSocketTimeout()).build();
            Intrinsics.checkNotNullExpressionValue((Object)requestConfig, (String)"custom()\n               \u2026\n                .build()");
            RequestConfig config = requestConfig;
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setMaxTotal(PluginSettings.INSTANCE.getMaxConnections());
            connectionManager.setDefaultMaxPerRoute(PluginSettings.INSTANCE.getMaxConnectionsPerRoute());
            CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)connectionManager).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler()).useSystemProperties().disableRedirectHandling().build();
            Intrinsics.checkNotNullExpressionValue((Object)closeableHttpClient, (String)"create()\n               \u2026\n                .build()");
            return closeableHttpClient;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

