/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.NatGatewayIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNatGatewaysRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeNatGatewaysRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(DescribeNatGatewaysRequest.getter(DescribeNatGatewaysRequest::dryRun)).setter(DescribeNatGatewaysRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<List<Filter>> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filter").getter(DescribeNatGatewaysRequest.getter(DescribeNatGatewaysRequest::filter)).setter(DescribeNatGatewaysRequest.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeNatGatewaysRequest.getter(DescribeNatGatewaysRequest::maxResults)).setter(DescribeNatGatewaysRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<List<String>> NAT_GATEWAY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NatGatewayIds").getter(DescribeNatGatewaysRequest.getter(DescribeNatGatewaysRequest::natGatewayIds)).setter(DescribeNatGatewaysRequest.setter(Builder::natGatewayIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NatGatewayId").unmarshallLocationName("NatGatewayId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeNatGatewaysRequest.getter(DescribeNatGatewaysRequest::nextToken)).setter(DescribeNatGatewaysRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD, FILTER_FIELD, MAX_RESULTS_FIELD, NAT_GATEWAY_IDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeNatGatewaysRequest.memberNameToFieldInitializer();
    private final Boolean dryRun;
    private final List<Filter> filter;
    private final Integer maxResults;
    private final List<String> natGatewayIds;
    private final String nextToken;

    private DescribeNatGatewaysRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.natGatewayIds = builder.natGatewayIds;
        this.nextToken = builder.nextToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final boolean hasFilter() {
        return this.filter != null && !(this.filter instanceof SdkAutoConstructList);
    }

    public final List<Filter> filter() {
        return this.filter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasNatGatewayIds() {
        return this.natGatewayIds != null && !(this.natGatewayIds instanceof SdkAutoConstructList);
    }

    public final List<String> natGatewayIds() {
        return this.natGatewayIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilter() ? this.filter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNatGatewayIds() ? this.natGatewayIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNatGatewaysRequest)) {
            return false;
        }
        DescribeNatGatewaysRequest other = (DescribeNatGatewaysRequest)((Object)obj);
        return Objects.equals(this.dryRun(), other.dryRun()) && this.hasFilter() == other.hasFilter() && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasNatGatewayIds() == other.hasNatGatewayIds() && Objects.equals(this.natGatewayIds(), other.natGatewayIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNatGatewaysRequest").add("DryRun", (Object)this.dryRun()).add("Filter", this.hasFilter() ? this.filter() : null).add("MaxResults", (Object)this.maxResults()).add("NatGatewayIds", this.hasNatGatewayIds() ? this.natGatewayIds() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NatGatewayIds": {
                return Optional.ofNullable(clazz.cast(this.natGatewayIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NatGatewayId", NAT_GATEWAY_IDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeNatGatewaysRequest, T> g) {
        return obj -> g.apply((DescribeNatGatewaysRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean dryRun;
        private List<Filter> filter = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private List<String> natGatewayIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNatGatewaysRequest model) {
            super(model);
            this.dryRun(model.dryRun);
            this.filter(model.filter);
            this.maxResults(model.maxResults);
            this.natGatewayIds(model.natGatewayIds);
            this.nextToken(model.nextToken);
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final List<Filter.Builder> getFilter() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filter);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilter(Collection<Filter.BuilderImpl> filter) {
            this.filter = FilterListCopier.copyFromBuilder(filter);
        }

        @Override
        public final Builder filter(Collection<Filter> filter) {
            this.filter = FilterListCopier.copy(filter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Filter ... filter) {
            this.filter(Arrays.asList(filter));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filter(Consumer<Filter.Builder> ... filter) {
            this.filter(Stream.of(filter).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getNatGatewayIds() {
            if (this.natGatewayIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.natGatewayIds;
        }

        public final void setNatGatewayIds(Collection<String> natGatewayIds) {
            this.natGatewayIds = NatGatewayIdStringListCopier.copy(natGatewayIds);
        }

        @Override
        public final Builder natGatewayIds(Collection<String> natGatewayIds) {
            this.natGatewayIds = NatGatewayIdStringListCopier.copy(natGatewayIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGatewayIds(String ... natGatewayIds) {
            this.natGatewayIds(Arrays.asList(natGatewayIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNatGatewaysRequest build() {
            return new DescribeNatGatewaysRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNatGatewaysRequest> {
        public Builder dryRun(Boolean var1);

        public Builder filter(Collection<Filter> var1);

        public Builder filter(Filter ... var1);

        public Builder filter(Consumer<Filter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder natGatewayIds(Collection<String> var1);

        public Builder natGatewayIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

