/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmediathek/tool/FileUtils;", "", "()V", "ONE_GB", "", "ONE_KB", "ONE_MB", "humanReadableByteCountBinary", "", "bytes", "moveToTrash", "", "filePath", "Ljava/nio/file/Path;", "removeExtension", "fileName", "MediathekView"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;

    private FileUtils() {
    }

    @JvmStatic
    public static final void moveToTrash(@NotNull Path filePath) throws IOException {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        com.sun.jna.platform.FileUtils fileUtils = com.sun.jna.platform.FileUtils.getInstance();
        if (fileUtils.hasTrash()) {
            File[] fileArray = new File[]{filePath.toFile()};
            fileUtils.moveToTrash(fileArray);
        } else {
            Files.deleteIfExists(filePath);
        }
    }

    @JvmStatic
    @NotNull
    public static final String removeExtension(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return FilesKt.getNameWithoutExtension(new File(fileName));
    }

    @JvmStatic
    @NotNull
    public static final String humanReadableByteCountBinary(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return bytes + " B";
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        String string = "%.1f %ciB";
        Object[] objectArray = new Object[]{(double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current())};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(format, *args)");
        return string2;
    }
}

