/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dependency.nnparser;

import com.hankcs.hanlp.collection.trie.DoubleArrayTrie;
import com.hankcs.hanlp.collection.trie.ITrie;
import com.hankcs.hanlp.corpus.io.ByteArray;
import com.hankcs.hanlp.corpus.io.ICacheAble;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.DataOutputStream;
import java.util.Map;
import java.util.TreeMap;

public class Alphabet
implements ICacheAble {
    ITrie<Integer> trie = new DoubleArrayTrie<Integer>();
    String[] idToLabelMap;

    public String labelOf(int id) {
        return this.idToLabelMap[id];
    }

    public int build(TreeMap<String, Integer> keyValueMap) {
        this.idToLabelMap = new String[keyValueMap.size()];
        for (Map.Entry<String, Integer> entry : keyValueMap.entrySet()) {
            this.idToLabelMap[entry.getValue().intValue()] = entry.getKey();
        }
        return this.trie.build(keyValueMap);
    }

    public Integer idOf(char[] label) {
        return this.trie.get(label);
    }

    public Integer idOf(String label) {
        return this.trie.get(label);
    }

    public int size() {
        return this.trie.size();
    }

    @Override
    public void save(DataOutputStream out) throws Exception {
        out.writeInt(this.idToLabelMap.length);
        for (String value : this.idToLabelMap) {
            TextUtility.writeString(value, out);
        }
    }

    @Override
    public boolean load(ByteArray byteArray) {
        this.idToLabelMap = new String[byteArray.nextInt()];
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (int i = 0; i < this.idToLabelMap.length; ++i) {
            this.idToLabelMap[i] = byteArray.nextString();
            map.put(this.idToLabelMap[i], i);
        }
        return this.trie.build(map) == 0;
    }
}

