/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.StringMatchResult;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class StringMatchResultOutput<K, V>
extends CommandOutput<K, V, StringMatchResult> {
    private static final ByteBuffer LEN = StandardCharsets.US_ASCII.encode("len");
    private String matchString;
    private int len;
    private List<Long> positions;
    private boolean readingLen = true;
    private final List<StringMatchResult.MatchedPosition> matchedPositions = new ArrayList<StringMatchResult.MatchedPosition>();

    public StringMatchResultOutput(RedisCodec<K, V> codec) {
        super(codec, null);
    }

    @Override
    public void set(ByteBuffer bytes) {
        this.matchString = (String)this.codec.decodeKey(bytes);
        this.readingLen = LEN.equals(bytes);
    }

    @Override
    public void set(long integer) {
        if (this.readingLen) {
            this.len = (int)integer;
        } else {
            if (this.positions == null) {
                this.positions = new ArrayList<Long>();
            }
            this.positions.add(integer);
        }
        this.matchString = null;
    }

    @Override
    public void complete(int depth) {
        if (depth == 2) {
            this.matchedPositions.add(StringMatchResultOutput.buildMatchedString(this.positions));
            this.positions = null;
        }
        if (depth == 0) {
            this.output = new StringMatchResult(this.matchString, this.matchedPositions, this.len);
        }
    }

    private static StringMatchResult.MatchedPosition buildMatchedString(List<Long> positions) {
        if (positions == null) {
            throw new IllegalStateException("No matched positions");
        }
        int size = positions.size();
        long matchLen = size % 2 == 0 ? 0L : positions.get(size - 1);
        return new StringMatchResult.MatchedPosition(new StringMatchResult.Position(positions.get(0), positions.get(1)), new StringMatchResult.Position(positions.get(2), positions.get(3)), matchLen);
    }
}

