#include "_gen/tp-svc-connection.h"

#include <telepathy-glib/dbus.h>
#include "_gen/signals-marshal.h"

static const DBusGObjectInfo _tp_svc_connection_object_info;

struct _TpSvcConnectionClass {
    GTypeInterface parent_class;
    tp_svc_connection_connect_impl connect;
    tp_svc_connection_disconnect_impl disconnect;
    tp_svc_connection_get_interfaces_impl get_interfaces;
    tp_svc_connection_get_protocol_impl get_protocol;
    tp_svc_connection_get_self_handle_impl get_self_handle;
    tp_svc_connection_get_status_impl get_status;
    tp_svc_connection_hold_handles_impl hold_handles;
    tp_svc_connection_inspect_handles_impl inspect_handles;
    tp_svc_connection_list_channels_impl list_channels;
    tp_svc_connection_release_handles_impl release_handles;
    tp_svc_connection_request_channel_impl request_channel;
    tp_svc_connection_request_handles_impl request_handles;
};

enum {
    SIGNAL_CONNECTION_NewChannel,
    SIGNAL_CONNECTION_StatusChanged,
    N_CONNECTION_SIGNALS
};
static guint connection_signals[N_CONNECTION_SIGNALS] = {0};

static void tp_svc_connection_base_init (gpointer klass);

GType
tp_svc_connection_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (TpSvcConnectionClass),
        tp_svc_connection_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "TpSvcConnection", &info, 0);
    }

  return type;
}

/**
 * tp_svc_connection_connect_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Connect on interface org.freedesktop.Telepathy.Connection.
 */
static void
tp_svc_connection_connect (TpSvcConnection *self,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_connect_impl impl = (TP_SVC_CONNECTION_GET_CLASS (self)->connect);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_implement_connect:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Connect D-Bus method
 *
 * Register an implementation for the Connect method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_implement_connect (TpSvcConnectionClass *klass, tp_svc_connection_connect_impl impl)
{
  klass->connect = impl;
}

/**
 * tp_svc_connection_disconnect_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Disconnect on interface org.freedesktop.Telepathy.Connection.
 */
static void
tp_svc_connection_disconnect (TpSvcConnection *self,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_disconnect_impl impl = (TP_SVC_CONNECTION_GET_CLASS (self)->disconnect);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_implement_disconnect:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Disconnect D-Bus method
 *
 * Register an implementation for the Disconnect method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_implement_disconnect (TpSvcConnectionClass *klass, tp_svc_connection_disconnect_impl impl)
{
  klass->disconnect = impl;
}

/**
 * tp_svc_connection_get_interfaces_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetInterfaces on interface org.freedesktop.Telepathy.Connection.
 */
static void
tp_svc_connection_get_interfaces (TpSvcConnection *self,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_get_interfaces_impl impl = (TP_SVC_CONNECTION_GET_CLASS (self)->get_interfaces);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_implement_get_interfaces:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetInterfaces D-Bus method
 *
 * Register an implementation for the GetInterfaces method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_implement_get_interfaces (TpSvcConnectionClass *klass, tp_svc_connection_get_interfaces_impl impl)
{
  klass->get_interfaces = impl;
}

/**
 * tp_svc_connection_get_protocol_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetProtocol on interface org.freedesktop.Telepathy.Connection.
 */
static void
tp_svc_connection_get_protocol (TpSvcConnection *self,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_get_protocol_impl impl = (TP_SVC_CONNECTION_GET_CLASS (self)->get_protocol);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_implement_get_protocol:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetProtocol D-Bus method
 *
 * Register an implementation for the GetProtocol method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_implement_get_protocol (TpSvcConnectionClass *klass, tp_svc_connection_get_protocol_impl impl)
{
  klass->get_protocol = impl;
}

/**
 * tp_svc_connection_get_self_handle_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetSelfHandle on interface org.freedesktop.Telepathy.Connection.
 */
static void
tp_svc_connection_get_self_handle (TpSvcConnection *self,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_get_self_handle_impl impl = (TP_SVC_CONNECTION_GET_CLASS (self)->get_self_handle);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_implement_get_self_handle:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetSelfHandle D-Bus method
 *
 * Register an implementation for the GetSelfHandle method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_implement_get_self_handle (TpSvcConnectionClass *klass, tp_svc_connection_get_self_handle_impl impl)
{
  klass->get_self_handle = impl;
}

/**
 * tp_svc_connection_get_status_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetStatus on interface org.freedesktop.Telepathy.Connection.
 */
static void
tp_svc_connection_get_status (TpSvcConnection *self,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_get_status_impl impl = (TP_SVC_CONNECTION_GET_CLASS (self)->get_status);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_implement_get_status:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetStatus D-Bus method
 *
 * Register an implementation for the GetStatus method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_implement_get_status (TpSvcConnectionClass *klass, tp_svc_connection_get_status_impl impl)
{
  klass->get_status = impl;
}

/**
 * tp_svc_connection_hold_handles_impl:
 * @self: The object implementing this interface
 * @in_handle_type: guint  (FIXME, generate documentation)
 * @in_handles: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * HoldHandles on interface org.freedesktop.Telepathy.Connection.
 */
static void
tp_svc_connection_hold_handles (TpSvcConnection *self,
    guint in_handle_type,
    const GArray *in_handles,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_hold_handles_impl impl = (TP_SVC_CONNECTION_GET_CLASS (self)->hold_handles);

  if (impl != NULL)
    {
      (impl) (self,
        in_handle_type,
        in_handles,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_implement_hold_handles:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the HoldHandles D-Bus method
 *
 * Register an implementation for the HoldHandles method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_implement_hold_handles (TpSvcConnectionClass *klass, tp_svc_connection_hold_handles_impl impl)
{
  klass->hold_handles = impl;
}

/**
 * tp_svc_connection_inspect_handles_impl:
 * @self: The object implementing this interface
 * @in_handle_type: guint  (FIXME, generate documentation)
 * @in_handles: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * InspectHandles on interface org.freedesktop.Telepathy.Connection.
 */
static void
tp_svc_connection_inspect_handles (TpSvcConnection *self,
    guint in_handle_type,
    const GArray *in_handles,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_inspect_handles_impl impl = (TP_SVC_CONNECTION_GET_CLASS (self)->inspect_handles);

  if (impl != NULL)
    {
      (impl) (self,
        in_handle_type,
        in_handles,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_implement_inspect_handles:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the InspectHandles D-Bus method
 *
 * Register an implementation for the InspectHandles method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_implement_inspect_handles (TpSvcConnectionClass *klass, tp_svc_connection_inspect_handles_impl impl)
{
  klass->inspect_handles = impl;
}

/**
 * tp_svc_connection_list_channels_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * ListChannels on interface org.freedesktop.Telepathy.Connection.
 */
static void
tp_svc_connection_list_channels (TpSvcConnection *self,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_list_channels_impl impl = (TP_SVC_CONNECTION_GET_CLASS (self)->list_channels);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_implement_list_channels:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the ListChannels D-Bus method
 *
 * Register an implementation for the ListChannels method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_implement_list_channels (TpSvcConnectionClass *klass, tp_svc_connection_list_channels_impl impl)
{
  klass->list_channels = impl;
}

/**
 * tp_svc_connection_release_handles_impl:
 * @self: The object implementing this interface
 * @in_handle_type: guint  (FIXME, generate documentation)
 * @in_handles: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * ReleaseHandles on interface org.freedesktop.Telepathy.Connection.
 */
static void
tp_svc_connection_release_handles (TpSvcConnection *self,
    guint in_handle_type,
    const GArray *in_handles,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_release_handles_impl impl = (TP_SVC_CONNECTION_GET_CLASS (self)->release_handles);

  if (impl != NULL)
    {
      (impl) (self,
        in_handle_type,
        in_handles,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_implement_release_handles:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the ReleaseHandles D-Bus method
 *
 * Register an implementation for the ReleaseHandles method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_implement_release_handles (TpSvcConnectionClass *klass, tp_svc_connection_release_handles_impl impl)
{
  klass->release_handles = impl;
}

/**
 * tp_svc_connection_request_channel_impl:
 * @self: The object implementing this interface
 * @in_type: const gchar * (FIXME, generate documentation)
 * @in_handle_type: guint  (FIXME, generate documentation)
 * @in_handle: guint  (FIXME, generate documentation)
 * @in_suppress_handler: gboolean  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestChannel on interface org.freedesktop.Telepathy.Connection.
 */
static void
tp_svc_connection_request_channel (TpSvcConnection *self,
    const gchar *in_type,
    guint in_handle_type,
    guint in_handle,
    gboolean in_suppress_handler,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_request_channel_impl impl = (TP_SVC_CONNECTION_GET_CLASS (self)->request_channel);

  if (impl != NULL)
    {
      (impl) (self,
        in_type,
        in_handle_type,
        in_handle,
        in_suppress_handler,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_implement_request_channel:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestChannel D-Bus method
 *
 * Register an implementation for the RequestChannel method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_implement_request_channel (TpSvcConnectionClass *klass, tp_svc_connection_request_channel_impl impl)
{
  klass->request_channel = impl;
}

/**
 * tp_svc_connection_request_handles_impl:
 * @self: The object implementing this interface
 * @in_handle_type: guint  (FIXME, generate documentation)
 * @in_names: const gchar ** (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestHandles on interface org.freedesktop.Telepathy.Connection.
 */
static void
tp_svc_connection_request_handles (TpSvcConnection *self,
    guint in_handle_type,
    const gchar **in_names,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_request_handles_impl impl = (TP_SVC_CONNECTION_GET_CLASS (self)->request_handles);

  if (impl != NULL)
    {
      (impl) (self,
        in_handle_type,
        in_names,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_implement_request_handles:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestHandles D-Bus method
 *
 * Register an implementation for the RequestHandles method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_implement_request_handles (TpSvcConnectionClass *klass, tp_svc_connection_request_handles_impl impl)
{
  klass->request_handles = impl;
}

/**
 * tp_svc_connection_emit_new_channel:
 * @instance: The object implementing this interface
 * @arg_object_path: const gchar * (FIXME, generate documentation)
 * @arg_channel_type: const gchar * (FIXME, generate documentation)
 * @arg_handle_type: guint  (FIXME, generate documentation)
 * @arg_handle: guint  (FIXME, generate documentation)
 * @arg_suppress_handler: gboolean  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * NewChannel signal on interface org.freedesktop.Telepathy.Connection.
 */
void
tp_svc_connection_emit_new_channel (gpointer instance,
    const gchar *arg_object_path,
    const gchar *arg_channel_type,
    guint arg_handle_type,
    guint arg_handle,
    gboolean arg_suppress_handler)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, TP_TYPE_SVC_CONNECTION));
  g_signal_emit (instance,
      connection_signals[SIGNAL_CONNECTION_NewChannel],
      0,
      arg_object_path,
      arg_channel_type,
      arg_handle_type,
      arg_handle,
      arg_suppress_handler);
}

/**
 * tp_svc_connection_emit_status_changed:
 * @instance: The object implementing this interface
 * @arg_status: guint  (FIXME, generate documentation)
 * @arg_reason: guint  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * StatusChanged signal on interface org.freedesktop.Telepathy.Connection.
 */
void
tp_svc_connection_emit_status_changed (gpointer instance,
    guint arg_status,
    guint arg_reason)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, TP_TYPE_SVC_CONNECTION));
  g_signal_emit (instance,
      connection_signals[SIGNAL_CONNECTION_StatusChanged],
      0,
      arg_status,
      arg_reason);
}

static inline void
tp_svc_connection_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[1] = {
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Connection");
  tp_svc_interface_set_dbus_properties_info (TP_TYPE_SVC_CONNECTION, &interface);

  connection_signals[SIGNAL_CONNECTION_NewChannel] =
  g_signal_new ("new-channel",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _tp_marshal_VOID__BOXED_STRING_UINT_UINT_BOOLEAN,
      G_TYPE_NONE,
      5,
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_STRING,
      G_TYPE_UINT,
      G_TYPE_UINT,
      G_TYPE_BOOLEAN);

  connection_signals[SIGNAL_CONNECTION_StatusChanged] =
  g_signal_new ("status-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _tp_marshal_VOID__UINT_UINT,
      G_TYPE_NONE,
      2,
      G_TYPE_UINT,
      G_TYPE_UINT);

  dbus_g_object_type_install_info (tp_svc_connection_get_type (),
      &_tp_svc_connection_object_info);
}
static void
tp_svc_connection_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      tp_svc_connection_base_init_once (klass);
    }
}
static const DBusGMethodInfo _tp_svc_connection_methods[] = {
  { (GCallback) tp_svc_connection_connect, g_cclosure_marshal_VOID__POINTER, 0 },
  { (GCallback) tp_svc_connection_disconnect, g_cclosure_marshal_VOID__POINTER, 48 },
  { (GCallback) tp_svc_connection_get_interfaces, g_cclosure_marshal_VOID__POINTER, 99 },
  { (GCallback) tp_svc_connection_get_protocol, g_cclosure_marshal_VOID__POINTER, 167 },
  { (GCallback) tp_svc_connection_get_self_handle, g_cclosure_marshal_VOID__POINTER, 232 },
  { (GCallback) tp_svc_connection_get_status, g_cclosure_marshal_VOID__POINTER, 299 },
  { (GCallback) tp_svc_connection_hold_handles, _tp_marshal_VOID__UINT_BOXED_POINTER, 362 },
  { (GCallback) tp_svc_connection_inspect_handles, _tp_marshal_VOID__UINT_BOXED_POINTER, 443 },
  { (GCallback) tp_svc_connection_list_channels, g_cclosure_marshal_VOID__POINTER, 541 },
  { (GCallback) tp_svc_connection_release_handles, _tp_marshal_VOID__UINT_BOXED_POINTER, 613 },
  { (GCallback) tp_svc_connection_request_channel, _tp_marshal_VOID__STRING_UINT_UINT_BOOLEAN_POINTER, 697 },
  { (GCallback) tp_svc_connection_request_handles, _tp_marshal_VOID__UINT_BOXED_POINTER, 822 },
};

static const DBusGObjectInfo _tp_svc_connection_object_info = {
  0,
  _tp_svc_connection_methods,
  12,
"org.freedesktop.Telepathy.Connection\0Connect\0A\0\0org.freedesktop.Telepathy.Connection\0Disconnect\0A\0\0org.freedesktop.Telepathy.Connection\0GetInterfaces\0A\0arg0\0O\0F\0N\0as\0\0org.freedesktop.Telepathy.Connection\0GetProtocol\0A\0arg0\0O\0F\0N\0s\0\0org.freedesktop.Telepathy.Connection\0GetSelfHandle\0A\0arg0\0O\0F\0N\0u\0\0org.freedesktop.Telepathy.Connection\0GetStatus\0A\0arg0\0O\0F\0N\0u\0\0org.freedesktop.Telepathy.Connection\0HoldHandles\0A\0handle_type\0I\0u\0handles\0I\0au\0\0org.freedesktop.Telepathy.Connection\0InspectHandles\0A\0handle_type\0I\0u\0handles\0I\0au\0arg2\0O\0F\0N\0as\0\0org.freedesktop.Telepathy.Connection\0ListChannels\0A\0arg0\0O\0F\0N\0a(osuu)\0\0org.freedesktop.Telepathy.Connection\0ReleaseHandles\0A\0handle_type\0I\0u\0handles\0I\0au\0\0org.freedesktop.Telepathy.Connection\0RequestChannel\0A\0type\0I\0s\0handle_type\0I\0u\0handle\0I\0u\0suppress_handler\0I\0b\0arg4\0O\0F\0N\0o\0\0org.freedesktop.Telepathy.Connection\0RequestHandles\0A\0handle_type\0I\0u\0names\0I\0as\0arg2\0O\0F\0N\0au\0\0\0",
"org.freedesktop.Telepathy.Connection\0NewChannel\0org.freedesktop.Telepathy.Connection\0StatusChanged\0\0",
"\0\0",
};

static const DBusGObjectInfo _tp_svc_connection_interface_aliasing_object_info;

struct _TpSvcConnectionInterfaceAliasingClass {
    GTypeInterface parent_class;
    tp_svc_connection_interface_aliasing_get_alias_flags_impl get_alias_flags;
    tp_svc_connection_interface_aliasing_request_aliases_impl request_aliases;
    tp_svc_connection_interface_aliasing_set_aliases_impl set_aliases;
};

enum {
    SIGNAL_CONNECTION_INTERFACE_ALIASING_AliasesChanged,
    N_CONNECTION_INTERFACE_ALIASING_SIGNALS
};
static guint connection_interface_aliasing_signals[N_CONNECTION_INTERFACE_ALIASING_SIGNALS] = {0};

static void tp_svc_connection_interface_aliasing_base_init (gpointer klass);

GType
tp_svc_connection_interface_aliasing_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (TpSvcConnectionInterfaceAliasingClass),
        tp_svc_connection_interface_aliasing_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "TpSvcConnectionInterfaceAliasing", &info, 0);
    }

  return type;
}

/**
 * tp_svc_connection_interface_aliasing_get_alias_flags_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetAliasFlags on interface org.freedesktop.Telepathy.Connection.Interface.Aliasing.
 */
static void
tp_svc_connection_interface_aliasing_get_alias_flags (TpSvcConnectionInterfaceAliasing *self,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_aliasing_get_alias_flags_impl impl = (TP_SVC_CONNECTION_INTERFACE_ALIASING_GET_CLASS (self)->get_alias_flags);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_aliasing_implement_get_alias_flags:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetAliasFlags D-Bus method
 *
 * Register an implementation for the GetAliasFlags method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_aliasing_implement_get_alias_flags (TpSvcConnectionInterfaceAliasingClass *klass, tp_svc_connection_interface_aliasing_get_alias_flags_impl impl)
{
  klass->get_alias_flags = impl;
}

/**
 * tp_svc_connection_interface_aliasing_request_aliases_impl:
 * @self: The object implementing this interface
 * @in_contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestAliases on interface org.freedesktop.Telepathy.Connection.Interface.Aliasing.
 */
static void
tp_svc_connection_interface_aliasing_request_aliases (TpSvcConnectionInterfaceAliasing *self,
    const GArray *in_contacts,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_aliasing_request_aliases_impl impl = (TP_SVC_CONNECTION_INTERFACE_ALIASING_GET_CLASS (self)->request_aliases);

  if (impl != NULL)
    {
      (impl) (self,
        in_contacts,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_aliasing_implement_request_aliases:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestAliases D-Bus method
 *
 * Register an implementation for the RequestAliases method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_aliasing_implement_request_aliases (TpSvcConnectionInterfaceAliasingClass *klass, tp_svc_connection_interface_aliasing_request_aliases_impl impl)
{
  klass->request_aliases = impl;
}

/**
 * tp_svc_connection_interface_aliasing_set_aliases_impl:
 * @self: The object implementing this interface
 * @in_aliases: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetAliases on interface org.freedesktop.Telepathy.Connection.Interface.Aliasing.
 */
static void
tp_svc_connection_interface_aliasing_set_aliases (TpSvcConnectionInterfaceAliasing *self,
    GHashTable *in_aliases,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_aliasing_set_aliases_impl impl = (TP_SVC_CONNECTION_INTERFACE_ALIASING_GET_CLASS (self)->set_aliases);

  if (impl != NULL)
    {
      (impl) (self,
        in_aliases,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_aliasing_implement_set_aliases:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetAliases D-Bus method
 *
 * Register an implementation for the SetAliases method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_aliasing_implement_set_aliases (TpSvcConnectionInterfaceAliasingClass *klass, tp_svc_connection_interface_aliasing_set_aliases_impl impl)
{
  klass->set_aliases = impl;
}

/**
 * tp_svc_connection_interface_aliasing_emit_aliases_changed:
 * @instance: The object implementing this interface
 * @arg_aliases: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * AliasesChanged signal on interface org.freedesktop.Telepathy.Connection.Interface.Aliasing.
 */
void
tp_svc_connection_interface_aliasing_emit_aliases_changed (gpointer instance,
    const GPtrArray *arg_aliases)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, TP_TYPE_SVC_CONNECTION_INTERFACE_ALIASING));
  g_signal_emit (instance,
      connection_interface_aliasing_signals[SIGNAL_CONNECTION_INTERFACE_ALIASING_AliasesChanged],
      0,
      arg_aliases);
}

static inline void
tp_svc_connection_interface_aliasing_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[1] = {
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Connection.Interface.Aliasing");
  tp_svc_interface_set_dbus_properties_info (TP_TYPE_SVC_CONNECTION_INTERFACE_ALIASING, &interface);

  connection_interface_aliasing_signals[SIGNAL_CONNECTION_INTERFACE_ALIASING_AliasesChanged] =
  g_signal_new ("aliases-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_INVALID)))));

  dbus_g_object_type_install_info (tp_svc_connection_interface_aliasing_get_type (),
      &_tp_svc_connection_interface_aliasing_object_info);
}
static void
tp_svc_connection_interface_aliasing_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      tp_svc_connection_interface_aliasing_base_init_once (klass);
    }
}
static const DBusGMethodInfo _tp_svc_connection_interface_aliasing_methods[] = {
  { (GCallback) tp_svc_connection_interface_aliasing_get_alias_flags, g_cclosure_marshal_VOID__POINTER, 0 },
  { (GCallback) tp_svc_connection_interface_aliasing_request_aliases, _tp_marshal_VOID__BOXED_POINTER, 86 },
  { (GCallback) tp_svc_connection_interface_aliasing_set_aliases, _tp_marshal_VOID__BOXED_POINTER, 188 },
};

static const DBusGObjectInfo _tp_svc_connection_interface_aliasing_object_info = {
  0,
  _tp_svc_connection_interface_aliasing_methods,
  3,
"org.freedesktop.Telepathy.Connection.Interface.Aliasing\0GetAliasFlags\0A\0arg0\0O\0F\0N\0u\0\0org.freedesktop.Telepathy.Connection.Interface.Aliasing\0RequestAliases\0A\0contacts\0I\0au\0arg1\0O\0F\0N\0as\0\0org.freedesktop.Telepathy.Connection.Interface.Aliasing\0SetAliases\0A\0aliases\0I\0a{us}\0\0\0",
"org.freedesktop.Telepathy.Connection.Interface.Aliasing\0AliasesChanged\0\0",
"\0\0",
};

static const DBusGObjectInfo _tp_svc_connection_interface_avatars_object_info;

struct _TpSvcConnectionInterfaceAvatarsClass {
    GTypeInterface parent_class;
    tp_svc_connection_interface_avatars_get_avatar_requirements_impl get_avatar_requirements;
    tp_svc_connection_interface_avatars_get_avatar_tokens_impl get_avatar_tokens;
    tp_svc_connection_interface_avatars_get_known_avatar_tokens_impl get_known_avatar_tokens;
    tp_svc_connection_interface_avatars_request_avatar_impl request_avatar;
    tp_svc_connection_interface_avatars_request_avatars_impl request_avatars;
    tp_svc_connection_interface_avatars_set_avatar_impl set_avatar;
    tp_svc_connection_interface_avatars_clear_avatar_impl clear_avatar;
};

enum {
    SIGNAL_CONNECTION_INTERFACE_AVATARS_AvatarUpdated,
    SIGNAL_CONNECTION_INTERFACE_AVATARS_AvatarRetrieved,
    N_CONNECTION_INTERFACE_AVATARS_SIGNALS
};
static guint connection_interface_avatars_signals[N_CONNECTION_INTERFACE_AVATARS_SIGNALS] = {0};

static void tp_svc_connection_interface_avatars_base_init (gpointer klass);

GType
tp_svc_connection_interface_avatars_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (TpSvcConnectionInterfaceAvatarsClass),
        tp_svc_connection_interface_avatars_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "TpSvcConnectionInterfaceAvatars", &info, 0);
    }

  return type;
}

/**
 * tp_svc_connection_interface_avatars_get_avatar_requirements_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetAvatarRequirements on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
static void
tp_svc_connection_interface_avatars_get_avatar_requirements (TpSvcConnectionInterfaceAvatars *self,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_avatars_get_avatar_requirements_impl impl = (TP_SVC_CONNECTION_INTERFACE_AVATARS_GET_CLASS (self)->get_avatar_requirements);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_avatars_implement_get_avatar_requirements:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetAvatarRequirements D-Bus method
 *
 * Register an implementation for the GetAvatarRequirements method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_avatars_implement_get_avatar_requirements (TpSvcConnectionInterfaceAvatarsClass *klass, tp_svc_connection_interface_avatars_get_avatar_requirements_impl impl)
{
  klass->get_avatar_requirements = impl;
}

/**
 * tp_svc_connection_interface_avatars_get_avatar_tokens_impl:
 * @self: The object implementing this interface
 * @in_contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetAvatarTokens on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
static void
tp_svc_connection_interface_avatars_get_avatar_tokens (TpSvcConnectionInterfaceAvatars *self,
    const GArray *in_contacts,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_avatars_get_avatar_tokens_impl impl = (TP_SVC_CONNECTION_INTERFACE_AVATARS_GET_CLASS (self)->get_avatar_tokens);

  if (impl != NULL)
    {
      (impl) (self,
        in_contacts,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_avatars_implement_get_avatar_tokens:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetAvatarTokens D-Bus method
 *
 * Register an implementation for the GetAvatarTokens method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_avatars_implement_get_avatar_tokens (TpSvcConnectionInterfaceAvatarsClass *klass, tp_svc_connection_interface_avatars_get_avatar_tokens_impl impl)
{
  klass->get_avatar_tokens = impl;
}

/**
 * tp_svc_connection_interface_avatars_get_known_avatar_tokens_impl:
 * @self: The object implementing this interface
 * @in_contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetKnownAvatarTokens on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
static void
tp_svc_connection_interface_avatars_get_known_avatar_tokens (TpSvcConnectionInterfaceAvatars *self,
    const GArray *in_contacts,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_avatars_get_known_avatar_tokens_impl impl = (TP_SVC_CONNECTION_INTERFACE_AVATARS_GET_CLASS (self)->get_known_avatar_tokens);

  if (impl != NULL)
    {
      (impl) (self,
        in_contacts,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_avatars_implement_get_known_avatar_tokens:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetKnownAvatarTokens D-Bus method
 *
 * Register an implementation for the GetKnownAvatarTokens method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_avatars_implement_get_known_avatar_tokens (TpSvcConnectionInterfaceAvatarsClass *klass, tp_svc_connection_interface_avatars_get_known_avatar_tokens_impl impl)
{
  klass->get_known_avatar_tokens = impl;
}

/**
 * tp_svc_connection_interface_avatars_request_avatar_impl:
 * @self: The object implementing this interface
 * @in_contact: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestAvatar on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
static void
tp_svc_connection_interface_avatars_request_avatar (TpSvcConnectionInterfaceAvatars *self,
    guint in_contact,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_avatars_request_avatar_impl impl = (TP_SVC_CONNECTION_INTERFACE_AVATARS_GET_CLASS (self)->request_avatar);

  if (impl != NULL)
    {
      (impl) (self,
        in_contact,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_avatars_implement_request_avatar:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestAvatar D-Bus method
 *
 * Register an implementation for the RequestAvatar method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_avatars_implement_request_avatar (TpSvcConnectionInterfaceAvatarsClass *klass, tp_svc_connection_interface_avatars_request_avatar_impl impl)
{
  klass->request_avatar = impl;
}

/**
 * tp_svc_connection_interface_avatars_request_avatars_impl:
 * @self: The object implementing this interface
 * @in_contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestAvatars on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
static void
tp_svc_connection_interface_avatars_request_avatars (TpSvcConnectionInterfaceAvatars *self,
    const GArray *in_contacts,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_avatars_request_avatars_impl impl = (TP_SVC_CONNECTION_INTERFACE_AVATARS_GET_CLASS (self)->request_avatars);

  if (impl != NULL)
    {
      (impl) (self,
        in_contacts,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_avatars_implement_request_avatars:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestAvatars D-Bus method
 *
 * Register an implementation for the RequestAvatars method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_avatars_implement_request_avatars (TpSvcConnectionInterfaceAvatarsClass *klass, tp_svc_connection_interface_avatars_request_avatars_impl impl)
{
  klass->request_avatars = impl;
}

/**
 * tp_svc_connection_interface_avatars_set_avatar_impl:
 * @self: The object implementing this interface
 * @in_avatar: const GArray * (FIXME, generate documentation)
 * @in_mime_type: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetAvatar on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
static void
tp_svc_connection_interface_avatars_set_avatar (TpSvcConnectionInterfaceAvatars *self,
    const GArray *in_avatar,
    const gchar *in_mime_type,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_avatars_set_avatar_impl impl = (TP_SVC_CONNECTION_INTERFACE_AVATARS_GET_CLASS (self)->set_avatar);

  if (impl != NULL)
    {
      (impl) (self,
        in_avatar,
        in_mime_type,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_avatars_implement_set_avatar:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetAvatar D-Bus method
 *
 * Register an implementation for the SetAvatar method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_avatars_implement_set_avatar (TpSvcConnectionInterfaceAvatarsClass *klass, tp_svc_connection_interface_avatars_set_avatar_impl impl)
{
  klass->set_avatar = impl;
}

/**
 * tp_svc_connection_interface_avatars_clear_avatar_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * ClearAvatar on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
static void
tp_svc_connection_interface_avatars_clear_avatar (TpSvcConnectionInterfaceAvatars *self,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_avatars_clear_avatar_impl impl = (TP_SVC_CONNECTION_INTERFACE_AVATARS_GET_CLASS (self)->clear_avatar);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_avatars_implement_clear_avatar:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the ClearAvatar D-Bus method
 *
 * Register an implementation for the ClearAvatar method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_avatars_implement_clear_avatar (TpSvcConnectionInterfaceAvatarsClass *klass, tp_svc_connection_interface_avatars_clear_avatar_impl impl)
{
  klass->clear_avatar = impl;
}

/**
 * tp_svc_connection_interface_avatars_emit_avatar_updated:
 * @instance: The object implementing this interface
 * @arg_contact: guint  (FIXME, generate documentation)
 * @arg_new_avatar_token: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * AvatarUpdated signal on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
void
tp_svc_connection_interface_avatars_emit_avatar_updated (gpointer instance,
    guint arg_contact,
    const gchar *arg_new_avatar_token)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, TP_TYPE_SVC_CONNECTION_INTERFACE_AVATARS));
  g_signal_emit (instance,
      connection_interface_avatars_signals[SIGNAL_CONNECTION_INTERFACE_AVATARS_AvatarUpdated],
      0,
      arg_contact,
      arg_new_avatar_token);
}

/**
 * tp_svc_connection_interface_avatars_emit_avatar_retrieved:
 * @instance: The object implementing this interface
 * @arg_contact: guint  (FIXME, generate documentation)
 * @arg_token: const gchar * (FIXME, generate documentation)
 * @arg_avatar: const GArray * (FIXME, generate documentation)
 * @arg_type: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * AvatarRetrieved signal on interface org.freedesktop.Telepathy.Connection.Interface.Avatars.
 */
void
tp_svc_connection_interface_avatars_emit_avatar_retrieved (gpointer instance,
    guint arg_contact,
    const gchar *arg_token,
    const GArray *arg_avatar,
    const gchar *arg_type)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, TP_TYPE_SVC_CONNECTION_INTERFACE_AVATARS));
  g_signal_emit (instance,
      connection_interface_avatars_signals[SIGNAL_CONNECTION_INTERFACE_AVATARS_AvatarRetrieved],
      0,
      arg_contact,
      arg_token,
      arg_avatar,
      arg_type);
}

static inline void
tp_svc_connection_interface_avatars_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[1] = {
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Connection.Interface.Avatars");
  tp_svc_interface_set_dbus_properties_info (TP_TYPE_SVC_CONNECTION_INTERFACE_AVATARS, &interface);

  connection_interface_avatars_signals[SIGNAL_CONNECTION_INTERFACE_AVATARS_AvatarUpdated] =
  g_signal_new ("avatar-updated",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _tp_marshal_VOID__UINT_STRING,
      G_TYPE_NONE,
      2,
      G_TYPE_UINT,
      G_TYPE_STRING);

  connection_interface_avatars_signals[SIGNAL_CONNECTION_INTERFACE_AVATARS_AvatarRetrieved] =
  g_signal_new ("avatar-retrieved",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      _tp_marshal_VOID__UINT_STRING_BOXED_STRING,
      G_TYPE_NONE,
      4,
      G_TYPE_UINT,
      G_TYPE_STRING,
      dbus_g_type_get_collection ("GArray", G_TYPE_UCHAR),
      G_TYPE_STRING);

  dbus_g_object_type_install_info (tp_svc_connection_interface_avatars_get_type (),
      &_tp_svc_connection_interface_avatars_object_info);
}
static void
tp_svc_connection_interface_avatars_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      tp_svc_connection_interface_avatars_base_init_once (klass);
    }
}
static const DBusGMethodInfo _tp_svc_connection_interface_avatars_methods[] = {
  { (GCallback) tp_svc_connection_interface_avatars_get_avatar_requirements, g_cclosure_marshal_VOID__POINTER, 0 },
  { (GCallback) tp_svc_connection_interface_avatars_get_avatar_tokens, _tp_marshal_VOID__BOXED_POINTER, 159 },
  { (GCallback) tp_svc_connection_interface_avatars_get_known_avatar_tokens, _tp_marshal_VOID__BOXED_POINTER, 261 },
  { (GCallback) tp_svc_connection_interface_avatars_request_avatar, g_cclosure_marshal_VOID__UINT_POINTER, 371 },
  { (GCallback) tp_svc_connection_interface_avatars_request_avatars, _tp_marshal_VOID__BOXED_POINTER, 482 },
  { (GCallback) tp_svc_connection_interface_avatars_set_avatar, _tp_marshal_VOID__BOXED_STRING_POINTER, 569 },
  { (GCallback) tp_svc_connection_interface_avatars_clear_avatar, g_cclosure_marshal_VOID__POINTER, 676 },
};

static const DBusGObjectInfo _tp_svc_connection_interface_avatars_object_info = {
  0,
  _tp_svc_connection_interface_avatars_methods,
  7,
"org.freedesktop.Telepathy.Connection.Interface.Avatars\0GetAvatarRequirements\0A\0arg0\0O\0F\0N\0as\0arg1\0O\0F\0N\0q\0arg2\0O\0F\0N\0q\0arg3\0O\0F\0N\0q\0arg4\0O\0F\0N\0q\0arg5\0O\0F\0N\0u\0\0org.freedesktop.Telepathy.Connection.Interface.Avatars\0GetAvatarTokens\0A\0contacts\0I\0au\0arg1\0O\0F\0N\0as\0\0org.freedesktop.Telepathy.Connection.Interface.Avatars\0GetKnownAvatarTokens\0A\0contacts\0I\0au\0arg1\0O\0F\0N\0a{us}\0\0org.freedesktop.Telepathy.Connection.Interface.Avatars\0RequestAvatar\0A\0contact\0I\0u\0arg1\0O\0F\0N\0ay\0arg2\0O\0F\0N\0s\0\0org.freedesktop.Telepathy.Connection.Interface.Avatars\0RequestAvatars\0A\0contacts\0I\0au\0\0org.freedesktop.Telepathy.Connection.Interface.Avatars\0SetAvatar\0A\0avatar\0I\0ay\0mime_type\0I\0s\0arg2\0O\0F\0N\0s\0\0org.freedesktop.Telepathy.Connection.Interface.Avatars\0ClearAvatar\0A\0\0\0",
"org.freedesktop.Telepathy.Connection.Interface.Avatars\0AvatarUpdated\0org.freedesktop.Telepathy.Connection.Interface.Avatars\0AvatarRetrieved\0\0",
"\0\0",
};

static const DBusGObjectInfo _tp_svc_connection_interface_capabilities_object_info;

struct _TpSvcConnectionInterfaceCapabilitiesClass {
    GTypeInterface parent_class;
    tp_svc_connection_interface_capabilities_advertise_capabilities_impl advertise_capabilities;
    tp_svc_connection_interface_capabilities_get_capabilities_impl get_capabilities;
};

enum {
    SIGNAL_CONNECTION_INTERFACE_CAPABILITIES_CapabilitiesChanged,
    N_CONNECTION_INTERFACE_CAPABILITIES_SIGNALS
};
static guint connection_interface_capabilities_signals[N_CONNECTION_INTERFACE_CAPABILITIES_SIGNALS] = {0};

static void tp_svc_connection_interface_capabilities_base_init (gpointer klass);

GType
tp_svc_connection_interface_capabilities_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (TpSvcConnectionInterfaceCapabilitiesClass),
        tp_svc_connection_interface_capabilities_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "TpSvcConnectionInterfaceCapabilities", &info, 0);
    }

  return type;
}

/**
 * tp_svc_connection_interface_capabilities_advertise_capabilities_impl:
 * @self: The object implementing this interface
 * @in_add: const GPtrArray * (FIXME, generate documentation)
 * @in_remove: const gchar ** (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * AdvertiseCapabilities on interface org.freedesktop.Telepathy.Connection.Interface.Capabilities.
 */
static void
tp_svc_connection_interface_capabilities_advertise_capabilities (TpSvcConnectionInterfaceCapabilities *self,
    const GPtrArray *in_add,
    const gchar **in_remove,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_capabilities_advertise_capabilities_impl impl = (TP_SVC_CONNECTION_INTERFACE_CAPABILITIES_GET_CLASS (self)->advertise_capabilities);

  if (impl != NULL)
    {
      (impl) (self,
        in_add,
        in_remove,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_capabilities_implement_advertise_capabilities:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the AdvertiseCapabilities D-Bus method
 *
 * Register an implementation for the AdvertiseCapabilities method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_capabilities_implement_advertise_capabilities (TpSvcConnectionInterfaceCapabilitiesClass *klass, tp_svc_connection_interface_capabilities_advertise_capabilities_impl impl)
{
  klass->advertise_capabilities = impl;
}

/**
 * tp_svc_connection_interface_capabilities_get_capabilities_impl:
 * @self: The object implementing this interface
 * @in_handles: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetCapabilities on interface org.freedesktop.Telepathy.Connection.Interface.Capabilities.
 */
static void
tp_svc_connection_interface_capabilities_get_capabilities (TpSvcConnectionInterfaceCapabilities *self,
    const GArray *in_handles,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_capabilities_get_capabilities_impl impl = (TP_SVC_CONNECTION_INTERFACE_CAPABILITIES_GET_CLASS (self)->get_capabilities);

  if (impl != NULL)
    {
      (impl) (self,
        in_handles,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_capabilities_implement_get_capabilities:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetCapabilities D-Bus method
 *
 * Register an implementation for the GetCapabilities method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_capabilities_implement_get_capabilities (TpSvcConnectionInterfaceCapabilitiesClass *klass, tp_svc_connection_interface_capabilities_get_capabilities_impl impl)
{
  klass->get_capabilities = impl;
}

/**
 * tp_svc_connection_interface_capabilities_emit_capabilities_changed:
 * @instance: The object implementing this interface
 * @arg_caps: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * CapabilitiesChanged signal on interface org.freedesktop.Telepathy.Connection.Interface.Capabilities.
 */
void
tp_svc_connection_interface_capabilities_emit_capabilities_changed (gpointer instance,
    const GPtrArray *arg_caps)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, TP_TYPE_SVC_CONNECTION_INTERFACE_CAPABILITIES));
  g_signal_emit (instance,
      connection_interface_capabilities_signals[SIGNAL_CONNECTION_INTERFACE_CAPABILITIES_CapabilitiesChanged],
      0,
      arg_caps);
}

static inline void
tp_svc_connection_interface_capabilities_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[1] = {
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Connection.Interface.Capabilities");
  tp_svc_interface_set_dbus_properties_info (TP_TYPE_SVC_CONNECTION_INTERFACE_CAPABILITIES, &interface);

  connection_interface_capabilities_signals[SIGNAL_CONNECTION_INTERFACE_CAPABILITIES_CapabilitiesChanged] =
  g_signal_new ("capabilities-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_INVALID)))));

  dbus_g_object_type_install_info (tp_svc_connection_interface_capabilities_get_type (),
      &_tp_svc_connection_interface_capabilities_object_info);
}
static void
tp_svc_connection_interface_capabilities_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      tp_svc_connection_interface_capabilities_base_init_once (klass);
    }
}
static const DBusGMethodInfo _tp_svc_connection_interface_capabilities_methods[] = {
  { (GCallback) tp_svc_connection_interface_capabilities_advertise_capabilities, _tp_marshal_VOID__BOXED_BOXED_POINTER, 0 },
  { (GCallback) tp_svc_connection_interface_capabilities_get_capabilities, _tp_marshal_VOID__BOXED_POINTER, 126 },
};

static const DBusGObjectInfo _tp_svc_connection_interface_capabilities_object_info = {
  0,
  _tp_svc_connection_interface_capabilities_methods,
  2,
"org.freedesktop.Telepathy.Connection.Interface.Capabilities\0AdvertiseCapabilities\0A\0add\0I\0a(su)\0remove\0I\0as\0arg2\0O\0F\0N\0a(su)\0\0org.freedesktop.Telepathy.Connection.Interface.Capabilities\0GetCapabilities\0A\0handles\0I\0au\0arg1\0O\0F\0N\0a(usuu)\0\0\0",
"org.freedesktop.Telepathy.Connection.Interface.Capabilities\0CapabilitiesChanged\0\0",
"\0\0",
};

static const DBusGObjectInfo _tp_svc_connection_interface_presence_object_info;

struct _TpSvcConnectionInterfacePresenceClass {
    GTypeInterface parent_class;
    tp_svc_connection_interface_presence_add_status_impl add_status;
    tp_svc_connection_interface_presence_clear_status_impl clear_status;
    tp_svc_connection_interface_presence_get_presence_impl get_presence;
    tp_svc_connection_interface_presence_get_statuses_impl get_statuses;
    tp_svc_connection_interface_presence_remove_status_impl remove_status;
    tp_svc_connection_interface_presence_request_presence_impl request_presence;
    tp_svc_connection_interface_presence_set_last_activity_time_impl set_last_activity_time;
    tp_svc_connection_interface_presence_set_status_impl set_status;
};

enum {
    SIGNAL_CONNECTION_INTERFACE_PRESENCE_PresenceUpdate,
    N_CONNECTION_INTERFACE_PRESENCE_SIGNALS
};
static guint connection_interface_presence_signals[N_CONNECTION_INTERFACE_PRESENCE_SIGNALS] = {0};

static void tp_svc_connection_interface_presence_base_init (gpointer klass);

GType
tp_svc_connection_interface_presence_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (TpSvcConnectionInterfacePresenceClass),
        tp_svc_connection_interface_presence_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "TpSvcConnectionInterfacePresence", &info, 0);
    }

  return type;
}

/**
 * tp_svc_connection_interface_presence_add_status_impl:
 * @self: The object implementing this interface
 * @in_status: const gchar * (FIXME, generate documentation)
 * @in_parms: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * AddStatus on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
static void
tp_svc_connection_interface_presence_add_status (TpSvcConnectionInterfacePresence *self,
    const gchar *in_status,
    GHashTable *in_parms,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_presence_add_status_impl impl = (TP_SVC_CONNECTION_INTERFACE_PRESENCE_GET_CLASS (self)->add_status);

  if (impl != NULL)
    {
      (impl) (self,
        in_status,
        in_parms,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_presence_implement_add_status:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the AddStatus D-Bus method
 *
 * Register an implementation for the AddStatus method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_presence_implement_add_status (TpSvcConnectionInterfacePresenceClass *klass, tp_svc_connection_interface_presence_add_status_impl impl)
{
  klass->add_status = impl;
}

/**
 * tp_svc_connection_interface_presence_clear_status_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * ClearStatus on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
static void
tp_svc_connection_interface_presence_clear_status (TpSvcConnectionInterfacePresence *self,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_presence_clear_status_impl impl = (TP_SVC_CONNECTION_INTERFACE_PRESENCE_GET_CLASS (self)->clear_status);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_presence_implement_clear_status:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the ClearStatus D-Bus method
 *
 * Register an implementation for the ClearStatus method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_presence_implement_clear_status (TpSvcConnectionInterfacePresenceClass *klass, tp_svc_connection_interface_presence_clear_status_impl impl)
{
  klass->clear_status = impl;
}

/**
 * tp_svc_connection_interface_presence_get_presence_impl:
 * @self: The object implementing this interface
 * @in_contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetPresence on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
static void
tp_svc_connection_interface_presence_get_presence (TpSvcConnectionInterfacePresence *self,
    const GArray *in_contacts,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_presence_get_presence_impl impl = (TP_SVC_CONNECTION_INTERFACE_PRESENCE_GET_CLASS (self)->get_presence);

  if (impl != NULL)
    {
      (impl) (self,
        in_contacts,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_presence_implement_get_presence:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetPresence D-Bus method
 *
 * Register an implementation for the GetPresence method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_presence_implement_get_presence (TpSvcConnectionInterfacePresenceClass *klass, tp_svc_connection_interface_presence_get_presence_impl impl)
{
  klass->get_presence = impl;
}

/**
 * tp_svc_connection_interface_presence_get_statuses_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * GetStatuses on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
static void
tp_svc_connection_interface_presence_get_statuses (TpSvcConnectionInterfacePresence *self,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_presence_get_statuses_impl impl = (TP_SVC_CONNECTION_INTERFACE_PRESENCE_GET_CLASS (self)->get_statuses);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_presence_implement_get_statuses:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the GetStatuses D-Bus method
 *
 * Register an implementation for the GetStatuses method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_presence_implement_get_statuses (TpSvcConnectionInterfacePresenceClass *klass, tp_svc_connection_interface_presence_get_statuses_impl impl)
{
  klass->get_statuses = impl;
}

/**
 * tp_svc_connection_interface_presence_remove_status_impl:
 * @self: The object implementing this interface
 * @in_status: const gchar * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RemoveStatus on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
static void
tp_svc_connection_interface_presence_remove_status (TpSvcConnectionInterfacePresence *self,
    const gchar *in_status,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_presence_remove_status_impl impl = (TP_SVC_CONNECTION_INTERFACE_PRESENCE_GET_CLASS (self)->remove_status);

  if (impl != NULL)
    {
      (impl) (self,
        in_status,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_presence_implement_remove_status:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RemoveStatus D-Bus method
 *
 * Register an implementation for the RemoveStatus method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_presence_implement_remove_status (TpSvcConnectionInterfacePresenceClass *klass, tp_svc_connection_interface_presence_remove_status_impl impl)
{
  klass->remove_status = impl;
}

/**
 * tp_svc_connection_interface_presence_request_presence_impl:
 * @self: The object implementing this interface
 * @in_contacts: const GArray * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * RequestPresence on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
static void
tp_svc_connection_interface_presence_request_presence (TpSvcConnectionInterfacePresence *self,
    const GArray *in_contacts,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_presence_request_presence_impl impl = (TP_SVC_CONNECTION_INTERFACE_PRESENCE_GET_CLASS (self)->request_presence);

  if (impl != NULL)
    {
      (impl) (self,
        in_contacts,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_presence_implement_request_presence:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the RequestPresence D-Bus method
 *
 * Register an implementation for the RequestPresence method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_presence_implement_request_presence (TpSvcConnectionInterfacePresenceClass *klass, tp_svc_connection_interface_presence_request_presence_impl impl)
{
  klass->request_presence = impl;
}

/**
 * tp_svc_connection_interface_presence_set_last_activity_time_impl:
 * @self: The object implementing this interface
 * @in_time: guint  (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetLastActivityTime on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
static void
tp_svc_connection_interface_presence_set_last_activity_time (TpSvcConnectionInterfacePresence *self,
    guint in_time,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_presence_set_last_activity_time_impl impl = (TP_SVC_CONNECTION_INTERFACE_PRESENCE_GET_CLASS (self)->set_last_activity_time);

  if (impl != NULL)
    {
      (impl) (self,
        in_time,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_presence_implement_set_last_activity_time:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetLastActivityTime D-Bus method
 *
 * Register an implementation for the SetLastActivityTime method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_presence_implement_set_last_activity_time (TpSvcConnectionInterfacePresenceClass *klass, tp_svc_connection_interface_presence_set_last_activity_time_impl impl)
{
  klass->set_last_activity_time = impl;
}

/**
 * tp_svc_connection_interface_presence_set_status_impl:
 * @self: The object implementing this interface
 * @in_statuses: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * SetStatus on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
static void
tp_svc_connection_interface_presence_set_status (TpSvcConnectionInterfacePresence *self,
    GHashTable *in_statuses,
    DBusGMethodInvocation *context)
{
  tp_svc_connection_interface_presence_set_status_impl impl = (TP_SVC_CONNECTION_INTERFACE_PRESENCE_GET_CLASS (self)->set_status);

  if (impl != NULL)
    {
      (impl) (self,
        in_statuses,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

/**
 * tp_svc_connection_interface_presence_implement_set_status:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the SetStatus D-Bus method
 *
 * Register an implementation for the SetStatus method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
tp_svc_connection_interface_presence_implement_set_status (TpSvcConnectionInterfacePresenceClass *klass, tp_svc_connection_interface_presence_set_status_impl impl)
{
  klass->set_status = impl;
}

/**
 * tp_svc_connection_interface_presence_emit_presence_update:
 * @instance: The object implementing this interface
 * @arg_presence: GHashTable * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * PresenceUpdate signal on interface org.freedesktop.Telepathy.Connection.Interface.Presence.
 */
void
tp_svc_connection_interface_presence_emit_presence_update (gpointer instance,
    GHashTable *arg_presence)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, TP_TYPE_SVC_CONNECTION_INTERFACE_PRESENCE));
  g_signal_emit (instance,
      connection_interface_presence_signals[SIGNAL_CONNECTION_INTERFACE_PRESENCE_PresenceUpdate],
      0,
      arg_presence);
}

static inline void
tp_svc_connection_interface_presence_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  static TpDBusPropertiesMixinPropInfo properties[1] = {
      { 0, 0, NULL, 0, NULL, NULL }
  };
  static TpDBusPropertiesMixinIfaceInfo interface =
      { 0, properties, NULL, NULL };

  interface.dbus_interface = g_quark_from_static_string ("org.freedesktop.Telepathy.Connection.Interface.Presence");
  tp_svc_interface_set_dbus_properties_info (TP_TYPE_SVC_CONNECTION_INTERFACE_PRESENCE, &interface);

  connection_interface_presence_signals[SIGNAL_CONNECTION_INTERFACE_PRESENCE_PresenceUpdate] =
  g_signal_new ("presence-update",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_map ("GHashTable", G_TYPE_UINT, (dbus_g_type_get_struct ("GValueArray", G_TYPE_UINT, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_VALUE)))), G_TYPE_INVALID)))));

  dbus_g_object_type_install_info (tp_svc_connection_interface_presence_get_type (),
      &_tp_svc_connection_interface_presence_object_info);
}
static void
tp_svc_connection_interface_presence_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      tp_svc_connection_interface_presence_base_init_once (klass);
    }
}
static const DBusGMethodInfo _tp_svc_connection_interface_presence_methods[] = {
  { (GCallback) tp_svc_connection_interface_presence_add_status, _tp_marshal_VOID__STRING_BOXED_POINTER, 0 },
  { (GCallback) tp_svc_connection_interface_presence_clear_status, g_cclosure_marshal_VOID__POINTER, 94 },
  { (GCallback) tp_svc_connection_interface_presence_get_presence, _tp_marshal_VOID__BOXED_POINTER, 165 },
  { (GCallback) tp_svc_connection_interface_presence_get_statuses, g_cclosure_marshal_VOID__POINTER, 282 },
  { (GCallback) tp_svc_connection_interface_presence_remove_status, _tp_marshal_VOID__STRING_POINTER, 379 },
  { (GCallback) tp_svc_connection_interface_presence_request_presence, _tp_marshal_VOID__BOXED_POINTER, 462 },
  { (GCallback) tp_svc_connection_interface_presence_set_last_activity_time, g_cclosure_marshal_VOID__UINT_POINTER, 551 },
  { (GCallback) tp_svc_connection_interface_presence_set_status, _tp_marshal_VOID__BOXED_POINTER, 639 },
};

static const DBusGObjectInfo _tp_svc_connection_interface_presence_object_info = {
  0,
  _tp_svc_connection_interface_presence_methods,
  8,
"org.freedesktop.Telepathy.Connection.Interface.Presence\0AddStatus\0A\0status\0I\0s\0parms\0I\0a{sv}\0\0org.freedesktop.Telepathy.Connection.Interface.Presence\0ClearStatus\0A\0\0org.freedesktop.Telepathy.Connection.Interface.Presence\0GetPresence\0A\0contacts\0I\0au\0presence\0O\0F\0N\0a{u(ua{sa{sv}})}\0\0org.freedesktop.Telepathy.Connection.Interface.Presence\0GetStatuses\0A\0arg0\0O\0F\0N\0a{s(ubba{ss})}\0\0org.freedesktop.Telepathy.Connection.Interface.Presence\0RemoveStatus\0A\0status\0I\0s\0\0org.freedesktop.Telepathy.Connection.Interface.Presence\0RequestPresence\0A\0contacts\0I\0au\0\0org.freedesktop.Telepathy.Connection.Interface.Presence\0SetLastActivityTime\0A\0time\0I\0u\0\0org.freedesktop.Telepathy.Connection.Interface.Presence\0SetStatus\0A\0statuses\0I\0a{sa{sv}}\0\0\0",
"org.freedesktop.Telepathy.Connection.Interface.Presence\0PresenceUpdate\0\0",
"\0\0",
};


