/* -*- Mode: javascript; tab-width: 20; indent-tabs-mode: nil; c-basic-offset: 4 -*-*/
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Spicebird Calendar Code
 *
 * The Initial Developer of the Original Code is Prasad Sunkari.
 * Portions created by the Initial Developer are Copyright (C) 2008
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Prasad Sunkari <prasad@synovel.com>
 *                 Ashok Gudibandla <ashok@synovel.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

const gCalendarAppName = "calendar";
const gTasksAppName = "tasks";

var calendarAppObserver = {
   observe: function (aSubject, aTopic, aCurrentApp) {
      if (aTopic == "csApplicationSwitched") {
         if (aCurrentApp == gCalendarAppName)
            this.switchToCalendar();
         else if (aCurrentApp == gTasksAppName)
            this.switchToTasks();
      }
   },
   
   switchToCalendar: function() {
      ltnSwitch2Calendar();

      // Restore the previously focused element if any.
      var focusElement = gFocusElements[gCalendarAppName];
      if (!focusElement)
      	focusElement = document.getElementById("calendar-list-tree-widget");
      focusElement.focus();

      calendarController.updateCommands();
      calendarAppController.updateCommands();
   },
   
   switchToTasks: function() {
       ltnSwitch2Task();

       // Restore the previously focused element if any.
       var focusElement = gFocusElements[gTasksAppName];
       if (!focusElement) {
         var taskTree = document.getElementById("calendar-task-tree");
         focusElement = document.getAnonymousElementByAttribute(taskTree, "anonid", "calendar-task-tree");
       }
       focusElement.focus();

       calendarController.updateCommands();

        var filter = "all";
        if (document.getElementById("task-tree-filtergroup") &&
            document.getElementById("task-tree-filtergroup").value)
            filter = document.getElementById("task-tree-filtergroup").value;

        taskViewUpdate(filter);
   },
}

function csObserveViewDaySelect(event) {
    var date = event.detail;
    var jsDate = new Date(date.year, date.month, date.day);
    
    // for the month and multiweek view find the main month,
    // which is the month with the most visible days in the view;
    // note, that the main date is the first day of the main month
    var jsMainDate;
    if (!event.originalTarget.supportsDisjointDates) {
        var mainDate = null;
        var maxVisibleDays = 0;
        var startDay = currentView().startDay;
        var endDay = currentView().endDay;
        var firstMonth = startDay.startOfMonth;
        var lastMonth = endDay.startOfMonth;
        for (var month = firstMonth.clone(); month.compare(lastMonth) <= 0; month.month += 1) {
            var visibleDays = 0;
            if (month.compare(firstMonth) == 0) {
                visibleDays = startDay.endOfMonth.day - startDay.day + 1;
            } else if (month.compare(lastMonth) == 0) { 
                visibleDays = endDay.day;
            } else {
                visibleDays = month.endOfMonth.day;
            }
            if (visibleDays > maxVisibleDays) {
                mainDate = month.clone();
                maxVisibleDays = visibleDays;
            }
        }
        jsMainDate = new Date(mainDate.year, mainDate.month, mainDate.day);
    }
    document.getElementById("sidebar-calendar-datepicker").dateValue = jsDate; 
    currentView().focus();
}

function doQuickAdd() {
   window.openDialog("chrome://calendar/content/csQuickAddEvent.xul", "Quick Add",
                        "chrome, modal, resizable,centerscreen,dialog=yes", null);
}

/**
  * This controller holds all the commands that can be triggered from other
  * applications. 
  */
var calCommonCmdController = {
   commands : {
         "calendar_new_event_command" : true,
         "calendar_new_todo_command" : true,
         "calendar_new_calendar_command" : true,
   },

   supportsCommand: function (aCommand) {
      if (aCommand in this.commands) 
         return true;
      return false;
   },

   isCommandEnabled: function (aCommand) {
      if (aCommand in this.commands) 
         return true;
      return false;
   },

   doCommand: function (aCommand) {
      switch(aCommand) {
         case "calendar_new_event_command" : 
            createEventWithDialog(getSelectedCalendar());
            break;
         case "calendar_new_todo_command" : 
            createTodoWithDialog(getSelectedTasksCalendar());
            break;
         case "calendar_new_calendar_command" : 
            openCalendarWizard();
            break;
      }
      return false;
   },

   updateCommands: function () {
        for (var command in this.commands) {
            goUpdateCommand(command);
        }
   },


   onEvent: function (aEvent) {
   },
};

var calendarAppController = {
   commands : {
      "cmd_selectAll": true,
      "cmd_new": true,
      "cmd_newTask": true,
      "cmd-weeks-in-multiweek-view": true
   },

   updateCommands: function () {
      for (var command in this.commands)
         goUpdateCommand(command);
   },

   supportsCommand : function (cmd) {
      if (cmd in this.commands)
         return true;
      return false;
   },

   isCommandEnabled : function (cmd) {
      switch(cmd) {
         case "cmd_selectAll":
         case "cmd_new":
         case "cmd_newTask":
            return true;
         case "cmd-weeks-in-multiweek-view":
            return getViewDeck().selectedPanel.id == "multiweek-view" &&
                    getViewDeck().getAttribute("collapsed") != "true";
         default :
            return false;
       }
    },

   doCommand : function (cmd) {
      switch(cmd) {
         case "cmd_selectAll":
            selectAllEvents();
            break;
         case "cmd_new":
            goDoCommand('calendar_new_event_command');
            break;
         case "cmd_newTask":
            goDoCommand('calendar_new_todo_command');
            break;
         default :
            return false;
       }
    }
}

function updateAssisteTzPopup() {
   var timezonePopup = document.getElementById("assist-tz-list-popup");
   var elem = document.getElementById('week-view');
   var multiView = document.getAnonymousElementByAttribute(elem,"anonid", "view-element" );

   while(timezonePopup.lastChild)
      timezonePopup.removeChild(timezonePopup.lastChild);

   function createItem (label, value, group) {
      var item = document.createElement("menuitem");
      item.setAttribute('label',label);
      item.setAttribute('value',value);
      if (value == multiView.assistTimezone) 
         item.setAttribute("checked", "true");
      if (group) {
         item.setAttribute('name','tz-group');
         item.setAttribute('type','radio');
      }
      return item;
   }

   timezonePopup.appendChild(createItem("None", "--none--", true));
   // Get the list of timeZones
   var TimezonesComp =  Components.classes["@synovel.com/collab/collab/timezones;1"]
                              .getService().QueryInterface(Components.interfaces.csITimezones);
   var defaultTzIds = TimezonesComp.getDefaultTimezoneIds({});
   for(var i=0;i<defaultTzIds.length;i++)
   {
      var names = defaultTzIds[i].split('/');
      var label = names[names.length - 1];
      timezonePopup.appendChild(createItem(label, defaultTzIds[i], true));
   }
   timezonePopup.appendChild(document.createElement("menuseparator"));
   // Add 'More..' option
   timezonePopup.appendChild(createItem("More...", "--more--", false));
}

function changeAssistTimezone(tzId) {
   var weekView = document.getElementById('week-view');
   var dayView = document.getElementById('day-view');
   var weekViewElem = document.getAnonymousElementByAttribute(weekView,"anonid", "view-element" );
   var dayViewElem = document.getAnonymousElementByAttribute(dayView,"anonid", "view-element" );
   if (tzId == "--more--") {
      openTimezoneSelectDialog();
      return;
   }
   else {
      weekViewElem.assistTimezone = tzId;
      dayViewElem.assistTimezone = tzId;
   }
}

function csToggleCompletedTasks()
{
    var showCommand = document.getElementById("show-completed-checkbox");
    var tasksTree = document.getElementById("calendar-task-tree");

    if (!showCommand)
        return;

    if (showCommand.hasAttribute("checked"))
        showCommand.removeAttribute("checked");
    else
        showCommand.setAttribute("checked", "true");

    if (tasksTree) {
        tasksTree.showCompleted = showCommand.hasAttribute("checked");
        tasksTree.refresh();
    }
}

function taskSearchbarKeyPress( searchTextItem, event )
{
    clearSearchTimer();

    if (event && event.keyCode == event.DOM_VK_RETURN) {
        filterTasksInTree(searchTextItem.value);
        return; 
    }
    else if (event && event.keyCode == event.DOM_VK_ESCAPE) {
      searchTextItem.value = "";
      clearSearchTimer();
      var taskTree = document.getElementById("calendar-task-tree");
      taskTree.refresh();
      return;
    }
    
    // make a new timer
    gSearchTimeout = setTimeout( function(){ filterTasksInTree(searchTextItem.value); }, 500 );
}

function filterTasksInTree(aText) {
  var regex = new RegExp (aText, "i");
  var taskTree = document.getElementById("calendar-task-tree");
  taskTree.search(regex);
}

function getTasksMinimonth () {
  return document.getElementById("taskminicalendar");
}

var tasksCmdController = {
   supportsCommand : function (cmd) {
      switch(cmd) {
         case "cmd_selectAll":
         case "cmd_delete":
         case "cmd_new":
            return true;
         default :
            return false;
       }
    },

   isCommandEnabled : function (cmd) {
      switch(cmd) {
         case "cmd_selectAll":
         case "cmd_delete":
            return calendarController.isCommandEnabled("calendar_delete_todo_command");
         case "cmd_new":
            return true;
         default :
            return false;
       }
    },

   doCommand : function (cmd) {
      switch(cmd) {
         case "cmd_selectAll":
            document.getElementById("calendar-task-tree").mTreeView.selection.selectAll();
            break;
         case "cmd_delete":
            calendarController.goDoCommand("calendar_delete_todo_command");
            break;
         case "cmd_new":
            goDoCommand('calendar_new_todo_command');
            break;
         default :
            return false;
       }
    }
}

function tasksInit () {
    var tabcollab = document.getElementById ("tabcollab");
    var newTab = tabcollab.addTab (50);
    var StringBundle = document.getElementById("bundle_collab");
    newTab.setAttribute ("label", StringBundle.getString("tasksTitle"));

    newTab.setAttribute ("onselect", "setCurrentApp('" + gTasksAppName + "')");
    newTab.setAttribute ("image", "chrome://calendar/skin/16x16/task.png");
    newTab.setAttribute ("type", "tasks");
    newTab.setAttribute ("id", "tab-tasks");
    newTab.setAttribute ("linkedpanel", "tabpanel-tasks");

    var controllers = getLinkedTabPanel(newTab).controllers;
    controllers.appendController(tasksCmdController);
    controllers.appendController(calendarController);

    getSelectedTasks = function(aEvent) {
        var taskTree = document.getElementById("calendar-task-tree");
        if (taskTree != null) {
            return taskTree.selectedTasks;
        } else {
            return [];
        }
    }

    // Set up the tree view
    setupTasksView();
}

// Enable app status in appInfo component
var calendarAppInfoClass = Components.classes["@synovel.com/collab/calendar-appinfo;1"];
if (calendarAppInfoClass) {
    var calendarAppInfo = calendarAppInfoClass.getService(Components.interfaces.csIAppInfo);
    if (calendarAppInfo)
        calendarAppInfo.enabled = true;
}

function collabCalendarInit () {
    var tabcollab = document.getElementById ("tabcollab");
    var newTab = tabcollab.addTab (40);
    var StringBundle = document.getElementById("bundle_collab");
    newTab.setAttribute ("label", StringBundle.getString("calendarTitle"));

    newTab.setAttribute ("onselect", "setCurrentApp('" + gCalendarAppName + "')");
    newTab.setAttribute ("image", "chrome://calendar/skin/16x16/office-calendar.png");
    newTab.setAttribute ("type", "calendar");
    newTab.setAttribute ("id", "tab-calendar");
    newTab.setAttribute ("linkedpanel", "tabpanel-calendar");
   
    var controllers = getLinkedTabPanel(newTab).controllers;
    controllers.appendController(calendarAppController);
    controllers.appendController(calendarController);

    gObserverService.addObserver(calendarAppObserver, "csApplicationSwitched", false)
    ltnOnLoad();

    var taskTree = document.getElementById("calendar-task-tree");
    var hideCompleted = document.getElementById("hide-completed-checkbox");
    if (taskTree && hideCompleted)
        taskTree.hideCompleted = hideCompleted.hasAttribute("checked");

    addCommonController(calCommonCmdController);
    calCommonCmdController.updateCommands();
}

/*
 * Duplicate of method changeContextMenuForTask
 * used to update menubar popup for tasks.
 */
function changeMenuForTask(aEvent) {
    var tasks = getSelectedTasks(aEvent);
    var task = null;
    var tasksSelected = (tasks.length > 0);
    applyAttributeToMenuChildren(aEvent.target, "disabled", (!tasksSelected));
    document.getElementById("calendar_new_todo_command").removeAttribute("disabled");
    if (tasksSelected) {
        if (isPropertyValueSame(tasks, "isCompleted")) {
            setBooleanAttribute(document.getElementById("task-menu-markcompleted"), "checked", tasks[0].isCompleted);
        } else {
            document.getElementById("task-menu-markcompleted").setAttribute("checked", false);
        }
    }
}

function changeNumberOfWeeks(aMenuItem) {
    var mwView = document.getElementById("multiweek-view");
    mwView.weeksInView = aMenuItem.value;
}

addEventListener("load", collabCalendarInit, true);
addEventListener("load", tasksInit, true);
