# accuraterip-checksum

## Description
A C99 command line program to compute the [AccurateRip](http://accuraterip.com/) checksum of single track WAV files, i.e. WAV files which contain only a single track of an audio CD.  
Such files can for example be generated by [Exact Audio Copy](http://exactaudiocopy.de/) and various other CD ripping programs, as listed e.g. [here](http://accuraterip.com/software.htm) and [here](https://wiki.hydrogenaud.io/index.php?title=AccurateRip).

Implemented according to [this thread on HydrogenAudio](http://www.hydrogenaudio.org/forums/index.php?showtopic=97603).

## Usage
Calculate AccurateRip v2 checksum of track number ```TRACK``` which is contained in WAV file ```TRACK_FILE```, and which was ripped from a disc with a total track count of ```TOTAL_TRACKS```:

	accuraterip-checksum TRACK_FILE TRACK TOTAL_TRACKS

Explicitly choose AccurateRip checksum version, where ```VERSION``` is 1 or 2:

	accuraterip-checksum --accuraterip-vVERSION TRACK_FILE TRACK TOTAL_TRACKS

Show accuraterip-checksum program version (this is **not** the AccurateRip checksum version!):

	accuraterip-checksum --version

The version of accuraterip-checksum should be added to the tags of audio files which were processed using the output of accuraterip-checksum:  
If any severe bugs are ever found in accuraterip-checksum this will allow you to identify files which were tagged using affected version.

## Dependencies
libsndfile is used for reading the WAV files.
Therefore, on Ubuntu, make sure you have the following packages installed:

	libsndfile1

For compiling you need:

	libsndfile1-dev

## Author
Leo Bogert (http://leo.bogert.de)

## Version
1.5

## Donations
	bitcoin:14kPd2QWsri3y2irVFX6wC33vv7FqTaEBh

## License
GPLv3
