/*
 * Copyright (C) 2025 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#if USE(CORE_IMAGE)

#import "FilterEffectApplier.h"
#import <wtf/TZoneMalloc.h>

namespace WebCore {

class FEComposite;

class FECompositeCoreImageApplier final : public FilterEffectConcreteApplier<FEComposite> {
    WTF_MAKE_TZONE_ALLOCATED(FECompositeCoreImageApplier);
    using Base = FilterEffectConcreteApplier<FEComposite>;

public:
    FECompositeCoreImageApplier(const FEComposite&);

    static bool supportsCoreImageRendering(const FEComposite&);

private:
    bool apply(const Filter&, std::span<const Ref<FilterImage>>, FilterImage&) const final;

    RetainPtr<CIImage> applyBuiltIn(RetainPtr<CIImage>&&, RetainPtr<CIImage>&&, const FloatRect& extent) const;
    RetainPtr<CIImage> applyArithmetic(RetainPtr<CIImage>&&, RetainPtr<CIImage>&&, const FloatRect& extent) const;
};

} // namespace WebCore

#endif // USE(CORE_IMAGE)
