/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_prussian(int filter,struct epsg_defs **first, struct epsg_defs **last)
{
/* old Prussian based on Cassini-Soldner - kindly contributed by Mark Johnson */
    struct epsg_defs *p;
    p = add_epsg_def(filter,first,last,187900,"mj10777.de",187900,"DHDN / Soldner Rathausnetz 660");
    add_proj4text(p,0,"+proj=cass +lat_0=52.41864827777778 +lon_0=13.62720366666667 ");
    add_proj4text(p,1,"+x_0=14741.77 +y_0=-11288.28 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner Rathausnetz 660\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",52.41864827777778],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",13.62720366666667],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",14741.77],PARAMETER[\"false_northing\",-11288.28],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187900\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187901,"mj10777.de",187901,"DHDN / Soldner 1 Kucklinsberg");
    add_proj4text(p,0,"+proj=cass +lat_0=54.46022375 +lon_0=21.95509736 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 1 Kucklinsberg\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",54.46022375],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",21.95509736],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187901\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187902,"mj10777.de",187902,"DHDN / Soldner 2 Paulinen");
    add_proj4text(p,0,"+proj=cass +lat_0=54.28921067 +lon_0=20.73315431 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 2 Paulinen\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",54.28921067],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",20.73315431],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187902\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187903,"mj10777.de",187903,"DHDN / Soldner 3 Markushof I");
    add_proj4text(p,0,"+proj=cass +lat_0=54.05881333 +lon_0=19.37343583 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 3 Markushof I\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",54.05881333],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",19.37343583],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187903\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187904,"mj10777.de",187904,"DHDN / Soldner 4 Thurmberg");
    add_proj4text(p,0,"+proj=cass +lat_0=54.22552092 +lon_0=18.12569375 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 4 Thurmberg\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",54.22552092],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",18.12569375],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187904\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187905,"mj10777.de",187905,"DHDN / Soldner 5 Kauernick I");
    add_proj4text(p,0,"+proj=cass +lat_0=53.38933197 +lon_0=19.59810438 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 5 Kauernick I\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",53.38933197],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",19.59810438],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187905\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187906,"mj10777.de",187906,"DHDN / Soldner 6 Thorn, Rathausturm");
    add_proj4text(p,0,"+proj=cass +lat_0=53.01181586 +lon_0=18.60725428 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 6 Thorn, Rathausturm\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",53.01181586],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",18.60725428],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187906\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187907,"mj10777.de",187907,"DHDN / Soldner 7 Heinrichsthal");
    add_proj4text(p,0,"+proj=cass +lat_0=53.71289217 +lon_0=17.49676781 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 7 Heinrichsthal\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",53.71289217],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",17.49676781],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187907\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187908,"mj10777.de",187908,"DHDN / Soldner 8 Gollenberg, Denkmal");
    add_proj4text(p,0,"+proj=cass +lat_0=54.20857178 +lon_0=16.22956781 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 8 Gollenberg, Denkmal\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",54.20857178],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",16.22956781],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187908\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187909,"mj10777.de",187909,"DHDN / Soldner 9 Gnesen");
    add_proj4text(p,0,"+proj=cass +lat_0=52.53820406 +lon_0=17.59450500 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 9 Gnesen\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",52.53820406],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",17.59450500],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187909\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187910,"mj10777.de",187910,"DHDN / Soldner 10 Josefsberg");
    add_proj4text(p,0,"+proj=cass +lat_0=51.98768806 +lon_0=16.20044389 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 10 Josefsberg\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",51.98768806],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",16.20044389],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187910\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187911,"mj10777.de",187911,"DHDN / Soldner 11 Schroda");
    add_proj4text(p,0,"+proj=cass +lat_0=52.23137372 +lon_0=17.27795372 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 11 Schroda\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",52.23137372],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",17.27795372],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187911\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187912,"mj10777.de",187912,"DHDN / Soldner 12 Pschow");
    add_proj4text(p,0,"+proj=cass +lat_0=50.04206544 +lon_0=18.39610692 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 12 Pschow\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",50.04206544],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",18.39610692],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187912\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187913,"mj10777.de",187913,"DHDN / Soldner 13 Rummelsberg");
    add_proj4text(p,0,"+proj=cass +lat_0=50.70352314 +lon_0=17.11233917 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 13 Rummelsberg\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",50.70352314],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",17.11233917],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187913\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187914,"mj10777.de",187914,"DHDN / Soldner 14 Gröditzberg I");
    add_proj4text(p,0,"+proj=cass +lat_0=51.17819342 +lon_0=15.76127086 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 14 Gröditzberg I\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",51.17819342],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",15.76127086],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187914\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187915,"mj10777.de",187915,"DHDN / Soldner 15 Kaltenborn");
    add_proj4text(p,0,"+proj=cass +lat_0=51.92903708 +lon_0=14.66212942 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 15 Kaltenborn\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",51.92903708],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",14.66212942],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187915\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187917,"mj10777.de",187917,"DHDN / Soldner 17 Greifswald, Nikolaikirche");
    add_proj4text(p,0,"+proj=cass +lat_0=54.09698872 +lon_0=13.37880703 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 17 Greifswald, Nikolaikirche\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",54.09698872],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",13.37880703],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187917\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187916,"mj10777.de",187916,"DHDN / Soldner 16 Bahn I");
    add_proj4text(p,0,"+proj=cass +lat_0=53.10184583 +lon_0=14.70144539 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 16 Bahn I\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",53.10184583],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",14.70144539],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187916\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187918,"mj10777.de",187918,"DHDN / Soldner 18 Müggelberg 600");
    add_proj4text(p,0,"+proj=cass +lat_0=52.41864827777778 +lon_0=13.62720366666667 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 18 Müggelberg 600\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",52.41864827777778],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",13.62720366666667],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187918\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187919,"mj10777.de",187919,"DHDN / Soldner 19 Götzer Berg 650");
    add_proj4text(p,0,"+proj=cass +lat_0=52.43725961111112 +lon_0=12.72882972222223 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 19 Götzer Berg 650\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",52.43725961111112],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",12.72882972222223],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187919\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187920,"mj10777.de",187920,"DHDN / Soldner 20 Torgau, Stadtkirche");
    add_proj4text(p,0,"+proj=cass +lat_0=51.56136217 +lon_0=13.00760264 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 20 Torgau, Stadtkirche\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",51.56136217],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",13.00760264],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187920\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187921,"mj10777.de",187921,"DHDN / Soldner 21 Burkersroda, Kirchturm");
    add_proj4text(p,0,"+proj=cass +lat_0=51.17656322 +lon_0=11.64139367 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 21 Burkersroda, Kirchturm\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",51.17656322],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",11.64139367],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187921\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187922,"mj10777.de",187922,"DHDN / Soldner 22 Inselsberg");
    add_proj4text(p,0,"+proj=cass +lat_0=50.85237983 +lon_0=10.46776506 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 22 Inselsberg\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",50.85237983],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",10.46776506],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187922\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187923,"mj10777.de",187923,"DHDN / Soldner 23 Magdeburg");
    add_proj4text(p,0,"+proj=cass +lat_0=52.12625311 +lon_0=11.63550325 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 23 Magdeburg\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",52.12625311],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",11.63550325],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187923\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187924,"mj10777.de",187924,"DHDN / Soldner 24 Ostenfeld I");
    add_proj4text(p,0,"+proj=cass +lat_0=54.47018733 +lon_0=9.23411097 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 24 Ostenfeld I\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",54.47018733],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",9.23411097],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187924\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187925,"mj10777.de",187925,"DHDN / Soldner 25 Rathkrügen");
    add_proj4text(p,0,"+proj=cass +lat_0=53.81839364 +lon_0=10.04220189 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 25 Rathkrügen\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",53.81839364],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",10.04220189],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187925\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187926,"mj10777.de",187926,"DHDN / Soldner 26 Bungsberg, Aussichtsturm");
    add_proj4text(p,0,"+proj=cass +lat_0=54.21110653 +lon_0=10.72636431 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 26 Bungsberg, Aussichtsturm\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",54.21110653],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",10.72636431],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187926\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187927,"mj10777.de",187927,"DHDN / Soldner 27 Celle, Stadtkirche");
    add_proj4text(p,0,"+proj=cass +lat_0=52.62574192 +lon_0=10.08190214 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 27 Celle, Stadtkirche\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",52.62574192],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",10.08190214],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187927\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187928,"mj10777.de",187928,"DHDN / Soldner 28 Kaltenborn");
    add_proj4text(p,0,"+proj=cass +lat_0=51.79646722 +lon_0=10.27322494 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 28 Kaltenborn\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",51.79646722],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",10.27322494],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187928\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187929,"mj10777.de",187929,"DHDN / Soldner 29 Silberberg");
    add_proj4text(p,0,"+proj=cass +lat_0=53.73123461 +lon_0=9.05774925 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 29 Silberberg\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",53.73123461],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",9.05774925],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187929\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187930,"mj10777.de",187930,"DHDN / Soldner 30 Windberg");
    add_proj4text(p,0,"+proj=cass +lat_0=52.88088372 +lon_0=7.53062114 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 30 Windberg\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",52.88088372],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",7.53062114],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187930\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187931,"mj10777.de",187931,"DHDN / Soldner 31 Hermannsdenkmal");
    add_proj4text(p,0,"+proj=cass +lat_0=51.91301647 +lon_0=8.84051853 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 31 Hermannsdenkmal\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",51.91301647],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",8.84051853],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187931\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187932,"mj10777.de",187932,"DHDN / Soldner 32 Münster");
    add_proj4text(p,0,"+proj=cass +lat_0=51.96547642 +lon_0=7.62334994 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 32 Münster\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",51.96547642],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",7.62334994],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187932\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187933,"mj10777.de",187933,"DHDN / Soldner 33 Bochum, Peter-Paul-Kirche");
    add_proj4text(p,0,"+proj=cass +lat_0=51.48373533 +lon_0=7.22115822 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 33 Bochum, Peter-Paul-Kirche\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",51.48373533],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",7.22115822],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187933\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187934,"mj10777.de",187934,"DHDN / Soldner 34 Homert");
    add_proj4text(p,0,"+proj=cass +lat_0=51.26480147 +lon_0=8.10687050 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 34 Homert\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",51.26480147],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",8.10687050],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187934\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187935,"mj10777.de",187935,"DHDN / Soldner 35 Kassel, Martinskirche");
    add_proj4text(p,0,"+proj=cass +lat_0=51.31846489 +lon_0=9.50203072 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 35 Kassel, Martinskirche\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",51.31846489],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",9.50203072],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187935\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187936,"mj10777.de",187936,"DHDN / Soldner 36 Schaumburg, Schloßturm");
    add_proj4text(p,0,"+proj=cass +lat_0=50.34048964 +lon_0=7.97808156 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 36 Schaumburg, Schloßturm\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",50.34048964],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",7.97808156],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187936\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187937,"mj10777.de",187937,"DHDN / Soldner 37 Fleckert");
    add_proj4text(p,0,"+proj=cass +lat_0=50.18762544 +lon_0=7.60594289 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 37 Fleckert\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",50.18762544],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",7.60594289],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187937\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187938,"mj10777.de",187938,"DHDN / Soldner 38 Cöln, Dom");
    add_proj4text(p,0,"+proj=cass +lat_0=50.94257242 +lon_0=6.95897600 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 38 Cöln, Dom\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",50.94257242],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",6.95897600],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187938\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187939,"mj10777.de",187939,"DHDN / Soldner 39 Langschoß");
    add_proj4text(p,0,"+proj=cass +lat_0=50.66738711 +lon_0=6.28935703 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 39 Langschoß\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",50.66738711],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",6.28935703],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187939\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187940,"mj10777.de",187940,"DHDN / Soldner 40 Rissenthal");
    add_proj4text(p,0,"+proj=cass +lat_0=49.47801819 +lon_0=6.75864339 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner 40 Rissenthal\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",49.47801819],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",6.75864339],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187940\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def(filter,first,last,187941,"mj10777.de",187941,"DHDN / Soldner Bayern");
    add_proj4text(p,0,"+proj=cass +lat_0=48.13959111 +lon_0=11.57437083 ");
    add_proj4text(p,1,"+x_0=0 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner Bayern\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",48.13959111],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",11.57437083],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187941\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def (filter,first, last, 187998, "mj10777.de", 187998,"DHDN / Ferro / Deutsches_Hauptdreiecksnetz");
    add_proj4text(p,0,"+proj=longlat +ellps=bessel +datum=potsdam +pm=ferro +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Ferro / Deutsches_Hauptdreiecksnetz\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",");
    add_srs_wkt(p,3,"SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"7004\"]], AUTHORITY[\"EPSG\",\"6314\"]],");
    add_srs_wkt(p,5,"PRIMEM[\"ferro\",-17.66666666666667],UNIT[\"Degree\",0.017453292519943295,");
    add_srs_wkt(p,6,"AUTHORITY[\"mj10777.de\",\"187998\"]],AUTHORITY[\"EPSG\",\"4314\"]]]");
/* mj10777: Not existing System, used for testing purposes. */
    p = add_epsg_def(filter,first,last,187999,"mj10777.de",187999,"DHDN / Brandenburger Tor");
    add_proj4text(p,0,"+proj=cass +lat_0=52.41864827777778 +lon_0=13.62720366666667 ");
    add_proj4text(p,1,"+x_0=16816.615499858 +y_0=-11047.322499366 +ellps=bessel +datum=potsdam +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"DHDN / Soldner Brandenburger Tor\",");
    add_srs_wkt(p,1,"GEOGCS[\"DHDN\",");
    add_srs_wkt(p,2,"DATUM[\"Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel 1841\",");
    add_srs_wkt(p,3,"6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],");
    add_srs_wkt(p,4,"AUTHORITY[\"EPSG\",\"6314\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt(p,5,"AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994328,");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4314\"]],");
    add_srs_wkt(p,7,"UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt(p,8,"PROJECTION[\"Cassini_Soldner\"],");
    add_srs_wkt(p,9,"PARAMETER[\"latitude_of_origin\",52.41864827777778],");
    add_srs_wkt(p,10,"PARAMETER[\"central_meridian\",13.62720366666667],");
    add_srs_wkt(p,11,"PARAMETER[\"false_easting\",16816.615499858],PARAMETER[\"false_northing\",-11047.322499366],");
    add_srs_wkt(p,12,"AUTHORITY[\"mj10777.de\",\"187999\"],AXIS[\"x\",NORTH],AXIS[\"y\",EAST]]");
    p = add_epsg_def (filter,first, last, 325833, "mj10777.de", 325833,"ETRS89 / UTM zone 33N (Brandenburg)");
    add_proj4text(p,0,"+proj=utm +zone=33 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt(p,0,"PROJCS[\"ETRS89 / UTM zone 33N (Brandenburg)\",GEOGCS[\"ETRS89\",");
    add_srs_wkt(p,1,"DATUM[\"European_Terrestrial_Reference_System_1989\",");
    add_srs_wkt(p,2,"SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt(p,3,"AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt(p,4,"PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt(p,5,"UNIT[\"degree\",0.01745329251994328,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt(p,6,"AUTHORITY[\"EPSG\",\"4258\"]],UNIT[\"metre\",1,");
    add_srs_wkt(p,7,"AUTHORITY[\"EPSG\",\"9001\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt(p,8,"PARAMETER[\"latitude_of_origin\",0],");
    add_srs_wkt(p,9,"PARAMETER[\"central_meridian\",15],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt(p,10,"PARAMETER[\"false_easting\",3500000],PARAMETER[\"false_northing\",0],");
    add_srs_wkt(p,11,"AUTHORITY[\"EPSG\",\"325833\"],");
    add_srs_wkt(p,12,"AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]]");
}

#endif /* full EPSG initialization enabled/disabled */

