# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, Optional, TypeVar, Union

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._deployment_templates_operations import build_create_request_initial, build_delete_request, build_get_request, build_list_request
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class DeploymentTemplatesOperations:
    """DeploymentTemplatesOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.machinelearningservices.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    async def _create_initial(
        self,
        endpoint: str,
        subscription_id: str,
        resource_group_name: str,
        registry_name: str,
        name: str,
        version: str,
        body: "_models.DeploymentTemplate",
        **kwargs: Any
    ) -> "_models.LongRunningNullResponse":
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.LongRunningNullResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(body, 'DeploymentTemplate')

        request = build_create_request_initial(
            registry_name=registry_name,
            name=name,
            version=version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._create_initial.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('LongRunningNullResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _create_initial.metadata = {'url': "/registries/{registryName}/{name}/versions/{version}"}  # type: ignore


    @distributed_trace_async
    async def begin_create(
        self,
        endpoint: str,
        subscription_id: str,
        resource_group_name: str,
        registry_name: str,
        name: str,
        version: str,
        body: "_models.DeploymentTemplate",
        **kwargs: Any
    ) -> AsyncLROPoller["_models.LongRunningNullResponse"]:
        """Creates a deployment template version.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param registry_name: The name of the AzureML registry.
        :type registry_name: str
        :param name: Name of the deployment template.
        :type name: str
        :param version: Version of the deployment template.
        :type version: str
        :param body: Properties of a Deployment Template Version.
        :type body: ~azure.mgmt.machinelearningservices.models.DeploymentTemplate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AsyncARMPolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.AsyncPollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AsyncLROPoller that returns either LongRunningNullResponse or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.machinelearningservices.models.LongRunningNullResponse]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, AsyncPollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.LongRunningNullResponse"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = await self._create_initial(
                endpoint=endpoint,
                subscription_id=subscription_id,
                resource_group_name=resource_group_name,
                registry_name=registry_name,
                name=name,
                version=version,
                body=body,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('LongRunningNullResponse', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }

        if polling is True: polling_method = AsyncARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
        elif polling is False: polling_method = AsyncNoPolling()
        else: polling_method = polling
        if cont_token:
            return AsyncLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AsyncLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_create.metadata = {'url': "/registries/{registryName}/{name}/versions/{version}"}  # type: ignore

    @distributed_trace
    def list(
        self,
        endpoint: str,
        subscription_id: str,
        resource_group_name: str,
        registry_name: str,
        name: Optional[str] = None,
        tags: Optional[str] = None,
        continuation_token_parameter: Optional[str] = None,
        continuation_token_from_header: Optional[str] = None,
        count: Optional[int] = None,
        stage: Optional[str] = None,
        list_view_type: Optional[str] = "ActiveOnly",
        **kwargs: Any
    ) -> AsyncIterable["_models.PagedDeploymentTemplate"]:
        """List deployment templates.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param registry_name: The name of the AzureML registry.
        :type registry_name: str
        :param name: Filter by deployment template name.
        :type name: str
        :param tags: Comma-separated list of tag names (and optionally values). Example:
         tag1,tag2=value2.
        :type tags: str
        :param continuation_token_parameter: Continuation token for pagination.
        :type continuation_token_parameter: str
        :param continuation_token_from_header: Continuation token for pagination (from header).
        :type continuation_token_from_header: str
        :param count: Maximum number of items to return.
        :type count: int
        :param stage: Filter by deployment template stage.
        :type stage: str
        :param list_view_type: View type for including/excluding (for example) archived entities.
        :type list_view_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PagedDeploymentTemplate or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.machinelearningservices.models.PagedDeploymentTemplate]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PagedDeploymentTemplate"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_request(
                    registry_name=registry_name,
                    api_version=api_version,
                    name=name,
                    tags=tags,
                    continuation_token_parameter=continuation_token_parameter,
                    continuation_token_from_header=continuation_token_from_header,
                    count=count,
                    stage=stage,
                    list_view_type=list_view_type,
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_list_request(
                    registry_name=registry_name,
                    api_version=api_version,
                    name=name,
                    tags=tags,
                    continuation_token_parameter=continuation_token_parameter,
                    continuation_token_from_header=continuation_token_from_header,
                    count=count,
                    stage=stage,
                    list_view_type=list_view_type,
                    template_url=next_link,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("PagedDeploymentTemplate", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': "/registries/{registryName}/deploymenttemplates"}  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        endpoint: str,
        subscription_id: str,
        resource_group_name: str,
        registry_name: str,
        name: str,
        version: str,
        asset_resource_tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> "_models.DeploymentTemplate":
        """Get a specific version of a deployment template.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param registry_name: The name of the AzureML registry.
        :type registry_name: str
        :param name: Name of the deployment template.
        :type name: str
        :param version: Version of the deployment template.
        :type version: str
        :param asset_resource_tenant_id: Asset resource tenant ID.
        :type asset_resource_tenant_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentTemplate, or the result of cls(response)
        :rtype: ~azure.mgmt.machinelearningservices.models.DeploymentTemplate
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentTemplate"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        
        request = build_get_request(
            registry_name=registry_name,
            name=name,
            version=version,
            api_version=api_version,
            asset_resource_tenant_id=asset_resource_tenant_id,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentTemplate', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': "/registries/{registryName}/deploymenttemplates/{name}/versions/{version}"}  # type: ignore


    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self,
        endpoint: str,
        subscription_id: str,
        resource_group_name: str,
        registry_name: str,
        name: str,
        version: str,
        **kwargs: Any
    ) -> None:
        """Delete a specific version of a deployment template.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param registry_name: The name of the AzureML registry.
        :type registry_name: str
        :param name: Name of the deployment template.
        :type name: str
        :param version: Version of the deployment template.
        :type version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        
        request = build_delete_request(
            registry_name=registry_name,
            name=name,
            version=version,
            api_version=api_version,
            template_url=self.delete.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = await self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {'url': "/registries/{registryName}/deploymenttemplates/{name}/versions/{version}"}  # type: ignore

