# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2021_05_01_preview.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.security.v2021_05_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Software(Resource):  # pylint: disable=too-many-instance-attributes
    """Represents a software data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar device_id: Unique identifier for the virtual machine in the service.
    :vartype device_id: str
    :ivar os_platform: Platform of the operating system running on the device.
    :vartype os_platform: str
    :ivar vendor: Name of the software vendor.
    :vartype vendor: str
    :ivar software_name: Name of the software product.
    :vartype software_name: str
    :ivar version: Version number of the software product.
    :vartype version: str
    :ivar end_of_support_status: End of support status. Known values are: "None",
     "noLongerSupported", "versionNoLongerSupported", "upcomingNoLongerSupported", and
     "upcomingVersionNoLongerSupported".
    :vartype end_of_support_status: str or
     ~azure.mgmt.security.v2021_05_01_preview.models.EndOfSupportStatus
    :ivar end_of_support_date: The end of support date in case the product is upcoming end of
     support.
    :vartype end_of_support_date: str
    :ivar number_of_known_vulnerabilities: Number of weaknesses.
    :vartype number_of_known_vulnerabilities: int
    :ivar first_seen_at: First time that the software was seen in the device.
    :vartype first_seen_at: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "device_id": {"key": "properties.deviceId", "type": "str"},
        "os_platform": {"key": "properties.osPlatform", "type": "str"},
        "vendor": {"key": "properties.vendor", "type": "str"},
        "software_name": {"key": "properties.softwareName", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "end_of_support_status": {"key": "properties.endOfSupportStatus", "type": "str"},
        "end_of_support_date": {"key": "properties.endOfSupportDate", "type": "str"},
        "number_of_known_vulnerabilities": {"key": "properties.numberOfKnownVulnerabilities", "type": "int"},
        "first_seen_at": {"key": "properties.firstSeenAt", "type": "str"},
    }

    def __init__(
        self,
        *,
        device_id: Optional[str] = None,
        os_platform: Optional[str] = None,
        vendor: Optional[str] = None,
        software_name: Optional[str] = None,
        version: Optional[str] = None,
        end_of_support_status: Optional[Union[str, "_models.EndOfSupportStatus"]] = None,
        end_of_support_date: Optional[str] = None,
        number_of_known_vulnerabilities: Optional[int] = None,
        first_seen_at: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword device_id: Unique identifier for the virtual machine in the service.
        :paramtype device_id: str
        :keyword os_platform: Platform of the operating system running on the device.
        :paramtype os_platform: str
        :keyword vendor: Name of the software vendor.
        :paramtype vendor: str
        :keyword software_name: Name of the software product.
        :paramtype software_name: str
        :keyword version: Version number of the software product.
        :paramtype version: str
        :keyword end_of_support_status: End of support status. Known values are: "None",
         "noLongerSupported", "versionNoLongerSupported", "upcomingNoLongerSupported", and
         "upcomingVersionNoLongerSupported".
        :paramtype end_of_support_status: str or
         ~azure.mgmt.security.v2021_05_01_preview.models.EndOfSupportStatus
        :keyword end_of_support_date: The end of support date in case the product is upcoming end of
         support.
        :paramtype end_of_support_date: str
        :keyword number_of_known_vulnerabilities: Number of weaknesses.
        :paramtype number_of_known_vulnerabilities: int
        :keyword first_seen_at: First time that the software was seen in the device.
        :paramtype first_seen_at: str
        """
        super().__init__(**kwargs)
        self.device_id = device_id
        self.os_platform = os_platform
        self.vendor = vendor
        self.software_name = software_name
        self.version = version
        self.end_of_support_status = end_of_support_status
        self.end_of_support_date = end_of_support_date
        self.number_of_known_vulnerabilities = number_of_known_vulnerabilities
        self.first_seen_at = first_seen_at


class SoftwaresList(_serialization.Model):
    """Represents the software inventory of the virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.v2021_05_01_preview.models.Software]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Software]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Software"]] = None, **kwargs):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.v2021_05_01_preview.models.Software]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None
