# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CheckNameAvailabilityParameters(_serialization.Model):
    """Details of check name availability request body.

    :ivar name: Name for checking availability.
    :vartype name: str
    :ivar type: The resource type of Quantum Workspace.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: str = "Microsoft.Quantum/Workspaces", **kwargs):
        """
        :keyword name: Name for checking availability.
        :paramtype name: str
        :keyword type: The resource type of Quantum Workspace.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityResult(_serialization.Model):
    """Result of check name availability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Indicator of availability of the Quantum Workspace resource name.
    :vartype name_available: bool
    :ivar reason: The reason of unavailability.
    :vartype reason: str
    :ivar message: The detailed info regarding the reason associated with the Namespace.
    :vartype message: str
    """

    _validation = {
        "message": {"readonly": True},
    }

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, name_available: Optional[bool] = None, reason: Optional[str] = None, **kwargs):
        """
        :keyword name_available: Indicator of availability of the Quantum Workspace resource name.
        :paramtype name_available: bool
        :keyword reason: The reason of unavailability.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.quantum.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.quantum.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.quantum.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.quantum.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class OfferingsListResult(_serialization.Model):
    """The response of a list Providers operation.

    :ivar value: Result of a list Providers operation.
    :vartype value: list[~azure.mgmt.quantum.models.ProviderDescription]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Providers.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ProviderDescription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ProviderDescription"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Result of a list Providers operation.
        :paramtype value: list[~azure.mgmt.quantum.models.ProviderDescription]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of Providers.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Operation(_serialization.Model):
    """Operation provided by provider.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: Properties of the operation.
    :vartype display: ~azure.mgmt.quantum.models.OperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: Properties of the operation.
        :paramtype display: ~azure.mgmt.quantum.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display


class OperationDisplay(_serialization.Model):
    """Properties of the operation.

    :ivar provider: Provider name.
    :vartype provider: str
    :ivar resource: Resource name.
    :vartype resource: str
    :ivar operation: Operation name.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Provider name.
        :paramtype provider: str
        :keyword resource: Resource name.
        :paramtype resource: str
        :keyword operation: Operation name.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationsList(_serialization.Model):
    """Lists the operations available.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: Url to follow for getting next page of operations.
    :vartype next_link: str
    :ivar value: Array of operations. Required.
    :vartype value: list[~azure.mgmt.quantum.models.Operation]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Operation]"},
    }

    def __init__(self, *, value: List["_models.Operation"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: Url to follow for getting next page of operations.
        :paramtype next_link: str
        :keyword value: Array of operations. Required.
        :paramtype value: list[~azure.mgmt.quantum.models.Operation]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class PricingDetail(_serialization.Model):
    """Detailed pricing information for an sku.

    :ivar id: Unique id for this pricing information.
    :vartype id: str
    :ivar value: The unit cost of this sku.
    :vartype value: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self, *, id: Optional[str] = None, value: Optional[str] = None, **kwargs  # pylint: disable=redefined-builtin
    ):
        """
        :keyword id: Unique id for this pricing information.
        :paramtype id: str
        :keyword value: The unit cost of this sku.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.value = value


class PricingDimension(_serialization.Model):
    """Information about pricing dimension.

    :ivar id: Unique id of this pricing dimension.
    :vartype id: str
    :ivar name: The display name of this pricing dimension.
    :vartype name: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self, *, id: Optional[str] = None, name: Optional[str] = None, **kwargs  # pylint: disable=redefined-builtin
    ):
        """
        :keyword id: Unique id of this pricing dimension.
        :paramtype id: str
        :keyword name: The display name of this pricing dimension.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name


class Provider(_serialization.Model):
    """Information about a Provider. A Provider is an entity that offers Targets to run Azure Quantum Jobs.

    :ivar provider_id: Unique id of this provider.
    :vartype provider_id: str
    :ivar provider_sku: The sku associated with pricing information for this provider.
    :vartype provider_sku: str
    :ivar instance_uri: A Uri identifying the specific instance of this provider.
    :vartype instance_uri: str
    :ivar application_name: The provider's marketplace application display name.
    :vartype application_name: str
    :ivar provisioning_state: Provisioning status field. Known values are: "Succeeded",
     "Launching", "Updating", "Deleting", "Deleted", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.quantum.models.Status
    :ivar resource_usage_id: Id to track resource usage for the provider.
    :vartype resource_usage_id: str
    """

    _attribute_map = {
        "provider_id": {"key": "providerId", "type": "str"},
        "provider_sku": {"key": "providerSku", "type": "str"},
        "instance_uri": {"key": "instanceUri", "type": "str"},
        "application_name": {"key": "applicationName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "resource_usage_id": {"key": "resourceUsageId", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider_id: Optional[str] = None,
        provider_sku: Optional[str] = None,
        instance_uri: Optional[str] = None,
        application_name: Optional[str] = None,
        provisioning_state: Optional[Union[str, "_models.Status"]] = None,
        resource_usage_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider_id: Unique id of this provider.
        :paramtype provider_id: str
        :keyword provider_sku: The sku associated with pricing information for this provider.
        :paramtype provider_sku: str
        :keyword instance_uri: A Uri identifying the specific instance of this provider.
        :paramtype instance_uri: str
        :keyword application_name: The provider's marketplace application display name.
        :paramtype application_name: str
        :keyword provisioning_state: Provisioning status field. Known values are: "Succeeded",
         "Launching", "Updating", "Deleting", "Deleted", and "Failed".
        :paramtype provisioning_state: str or ~azure.mgmt.quantum.models.Status
        :keyword resource_usage_id: Id to track resource usage for the provider.
        :paramtype resource_usage_id: str
        """
        super().__init__(**kwargs)
        self.provider_id = provider_id
        self.provider_sku = provider_sku
        self.instance_uri = instance_uri
        self.application_name = application_name
        self.provisioning_state = provisioning_state
        self.resource_usage_id = resource_usage_id


class ProviderDescription(_serialization.Model):
    """Information about an offering. A provider offering is an entity that offers Targets to run Azure Quantum Jobs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Unique provider's id.
    :vartype id: str
    :ivar name: Provider's display name.
    :vartype name: str
    :ivar properties: A list of provider-specific properties.
    :vartype properties: ~azure.mgmt.quantum.models.ProviderProperties
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "ProviderProperties"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        properties: Optional["_models.ProviderProperties"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique provider's id.
        :paramtype id: str
        :keyword properties: A list of provider-specific properties.
        :paramtype properties: ~azure.mgmt.quantum.models.ProviderProperties
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = None
        self.properties = properties


class ProviderProperties(_serialization.Model):
    """Provider properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: A description about this provider.
    :vartype description: str
    :ivar provider_type: Provider type.
    :vartype provider_type: str
    :ivar company: Company name.
    :vartype company: str
    :ivar default_endpoint: Provider's default endpoint.
    :vartype default_endpoint: str
    :ivar aad: Azure Active Directory info.
    :vartype aad: ~azure.mgmt.quantum.models.ProviderPropertiesAad
    :ivar managed_application: Provider's Managed-Application info.
    :vartype managed_application: ~azure.mgmt.quantum.models.ProviderPropertiesManagedApplication
    :ivar targets: The list of targets available from this provider.
    :vartype targets: list[~azure.mgmt.quantum.models.TargetDescription]
    :ivar skus: The list of skus available from this provider.
    :vartype skus: list[~azure.mgmt.quantum.models.SkuDescription]
    :ivar quota_dimensions: The list of quota dimensions from the provider.
    :vartype quota_dimensions: list[~azure.mgmt.quantum.models.QuotaDimension]
    :ivar pricing_dimensions: The list of pricing dimensions from the provider.
    :vartype pricing_dimensions: list[~azure.mgmt.quantum.models.PricingDimension]
    """

    _validation = {
        "description": {"readonly": True},
        "provider_type": {"readonly": True},
        "company": {"readonly": True},
        "default_endpoint": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "provider_type": {"key": "providerType", "type": "str"},
        "company": {"key": "company", "type": "str"},
        "default_endpoint": {"key": "defaultEndpoint", "type": "str"},
        "aad": {"key": "aad", "type": "ProviderPropertiesAad"},
        "managed_application": {"key": "managedApplication", "type": "ProviderPropertiesManagedApplication"},
        "targets": {"key": "targets", "type": "[TargetDescription]"},
        "skus": {"key": "skus", "type": "[SkuDescription]"},
        "quota_dimensions": {"key": "quotaDimensions", "type": "[QuotaDimension]"},
        "pricing_dimensions": {"key": "pricingDimensions", "type": "[PricingDimension]"},
    }

    def __init__(
        self,
        *,
        aad: Optional["_models.ProviderPropertiesAad"] = None,
        managed_application: Optional["_models.ProviderPropertiesManagedApplication"] = None,
        targets: Optional[List["_models.TargetDescription"]] = None,
        skus: Optional[List["_models.SkuDescription"]] = None,
        quota_dimensions: Optional[List["_models.QuotaDimension"]] = None,
        pricing_dimensions: Optional[List["_models.PricingDimension"]] = None,
        **kwargs
    ):
        """
        :keyword aad: Azure Active Directory info.
        :paramtype aad: ~azure.mgmt.quantum.models.ProviderPropertiesAad
        :keyword managed_application: Provider's Managed-Application info.
        :paramtype managed_application: ~azure.mgmt.quantum.models.ProviderPropertiesManagedApplication
        :keyword targets: The list of targets available from this provider.
        :paramtype targets: list[~azure.mgmt.quantum.models.TargetDescription]
        :keyword skus: The list of skus available from this provider.
        :paramtype skus: list[~azure.mgmt.quantum.models.SkuDescription]
        :keyword quota_dimensions: The list of quota dimensions from the provider.
        :paramtype quota_dimensions: list[~azure.mgmt.quantum.models.QuotaDimension]
        :keyword pricing_dimensions: The list of pricing dimensions from the provider.
        :paramtype pricing_dimensions: list[~azure.mgmt.quantum.models.PricingDimension]
        """
        super().__init__(**kwargs)
        self.description = None
        self.provider_type = None
        self.company = None
        self.default_endpoint = None
        self.aad = aad
        self.managed_application = managed_application
        self.targets = targets
        self.skus = skus
        self.quota_dimensions = quota_dimensions
        self.pricing_dimensions = pricing_dimensions


class ProviderPropertiesAad(_serialization.Model):
    """Azure Active Directory info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar application_id: Provider's application id.
    :vartype application_id: str
    :ivar tenant_id: Provider's tenant id.
    :vartype tenant_id: str
    """

    _validation = {
        "application_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "application_id": {"key": "applicationId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.application_id = None
        self.tenant_id = None


class ProviderPropertiesManagedApplication(_serialization.Model):
    """Provider's Managed-Application info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar publisher_id: Provider's publisher id.
    :vartype publisher_id: str
    :ivar offer_id: Provider's offer id.
    :vartype offer_id: str
    """

    _validation = {
        "publisher_id": {"readonly": True},
        "offer_id": {"readonly": True},
    }

    _attribute_map = {
        "publisher_id": {"key": "publisherId", "type": "str"},
        "offer_id": {"key": "offerId", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.publisher_id = None
        self.offer_id = None


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class QuantumWorkspace(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The resource proxy definition object for quantum workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Managed Identity information.
    :vartype identity: ~azure.mgmt.quantum.models.QuantumWorkspaceIdentity
    :ivar system_data: System metadata.
    :vartype system_data: ~azure.mgmt.quantum.models.SystemData
    :ivar providers: List of Providers selected for this Workspace.
    :vartype providers: list[~azure.mgmt.quantum.models.Provider]
    :ivar usable: Whether the current workspace is ready to accept Jobs. Known values are: "Yes",
     "No", and "Partial".
    :vartype usable: str or ~azure.mgmt.quantum.models.UsableStatus
    :ivar provisioning_state: Provisioning status field. Known values are: "Succeeded",
     "ProviderLaunching", "ProviderUpdating", "ProviderDeleting", "ProviderProvisioning", and
     "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.quantum.models.ProvisioningStatus
    :ivar storage_account: ARM Resource Id of the storage account associated with this workspace.
    :vartype storage_account: str
    :ivar endpoint_uri: The URI of the workspace endpoint.
    :vartype endpoint_uri: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "system_data": {"readonly": True},
        "usable": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "endpoint_uri": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "QuantumWorkspaceIdentity"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "providers": {"key": "properties.providers", "type": "[Provider]"},
        "usable": {"key": "properties.usable", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "storage_account": {"key": "properties.storageAccount", "type": "str"},
        "endpoint_uri": {"key": "properties.endpointUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.QuantumWorkspaceIdentity"] = None,
        providers: Optional[List["_models.Provider"]] = None,
        storage_account: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Managed Identity information.
        :paramtype identity: ~azure.mgmt.quantum.models.QuantumWorkspaceIdentity
        :keyword providers: List of Providers selected for this Workspace.
        :paramtype providers: list[~azure.mgmt.quantum.models.Provider]
        :keyword storage_account: ARM Resource Id of the storage account associated with this
         workspace.
        :paramtype storage_account: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.system_data = None
        self.providers = providers
        self.usable = None
        self.provisioning_state = None
        self.storage_account = storage_account
        self.endpoint_uri = None


class QuantumWorkspaceIdentity(_serialization.Model):
    """Managed Identity information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Known values are: "SystemAssigned" and "None".
    :vartype type: str or ~azure.mgmt.quantum.models.ResourceIdentityType
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.ResourceIdentityType"]] = None, **kwargs):
        """
        :keyword type: The identity type. Known values are: "SystemAssigned" and "None".
        :paramtype type: str or ~azure.mgmt.quantum.models.ResourceIdentityType
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class QuotaDimension(_serialization.Model):
    """Information about a specific quota dimension.

    :ivar id: Unique id of this dimension.
    :vartype id: str
    :ivar scope: The scope of this quota dimension.
    :vartype scope: str
    :ivar period: The reset period of this quota dimension.
    :vartype period: str
    :ivar quota: The max limit of this dimension.
    :vartype quota: float
    :ivar name: The display name of this quota dimension.
    :vartype name: str
    :ivar description: A description about this quota dimension.
    :vartype description: str
    :ivar unit: The standard unit of measurement used for this quota dimension.
    :vartype unit: str
    :ivar unit_plural: The standard unit of measurement used for this quota dimension in plural
     form.
    :vartype unit_plural: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "period": {"key": "period", "type": "str"},
        "quota": {"key": "quota", "type": "float"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "unit_plural": {"key": "unitPlural", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        scope: Optional[str] = None,
        period: Optional[str] = None,
        quota: Optional[float] = None,
        name: Optional[str] = None,
        description: Optional[str] = None,
        unit: Optional[str] = None,
        unit_plural: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Unique id of this dimension.
        :paramtype id: str
        :keyword scope: The scope of this quota dimension.
        :paramtype scope: str
        :keyword period: The reset period of this quota dimension.
        :paramtype period: str
        :keyword quota: The max limit of this dimension.
        :paramtype quota: float
        :keyword name: The display name of this quota dimension.
        :paramtype name: str
        :keyword description: A description about this quota dimension.
        :paramtype description: str
        :keyword unit: The standard unit of measurement used for this quota dimension.
        :paramtype unit: str
        :keyword unit_plural: The standard unit of measurement used for this quota dimension in plural
         form.
        :paramtype unit_plural: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.scope = scope
        self.period = period
        self.quota = quota
        self.name = name
        self.description = description
        self.unit = unit
        self.unit_plural = unit_plural


class SkuDescription(_serialization.Model):
    """Information about a specific sku.

    :ivar id: Unique sku id.
    :vartype id: str
    :ivar name: Display name of this sku.
    :vartype name: str
    :ivar version: Display name of this sku.
    :vartype version: str
    :ivar description: Description about this sku.
    :vartype description: str
    :ivar restricted_access_uri: Uri to subscribe to the restricted access sku.
    :vartype restricted_access_uri: str
    :ivar auto_add: Flag to indicate whether the sku should be automatically added during workspace
     creation.
    :vartype auto_add: bool
    :ivar targets: The list of targets available for this sku.
    :vartype targets: list[str]
    :ivar quota_dimensions: The list of quota dimensions for this sku.
    :vartype quota_dimensions: list[~azure.mgmt.quantum.models.QuotaDimension]
    :ivar pricing_details: The list of pricing details for the sku.
    :vartype pricing_details: list[~azure.mgmt.quantum.models.PricingDetail]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "restricted_access_uri": {"key": "restrictedAccessUri", "type": "str"},
        "auto_add": {"key": "autoAdd", "type": "bool"},
        "targets": {"key": "targets", "type": "[str]"},
        "quota_dimensions": {"key": "quotaDimensions", "type": "[QuotaDimension]"},
        "pricing_details": {"key": "pricingDetails", "type": "[PricingDetail]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        version: Optional[str] = None,
        description: Optional[str] = None,
        restricted_access_uri: Optional[str] = None,
        auto_add: Optional[bool] = None,
        targets: Optional[List[str]] = None,
        quota_dimensions: Optional[List["_models.QuotaDimension"]] = None,
        pricing_details: Optional[List["_models.PricingDetail"]] = None,
        **kwargs
    ):
        """
        :keyword id: Unique sku id.
        :paramtype id: str
        :keyword name: Display name of this sku.
        :paramtype name: str
        :keyword version: Display name of this sku.
        :paramtype version: str
        :keyword description: Description about this sku.
        :paramtype description: str
        :keyword restricted_access_uri: Uri to subscribe to the restricted access sku.
        :paramtype restricted_access_uri: str
        :keyword auto_add: Flag to indicate whether the sku should be automatically added during
         workspace creation.
        :paramtype auto_add: bool
        :keyword targets: The list of targets available for this sku.
        :paramtype targets: list[str]
        :keyword quota_dimensions: The list of quota dimensions for this sku.
        :paramtype quota_dimensions: list[~azure.mgmt.quantum.models.QuotaDimension]
        :keyword pricing_details: The list of pricing details for the sku.
        :paramtype pricing_details: list[~azure.mgmt.quantum.models.PricingDetail]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.version = version
        self.description = description
        self.restricted_access_uri = restricted_access_uri
        self.auto_add = auto_add
        self.targets = targets
        self.quota_dimensions = quota_dimensions
        self.pricing_details = pricing_details


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.quantum.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.quantum.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.quantum.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.quantum.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsObject(_serialization.Model):
    """Tags object for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class TargetDescription(_serialization.Model):
    """Information about a Target. A target is the component that can process a specific type of Job.

    :ivar id: Unique target id.
    :vartype id: str
    :ivar name: Display name of this target.
    :vartype name: str
    :ivar description: A description about this target.
    :vartype description: str
    :ivar accepted_data_formats: List of data formats accepted by this target.
    :vartype accepted_data_formats: list[str]
    :ivar accepted_content_encodings: List of content encodings accepted by this target.
    :vartype accepted_content_encodings: list[str]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "accepted_data_formats": {"key": "acceptedDataFormats", "type": "[str]"},
        "accepted_content_encodings": {"key": "acceptedContentEncodings", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        description: Optional[str] = None,
        accepted_data_formats: Optional[List[str]] = None,
        accepted_content_encodings: Optional[List[str]] = None,
        **kwargs
    ):
        """
        :keyword id: Unique target id.
        :paramtype id: str
        :keyword name: Display name of this target.
        :paramtype name: str
        :keyword description: A description about this target.
        :paramtype description: str
        :keyword accepted_data_formats: List of data formats accepted by this target.
        :paramtype accepted_data_formats: list[str]
        :keyword accepted_content_encodings: List of content encodings accepted by this target.
        :paramtype accepted_content_encodings: list[str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.description = description
        self.accepted_data_formats = accepted_data_formats
        self.accepted_content_encodings = accepted_content_encodings


class WorkspaceListResult(_serialization.Model):
    """The response of a list Workspaces operation.

    :ivar value: Result of a list Workspaces operation.
    :vartype value: list[~azure.mgmt.quantum.models.QuantumWorkspace]
    :ivar next_link: Link to the next set of results. Not empty if Value contains incomplete list
     of Workspaces.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[QuantumWorkspace]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.QuantumWorkspace"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Result of a list Workspaces operation.
        :paramtype value: list[~azure.mgmt.quantum.models.QuantumWorkspace]
        :keyword next_link: Link to the next set of results. Not empty if Value contains incomplete
         list of Workspaces.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link
