--TEST--
DateTime: epoch
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/tools.php';

$canonicalBson = hex2bin('10000000096100000000000000000000');
$canonicalExtJson = '{"a" : {"$date" : {"$numberLong" : "0"}}}';
$relaxedExtJson = '{"a" : {"$date" : "1970-01-01T00:00:00Z"}}';

// Canonical BSON -> Native -> Canonical BSON
echo bin2hex(fromPHP(toPHP($canonicalBson))), "\n";

// Canonical BSON -> Canonical extJSON
echo json_canonicalize(toCanonicalExtendedJSON($canonicalBson)), "\n";

// Canonical BSON -> Relaxed extJSON
echo json_canonicalize(toRelaxedExtendedJSON($canonicalBson)), "\n";

// Canonical extJSON -> Canonical BSON
echo bin2hex(fromJSON($canonicalExtJson)), "\n";

// Relaxed extJSON -> BSON -> Relaxed extJSON
echo json_canonicalize(toRelaxedExtendedJSON(fromJSON($relaxedExtJson))), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
10000000096100000000000000000000
{"a":{"$date":{"$numberLong":"0"}}}
{"a":{"$date":"1970-01-01T00:00:00Z"}}
10000000096100000000000000000000
{"a":{"$date":"1970-01-01T00:00:00Z"}}
===DONE===